/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.minimap;

import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import gaiasky.gui.iface.TableGuiInterface;
import gaiasky.gui.minimap.MinimapWidget;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.Separator;

public class MinimapInterface
extends TableGuiInterface {
    private final MinimapWidget minimap;
    private final OwnLabel mapName;

    public MinimapInterface(Skin skin, ShaderProgram shapeShader, ShaderProgram spriteShader) {
        super(skin);
        this.minimap = new MinimapWidget(skin, shapeShader, spriteShader);
        Table mainTable = new Table(skin);
        mainTable.pad(10.0f);
        mainTable.setBackground("bg-pane");
        Table side = new Table(skin);
        side.add((Actor)this.minimap.getSideProjection());
        Table top = new Table(skin);
        top.add((Actor)this.minimap.getTopProjection());
        this.mapName = new OwnLabel((CharSequence)"", skin, "header");
        OwnLabel sideLabel = new OwnLabel((CharSequence)I18n.msg("gui.minimap.vert.side"), skin, "default-red");
        Table sideLabelTable = new Table(skin);
        sideLabelTable.add((Actor)sideLabel);
        OwnLabel topLabel = new OwnLabel((CharSequence)I18n.msg("gui.minimap.vert.top"), skin, "default-red");
        Table topLabelTable = new Table(skin);
        topLabelTable.add((Actor)topLabel);
        mainTable.add((Actor)this.mapName).right().colspan(3).row();
        mainTable.add((Actor)sideLabelTable).width(25.0f).center().padBottom(20.0f);
        mainTable.add((Actor)new Separator(skin, "small")).growY().padBottom(20.0f);
        mainTable.add((Actor)side).padBottom(20.0f).row();
        mainTable.add((Actor)topLabelTable).width(25.0f).center();
        mainTable.add((Actor)new Separator(skin, "small")).growY();
        mainTable.add((Actor)top);
        this.add((Actor)mainTable);
        this.pack();
    }

    private void updateMapName(String name) {
        if (this.mapName != null) {
            this.mapName.setText(name);
        }
    }

    @Override
    public void update() {
        if (this.minimap != null) {
            this.minimap.update();
            String mapName = this.minimap.getCurrentName();
            if (mapName != null && !mapName.equals(this.mapName.getName())) {
                this.updateMapName(mapName);
            }
        }
    }

    @Override
    public void dispose() {
        this.minimap.dispose();
    }
}

