/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.minimap;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.GaiaSky;
import gaiasky.gui.api.IMinimapScale;
import gaiasky.gui.main.KeyBindings;
import gaiasky.gui.minimap.HeliosphereMinimapScale;
import gaiasky.gui.minimap.HighZMinimapScale;
import gaiasky.gui.minimap.InnerSolarSystemMinimapScale;
import gaiasky.gui.minimap.LocalGroup1MinimapScale;
import gaiasky.gui.minimap.LocalGroup2MinimapScale;
import gaiasky.gui.minimap.MilkyWayMinimapScale;
import gaiasky.gui.minimap.OortCloudMinimapScale;
import gaiasky.gui.minimap.OuterSolarSystemMinimapScale;
import gaiasky.gui.minimap.SolarNeighbourhoodMinimapScale;
import gaiasky.scene.camera.CameraManager;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector3D;
import gaiasky.util.scene2d.OwnTextHotkeyTooltip;
import gaiasky.util.scene2d.TextureWidget;

public class MinimapWidget
implements Disposable {
    private final FrameBuffer tfb;
    private final FrameBuffer sfb;
    private final TextureWidget topProjection;
    private final TextureWidget sideProjection;
    private final Vector3D aux3d;
    private final Array<IMinimapScale> scales;
    int side;
    int side2;
    int sideShort;
    int sideShort2;
    private IMinimapScale current;

    public MinimapWidget(Skin skin, ShaderProgram shapeShader, ShaderProgram spriteShader) {
        this.side = (int)(1.4f * Settings.settings.program.minimap.size);
        this.side2 = this.side / 2;
        this.sideShort = (int)(0.7f * Settings.settings.program.minimap.size);
        this.sideShort2 = this.sideShort / 2;
        OrthographicCamera orthographic = new OrthographicCamera();
        ShapeRenderer sr = new ShapeRenderer(200, shapeShader);
        sr.setAutoShapeType(true);
        SpriteBatch sb = new SpriteBatch(1000, spriteShader);
        BitmapFont font = skin.getFont("ui-23");
        this.tfb = new FrameBuffer(Pixmap.Format.RGBA8888, this.side, this.side, true);
        this.sfb = new FrameBuffer(Pixmap.Format.RGBA8888, this.side, this.sideShort, true);
        this.topProjection = new TextureWidget(this.tfb);
        this.sideProjection = new TextureWidget(this.sfb);
        this.scales = new Array();
        InnerSolarSystemMinimapScale issms = new InnerSolarSystemMinimapScale();
        issms.initialize(orthographic, sb, sr, font, this.side, this.sideShort);
        OuterSolarSystemMinimapScale ossms = new OuterSolarSystemMinimapScale();
        ossms.initialize(orthographic, sb, sr, font, this.side, this.sideShort);
        HeliosphereMinimapScale hsms = new HeliosphereMinimapScale();
        hsms.initialize(orthographic, sb, sr, font, this.side, this.sideShort);
        OortCloudMinimapScale ocms = new OortCloudMinimapScale();
        ocms.initialize(orthographic, sb, sr, font, this.side, this.sideShort);
        SolarNeighbourhoodMinimapScale snms = new SolarNeighbourhoodMinimapScale();
        snms.initialize(orthographic, sb, sr, font, this.side, this.sideShort);
        MilkyWayMinimapScale mmms = new MilkyWayMinimapScale();
        mmms.initialize(orthographic, sb, sr, font, this.side, this.sideShort);
        LocalGroup1MinimapScale lg1ms = new LocalGroup1MinimapScale();
        lg1ms.initialize(orthographic, sb, sr, font, this.side, this.sideShort);
        LocalGroup2MinimapScale lg2ms = new LocalGroup2MinimapScale();
        lg2ms.initialize(orthographic, sb, sr, font, this.side, this.sideShort);
        HighZMinimapScale hzms = new HighZMinimapScale();
        hzms.initialize(orthographic, sb, sr, font, this.side, this.sideShort);
        this.scales.add((Object)issms);
        this.scales.add((Object)ossms);
        this.scales.add((Object)hsms);
        this.scales.add((Object)ocms);
        this.scales.add((Object)snms);
        this.scales.add((Object)mmms);
        this.scales.add((Object)lg1ms);
        this.scales.add((Object)lg2ms);
        this.scales.add((Object)hzms);
        this.current = null;
        String[] minimapHotkey = KeyBindings.instance.getStringKeys("action.toggle/gui.minimap.title", true);
        this.topProjection.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.minimap.title") + " - " + I18n.msg("gui.minimap.top"), minimapHotkey, skin));
        this.sideProjection.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.minimap.title") + " - " + I18n.msg("gui.minimap.side"), minimapHotkey, skin));
        this.aux3d = new Vector3D();
    }

    public void update() {
        CameraManager cam = GaiaSky.instance.cameraManager;
        double distSun = cam.getPos().lenDouble();
        for (IMinimapScale mms : this.scales) {
            if (!mms.isActive(cam.getPos().tov3d(this.aux3d), distSun)) continue;
            mms.update();
            mms.renderSideProjection(this.sfb);
            mms.renderTopProjection(this.tfb);
            if (this.current != null && this.current == mms) break;
            this.current = mms;
            break;
        }
    }

    public TextureWidget getSideProjection() {
        return this.sideProjection;
    }

    public TextureWidget getTopProjection() {
        return this.topProjection;
    }

    public String getCurrentName() {
        if (this.current != null) {
            return this.current.getName();
        }
        return null;
    }

    public void dispose() {
    }
}

