/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.minimap;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import gaiasky.GaiaSky;
import gaiasky.gui.minimap.AbstractMinimapScale;
import gaiasky.util.Constants;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Matrix4D;

public class OortCloudMinimapScale
extends AbstractMinimapScale {
    private final Color occ = new Color(0.4f, 0.8f, 0.5f, 1.0f);

    @Override
    public void updateLocal() {
        this.position(GaiaSky.instance.cameraManager.getPos().tov3d(this.aux3d1), this.camp);
    }

    @Override
    public void initialize(OrthographicCamera ortho, SpriteBatch sb, ShapeRenderer sr, BitmapFont font, int side, int sideshort) {
        super.initialize(ortho, sb, sr, font, side, sideshort, Constants.AU_TO_U, Constants.U_TO_AU, 100000.0, 1000.0);
        this.trans = new Matrix4D();
    }

    @Override
    public void renderSideProjection(FrameBuffer fb) {
        Gdx.gl.glEnable(3042);
        this.ortho.setToOrtho(true, (float)this.side, (float)this.sideshort);
        this.sr.setProjectionMatrix(this.ortho.combined);
        this.sb.setProjectionMatrix(this.ortho.combined);
        fb.begin();
        Gdx.gl.glClear(0x4100 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        Gdx.gl.glBlendFunc(770, 771);
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        float xcenter = this.u2Px(0.0, this.side2);
        float ycenter = this.u2Px(0.0, this.sideshort2);
        this.sr.setColor(this.occ);
        this.sr.getColor().a = 0.5f;
        this.sr.circle(xcenter, ycenter, (float)(100000.0 / this.extentUp) * (float)this.side2);
        this.sr.setColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.sr.circle(xcenter, ycenter, (float)(10000.0 / this.extentUp) * (float)this.side2);
        this.sr.end();
        Gdx.gl.glLineWidth(2.0f);
        this.sr.begin(ShapeRenderer.ShapeType.Line);
        this.sr.setColor(this.occ);
        this.sr.circle((float)this.side2, (float)this.sideshort2, (float)(100000.0 / this.extentUp) * (float)this.side2);
        this.sr.circle((float)this.side2, (float)this.sideshort2, (float)(50000.0 / this.extentUp) * (float)this.side2);
        this.sr.circle((float)this.side2, (float)this.sideshort2, (float)(10000.0 / this.extentUp) * (float)this.side2);
        this.sr.end();
        Gdx.gl.glLineWidth(1.0f);
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.sr.setColor(this.sunc);
        this.sr.circle(xcenter, ycenter, this.px(this.suns));
        this.renderCameraSide(0.4f);
        this.sr.end();
        this.sb.begin();
        this.font.setColor(this.occ);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("oort_cloud"), (float)this.side2 - this.px(60.0f), (float)this.u2Px(-50000.0, this.sideshort2) + this.px(8.0f));
        this.font.setColor(this.sunc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("sun"), (float)this.side2 + this.px(8.0f), (float)this.u2Px(10.0, this.sideshort2) - this.px(2.0f));
        this.sb.end();
        fb.end();
    }

    @Override
    public void renderTopProjection(FrameBuffer fb) {
        Gdx.gl.glEnable(3042);
        this.ortho.setToOrtho(true, (float)this.side, (float)this.side);
        this.sr.setProjectionMatrix(this.ortho.combined);
        this.sb.setProjectionMatrix(this.ortho.combined);
        fb.begin();
        Gdx.gl.glClear(0x4100 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        Gdx.gl.glBlendFunc(770, 771);
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.sr.setColor(this.occ);
        this.sr.getColor().a = 0.5f;
        this.sr.circle((float)this.side2, (float)this.side2, (float)(100000.0 / this.extentUp) * (float)this.side2);
        this.sr.setColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.sr.circle((float)this.side2, (float)this.side2, (float)(10000.0 / this.extentUp) * (float)this.side2);
        this.sr.end();
        Gdx.gl.glLineWidth(2.0f);
        this.sr.begin(ShapeRenderer.ShapeType.Line);
        this.sr.setColor(this.occ);
        this.sr.circle((float)this.side2, (float)this.side2, (float)(100000.0 / this.extentUp) * (float)this.side2);
        this.sr.circle((float)this.side2, (float)this.side2, (float)(50000.0 / this.extentUp) * (float)this.side2);
        this.sr.circle((float)this.side2, (float)this.side2, (float)(10000.0 / this.extentUp) * (float)this.side2);
        this.sr.end();
        Gdx.gl.glLineWidth(1.0f);
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.sr.setColor(this.sunc);
        this.sr.circle((float)this.side2, (float)this.side2, this.px(this.suns));
        this.renderCameraTop(0.4f);
        this.sr.end();
        this.sb.begin();
        this.font.setColor(this.textbc);
        this.font.draw((Batch)this.sb, (CharSequence)("10,000 " + I18n.msg("gui.unit.au")), (float)this.side2, (float)this.u2Px(19000.0, this.side2));
        this.font.draw((Batch)this.sb, (CharSequence)("50,000 " + I18n.msg("gui.unit.au")), (float)this.side2, (float)this.u2Px(60000.0, this.side2));
        this.font.draw((Batch)this.sb, (CharSequence)("100,000 " + I18n.msg("gui.unit.au")), (float)this.side2, (float)this.u2Px(95000.0, this.side2));
        this.font.setColor(this.occ);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("oort_cloud"), (float)this.side2 + this.px(15.0f), (float)this.u2Px(-60000.0, this.side2) + this.px(8.0f));
        this.font.setColor(this.sunc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("sun"), (float)this.side2 + this.px(5.0f), (float)this.side2 - this.px(5.0f));
        this.sb.end();
        fb.end();
    }

    @Override
    public String getName() {
        return I18n.obj("oort_cloud");
    }
}

