/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.minimap;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import gaiasky.GaiaSky;
import gaiasky.gui.minimap.AbstractMinimapScale;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Constants;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.i18n.I18n;

public class OuterSolarSystemMinimapScale
extends AbstractMinimapScale {
    private final float[] satf;
    private final float[] uraf;
    private final float[] nepf;
    private final float[] jupf = new float[4];
    private final Color jupc;
    private final Color satc;
    private final Color nepc;
    private final Color urac;
    private final FocusView sat;
    private final FocusView ura;
    private final FocusView nep;
    private final FocusView jup;

    public OuterSolarSystemMinimapScale() {
        this.satf = new float[4];
        this.uraf = new float[4];
        this.nepf = new float[4];
        this.jupc = new Color(0.4f, 0.8f, 1.0f, 1.0f);
        this.satc = new Color(1.0f, 1.0f, 0.4f, 1.0f);
        this.urac = new Color(0.3f, 0.4f, 1.0f, 1.0f);
        this.nepc = new Color(0.8f, 0.2f, 1.0f, 1.0f);
        this.jup = new FocusView();
        this.sat = new FocusView();
        this.ura = new FocusView();
        this.nep = new FocusView();
    }

    @Override
    public void updateLocal() {
        if (this.jup.isEmpty()) {
            this.jup.setEntity(GaiaSky.instance.scene.index().getEntity("Jupiter"));
        }
        if (this.sat.isEmpty()) {
            this.sat.setEntity(GaiaSky.instance.scene.index().getEntity("Saturn"));
        }
        if (this.ura.isEmpty()) {
            this.ura.setEntity(GaiaSky.instance.scene.index().getEntity("Uranus"));
        }
        if (this.nep.isEmpty()) {
            this.nep.setEntity(GaiaSky.instance.scene.index().getEntity("Neptune"));
        }
        if (!this.jup.isEmpty()) {
            this.position(this.jup.getAbsolutePosition(this.aux3b1).tov3d(this.aux3d1), this.jupf);
        }
        if (!this.sat.isEmpty()) {
            this.position(this.sat.getAbsolutePosition(this.aux3b1).tov3d(this.aux3d1), this.satf);
        }
        if (!this.ura.isEmpty()) {
            this.position(this.ura.getAbsolutePosition(this.aux3b1).tov3d(this.aux3d1), this.uraf);
        }
        if (!this.nep.isEmpty()) {
            this.position(this.nep.getAbsolutePosition(this.aux3b1).tov3d(this.aux3d1), this.nepf);
        }
        this.position(GaiaSky.instance.cameraManager.getPos().tov3d(this.aux3d1), this.camp);
    }

    @Override
    public void initialize(OrthographicCamera ortho, SpriteBatch sb, ShapeRenderer sr, BitmapFont font, int side, int sideshort) {
        super.initialize(ortho, sb, sr, font, side, sideshort, Constants.AU_TO_U, Constants.U_TO_AU, 50.0, 2.2);
        this.trans = Coordinates.eqToEcl();
    }

    @Override
    public void renderSideProjection(FrameBuffer fb) {
        Gdx.gl.glEnable(3042);
        this.ortho.setToOrtho(true, (float)this.side, (float)this.sideshort);
        this.sr.setProjectionMatrix(this.ortho.combined);
        this.sb.setProjectionMatrix(this.ortho.combined);
        fb.begin();
        Gdx.gl.glClear(0x4100 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        Gdx.gl.glBlendFunc(770, 771);
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        float ycenter = this.u2Px(0.0, this.sideshort2);
        this.sr.setColor(this.nepc);
        this.sr.rectLine((float)this.u2Px(-30.0, this.side2), ycenter, (float)this.u2Px(30.0, this.side2), ycenter, 2.0f);
        this.sr.setColor(this.urac);
        this.sr.rectLine((float)this.u2Px(-20.0, this.side2), ycenter, (float)this.u2Px(20.0, this.side2), ycenter, 2.0f);
        this.sr.setColor(this.satc);
        this.sr.rectLine((float)this.u2Px(-9.2, this.side2), ycenter, (float)this.u2Px(9.2, this.side2), ycenter, 2.0f);
        this.sr.setColor(this.jupc);
        this.sr.rectLine((float)this.u2Px(-5.4, this.side2), ycenter, (float)this.u2Px(5.4, this.side2), ycenter, 2.0f);
        this.sr.setColor(this.sunc);
        this.sr.circle((float)this.u2Px(0.0, this.side2), ycenter, this.px(this.suns));
        this.sr.setColor(this.jupc);
        this.sr.circle(this.jupf[0], this.jupf[1], this.px(3.0f));
        this.sr.setColor(this.satc);
        this.sr.circle(this.satf[0], this.satf[1], this.px(3.0f));
        this.sr.setColor(this.urac);
        this.sr.circle(this.uraf[0], this.uraf[1], this.px(3.0f));
        this.sr.setColor(this.nepc);
        this.sr.circle(this.nepf[0], this.nepf[1], this.px(3.0f));
        this.renderCameraSide(0.4f);
        this.sr.end();
        this.sb.begin();
        this.font.setColor(this.jupc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("jupiter"), this.jupf[0] - this.px(20.0f), this.jupf[1] - this.px(10.0f));
        this.font.setColor(this.satc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("saturn"), this.satf[0] - this.px(20.0f), this.satf[1] + this.px(25.0f));
        this.font.setColor(this.urac);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("uranus"), this.uraf[0] - this.px(20.0f), this.uraf[1] - this.px(25.0f));
        this.font.setColor(this.nepc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("neptune"), this.nepf[0] - this.px(20.0f), this.nepf[1] + this.px(40.0f));
        this.font.setColor(this.sunc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("sun"), (float)this.side2 + this.px(8.0f), (float)this.u2Px(10.0, this.sideshort2) - this.px(2.0f));
        this.sb.end();
        fb.end();
    }

    @Override
    public void renderTopProjection(FrameBuffer fb) {
        Gdx.gl.glEnable(3042);
        this.ortho.setToOrtho(true, (float)this.side, (float)this.side);
        this.sr.setProjectionMatrix(this.ortho.combined);
        this.sb.setProjectionMatrix(this.ortho.combined);
        fb.begin();
        Gdx.gl.glClear(0x4100 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        Gdx.gl.glBlendFunc(770, 771);
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.sr.setColor(this.nepc);
        this.sr.getColor().mul(0.2f, 0.2f, 0.2f, 1.0f);
        this.sr.circle((float)this.side2, (float)this.side2, (float)(30.0 / this.extentUp) * (float)this.side2);
        this.sr.setColor(this.urac);
        this.sr.getColor().mul(0.2f, 0.2f, 0.2f, 1.0f);
        this.sr.circle((float)this.side2, (float)this.side2, (float)(20.0 / this.extentUp) * (float)this.side2);
        this.sr.setColor(this.satc);
        this.sr.getColor().mul(0.2f, 0.2f, 0.2f, 1.0f);
        this.sr.circle((float)this.side2, (float)this.side2, (float)(9.2 / this.extentUp) * (float)this.side2);
        this.sr.setColor(this.jupc);
        this.sr.getColor().mul(0.2f, 0.2f, 0.2f, 1.0f);
        this.sr.circle((float)this.side2, (float)this.side2, (float)(5.4 / this.extentUp) * (float)this.side2);
        this.sr.end();
        this.sr.begin(ShapeRenderer.ShapeType.Line);
        Gdx.gl.glLineWidth(2.0f);
        this.sr.setColor(this.jupc);
        this.sr.circle((float)this.side2, (float)this.side2, (float)(5.4 / this.extentUp) * (float)this.side2);
        this.sr.setColor(this.satc);
        this.sr.circle((float)this.side2, (float)this.side2, (float)(9.2 / this.extentUp) * (float)this.side2);
        this.sr.setColor(this.urac);
        this.sr.circle((float)this.side2, (float)this.side2, (float)(20.0 / this.extentUp) * (float)this.side2);
        this.sr.setColor(this.nepc);
        this.sr.circle((float)this.side2, (float)this.side2, (float)(30.0 / this.extentUp) * (float)this.side2);
        this.sr.end();
        Gdx.gl.glLineWidth(1.0f);
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.sr.setColor(this.sunc);
        this.sr.circle((float)this.side2, (float)this.side2, this.px(this.suns));
        this.sr.setColor(this.jupc);
        this.sr.circle(this.jupf[2], this.jupf[3], this.px(3.0f));
        this.sr.setColor(this.satc);
        this.sr.circle(this.satf[2], this.satf[3], this.px(3.0f));
        this.sr.setColor(this.urac);
        this.sr.circle(this.uraf[2], this.uraf[3], this.px(3.0f));
        this.sr.setColor(this.nepc);
        this.sr.circle(this.nepf[2], this.nepf[3], this.px(3.0f));
        this.renderCameraTop(0.2f);
        this.sr.end();
        this.sb.begin();
        this.font.setColor(this.textbc);
        this.font.draw((Batch)this.sb, (CharSequence)("5.4 " + I18n.msg("gui.unit.au")), (float)this.side2, (float)this.u2Px(8.0, this.side2));
        this.font.draw((Batch)this.sb, (CharSequence)("9.2 " + I18n.msg("gui.unit.au")), (float)this.side2, (float)this.u2Px(12.2, this.side2));
        this.font.draw((Batch)this.sb, (CharSequence)("20 " + I18n.msg("gui.unit.au")), (float)this.side2, (float)this.u2Px(23.0, this.side2));
        this.font.draw((Batch)this.sb, (CharSequence)("30 " + I18n.msg("gui.unit.au")), (float)this.side2, (float)this.u2Px(33.0, this.side2));
        this.font.setColor(this.jupc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("jupiter"), this.jupf[2] - this.px(20.0f), this.jupf[3] - this.px(8.0f));
        this.font.setColor(this.satc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("saturn"), this.satf[2] - this.px(20.0f), this.satf[3] - this.px(8.0f));
        this.font.setColor(this.urac);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("uranus"), this.uraf[2] - this.px(20.0f), this.uraf[3] - this.px(8.0f));
        this.font.setColor(this.nepc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("neptune"), this.nepf[2] - this.px(20.0f), this.nepf[3] - this.px(8.0f));
        this.font.setColor(this.sunc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("sun"), (float)this.side2 + this.px(5.0f), (float)this.side2 - this.px(5.0f));
        this.sb.end();
        fb.end();
    }

    @Override
    public String getName() {
        return I18n.msg("gui.minimap.outerss");
    }
}

