/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.minimap;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.utils.Scaling;
import gaiasky.gui.minimap.AbstractMinimapScale;
import gaiasky.util.Constants;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector2D;
import gaiasky.util.math.Vector3D;

public class SolarNeighbourhoodMinimapScale
extends AbstractMinimapScale {
    private Image topProjection;
    private Image sideProjection;

    public SolarNeighbourhoodMinimapScale() {
        this.camp = new float[4];
    }

    @Override
    public void updateLocal() {
    }

    @Override
    public void initialize(OrthographicCamera ortho, SpriteBatch sb, ShapeRenderer sr, BitmapFont font, int side, int sideshort) {
        super.initialize(ortho, sb, sr, font, side, sideshort, Constants.PC_TO_U, Constants.U_TO_PC, 500.0, 100000.0 * Constants.AU_TO_U * Constants.U_TO_PC);
        Texture texTop = new Texture(Gdx.files.internal("img/minimap/solar_neighbourhood_top_s.jpg"));
        texTop.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        this.topProjection = new Image(texTop);
        this.topProjection.setScaling(Scaling.fit);
        this.topProjection.setSize((float)side, (float)side);
        Texture texSide = new Texture(Gdx.files.internal("img/minimap/solar_neighbourhood_side_s.jpg"));
        texSide.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        this.sideProjection = new Image(texSide);
        this.sideProjection.setScaling(Scaling.fit);
        this.sideProjection.setSize((float)side, (float)sideshort);
        this.trans = Coordinates.eqToGal();
    }

    @Override
    public float[] position(Vector3D pos, float[] out) {
        Vector3D p = this.aux3d1.set(pos).mul(this.trans);
        Vector2D pos2d = this.aux2d1;
        pos2d.set(p.z, p.y).scl(this.from);
        float cx = this.u2Px(pos2d.x, this.side2);
        float cy = this.u2Px(pos2d.y, this.sideshort2);
        out[0] = cx;
        out[1] = cy;
        pos2d.set(-p.x, p.z).scl(this.from);
        cx = this.u2Px(pos2d.x, this.side2);
        cy = this.u2Px(pos2d.y, this.side2);
        out[2] = cx;
        out[3] = cy;
        return out;
    }

    @Override
    public void renderSideProjection(FrameBuffer fb) {
        this.ortho.setToOrtho(true, (float)this.side, (float)this.sideshort);
        this.sr.setProjectionMatrix(this.ortho.combined);
        this.sb.setProjectionMatrix(this.ortho.combined);
        fb.begin();
        Gdx.gl.glClear(0x4100 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        this.sb.begin();
        this.sideProjection.draw((Batch)this.sb, 1.0f);
        this.sb.end();
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        this.sr.begin(ShapeRenderer.ShapeType.Line);
        this.sr.setColor(this.textyc);
        this.sr.getColor().a *= 0.6f;
        this.sr.line(0.0f, (float)this.sideshort2, (float)this.side, (float)this.sideshort2);
        this.sr.line((float)this.side2, 0.0f, (float)this.side2, (float)this.side);
        this.sr.setColor(this.textbc);
        this.sr.getColor().a *= 0.3f;
        this.sr.circle((float)this.side2, (float)this.sideshort2, (float)this.side2);
        this.sr.circle((float)this.side2, (float)this.sideshort2, (float)this.side2 / 2.0f);
        this.sr.end();
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.sr.setColor(this.sunc);
        this.sr.circle((float)this.side2, (float)this.sideshort2, this.px(this.suns));
        this.renderCameraSide();
        this.sr.end();
        this.sb.begin();
        this.font.setColor(this.sunc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("sun"), (float)this.side2 + this.px(7.0f), (float)this.sideshort2);
        this.font.setColor(this.textgc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.msg("gui.minimap.togc"), (float)this.side - this.px(50.0f), (float)this.sideshort2 + this.px(15.0f));
        this.font.draw((Batch)this.sb, (CharSequence)I18n.msg("gui.minimap.tooutergalaxy"), 0.0f, (float)this.sideshort2 + this.px(15.0f));
        this.font.draw((Batch)this.sb, (CharSequence)I18n.msg("gui.minimap.ngp"), (float)this.side2 - this.px(30.0f), (float)this.sideshort);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.msg("gui.minimap.sgp"), (float)this.side2 - this.px(30.0f), this.px(30.0f));
        this.sb.end();
        fb.end();
    }

    @Override
    public void renderTopProjection(FrameBuffer fb) {
        this.ortho.setToOrtho(true, (float)this.side, (float)this.side);
        this.sr.setProjectionMatrix(this.ortho.combined);
        this.sb.setProjectionMatrix(this.ortho.combined);
        fb.begin();
        Gdx.gl.glClear(0x4100 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        Gdx.gl.glBlendFunc(770, 771);
        this.sb.begin();
        this.topProjection.draw((Batch)this.sb, 1.0f);
        this.sb.end();
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        this.sr.begin(ShapeRenderer.ShapeType.Line);
        this.sr.setColor(this.textyc);
        this.sr.getColor().a *= 0.6f;
        this.sr.line(0.0f, (float)this.side2, (float)this.side, (float)this.side2);
        this.sr.line((float)this.side2, 0.0f, (float)this.side2, (float)this.side);
        this.sr.setColor(this.textbc);
        this.sr.getColor().a *= 0.3f;
        this.sr.circle((float)this.side2, (float)this.side2, (float)this.side2);
        this.sr.circle((float)this.side2, (float)this.side2, (float)this.side2 * 3.0f / 4.0f);
        this.sr.circle((float)this.side2, (float)this.side2, (float)this.side2 / 2.0f);
        this.sr.circle((float)this.side2, (float)this.side2, (float)this.side2 / 4.0f);
        this.sr.end();
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.sr.setColor(this.sunc);
        this.sr.circle((float)this.side2, (float)this.side2, this.px(this.suns));
        this.renderCameraTop();
        this.sr.end();
        this.sb.begin();
        this.font.setColor(1.0f, 1.0f, 0.0f, 1.0f);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("sun"), (float)this.side2 + this.px(10.0f), (float)this.side2 + this.px(10.0f));
        this.font.setColor(this.textgc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("hyades"), (float)this.side2 + this.px(5.0f), (float)this.side2 - this.px(5.0f));
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("pleiades"), (float)this.side2, (float)this.side2 - this.px(20.0f));
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("taurus"), (float)this.side2 - this.px(30.0f), (float)this.side2 - this.px(40.0f));
        this.font.draw((Batch)this.sb, (CharSequence)"Near\nPerseus", (float)this.side2 - this.px(70.0f), (float)this.side2 - this.px(50.0f));
        this.font.draw((Batch)this.sb, (CharSequence)"Far\nPerseus", (float)this.side2 - this.px(50.0f), (float)this.side2 - this.px(85.0f));
        this.font.draw((Batch)this.sb, (CharSequence)"Orion", (float)this.side2 + this.px(20.0f), (float)this.side2 - this.px(85.0f));
        this.font.draw((Batch)this.sb, (CharSequence)"Cepheus", (float)this.side2 - this.px(110.0f), (float)this.side2 - this.px(30.0f));
        this.font.draw((Batch)this.sb, (CharSequence)"Coalsack", (float)this.side2 + this.px(30.0f), (float)this.side2 + this.px(30.0f));
        this.font.draw((Batch)this.sb, (CharSequence)"Ophiucus", (float)this.side2, (float)this.side2 + this.px(45.0f));
        this.font.draw((Batch)this.sb, (CharSequence)"Near\nAquila", (float)this.side2 - this.px(50.0f), (float)this.side2 + this.px(55.0f));
        this.font.draw((Batch)this.sb, (CharSequence)"Serpens", (float)this.side2 - this.px(70.0f), (float)this.side2 + this.px(85.0f));
        this.font.setColor(this.textrc);
        this.font.draw((Batch)this.sb, (CharSequence)"ORI OB1", (float)this.side2 + this.px(30.0f), (float)this.side2 - this.px(70.0f));
        this.font.draw((Batch)this.sb, (CharSequence)"VEL OB2", (float)this.side2 + this.px(65.0f), (float)this.side2 - this.px(15.0f));
        this.font.setColor(this.textmc);
        this.font.draw((Batch)this.sb, (CharSequence)("0" + I18n.msg("gui.unit.deg")), (float)this.side2 - this.px(15.0f), (float)this.side - this.px(5.0f));
        this.font.draw((Batch)this.sb, (CharSequence)("270" + I18n.msg("gui.unit.deg")), (float)this.side - this.px(30.0f), (float)this.side2 + this.px(5.0f));
        this.font.draw((Batch)this.sb, (CharSequence)("180" + I18n.msg("gui.unit.deg")), (float)this.side2 + this.px(3.0f), this.px(15.0f));
        this.font.draw((Batch)this.sb, (CharSequence)("90" + I18n.msg("gui.unit.deg")), this.px(5.0f), (float)this.side2 + this.px(5.0f));
        this.font.setColor(this.textbc);
        this.font.draw((Batch)this.sb, (CharSequence)("250" + I18n.msg("gui.unit.pc")), (float)this.side2 + this.px(15.0f), (float)this.side2 + (float)this.side2 / 2.0f + this.px(10.0f));
        this.font.draw((Batch)this.sb, (CharSequence)("500" + I18n.msg("gui.unit.pc")), (float)this.side2 + this.px(25.0f), (float)this.side);
        this.sb.end();
        fb.end();
    }

    @Override
    public String getName() {
        return I18n.msg("gui.minimap.solarneighbourhood");
    }
}

