/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.util;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.gui.api.LinkListener;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.Link;
import gaiasky.util.scene2d.OwnTextButton;
import gaiasky.util.scene2d.OwnTextTooltip;

public class ExternalInformationUpdater {
    private static final Logger.Log logger = Logger.getLogger(ExternalInformationUpdater.class);
    private Skin skin;
    private Label.LabelStyle linkStyle;
    private Cell<Link> dataCell;
    private Cell<Link> gaiaCell;
    private Cell<Link> simbadCell;
    private Link simbadLink;
    private OwnTextButton infoButton;
    private OwnTextButton archiveButton;
    private Table table;
    private float pad;

    public void setParameters(Table table, Skin skin, float pad) {
        this.table = table;
        this.skin = skin;
        this.linkStyle = (Label.LabelStyle)skin.get("link", Label.LabelStyle.class);
        this.pad = pad;
    }

    public void update(FocusView focus) {
        GaiaSky.postRunnable(() -> {
            if (focus != null) {
                logger.debug("Looking up network resources for '" + focus.getName() + "'");
                this.table.row();
                this.dataCell = this.table.add().left();
                this.gaiaCell = this.table.add().left();
                this.simbadCell = this.table.add().left();
                if (focus.isStar()) {
                    EventManager.publish(Event.UPDATE_ARCHIVE_VIEW_CMD, this, focus);
                    if (this.archiveButton != null) {
                        this.archiveButton.remove();
                    }
                    this.archiveButton = new OwnTextButton(I18n.msg("gui.focusinfo.archive"), this.skin);
                    this.archiveButton.pad(this.pad / 3.0f, this.pad, this.pad / 3.0f, this.pad);
                    this.archiveButton.addListener(new GaiaArchiveButtonListener(focus));
                    this.archiveButton.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.gaiaarchive"), this.skin));
                    this.gaiaCell.setActor((Actor)this.archiveButton).padRight(this.pad);
                } else {
                    this.gaiaCell.padRight(0.0f);
                }
                EventManager.publish(Event.UPDATE_DATA_INFO_CMD, this, focus);
                if (this.infoButton != null) {
                    this.infoButton.remove();
                }
                this.infoButton = new OwnTextButton(I18n.msg("gui.focusinfo.moreinfo"), this.skin);
                this.infoButton.setDisabled(Settings.settings.program.offlineMode);
                this.infoButton.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.wiki"), this.skin));
                this.infoButton.pad(this.pad / 3.0f, this.pad, this.pad / 3.0f, this.pad);
                this.infoButton.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        EventManager.publish(Event.SHOW_DATA_INFO_CMD, this, focus);
                        return true;
                    }
                    return false;
                });
                this.dataCell.setActor((Actor)this.infoButton).padRight(this.pad);
                this.setSimbadLink(focus, new LinkListener(){

                    @Override
                    public void ok(String link, String languageCode) {
                        if (ExternalInformationUpdater.this.simbadCell != null) {
                            try {
                                if (ExternalInformationUpdater.this.simbadLink != null) {
                                    ExternalInformationUpdater.this.simbadLink.remove();
                                }
                                ExternalInformationUpdater.this.simbadLink = new Link((CharSequence)I18n.msg("gui.focusinfo.simbad"), ExternalInformationUpdater.this.linkStyle, "");
                                ExternalInformationUpdater.this.simbadLink.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.simbad"), ExternalInformationUpdater.this.skin));
                                ExternalInformationUpdater.this.simbadLink.setLinkURL(link);
                                ExternalInformationUpdater.this.simbadCell.setActor((Actor)ExternalInformationUpdater.this.simbadLink);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }

                    @Override
                    public void ko(String link) {
                    }
                });
            }
        });
    }

    private void setSimbadLink(FocusView focus, LinkListener listener) {
        if (focus.isStar()) {
            String url = "https://simbad.u-strasbg.fr/simbad/sim-id?Ident=";
            if (focus.getHip() > 0) {
                listener.ok(url + "HIP+" + focus.getHip(), "en");
            } else {
                listener.ko(null);
            }
        } else {
            listener.ko(null);
        }
    }

    private record GaiaArchiveButtonListener(FocusView focus) implements EventListener
    {
        public boolean handle(com.badlogic.gdx.scenes.scene2d.Event event) {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_ARCHIVE_VIEW_CMD, this, this.focus);
                return true;
            }
            return false;
        }
    }
}

