/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.vr;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.glutils.HdpiUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.viewport.Viewport;
import gaiasky.util.Settings;
import gaiasky.util.camera.CameraUtils;

public class FixedScreenViewport
extends Viewport {
    private final int width;
    private final int height;
    final Vector3 tmp = new Vector3();

    public FixedScreenViewport(int width, int height) {
        this(width, height, (Camera)new OrthographicCamera());
    }

    public FixedScreenViewport(int width, int height, Camera camera) {
        this.setCamera(camera);
        this.width = width;
        this.height = height;
    }

    public Vector2 unproject(Vector2 screenCoords) {
        this.tmp.set(screenCoords.x, screenCoords.y, 1.0f);
        CameraUtils.unproject(this.getCamera(), this.tmp, this.getScreenX(), this.getScreenY(), this.getScreenWidth(), this.getScreenHeight(), this.height);
        screenCoords.set(this.tmp.x, this.tmp.y);
        return screenCoords;
    }

    public Vector3 unproject(Vector3 screenCoords) {
        CameraUtils.unproject(this.getCamera(), screenCoords, this.getScreenX(), this.getScreenY(), this.getScreenWidth(), this.getScreenHeight(), this.height);
        return screenCoords;
    }

    public Vector2 toScreenCoordinates(Vector2 worldCoords, Matrix4 transformMatrix) {
        this.tmp.set(worldCoords.x, worldCoords.y, 0.0f);
        this.tmp.mul(transformMatrix);
        this.getCamera().project(this.tmp, (float)this.getScreenX(), (float)this.getScreenY(), (float)this.getScreenWidth(), (float)this.getScreenHeight());
        this.tmp.y = (float)this.height - this.tmp.y;
        worldCoords.x = this.tmp.x;
        worldCoords.y = this.tmp.y;
        return worldCoords;
    }

    public void update(int screenWidth, int screenHeight, boolean centerCamera) {
        this.setScreenBounds(0, 0, this.width, this.height);
        this.setWorldSize(this.width, this.height);
        this.apply(centerCamera);
    }

    public void apply(boolean centerCamera) {
        int bbw = Settings.settings.graphics.backBufferResolution[0];
        int bbh = Settings.settings.graphics.backBufferResolution[1];
        if (this.width != bbw || this.height != bbh) {
            HdpiUtils.glViewport((int)0, (int)0, (int)(this.width * bbw / this.width), (int)(this.height * bbh / this.height));
        } else {
            HdpiUtils.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        }
        HdpiUtils.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        this.getCamera().viewportWidth = this.width;
        this.getCamera().viewportHeight = this.height;
        if (centerCamera) {
            this.getCamera().position.set((float)this.width / 2.0f, (float)this.height / 2.0f, 0.0f);
        }
        this.getCamera().update();
    }

    public float getUnitsPerPixel() {
        return 1.0f;
    }
}

