/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.vr;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.api.IGui;
import gaiasky.gui.main.GamepadGui;
import gaiasky.gui.vr.FixedScreenViewport;
import gaiasky.render.BlendMode;
import gaiasky.render.ComponentTypes;
import gaiasky.render.RenderGroup;
import gaiasky.scene.Archetype;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.AffineTransformations;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Coordinates;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.RenderType;
import gaiasky.scene.component.VRDevice;
import gaiasky.scene.component.tag.TagNoClosest;
import gaiasky.scene.record.ModelComponent;
import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.camera.CameraUtils;
import gaiasky.util.coord.StaticCoordinates;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.TextureAttribute;
import gaiasky.util.math.IntersectorDouble;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.scene2d.FixedStage;
import gaiasky.vr.openxr.input.XrControllerDevice;
import gaiasky.vr.openxr.input.XrInputListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MainVRGui
implements XrInputListener,
InputProcessor,
IGui,
IObserver,
Disposable {
    public static final int WIDTH = 1632;
    public static final int HEIGHT = 918;
    public static final double HEIGHT_OVER_WIDTH = 0.5625;
    public static final double HEIGHT_OVER_2WIDTH = 0.28125;
    Scene scene;
    Stage stage;
    Skin skin;
    FrameBuffer buffer;
    Entity entity;
    Vector3Q relativePosition = new Vector3Q();
    Vector2 pointer = new Vector2(Float.NaN, Float.NaN);
    boolean triggerPressed = false;
    boolean mouseHit = false;
    boolean vr;
    boolean visible = false;
    ShapeRenderer shapeRenderer;
    SpriteBatch batch;
    Set<VRDevice> vrControllers;
    Map<XrControllerDevice, VRDevice> deviceToDevice;
    private GamepadGui gamepadGui;
    private XrControllerDevice interactingController;
    private final Vector3D auxDouble = new Vector3D();
    private final Vector3 aux = new Vector3();
    private final Vector3D mouseP0 = new Vector3D();
    private final Vector3D mouseP1 = new Vector3D();
    private final Vector3D point = new Vector3D();
    private final Vector3D normal = new Vector3D();
    private final Vector3D p0 = new Vector3D();
    private final Vector3D p1 = new Vector3D();
    private final Vector3D intersection3D = new Vector3D();
    private final Vector3D intersection2D = new Vector3D();
    private final Matrix4D transform = new Matrix4D();
    private final Matrix4D inverse = new Matrix4D();
    private final Vector3D camDir = new Vector3D();
    private final Vector3D camUp = new Vector3D();
    private final Vector3D up = new Vector3D();
    private final Vector3D side = new Vector3D();

    public MainVRGui(Skin skin) {
        this.setSkin(skin);
    }

    @Override
    public void initialize(AssetManager manager, SpriteBatch batch) {
        this.setVR(Settings.settings.runtime.openXr);
        this.batch = new SpriteBatch(20, GaiaSky.instance.getGlobalResources().getSpriteShader());
        this.shapeRenderer = new ShapeRenderer(100, GaiaSky.instance.getGlobalResources().getShapeShader());
        this.shapeRenderer.setAutoShapeType(true);
        this.vrControllers = new HashSet<VRDevice>();
        this.deviceToDevice = new HashMap<XrControllerDevice, VRDevice>();
        GLFrameBuffer.FrameBufferBuilder builder = new GLFrameBuffer.FrameBufferBuilder(1632, 918);
        builder.addBasicColorTextureAttachment(Pixmap.Format.RGBA8888);
        this.buffer = builder.build();
        EventManager.instance.subscribe((IObserver)this, Event.SHOW_VR_UI, Event.VR_CONTROLLER_INFO, Event.SCENE_LOADED);
    }

    @Override
    public void doneLoading(AssetManager assetManager) {
    }

    public void build(Skin skin) {
        if (this.stage != null) {
            this.stage.clear();
        } else {
            FixedScreenViewport vp = new FixedScreenViewport(1632, 918);
            this.stage = new FixedStage(vp, this.batch, 1632, 918);
        }
        if (this.gamepadGui == null) {
            this.gamepadGui = new GamepadGui(skin, Gdx.graphics, Float.valueOf(1.0f), true);
            this.gamepadGui.initialize(this.stage);
        }
        this.gamepadGui.build();
        Table content = this.gamepadGui.getContent();
        content.setFillParent(true);
        content.left().top();
        this.stage.addActor((Actor)content);
    }

    @Override
    public void update(double dt) {
        Base base;
        if (this.entity != null && (base = (Base)Mapper.base.get(this.entity)).isVisible()) {
            if (!this.vr || !this.vrControllers.isEmpty()) {
                Model model = (Model)Mapper.model.get(this.entity);
                AffineTransformations affine = (AffineTransformations)Mapper.affine.get(this.entity);
                this.transform.set(model.model.instance.transform);
                this.inverse.set(this.transform).inv();
                ICamera camera = GaiaSky.instance.getICamera();
                this.point.set(0.0, 0.0, 0.0);
                this.normal.set(0.0, -1.0, 0.0);
                this.point.mul(this.transform);
                this.normal.mul(affine.apply(this.transform.idt()));
                int intersecting = 0;
                for (VRDevice device : this.vrControllers) {
                    if (device.device.isInitialized() && device.device.isActive()) {
                        if (!this.deviceToDevice.containsKey(device.device)) {
                            this.deviceToDevice.put(device.device, device);
                        }
                        intersecting += this.processDevice(device, this.p0.set(device.beamP0), this.p1.set(device.beamPn));
                        continue;
                    }
                    this.deviceToDevice.remove(device.device);
                }
                if (!this.vr) {
                    ICamera cam = GaiaSky.instance.getICamera();
                    this.aux.set((float)Gdx.input.getX(), (float)Gdx.input.getY(), 0.1f);
                    CameraUtils.unproject((Camera)cam.getCamera(), this.aux, 1632, 918);
                    this.mouseP0.set(this.aux).scl(3200.0);
                    this.mouseP1.set(cam.getDirection()).nor().scl(10.0 * Constants.KM_TO_U).add(this.mouseP0);
                    int nHits = this.processDevice(null, this.p0.set(this.mouseP0), this.p1.set(this.mouseP1));
                    this.mouseHit = nHits > 0;
                    intersecting += nHits;
                }
                if (intersecting == 0) {
                    this.pointer.x = Float.NaN;
                    this.pointer.y = Float.NaN;
                }
            }
            this.stage.act((float)dt);
        }
    }

    private int processDevice(VRDevice device, Vector3D beamP0, Vector3D beamP1) {
        ICamera cam = GaiaSky.instance.getICamera();
        boolean intersects = IntersectorDouble.intersectLineSegmentPlane(beamP0, beamP1, this.normal, this.point, this.intersection3D);
        if (intersects) {
            this.intersection2D.set(this.intersection3D).mul(this.inverse);
            double x3d = this.intersection2D.x;
            double v = (x3d + 0.28125) / 0.5625;
            double z3d = this.intersection2D.z;
            double u = z3d + 0.5;
            if (device != null) {
                device.intersection.set(this.intersection3D);
                boolean bl = device.hitUI = u > 0.0 && u < 1.0 && v > 0.0 && v < 1.0;
                if (this.interactingController == null) {
                    this.interactingController = device.device;
                }
                boolean bl2 = device.interacting = device.device == this.interactingController;
            }
            if (device == null || device.hitUI && device.device == this.interactingController) {
                int x = (int)(u * 1632.0);
                int y = (int)(v * 918.0);
                this.pointer.x = x;
                this.pointer.y = 918 - y;
                if (this.triggerPressed) {
                    this.stage.touchDragged(x, y, 0);
                } else {
                    this.stage.mouseMoved(x, y);
                }
                return 1;
            }
        }
        return 0;
    }

    private void updatePosition() {
        Base base;
        if (this.entity != null && (base = (Base)Mapper.base.get(this.entity)).isVisible()) {
            ICamera camera = GaiaSky.instance.getICamera();
            Body body = (Body)Mapper.body.get(this.entity);
            Coordinates coord = (Coordinates)Mapper.coordinates.get(this.entity);
            AffineTransformations affine = (AffineTransformations)Mapper.affine.get(this.entity);
            body.pos.set(camera.getPos()).add(this.relativePosition);
            ((StaticCoordinates)coord.coordinates).setPosition(body.pos);
        }
    }

    private boolean isVRUIVisible() {
        return this.entity != null && ((Base)Mapper.base.get(this.entity)).isVisible();
    }

    private void showVRUI(Base base) {
        if (base != null) {
            this.gamepadGui.programmaticUpdate();
            this.gamepadGui.getContent().getColor().a = 0.0f;
            base.visible = true;
            this.visible = true;
            this.gamepadGui.getContent().addAction((Action)Actions.sequence((Action)Actions.visible((boolean)true), (Action)Actions.fadeIn((float)Settings.settings.program.ui.getAnimationSeconds())));
            if (!this.vr) {
                GaiaSky.instance.inputMultiplexer.addProcessor((InputProcessor)this);
            }
            GaiaSky.instance.scripting().parkCameraRunnable("VRUI-pos-updater", this::updatePosition);
        }
    }

    private void hideVRUI(Base base) {
        if (base != null) {
            this.gamepadGui.getContent().getColor().a = 1.0f;
            this.gamepadGui.getContent().addAction((Action)Actions.sequence((Action)Actions.fadeOut((float)Settings.settings.program.ui.getAnimationSeconds()), (Action)Actions.run(() -> {
                base.visible = false;
                this.visible = false;
                for (VRDevice device : this.vrControllers) {
                    device.hitUI = false;
                }
                GaiaSky.instance.scripting().removeRunnable("VRUI-pos-updater");
            }), (Action)Actions.visible((boolean)false)));
            if (!this.vr) {
                GaiaSky.instance.inputMultiplexer.removeProcessor((InputProcessor)this);
            }
        }
    }

    public boolean contains(int x, int y, Vector3[] points) {
        boolean result = false;
        int i = 0;
        int j = points.length - 1;
        while (i < points.length) {
            if (points[i].y > (float)y != points[j].y > (float)y && (float)x < (points[j].x - points[i].x) * ((float)y - points[i].y) / (points[j].y - points[i].y) + points[i].x) {
                result = !result;
            }
            j = i++;
        }
        return result;
    }

    @Override
    public void render(int rw, int rh) {
        if (this.stage != null) {
            this.buffer.begin();
            Gdx.gl.glClear(16640);
            this.stage.draw();
            this.buffer.end();
        }
    }

    @Override
    public void resize(int width, int height) {
        if (this.shapeRenderer != null) {
            this.shapeRenderer.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, 1632.0f, 918.0f);
            this.shapeRenderer.updateMatrices();
        }
        if (this.batch != null) {
            this.batch.setProjectionMatrix(this.batch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, 1632.0f, 918.0f));
        }
    }

    @Override
    public void resizeImmediate(int width, int height) {
    }

    @Override
    public boolean cancelTouchFocus() {
        return false;
    }

    @Override
    public Stage getGuiStage() {
        return this.stage;
    }

    @Override
    public void setVisibilityToggles(ComponentTypes.ComponentType[] entities, ComponentTypes visible) {
    }

    @Override
    public Actor findActor(String name) {
        return null;
    }

    @Override
    public void setVR(boolean vr) {
        this.vr = vr;
    }

    @Override
    public boolean isVR() {
        return this.vr;
    }

    @Override
    public boolean mustDraw() {
        return true;
    }

    @Override
    public boolean updateUnitsPerPixel(float upp) {
        return false;
    }

    @Override
    public float getUnitsPerPixel() {
        return 1.0f;
    }

    @Override
    public void setBackBufferSize(int width, int height) {
    }

    public void dispose() {
        if (this.buffer != null) {
            this.buffer.dispose();
        }
        if (this.stage != null) {
            this.stage.dispose();
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.SHOW_VR_UI) {
            GaiaSky.postRunnable(() -> {
                if (this.entity == null) {
                    Archetype at = this.scene.archetypes().get("gaiasky.scenegraph.ModelBody");
                    Entity entity = at.createEntity();
                    entity.add((Component)new TagNoClosest());
                    Base base = (Base)Mapper.base.get(entity);
                    base.setName("VRUI");
                    base.archetype = at;
                    base.ct = new ComponentTypes(ComponentTypes.ComponentType.Others.ordinal());
                    base.visible = false;
                    Body body = (Body)Mapper.body.get(entity);
                    body.setColor(new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    body.setLabelColor(new float[]{0.0f, 0.0f, 0.0f, 0.0f});
                    if (this.vr) {
                        body.setSize(1.0);
                        body.sizeInUnitsFlag = true;
                    } else {
                        body.setSizeKm(1.0);
                    }
                    AffineTransformations affine = (AffineTransformations)Mapper.affine.get(entity);
                    affine.initialize();
                    Coordinates coord = (Coordinates)Mapper.coordinates.get(entity);
                    StaticCoordinates staticCoordinates = new StaticCoordinates();
                    staticCoordinates.setPosition(body.pos);
                    coord.coordinates = staticCoordinates;
                    GraphNode graph = (GraphNode)Mapper.graph.get(entity);
                    graph.setParent("Universe");
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("divisionsu", 1L);
                    params.put("divisionsv", 1L);
                    params.put("width", 1.0);
                    params.put("height", 0.5625);
                    params.put("flip", false);
                    Model model = (Model)Mapper.model.get(entity);
                    model.model = new ModelComponent();
                    model.model.type = "surface";
                    model.modelSize = 1.0;
                    model.model.setPrimitiveType(4);
                    model.model.setParams(params);
                    model.model.setStaticLight(1.0);
                    model.model.setBlendMode(BlendMode.ALPHA);
                    RenderType rt = (RenderType)Mapper.renderType.get(entity);
                    rt.renderGroup = RenderGroup.MODEL_PIX_TRANSPARENT;
                    this.scene.initializeEntity(entity);
                    this.scene.setUpEntity(entity);
                    Material mat = (Material)model.model.instance.materials.get(0);
                    if (mat != null) {
                        mat.set((Attribute)TextureAttribute.createDiffuse((Texture)this.buffer.getColorBufferTexture()));
                    }
                    this.entity = entity;
                    EventManager.publish(Event.SCENE_ADD_OBJECT_NO_POST_CMD, this, entity, true);
                }
                Runnable r = () -> {
                    Base base = (Base)Mapper.base.get(this.entity);
                    if (base.isVisible()) {
                        this.hideVRUI(base);
                    } else {
                        this.build(this.skin);
                        this.showVRUI(base);
                        ICamera camera = GaiaSky.instance.getICamera();
                        Vector3D dir = this.camDir.set(camera.getDirection());
                        dir.y = 0.0;
                        dir.nor();
                        Body body = (Body)Mapper.body.get(this.entity);
                        body.setSize(0.95);
                        if (this.vr) {
                            body.pos.set(camera.getPos().cpy().add(camera.getCamera().position).add(dir.scl(0.9)));
                        } else {
                            body.pos.set(camera.getPos().cpy().add(dir.scl(2.0 * Constants.KM_TO_U)));
                        }
                        this.relativePosition.set(body.pos).sub(camera.getPos());
                        Coordinates coord = (Coordinates)Mapper.coordinates.get(this.entity);
                        ((StaticCoordinates)coord.coordinates).setPosition(body.pos);
                        AffineTransformations affine = (AffineTransformations)Mapper.affine.get(this.entity);
                        affine.transformations.clear();
                        dir.set(camera.getCamera().direction);
                        double angle = dir.angle(new Vector3D(0.0, 0.0, 1.0));
                        if (dir.x < 0.0) {
                            angle = -angle;
                        }
                        affine.setQuaternion(new double[]{0.0, 1.0, 0.0}, angle);
                        affine.setQuaternion(new double[]{1.0, 0.0, 0.0}, 90.0);
                        affine.setQuaternion(new double[]{0.0, 1.0, 0.0}, -90.0);
                    }
                };
                r.run();
            });
        } else if (event == Event.VR_CONTROLLER_INFO) {
            this.vrControllers.add((VRDevice)data[0]);
        } else if (event == Event.SCENE_LOADED) {
            this.setScene((Scene)data[0]);
        }
    }

    public void setScene(Scene scene) {
        this.scene = scene;
    }

    public void setSkin(Skin skin) {
        this.skin = skin;
    }

    public boolean keyDown(int keycode) {
        return false;
    }

    public boolean keyUp(int keycode) {
        return false;
    }

    public boolean keyTyped(char character) {
        return false;
    }

    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (!this.vr && button == 0 && this.mouseHit) {
            this.stage.touchDown((int)this.pointer.x, (int)(918.0f - this.pointer.y), 0, button);
            this.triggerPressed = true;
            return true;
        }
        return false;
    }

    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (!this.vr && button == 0 && this.mouseHit) {
            this.stage.touchUp((int)this.pointer.x, (int)(918.0f - this.pointer.y), 0, button);
            this.triggerPressed = false;
            return true;
        }
        return false;
    }

    public boolean touchCancelled(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    public boolean scrolled(float amountX, float amountY) {
        return false;
    }

    @Override
    public boolean showUI(boolean value, XrControllerDevice device) {
        return false;
    }

    @Override
    public boolean accept(boolean value, XrControllerDevice device) {
        return false;
    }

    @Override
    public boolean cameraMode(boolean value, XrControllerDevice device) {
        return false;
    }

    @Override
    public boolean rotate(boolean value, XrControllerDevice device) {
        return false;
    }

    @Override
    public boolean move(Vector2 value, XrControllerDevice device) {
        return false;
    }

    @Override
    public boolean select(float value, XrControllerDevice device) {
        if (this.visible) {
            if (value > 0.0f) {
                VRDevice dev = this.deviceToDevice.get(device);
                if (dev.hitUI && !dev.interacting) {
                    this.interactingController = dev.device;
                    dev.interacting = true;
                }
                if (Float.isFinite(this.pointer.x) && Float.isFinite(this.pointer.y)) {
                    this.stage.touchDown((int)this.pointer.x, (int)(918.0f - this.pointer.y), 0, 0);
                    this.triggerPressed = true;
                    this.interactingController = device;
                    return true;
                }
            } else {
                VRDevice dev = this.deviceToDevice.get(device);
                if (dev.hitUI && !dev.interacting) {
                    this.interactingController = dev.device;
                    dev.interacting = true;
                }
                if (Float.isFinite(this.pointer.x) && Float.isFinite(this.pointer.y) && device == this.interactingController) {
                    this.stage.touchUp((int)this.pointer.x, (int)(918.0f - this.pointer.y), 0, 0);
                    this.triggerPressed = false;
                    return true;
                }
            }
        }
        return false;
    }
}

