/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.vr;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.camera.NaturalCamera;
import gaiasky.scene.component.VRDevice;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Logger;
import gaiasky.util.comp.ViewAngleComparator;
import gaiasky.util.math.Vector3D;
import gaiasky.vr.openxr.XrDriver;
import gaiasky.vr.openxr.input.XrControllerDevice;
import gaiasky.vr.openxr.input.XrInputListener;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OpenXRListener
implements XrInputListener,
IObserver {
    private static final Logger.Log logger = Logger.getLogger(OpenXRListener.class);
    private static final long SELECTION_COUNTDOWN_MS = 1500L;
    private final NaturalCamera cam;
    private XrDriver driver;
    private final Comparator<Entity> comp;
    private final Vector3D p0;
    private final Vector3D p1;
    private final FocusView focusView;
    private Map<XrControllerDevice, Entity> xrControllerToModel;
    private final Set<XrControllerDevice> selecting = ConcurrentHashMap.newKeySet(2);
    private long selectingTime = 0L;
    private long lastAxisMovedFrame = Long.MIN_VALUE;

    public OpenXRListener(NaturalCamera cam) {
        this.cam = cam;
        this.comp = new ViewAngleComparator<Entity>();
        this.p0 = new Vector3D();
        this.p1 = new Vector3D();
        this.focusView = new FocusView();
        EventManager.instance.subscribe((IObserver)this, Event.VR_DRIVER_LOADED);
    }

    private void lazyInit() {
        if (this.xrControllerToModel == null) {
            this.xrControllerToModel = GaiaSky.instance.sceneRenderer.getXRControllerToModel();
        }
    }

    public void update() {
        long currentFrame = GaiaSky.instance.frames;
        if (currentFrame - this.lastAxisMovedFrame > 1L) {
            this.cam.clearVelocityVR();
        }
        this.updateSelectionCountdown();
    }

    private void startSelectionCountdown(XrControllerDevice device) {
        this.selecting.add(device);
        this.selectingTime = System.currentTimeMillis();
        EventManager.publish(Event.VR_SELECTING_STATE, this, true, 0.0, device);
    }

    private void updateSelectionCountdown() {
        for (XrControllerDevice device : this.selecting) {
            if (((Float)device.select.currentState).floatValue() > 0.0f) {
                long elapsed = System.currentTimeMillis() - this.selectingTime;
                double completion = (double)elapsed / 1500.0;
                if (completion >= 1.0) {
                    this.doSelection(device);
                    EventManager.publish(Event.VR_SELECTING_STATE, this, false, completion, device);
                    this.selecting.remove(device);
                    continue;
                }
                EventManager.publish(Event.VR_SELECTING_STATE, this, this.selecting.contains(device), completion, device);
                continue;
            }
            EventManager.publish(Event.VR_SELECTING_STATE, this, false, 0.0, device);
            this.selecting.remove(device);
        }
    }

    private void stopSelectionCountdown(XrControllerDevice device) {
        if (this.selecting.contains(device)) {
            EventManager.publish(Event.VR_SELECTING_STATE, this, false, 0.0, device);
            this.selecting.remove(device);
            long elapsed = System.currentTimeMillis() - this.selectingTime;
            double completion = (double)elapsed / 1500.0;
            if (completion >= 1.0) {
                this.doSelection(device);
            }
        }
    }

    private void doSelection(XrControllerDevice device) {
        this.lazyInit();
        Entity sm = this.xrControllerToModel.get(device);
        if (sm != null && Mapper.vr.has(sm)) {
            VRDevice vr = (VRDevice)Mapper.vr.get(sm);
            this.p0.set(vr.beamP0);
            this.p1.set(vr.beamP2);
            Entity hit = this.getBestHit(this.p0, this.p1);
            if (hit != null) {
                EventManager.publish(Event.FOCUS_CHANGE_CMD, this, hit);
                EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FOCUS_MODE});
                device.sendHapticPulse(this.driver, 200000000L, 150.0f, 1.0f);
            }
        } else {
            logger.info("Model corresponding to device not found");
        }
    }

    private Array<Entity> getHits(Vector3D p0, Vector3D p1) {
        Array<Entity> l = this.cam.getScene().findFocusableEntities();
        Array hits = new Array();
        for (Entity s : l) {
            this.focusView.setEntity(s);
            this.focusView.addEntityHitRay(p0, p1, this.cam, (Array<Entity>)hits);
        }
        return hits;
    }

    private Entity getBestHit(Vector3D p0, Vector3D p1) {
        Array<Entity> hits = this.getHits(p0, p1);
        if (hits.size != 0) {
            hits.sort(this.comp);
            return (Entity)hits.get(hits.size - 1);
        }
        return null;
    }

    @Override
    public boolean showUI(boolean value, XrControllerDevice device) {
        if (!value) {
            EventManager.publish(Event.SHOW_VR_UI, this, new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(boolean value, XrControllerDevice device) {
        return false;
    }

    @Override
    public boolean cameraMode(boolean value, XrControllerDevice device) {
        if (!value) {
            CameraManager.CameraMode cm = this.cam.getMode().isFocus() ? CameraManager.CameraMode.FREE_MODE : CameraManager.CameraMode.FOCUS_MODE;
            this.cam.clearVelocityVR();
            EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{cm});
            return true;
        }
        return false;
    }

    @Override
    public boolean rotate(boolean value, XrControllerDevice device) {
        return false;
    }

    @Override
    public boolean move(Vector2 value, XrControllerDevice device) {
        VRDevice vr;
        float valueX = value.x;
        float valueY = value.y;
        this.lazyInit();
        Entity sm = this.xrControllerToModel.get(device);
        VRDevice vRDevice = vr = sm != null ? (VRDevice)Mapper.vr.get(sm) : null;
        if (vr != null) {
            if (this.cam.getMode().isFocus()) {
                this.cam.setVelocityVR(vr.beamP0, vr.beamP1, valueX, valueY);
            } else {
                this.cam.setVelocityVR(vr.beamP0, vr.beamP1, valueX, valueY);
            }
        }
        this.lastAxisMovedFrame = GaiaSky.instance.frames;
        return false;
    }

    @Override
    public boolean select(float value, XrControllerDevice device) {
        this.lazyInit();
        Entity sm = this.xrControllerToModel.get(device);
        VRDevice vr = sm != null ? (VRDevice)Mapper.vr.get(sm) : null;
        boolean selectingDevice = this.selecting.contains(device);
        if (!selectingDevice && value != 0.0f && vr != null && !vr.hitUI) {
            this.startSelectionCountdown(device);
        } else if (selectingDevice && value == 0.0f) {
            this.stopSelectionCountdown(device);
        }
        return false;
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.VR_DRIVER_LOADED) {
            this.driver = (XrDriver)data[0];
        }
    }
}

