/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.vr;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Array;
import gaiasky.gui.api.IGui;
import gaiasky.render.ComponentTypes;
import gaiasky.util.Bits;
import gaiasky.util.Logger;
import gaiasky.util.ModelCache;
import gaiasky.util.Pair;
import gaiasky.util.RenderUtils;
import gaiasky.util.gdx.IntModelBatch;
import gaiasky.util.gdx.IntRenderableProvider;
import gaiasky.util.gdx.g2d.ExtSpriteBatch;
import gaiasky.util.gdx.graphics.TextureView;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.gdx.model.IntModelInstance;
import gaiasky.util.gdx.shader.Environment;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.BlendingAttribute;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.util.gdx.shader.attribute.IntAttribute;
import gaiasky.util.gdx.shader.attribute.TextureAttribute;
import gaiasky.util.gdx.shader.provider.GroundShaderProvider;
import gaiasky.util.math.Vector3D;
import gaiasky.vr.openxr.XrDriver;
import gaiasky.vr.openxr.XrRenderer;
import gaiasky.vr.openxr.XrViewManager;
import gaiasky.vr.openxr.input.XrControllerDevice;
import gaiasky.vr.openxr.input.XrInputListener;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.GL30;
import org.lwjgl.openxr.XrCompositionLayerProjectionView;
import org.lwjgl.openxr.XrSwapchainImageOpenGLKHR;

public class StandaloneVRGui<T extends IGui>
implements IGui,
XrRenderer {
    private static final Logger.Log logger = Logger.getLogger(StandaloneVRGui.class);
    final int vrWidth;
    final int vrHeight;
    int guiWidth = 2960;
    int guiHeight = 1440;
    Skin skin;
    Class<T> guiClass;
    T gui;
    PerspectiveCamera camera;
    IntModelInstance instance;
    IntModelBatch batch;
    Environment uiEnvironment;
    Environment controllersEnvironment;
    final XrDriver driver;
    final XrInputListener listener;
    final XrViewManager viewManager;
    private final TextureView textureView;
    FrameBuffer fbGui;
    ExtSpriteBatch sbScreen;
    Array<XrControllerDevice> controllers;
    Vector2 lastSize = new Vector2();
    private boolean positionSet = false;
    private boolean renderToScreen = false;

    public StandaloneVRGui(XrDriver xrDriver, Class<T> guiClass, Skin skin, XrInputListener listener) {
        this.driver = xrDriver;
        this.vrWidth = xrDriver.getWidth();
        this.vrHeight = xrDriver.getHeight();
        this.guiClass = guiClass;
        this.skin = skin;
        this.listener = listener;
        this.viewManager = new XrViewManager();
        this.textureView = new TextureView(0, this.vrWidth, this.vrHeight);
    }

    @Override
    public void initialize(AssetManager assetManager, SpriteBatch spriteBatch) {
        Material material;
        try {
            this.gui = (IGui)this.guiClass.getDeclaredConstructor(Skin.class, Graphics.class, Float.class, Boolean.class).newInstance(this.skin, Gdx.graphics, Float.valueOf(1.0f), true);
            this.gui.setVR(true);
            this.gui.initialize(assetManager, spriteBatch);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error(e);
        }
        GLFrameBuffer.FrameBufferBuilder builder = new GLFrameBuffer.FrameBufferBuilder(this.guiWidth, this.guiHeight);
        builder.addBasicColorTextureAttachment(Pixmap.Format.RGBA8888);
        this.fbGui = builder.build();
        this.camera = new PerspectiveCamera(50.0f, (float)this.vrWidth, (float)this.vrHeight);
        this.camera.near = 0.1f;
        this.camera.far = 10.0f;
        this.camera.position.set(0.0f, 0.0f, 0.0f);
        this.camera.direction.set(1.0f, 0.0f, 0.0f);
        this.camera.up.set(0.0f, 0.0f, 1.0f);
        this.camera.update();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("divisionsu", 1L);
        params.put("divisionsv", 1L);
        params.put("width", 1.0);
        params.put("height", (double)this.guiWidth / (double)this.guiHeight);
        params.put("flip", true);
        ModelCache cache = new ModelCache();
        Bits attributes = Bits.indices(1, 8, 128, 256, 16);
        Pair<IntModel, Map<String, Material>> pair = cache.getModel("surface", params, attributes, 4);
        IntModel model = pair.getFirst();
        Map<String, Material> materials = pair.getSecond();
        if (materials.isEmpty()) {
            material = new Material();
            materials.put("base", material);
        } else {
            Object key = materials.keySet().toArray()[0];
            material = materials.get(key);
        }
        material.set((Attribute)new TextureAttribute(TextureAttribute.Diffuse, (Texture)this.fbGui.getColorBufferTexture()));
        material.set((Attribute)new BlendingAttribute(true, 770, 771, 1.0f));
        material.set((Attribute)new IntAttribute(IntAttribute.CullFace, 1029));
        this.uiEnvironment = new Environment();
        this.uiEnvironment.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, 1.0f, 1.0f, 1.0f, 1.0f));
        this.instance = new IntModelInstance(model);
        this.batch = new IntModelBatch(new GroundShaderProvider(Gdx.files.internal("shader/pbr.vertex.glsl"), Gdx.files.internal("shader/pbr.fragment.glsl")));
        this.controllersEnvironment = new Environment();
        this.controllersEnvironment.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, 0.6f, 0.6f, 0.6f, 1.0f));
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.color.set(1.0f, 1.0f, 1.0f, 1.0f);
        directionalLight.direction.set(0.0f, -0.3f, -4.0f);
        this.controllersEnvironment.add(directionalLight);
        this.sbScreen = new ExtSpriteBatch(5);
        if (this.driver != null && this.listener != null) {
            this.driver.addListener(this.listener);
        }
    }

    private void setSurfacePosition(XrCompositionLayerProjectionView view) {
        this.viewManager.updateCamera(view, this.camera);
        Vector3D dir = new Vector3D();
        dir.set(this.camera.direction);
        float angle = (float)dir.angle(Vector3D.getUnitX());
        if (dir.z > 0.0) {
            angle = -angle;
        }
        Vector3D pos = new Vector3D();
        pos.set(this.camera.position);
        dir.y = 0.0;
        pos.add(dir.nor().scl(1.5));
        this.instance.transform.idt().translate((float)pos.x, (float)pos.y, (float)pos.z).rotate(0.0f, 1.0f, 0.0f, 90.0f + angle).rotate(0.0f, 0.0f, 1.0f, 180.0f).rotate(1.0f, 0.0f, 0.0f, 90.0f);
    }

    @Override
    public void doneLoading(AssetManager assetManager) {
    }

    @Override
    public void update(double dt) {
        if (this.controllers == null) {
            this.controllers = this.driver.getControllerDevices();
        }
        if (this.controllers != null) {
            for (XrControllerDevice controller : this.controllers) {
                if (controller.isInitialized()) continue;
                controller.initialize(this.driver);
            }
        }
        this.gui.update(dt);
    }

    @Override
    public void render(int rw, int rh) {
        if (!this.driver.pollEvents()) {
            this.fbGui.begin();
            Gdx.gl.glClear(16640);
            this.gui.render(rw, rh);
            this.fbGui.end();
            if (this.driver.isRunning() && this.driver.hasRenderer()) {
                this.driver.renderFrameOpenXR();
            }
        }
    }

    @Override
    public void renderOpenXRView(XrCompositionLayerProjectionView layerView, XrSwapchainImageOpenGLKHR swapchainImage, FrameBuffer frameBuffer, int viewIndex) {
        if (!this.positionSet) {
            this.setSurfacePosition(layerView);
            this.positionSet = true;
        }
        this.viewManager.updateCamera(layerView, this.camera);
        frameBuffer.begin();
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)swapchainImage.image(), (int)0);
        Gdx.gl.glClear(16640);
        this.batch.begin((Camera)this.camera);
        this.batch.render((IntRenderableProvider)this.instance, this.uiEnvironment);
        this.renderControllers();
        this.batch.end();
        frameBuffer.end();
        if (viewIndex == 0 && this.renderToScreen) {
            this.textureView.setTexture(swapchainImage.image(), this.driver.getWidth(), this.driver.getHeight());
            Gdx.gl.glEnable(36281);
            RenderUtils.renderKeepAspect(this.textureView, this.sbScreen, Gdx.graphics, this.lastSize);
            Gdx.gl.glDisable(36281);
        }
    }

    private void renderControllers() {
        if (this.controllers != null) {
            for (XrControllerDevice controller : this.controllers) {
                IntModelInstance controllerInstance;
                if (!controller.isInitialized() || !controller.isActive() || (controllerInstance = controller.modelInstance) == null) continue;
                this.batch.render((IntRenderableProvider)controllerInstance, this.controllersEnvironment);
            }
        }
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void resizeImmediate(int width, int height) {
    }

    @Override
    public boolean cancelTouchFocus() {
        return false;
    }

    @Override
    public Stage getGuiStage() {
        return null;
    }

    @Override
    public void setVisibilityToggles(ComponentTypes.ComponentType[] entities, ComponentTypes visible) {
    }

    @Override
    public Actor findActor(String name) {
        return null;
    }

    @Override
    public void setVR(boolean vr) {
    }

    @Override
    public boolean isVR() {
        return true;
    }

    @Override
    public boolean mustDraw() {
        return false;
    }

    @Override
    public boolean updateUnitsPerPixel(float upp) {
        return false;
    }

    @Override
    public float getUnitsPerPixel() {
        return 1.0f;
    }

    @Override
    public void setBackBufferSize(int width, int height) {
    }

    public void dispose() {
        if (this.driver != null && this.listener != null) {
            this.driver.removeListener(this.listener);
        }
        this.batch.dispose();
        this.sbScreen.dispose();
    }

    public void setRenderToScreen(boolean renderToScreen) {
        this.renderToScreen = renderToScreen;
    }
}

