/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.vr;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.viewport.Viewport;
import gaiasky.GaiaSky;
import gaiasky.gui.main.AbstractGui;
import gaiasky.gui.main.VersionLineTable;
import gaiasky.gui.main.WelcomeGui;
import gaiasky.gui.vr.FixedScreenViewport;
import gaiasky.util.Settings;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;

public class WelcomeGuiVR
extends AbstractGui {
    private Table center;
    private Table bottom;
    private final WelcomeGui wg;

    public WelcomeGuiVR(Skin skin, Graphics graphics, Float unitsPerPixel, Boolean vr) {
        super(graphics, unitsPerPixel);
        this.wg = (WelcomeGui)GaiaSky.instance.welcomeGui;
        this.skin = skin;
    }

    @Override
    public void initialize(AssetManager assetManager, SpriteBatch sb) {
        FixedScreenViewport vp = new FixedScreenViewport(this.getBackBufferWidth(), this.getBackBufferHeight());
        this.stage = new Stage((Viewport)vp, (Batch)sb);
        this.center = new Table();
        this.center.setFillParent(true);
        this.center.center();
        String textStyle = "header-raw";
        this.bottom = new VersionLineTable(this.skin, true);
        this.bottom.bottom();
        FileHandle gsIcon = Gdx.files.internal("icon/gs_icon_256.png");
        Texture iconTex = new Texture(gsIcon);
        iconTex.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Image logo = new Image(iconTex);
        logo.setScale(0.75f);
        logo.setOrigin(1);
        this.center.add((Actor)logo).padBottom(20.0f).row();
        HorizontalGroup titleGroup = new HorizontalGroup();
        titleGroup.space(64.0f);
        OwnLabel gaiaSky = new OwnLabel((CharSequence)Settings.getApplicationTitle(Settings.settings.runtime.openXr), this.skin, "main-title");
        OwnLabel version = new OwnLabel((CharSequence)Settings.settings.version.version, this.skin, "main-title");
        version.setColor(this.skin.getColor("theme"));
        titleGroup.addActor((Actor)gaiaSky);
        titleGroup.addActor((Actor)version);
        this.center.add((Actor)titleGroup).padBottom(110.0f).row();
        OwnLabel w1 = new OwnLabel((CharSequence)I18n.msg("gui.vr.welcome.1"), this.skin, textStyle);
        w1.setAlignment(1);
        this.center.add((Actor)w1).padBottom(40.0f).row();
        if (this.wg.baseDataPresent()) {
            OwnLabel w2 = new OwnLabel((CharSequence)I18n.msg("gui.vr.welcome.2"), this.skin, textStyle);
            w2.setAlignment(1);
            OwnLabel w3 = new OwnLabel((CharSequence)I18n.msg("gui.vr.welcome.3"), this.skin, "header-blue");
            w3.setAlignment(1);
            this.center.add((Actor)w2).row();
            this.center.add((Actor)w3);
        } else {
            OwnLabel w2 = new OwnLabel((CharSequence)I18n.msg("gui.welcome.start.nobasedata"), this.skin, textStyle);
            w2.setColor(ColorUtils.aOrangeC);
            w2.setAlignment(1);
            this.center.add((Actor)w2);
        }
        this.rebuildGui();
    }

    @Override
    public void doneLoading(AssetManager assetManager) {
    }

    @Override
    protected void rebuildGui() {
        if (this.stage != null) {
            this.stage.clear();
            this.stage.addActor((Actor)this.center);
            this.stage.addActor((Actor)this.bottom);
        }
    }
}

