/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.SpriteDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BufferUtils;
import gaiasky.gui.window.GenericDialog;
import gaiasky.gui.window.MemInfoWindow;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.Link;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnTextArea;
import gaiasky.util.scene2d.OwnTextButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import gaiasky.util.scene2d.Separator;
import gaiasky.util.update.VersionCheckEvent;
import gaiasky.util.update.VersionChecker;
import java.nio.IntBuffer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.List;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.Display;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OperatingSystem;

public class AboutWindow
extends GenericDialog {
    private static final Logger.Log logger = Logger.getLogger(AboutWindow.class);
    private final Label.LabelStyle linkStyle;
    private final Label.LabelStyle linkLargeStyle;
    private Table checkTable;
    private OwnLabel checkLabel;
    private MemInfoWindow memInfoWindow;

    public AboutWindow(Stage stage, Skin skin) {
        super(I18n.msg("gui.help.help") + " - " + Settings.settings.version.version + " - " + I18n.msg("gui.build", Settings.settings.version.build), skin, stage);
        this.linkStyle = (Label.LabelStyle)skin.get("link", Label.LabelStyle.class);
        this.linkLargeStyle = (Label.LabelStyle)skin.get("link-large", Label.LabelStyle.class);
        this.setCancelText(I18n.msg("gui.close"));
        this.buildSuper();
    }

    @Override
    protected void build() {
        Table contentUpdates;
        OwnLabel sysOS;
        OwnTextButton tabUpdates;
        float contentWidth = 1140.0f;
        float titleWidth = 250.0f;
        float taWidth = 850.0f;
        float taWidth2 = 1280.0f;
        float taHeight = 160.0f;
        float tabWidth = 240.0f;
        float buttonHeight = 40.0f;
        this.padLeft(pad18);
        this.padRight(pad18);
        boolean showUpdateTab = !SysUtils.launchedViaInstall4j();
        HorizontalGroup tabGroup = new HorizontalGroup();
        tabGroup.left();
        OwnTextButton tabHelp = new OwnTextButton(I18n.msg("gui.help.help"), this.skin, "toggle-big");
        tabHelp.pad(pad10);
        tabHelp.setWidth(240.0f);
        OwnTextButton tabAbout = new OwnTextButton(I18n.msg("gui.help.about"), this.skin, "toggle-big");
        tabAbout.pad(pad10);
        tabAbout.setWidth(240.0f);
        OwnTextButton tabSystem = new OwnTextButton(I18n.msg("gui.help.system"), this.skin, "toggle-big");
        tabSystem.pad(pad10);
        tabSystem.setWidth(240.0f);
        OwnTextButton ownTextButton = tabUpdates = showUpdateTab ? new OwnTextButton(I18n.msg("gui.newversion"), this.skin, "toggle-big") : null;
        if (showUpdateTab) {
            tabUpdates.pad(pad10);
            tabUpdates.setWidth(240.0f);
        }
        tabGroup.addActor((Actor)tabHelp);
        tabGroup.addActor((Actor)tabAbout);
        tabGroup.addActor((Actor)tabSystem);
        if (showUpdateTab) {
            tabGroup.addActor((Actor)tabUpdates);
        }
        this.tabButtons = new Array();
        this.tabButtons.add((Object)tabHelp);
        this.tabButtons.add((Object)tabAbout);
        this.tabButtons.add((Object)tabSystem);
        if (showUpdateTab) {
            this.tabButtons.add((Object)tabUpdates);
        }
        this.content.add((Actor)tabGroup).left().padLeft(pad10);
        this.content.row();
        this.content.pad(pad18);
        Table contentHelp = new Table(this.skin);
        contentHelp.top();
        OwnLabel gaiasky = new OwnLabel((CharSequence)Settings.getApplicationTitle(Settings.settings.runtime.openXr), this.skin, "main-title");
        OwnLabel homepageTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.homepage"), this.skin, "header");
        Link homepageLink = new Link((CharSequence)"https://gaiasky.space", this.linkLargeStyle, "https://gaiasky.space");
        OwnLabel docsTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.docs"), this.skin, "header");
        Link docsLink = new Link((CharSequence)"http://docs.gaiasky.space", this.linkLargeStyle, "http://docs.gaiasky.space");
        OwnLabel repoTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.repo"), this.skin, "header");
        Link repoLink = new Link((CharSequence)"https://codeberg.org/gaiasky/gaiasky", this.linkLargeStyle, "https://codeberg.org/gaiasky/gaiasky");
        FileHandle gsIcon = Gdx.files.internal(Settings.settings.runtime.openXr ? "icon/gsvr_round_256.png" : "icon/gs_icon_256.png");
        Texture iconTex = new Texture(gsIcon);
        iconTex.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Image gaiaSkyIcon = new Image(iconTex);
        gaiaSkyIcon.setOrigin(1);
        contentHelp.add((Actor)gaiaSkyIcon).colspan(2).padTop(pad34).align(1);
        contentHelp.row();
        contentHelp.add((Actor)gaiasky).pad(pad18).padBottom(pad18 * 5.0f).colspan(2);
        contentHelp.row();
        contentHelp.add((Actor)homepageTitle).left().padBottom(pad34).row();
        contentHelp.add((Actor)homepageLink).left().padBottom(pad34 * 2.0f);
        contentHelp.row();
        contentHelp.add((Actor)docsTitle).left().padBottom(pad34).row();
        contentHelp.add((Actor)docsLink).left().padBottom(pad18 * 4.0f);
        contentHelp.row();
        contentHelp.add((Actor)repoTitle).left().padBottom(pad34).row();
        contentHelp.add((Actor)repoLink).left().padBottom(pad18 * 4.0f);
        contentHelp.pack();
        Table contentAbout = new Table(this.skin);
        contentAbout.top();
        OwnTextArea intro = new OwnTextArea(I18n.msg("gui.help.gscredits", Settings.settings.version.version), (TextField.TextFieldStyle)this.skin.get("regular", TextField.TextFieldStyle.class));
        intro.setDisabled(true);
        intro.setPrefRows(3.0f);
        intro.setWidth(1140.0f);
        OwnLabel homePageTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.homepage"), this.skin);
        Link homepage = new Link((CharSequence)"https://gaiasky.space", this.linkStyle, "https://gaiasky.space");
        OwnLabel devNewsTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.devnews"), this.skin);
        Link tw = new Link((CharSequence)"#GaiaSky", this.linkStyle, "https://mastodon.social/tags/GaiaSky");
        OwnLabel authorTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.author"), this.skin);
        Table author = new Table(this.skin);
        OwnLabel authorName = new OwnLabel((CharSequence)"Toni Sagrist\u00e0 Sell\u00e9s", this.skin);
        Link authorMail = new Link((CharSequence)"tsagrista@ari.uni-heidelberg.de", this.linkStyle, "mailto:tsagrista@ari.uni-heidelberg.de");
        Link authorPage = new Link((CharSequence)"tonisagrista.com", this.linkStyle, "https://tonisagrista.com");
        Link authorMasto = new Link((CharSequence)"@jumpinglangur@mastodon.social", this.linkStyle, "https://mastodon.social/@jumpinglangur");
        Link authorBs = new Link((CharSequence)"@gaiasky.bsky.social", this.linkStyle, "https://bsky.app/profile/gaiasky.bsky.social");
        author.add((Actor)authorName).left().row();
        author.add((Actor)authorMail).left().row();
        author.add((Actor)authorPage).left().row();
        author.add((Actor)authorMasto).left().row();
        author.add((Actor)authorBs).left().row();
        OwnLabel contribTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.contributors"), this.skin);
        Table contrib = new Table(this.skin);
        contrib.left();
        OwnLabel contribName = new OwnLabel((CharSequence)"Apl. Prof. Dr. Stefan Jordan", this.skin);
        Link contribMail = new Link((CharSequence)"jordan@ari.uni-heidelberg.de", this.linkStyle, "mailto:jordan@ari.uni-heidelberg.de");
        contrib.add((Actor)contribName).left().row();
        contrib.add((Actor)contribMail).left().row();
        HorizontalGroup licenseHorizontal = new HorizontalGroup();
        licenseHorizontal.space(pad18);
        VerticalGroup licenseVertical = new VerticalGroup();
        OwnTextArea licenseText = new OwnTextArea(I18n.msg("gui.help.license"), (TextField.TextFieldStyle)this.skin.get("regular", TextField.TextFieldStyle.class));
        licenseText.setDisabled(true);
        licenseText.setPrefRows(3.0f);
        licenseText.setWidth(640.0f);
        Link licenseLink = new Link((CharSequence)"https://opensource.org/licenses/MPL-2.0", this.linkStyle, "https://opensource.org/licenses/MPL-2.0");
        licenseVertical.addActor((Actor)licenseText);
        licenseVertical.addActor((Actor)licenseLink);
        licenseHorizontal.addActor((Actor)licenseVertical);
        HorizontalGroup thanks = new HorizontalGroup();
        thanks.space(pad18).pad(pad18);
        Container thanksSc = new Container((Actor)thanks);
        thanksSc.setBackground(this.skin.getDrawable("bg-clear"));
        Image zah = new Image((Drawable)this.getSpriteDrawable(Gdx.files.internal("img/zah.png")));
        Image dlr = new Image((Drawable)this.getSpriteDrawable(Gdx.files.internal("img/dlr.png")));
        Image bwt = new Image((Drawable)this.getSpriteDrawable(Gdx.files.internal("img/bwt.png")));
        Image dpac = new Image((Drawable)this.getSpriteDrawable(Gdx.files.internal("img/dpac.png")));
        thanks.addActor((Actor)zah);
        thanks.addActor((Actor)dlr);
        thanks.addActor((Actor)bwt);
        thanks.addActor((Actor)dpac);
        contentAbout.add((Actor)intro).colspan(2).left().padTop(pad34);
        contentAbout.row();
        contentAbout.add((Actor)homePageTitle).left().padRight(pad18).padTop(pad18);
        contentAbout.add((Actor)homepage).left().padTop(pad18);
        contentAbout.row();
        contentAbout.add((Actor)devNewsTitle).left().padRight(pad18).padTop(pad18);
        contentAbout.add((Actor)tw).left().padTop(pad18);
        contentAbout.row();
        contentAbout.add((Actor)authorTitle).left().padRight(pad18).padTop(pad18);
        contentAbout.add((Actor)author).left().padTop(pad10).padTop(pad18);
        contentAbout.row();
        contentAbout.add((Actor)contribTitle).left().padRight(pad18).padTop(pad18);
        contentAbout.add((Actor)contrib).left().padTop(pad18);
        contentAbout.row();
        contentAbout.add((Actor)licenseHorizontal).colspan(2).center().padTop(pad18 * 4.0f);
        contentAbout.row();
        contentAbout.add((Actor)thanksSc).colspan(2).center().padTop(pad18 * 6.0f);
        contentAbout.pack();
        Table contentSystem = new Table(this.skin);
        contentSystem.top();
        OwnLabel buildInfo = new OwnLabel((CharSequence)I18n.msg("gui.help.buildinfo"), this.skin, "header");
        OwnLabel versionTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.version", Settings.APPLICATION_NAME), this.skin);
        OwnLabel version = new OwnLabel((CharSequence)Settings.settings.version.version, this.skin);
        OwnLabel revisionTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.buildnumber"), this.skin);
        OwnLabel revision = new OwnLabel((CharSequence)Settings.settings.version.build, this.skin);
        OwnLabel timeTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.buildtime"), this.skin);
        OwnLabel time = new OwnLabel((CharSequence)Settings.settings.version.buildTime.toString(), this.skin);
        OwnLabel systemTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.buildsys"), this.skin);
        OwnTextArea system = new OwnTextArea(Settings.settings.version.system, (TextField.TextFieldStyle)this.skin.get("regular", TextField.TextFieldStyle.class));
        system.setDisabled(true);
        system.setPrefRows(3.0f);
        system.setWidth(566.6667f);
        OwnLabel builderTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.builder"), this.skin);
        OwnLabel builder = new OwnLabel((CharSequence)Settings.settings.version.builder, this.skin);
        OwnLabel paths = new OwnLabel((CharSequence)I18n.msg("gui.help.paths"), this.skin, "header");
        int pathLength = 48;
        OwnLabel configTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.paths.config"), this.skin);
        String configPath = SysUtils.getConfigDir().toAbsolutePath().toString();
        OwnLabel config = new OwnLabel((CharSequence)TextUtils.capString(configPath, pathLength, true), this.skin);
        config.addListener((EventListener)new OwnTextTooltip(configPath, this.skin, 15));
        OwnLabel dataTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.paths.data"), this.skin);
        String dataPath = SysUtils.getDataDir().toAbsolutePath().toString();
        OwnLabel data = new OwnLabel((CharSequence)TextUtils.capString(dataPath, pathLength, true), this.skin);
        data.addListener((EventListener)new OwnTextTooltip(dataPath, this.skin, 15));
        OwnLabel screenshotsTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.paths.screenshots"), this.skin);
        String screenshotsPath = SysUtils.getDefaultScreenshotsDir().toAbsolutePath().toString();
        OwnLabel screenshots = new OwnLabel((CharSequence)TextUtils.capString(screenshotsPath, pathLength, true), this.skin);
        screenshots.addListener((EventListener)new OwnTextTooltip(screenshotsPath, this.skin, 15));
        OwnLabel framesTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.paths.frames"), this.skin);
        String framesPath = SysUtils.getDefaultFramesDir().toAbsolutePath().toString();
        OwnLabel frames = new OwnLabel((CharSequence)TextUtils.capString(framesPath, pathLength, true), this.skin);
        frames.addListener((EventListener)new OwnTextTooltip(framesPath, this.skin, 15));
        OwnLabel mappingsTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.paths.mappings"), this.skin);
        String mappingsPath = SysUtils.getDefaultMappingsDir().toAbsolutePath().toString();
        OwnLabel mappings = new OwnLabel((CharSequence)TextUtils.capString(mappingsPath, pathLength, true), this.skin);
        mappings.addListener((EventListener)new OwnTextTooltip(mappingsPath, this.skin, 15));
        OwnLabel cameraTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.paths.camera"), this.skin);
        String cameraPath = SysUtils.getDefaultCameraDir().toAbsolutePath().toString();
        OwnLabel camera = new OwnLabel((CharSequence)TextUtils.capString(cameraPath, pathLength, true), this.skin);
        camera.addListener((EventListener)new OwnTextTooltip(cameraPath, this.skin, 15));
        OwnLabel javaInfo = new OwnLabel((CharSequence)I18n.msg("gui.help.javainfo"), this.skin, "header");
        OwnLabel javaVersionTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.javaversion"), this.skin);
        OwnLabel javaVersion = new OwnLabel((CharSequence)System.getProperty("java.version"), this.skin);
        OwnLabel javaRuntimeTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.javaname"), this.skin);
        OwnLabel javaRuntime = new OwnLabel((CharSequence)System.getProperty("java.runtime.name"), this.skin);
        OwnLabel javaVMNameTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.javavmname"), this.skin);
        OwnLabel javaVMName = new OwnLabel((CharSequence)System.getProperty("java.vm.name"), this.skin);
        OwnLabel javaVMVersionTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.javavmversion"), this.skin);
        OwnLabel javaVMVersion = new OwnLabel((CharSequence)System.getProperty("java.vm.version"), this.skin);
        OwnLabel javaVMVendorTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.javavmvendor"), this.skin);
        OwnLabel javaVMVendor = new OwnLabel((CharSequence)System.getProperty("java.vm.vendor"), this.skin);
        OwnTextButton memInfoButton = new OwnTextButton(I18n.msg("gui.help.meminfo"), this.skin, "default");
        memInfoButton.setName("memoryinfo");
        memInfoButton.pad(0.0f, pad18, 0.0f, pad18);
        memInfoButton.setHeight(40.0f);
        memInfoButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.memInfoWindow == null) {
                    this.memInfoWindow = new MemInfoWindow(this.stage, this.skin);
                }
                if (!this.memInfoWindow.isVisible() || !this.memInfoWindow.hasParent()) {
                    this.memInfoWindow.show(this.stage);
                }
                return true;
            }
            return false;
        });
        OwnLabel sysInfo = new OwnLabel((CharSequence)I18n.msg("gui.help.sysinfo"), this.skin, "header");
        OwnLabel sysOSTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.os"), this.skin);
        try {
            SystemInfo si = new SystemInfo();
            OperatingSystem os = si.getOperatingSystem();
            String st = System.getenv("XDG_SESSION_TYPE");
            sysOS = new OwnLabel((CharSequence)(I18n.msg("gui.help.os.family") + ": " + os.getFamily() + "\n" + I18n.msg("gui.help.os.name") + ": " + os.getVersionInfo().getCodeName() + "\n" + I18n.msg("gui.help.os.version") + ": " + os.getVersionInfo().getVersion() + "\n" + I18n.msg("gui.help.os.build") + ": " + os.getVersionInfo().getBuildNumber() + "\n" + I18n.msg("gui.help.os.manufacturer") + ": " + os.getManufacturer() + "\n" + I18n.msg("gui.help.os.arch") + ": " + System.getProperty("os.arch") + (String)(SysUtils.isLinux() ? "\n" + I18n.msg("gui.help.os.session") + ": " + st : "")), this.skin);
        }
        catch (Error e) {
            sysOS = new OwnLabel((CharSequence)(System.getProperty("os.name") + "\n" + System.getProperty("os.version") + "\n" + System.getProperty("os.arch")), this.skin);
        }
        OwnLabel glRendererTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.graphicsdevice"), this.skin);
        String glRendererStr = Gdx.gl.glGetString(7937);
        OwnLabel glRenderer = new OwnLabel((CharSequence)TextUtils.breakSpaces(glRendererStr, 48), this.skin);
        OwnLabel sessionTypeTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.graphicsdevice"), this.skin);
        OwnLabel glInfo = new OwnLabel((CharSequence)I18n.msg("gui.help.openglinfo"), this.skin, "header");
        OwnLabel glVendorTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.glvendor"), this.skin);
        OwnLabel glVendor = new OwnLabel((CharSequence)Gdx.gl.glGetString(7936), this.skin);
        OwnLabel glVersionTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.openglversion"), this.skin);
        OwnLabel glVersion = new OwnLabel((CharSequence)Gdx.gl.glGetString(7938), this.skin);
        OwnLabel glslVersionTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.glslversion"), this.skin);
        OwnLabel glslVersion = new OwnLabel((CharSequence)Gdx.gl.glGetString(35724), this.skin);
        OwnLabel glExtensionsTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.glextensions"), this.skin);
        String extensions = GlobalResources.getGLExtensions();
        IntBuffer buf = BufferUtils.newIntBuffer((int)16);
        Gdx.gl.glGetIntegerv(3379, buf);
        int maxSize = buf.get(0);
        int lines = GlobalResources.countOccurrences(extensions, '\n');
        OwnTextArea maxTexSize = new OwnTextArea("Max texture size: " + maxSize + "\n" + extensions, this.skin, "default");
        maxTexSize.setDisabled(true);
        maxTexSize.setPrefRows(lines);
        maxTexSize.clearListeners();
        OwnScrollPane glExtensionsScroll = new OwnScrollPane((Actor)maxTexSize, this.skin, "default-nobg");
        glExtensionsScroll.setWidth(850.0f);
        glExtensionsScroll.setHeight(160.0f);
        glExtensionsScroll.setForceScroll(false, true);
        glExtensionsScroll.setSmoothScrolling(true);
        glExtensionsScroll.setFadeScrollBars(false);
        this.scrolls.add((Object)glExtensionsScroll);
        contentSystem.add((Actor)buildInfo).colspan(2).left().padTop(pad34);
        contentSystem.row();
        contentSystem.add((Actor)new Separator(this.skin, "small")).colspan(2).bottom().left().expandX().fillX().padBottom(pad20);
        contentSystem.row();
        contentSystem.add((Actor)versionTitle).left().top().padRight(pad18).width(250.0f);
        contentSystem.add((Actor)version).left();
        contentSystem.row();
        contentSystem.add((Actor)revisionTitle).left().top().padRight(pad18).padTop(pad10);
        contentSystem.add((Actor)revision).left().padTop(pad10);
        contentSystem.row();
        contentSystem.add((Actor)timeTitle).left().top().padRight(pad18).padTop(pad10);
        contentSystem.add((Actor)time).left().padTop(pad10);
        contentSystem.row();
        contentSystem.add((Actor)builderTitle).left().top().padRight(pad18).padTop(pad10);
        contentSystem.add((Actor)builder).left().padTop(pad10);
        contentSystem.row();
        contentSystem.add((Actor)systemTitle).left().top().padRight(pad18).padTop(pad10);
        contentSystem.add((Actor)system).left().padTop(pad10);
        contentSystem.row();
        contentSystem.add((Actor)paths).colspan(2).left().padTop(pad34);
        contentSystem.row();
        contentSystem.add((Actor)new Separator(this.skin, "small")).colspan(2).bottom().left().expandX().fillX().padBottom(pad20);
        contentSystem.row();
        contentSystem.add((Actor)configTitle).left().top().padRight(pad18);
        contentSystem.add((Actor)config).left();
        contentSystem.row();
        contentSystem.add((Actor)dataTitle).left().top().padRight(pad18);
        contentSystem.add((Actor)data).left();
        contentSystem.row();
        contentSystem.add((Actor)screenshotsTitle).left().top().padRight(pad18);
        contentSystem.add((Actor)screenshots).left();
        contentSystem.row();
        contentSystem.add((Actor)framesTitle).left().top().padRight(pad18);
        contentSystem.add((Actor)frames).left();
        contentSystem.row();
        contentSystem.add((Actor)cameraTitle).left().top().padRight(pad18);
        contentSystem.add((Actor)camera).left();
        contentSystem.row();
        contentSystem.add((Actor)mappingsTitle).left().top().padRight(pad18);
        contentSystem.add((Actor)mappings).left();
        contentSystem.row();
        contentSystem.add((Actor)javaInfo).colspan(2).left().padTop(pad34 * 2.0f);
        contentSystem.row();
        contentSystem.add((Actor)new Separator(this.skin, "small")).colspan(2).bottom().left().expandX().fillX().padBottom(pad20);
        contentSystem.row();
        contentSystem.add((Actor)javaVersionTitle).left().top().padRight(pad18);
        contentSystem.add((Actor)javaVersion).left();
        contentSystem.row();
        contentSystem.add((Actor)javaRuntimeTitle).left().top().padRight(pad18).padTop(pad10);
        contentSystem.add((Actor)javaRuntime).left().padTop(pad10);
        contentSystem.row();
        contentSystem.add((Actor)javaVMNameTitle).left().top().padRight(pad18).padTop(pad10);
        contentSystem.add((Actor)javaVMName).left().padTop(pad10);
        contentSystem.row();
        contentSystem.add((Actor)javaVMVersionTitle).left().top().padRight(pad18).padTop(pad10);
        contentSystem.add((Actor)javaVMVersion).left().padTop(pad10);
        contentSystem.row();
        contentSystem.add((Actor)javaVMVendorTitle).left().top().padRight(pad18).padTop(pad10);
        contentSystem.add((Actor)javaVMVendor).left().padTop(pad10);
        contentSystem.row();
        contentSystem.add((Actor)memInfoButton).colspan(2).left().padTop(pad18);
        contentSystem.row();
        contentSystem.add((Actor)sysInfo).colspan(2).left().padTop(pad34 * 2.0f);
        contentSystem.row();
        contentSystem.add((Actor)new Separator(this.skin, "small")).colspan(2).bottom().left().expandX().fillX().padBottom(pad20);
        contentSystem.row();
        try {
            SystemInfo si = new SystemInfo();
            HardwareAbstractionLayer hal = si.getHardware();
            CentralProcessor cp = hal.getProcessor();
            OwnLabel cpuTitle = new OwnLabel((CharSequence)I18n.msg("gui.help.cpu"), this.skin);
            OwnLabel cpu = new OwnLabel((CharSequence)cp.toString(), this.skin);
            contentSystem.add((Actor)cpuTitle).left().top().padRight(pad18).padTop(pad10).padBottom(pad18);
            contentSystem.add((Actor)cpu).left().padTop(pad10).padBottom(pad18);
            contentSystem.row();
        }
        catch (Exception ignored) {
            contentSystem.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.help.cpu.no"), this.skin)).colspan(2).left().padTop(pad18).padBottom(pad18).row();
        }
        contentSystem.add((Actor)sysOSTitle).left().top().padRight(pad18).padBottom(pad18);
        contentSystem.add((Actor)sysOS).left().padBottom(pad18);
        contentSystem.row();
        contentSystem.add((Actor)glRendererTitle).left().top().padRight(pad18).padTop(pad18);
        contentSystem.add((Actor)glRenderer).left().padTop(pad10);
        contentSystem.row();
        OwnLabel displaysInfo = new OwnLabel((CharSequence)I18n.msg("gui.help.displays"), this.skin, "header");
        contentSystem.add((Actor)displaysInfo).colspan(2).left().padTop(pad34 * 2.0f);
        contentSystem.row();
        contentSystem.add((Actor)new Separator(this.skin, "small")).colspan(2).bottom().left().expandX().fillX().padBottom(pad20);
        contentSystem.row();
        try {
            SystemInfo si = new SystemInfo();
            List displays = si.getHardware().getDisplays();
            for (Display display : displays) {
                OwnLabel displayLabel = new OwnLabel((CharSequence)display.toString(), this.skin);
                contentSystem.add((Actor)displayLabel).colspan(2).left().padBottom(pad34).row();
            }
        }
        catch (Exception ignored) {
            OwnLabel none = new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.na"), this.skin);
            contentSystem.add((Actor)none).colspan(2).left().padBottom(pad34).row();
        }
        contentSystem.add((Actor)glInfo).colspan(2).left().padTop(pad34 * 2.0f);
        contentSystem.row();
        contentSystem.add((Actor)new Separator(this.skin, "small")).colspan(2).bottom().left().expandX().fillX().padBottom(pad20);
        contentSystem.row();
        contentSystem.add((Actor)glVersionTitle).left().top().padRight(pad18);
        contentSystem.add((Actor)glVersion).left();
        contentSystem.row();
        contentSystem.add((Actor)glVendorTitle).left().top().padRight(pad18).padTop(pad10);
        contentSystem.add((Actor)glVendor).left().padTop(pad10);
        contentSystem.row();
        contentSystem.add((Actor)glslVersionTitle).left().top().padRight(pad18).padTop(pad10);
        contentSystem.add((Actor)glslVersion).left().padTop(pad10);
        contentSystem.row();
        contentSystem.add((Actor)glExtensionsTitle).left().top().padRight(pad18).padTop(pad10);
        contentSystem.add((Actor)glExtensionsScroll).left().padTop(pad10);
        OwnScrollPane systemScroll = new OwnScrollPane((Actor)contentSystem, this.skin, "minimalist-nobg");
        systemScroll.setFadeScrollBars(false);
        systemScroll.setScrollingDisabled(true, false);
        systemScroll.setOverscroll(false, false);
        systemScroll.setSmoothScrolling(true);
        systemScroll.setHeight(800.0f);
        systemScroll.pack();
        Table table = contentUpdates = showUpdateTab ? new Table(this.skin) : null;
        if (showUpdateTab) {
            contentUpdates.top();
            this.checkTable = new Table(this.skin);
            this.checkLabel = new OwnLabel((CharSequence)"", this.skin);
            this.checkTable.add((Actor)this.checkLabel).top().left().padBottom(pad10).row();
            if (Settings.settings.program.update.lastCheck == null || new Date().getTime() - Settings.settings.program.update.lastCheck.toEpochMilli() > Settings.ProgramSettings.UpdateSettings.VERSION_CHECK_INTERVAL_MS) {
                this.checkLabel.setText(I18n.msg("gui.newversion.checking"));
                this.getCheckVersionThread().start();
            } else {
                this.newVersionCheck(Settings.settings.version.version, Settings.settings.version.versionNumber, Settings.settings.version.buildTime, false);
            }
            contentUpdates.add((Actor)this.checkTable).left().top().padTop(pad34);
        }
        this.addTabContent((Group)contentHelp);
        this.addTabContent((Group)contentAbout);
        this.addTabContent((Group)systemScroll);
        if (showUpdateTab) {
            this.addTabContent((Group)contentUpdates);
        }
        this.content.add((Actor)this.tabStack).expand().fill();
        this.setUpTabListeners();
    }

    @Override
    protected boolean accept() {
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }

    private SpriteDrawable getSpriteDrawable(FileHandle fh) {
        Texture tex = new Texture(fh);
        return new SpriteDrawable(new Sprite(tex));
    }

    private void newVersionCheck(String tagVersion, Integer versionNumber, Instant tagDate, boolean log) {
        Settings.settings.program.update.lastCheck = Instant.now();
        if (versionNumber > Settings.settings.version.versionNumber) {
            DateTimeFormatter df = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.MEDIUM).withLocale(I18n.locale).withZone(ZoneOffset.UTC);
            if (log) {
                logger.info(I18n.msg("gui.newversion.available", Settings.settings.version.version, tagVersion + " [" + df.format(tagDate) + "]"));
            }
            this.checkLabel.setText(I18n.msg("gui.newversion.available", Settings.settings.version, tagVersion + " [" + df.format(tagDate) + "]"));
            String uri = "https://gaiasky.space/downloads";
            OwnTextButton getNewVersion = new OwnTextButton(I18n.msg("gui.newversion.getit"), this.skin);
            getNewVersion.pad(0.0f, pad18, 0.0f, pad18);
            getNewVersion.setHeight(40.0f);
            getNewVersion.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    Gdx.net.openURI("https://gaiasky.space/downloads");
                    return true;
                }
                return false;
            });
            this.checkTable.add((Actor)getNewVersion).center().padTop(pad18).padBottom(pad10).row();
            Link link = new Link((CharSequence)"https://gaiasky.space/downloads", this.linkStyle, "https://gaiasky.space/downloads");
            this.checkTable.add((Actor)link).center();
        } else {
            if (log) {
                logger.info(I18n.msg("gui.newversion.nonew", Settings.settings.program.update.getLastCheckedString()));
            }
            this.checkLabel.setText(I18n.msg("gui.newversion.nonew", Settings.settings.program.update.getLastCheckedString()));
            OwnTextButton checkNewVersion = new OwnTextButton(I18n.msg("gui.newversion.checknow"), this.skin);
            checkNewVersion.pad(pad10, pad18, pad10, pad18);
            checkNewVersion.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    this.checkLabel.setText(I18n.msg("gui.newversion.checking"));
                    logger.info(I18n.msg("gui.newversion.checking"));
                    this.getCheckVersionThread().start();
                    return true;
                }
                return false;
            });
            this.checkTable.add((Actor)checkNewVersion).center().padTop(pad18);
        }
    }

    private Thread getCheckVersionThread() {
        VersionChecker vc = new VersionChecker(Settings.settings.program.url.versionCheck);
        vc.setListener(event -> {
            if (event instanceof VersionCheckEvent) {
                VersionCheckEvent vce = (VersionCheckEvent)event;
                if (!vce.isFailed()) {
                    this.checkTable.clear();
                    this.checkTable.add((Actor)this.checkLabel).top().left().padBottom(pad10).row();
                    this.newVersionCheck(vce.getTag(), vce.getVersionNumber(), vce.getTagTime(), true);
                } else {
                    logger.info(I18n.msg("gui.newversion.fail"));
                    this.checkLabel.setText(I18n.msg("notif.error", "Could not get last version"));
                    this.checkLabel.setColor(Color.RED);
                }
            }
            return false;
        });
        return new Thread(vc);
    }
}

