/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import gaiasky.gui.beans.DistanceUnitComboBoxBean;
import gaiasky.gui.beans.OrientationComboBoxBean;
import gaiasky.gui.beans.PrimitiveComboBoxBean;
import gaiasky.gui.beans.ShapeComboBoxBean;
import gaiasky.gui.window.ColorPicker;
import gaiasky.gui.window.GenericDialog;
import gaiasky.scene.api.IFocus;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnSelectBox;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.validator.FloatValidator;

public class AddShapeDialog
extends GenericDialog {
    private final IFocus object;
    private final String objectName;
    private final float fieldWidth;
    private final float titleWidth;
    private final float cpSize;
    public OwnCheckBox track;
    public OwnCheckBox showLabel;
    public OwnTextField name;
    public OwnTextField size;
    public ColorPicker color;
    public OwnSelectBox<DistanceUnitComboBoxBean> units;
    public OwnSelectBox<ShapeComboBoxBean> shape;
    public OwnSelectBox<PrimitiveComboBoxBean> primitive;
    public OwnSelectBox<OrientationComboBoxBean> orientation;
    private boolean canRecomputeName = true;

    public AddShapeDialog(String title, IFocus object, String objectName, Skin skin, Stage ui) {
        super(title, skin, ui);
        this.objectName = objectName;
        this.object = object;
        this.fieldWidth = 288.0f;
        this.titleWidth = 150.0f;
        this.cpSize = 32.0f;
        this.setAcceptText(I18n.msg("gui.ok"));
        this.setCancelText(I18n.msg("gui.cancel"));
        this.buildSuper();
    }

    @Override
    protected void build() {
        this.content.clear();
        OwnLabel info = new OwnLabel((CharSequence)I18n.msg("gui.shape.info", this.object.getName()), this.skin, "hud-subheader");
        this.content.add((Actor)info).left().padBottom(pad20).row();
        this.addName(this.content, "1 " + I18n.msg("gui.unit.au") + " -> " + this.objectName);
        FloatValidator val = new FloatValidator(0.0f, Float.MAX_VALUE);
        this.size = new OwnTextField("1.0", this.skin, val);
        this.size.setWidth(this.fieldWidth * 0.6f);
        this.size.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.recomputeObjectName();
            }
            return true;
        });
        this.units = new OwnSelectBox(this.skin);
        this.units.setWidth(this.fieldWidth * 0.3f);
        this.units.setItems(DistanceUnitComboBoxBean.defaultBeans());
        this.units.setSelectedIndex(2);
        this.units.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.recomputeObjectName();
            }
            return true;
        });
        HorizontalGroup sizeGroup = new HorizontalGroup();
        sizeGroup.space(15.0f);
        sizeGroup.addActor((Actor)this.size);
        sizeGroup.addActor(this.units);
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.shape.size"), this.skin, this.titleWidth)).left().padRight(pad18).padBottom(pad18);
        this.content.add((Actor)sizeGroup).left().padBottom(pad18).row();
        this.showLabel = new OwnCheckBox(I18n.msg("gui.shape.label"), this.skin, pad10);
        this.showLabel.setChecked(true);
        this.content.add((Actor)this.showLabel).left().colspan(2).padRight(pad18).padBottom(pad18).row();
        this.track = new OwnCheckBox(I18n.msg("gui.shape.track"), this.skin, pad10);
        this.track.setChecked(true);
        this.content.add((Actor)this.track).left().colspan(2).padRight(pad18).padBottom(pad34).row();
        this.addSeparator(2);
        this.shape = new OwnSelectBox(this.skin);
        this.shape.setWidth(this.fieldWidth);
        this.shape.setItems(ShapeComboBoxBean.defaultShapes());
        this.shape.setSelectedIndex(0);
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.shape.shape"), this.skin, this.titleWidth)).left().padRight(pad18).padBottom(pad18);
        this.content.add(this.shape).left().padBottom(pad18).row();
        this.addColor(this.content);
        this.primitive = new OwnSelectBox(this.skin);
        this.primitive.setWidth(this.fieldWidth);
        this.primitive.setItems(PrimitiveComboBoxBean.defaultShapes());
        this.primitive.setSelectedIndex(0);
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.shape.primitive"), this.skin, this.titleWidth)).left().padRight(pad18).padBottom(pad18);
        this.content.add(this.primitive).left().padBottom(pad18).row();
        this.orientation = new OwnSelectBox(this.skin);
        this.orientation.setWidth(this.fieldWidth);
        this.orientation.setItems(OrientationComboBoxBean.defaultOrientations());
        this.orientation.setSelectedIndex(0);
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.shape.orientation"), this.skin, this.titleWidth)).left().padRight(pad18).padBottom(pad18);
        this.content.add(this.orientation).left().padBottom(pad18).row();
    }

    private void addName(Table container, String text) {
        this.name = new OwnTextField(text, this.skin);
        this.name.setWidth(this.fieldWidth);
        this.name.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent && !this.name.getText().equals(text)) {
                this.canRecomputeName = false;
            }
            return true;
        });
        container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.shape.name"), this.skin, this.titleWidth)).left().padRight(pad18).padBottom(pad18);
        container.add((Actor)this.name).left().padBottom(pad18).row();
    }

    private void addColor(Table container) {
        this.color = new ColorPicker(new float[]{0.3f, 0.4f, 1.0f, 0.5f}, this.stage, this.skin);
        container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.shape.color"), this.skin, this.titleWidth)).left().padRight(pad18).padBottom(pad10);
        Table lc = new Table(this.skin);
        lc.add((Actor)this.color).size(this.cpSize);
        container.add((Actor)lc).left().padBottom(pad10).row();
    }

    private void recomputeObjectName() {
        if (this.canRecomputeName) {
            String newName = this.size.getText() + " " + ((DistanceUnitComboBoxBean)this.units.getSelected()).name + " -> " + this.objectName;
            this.name.setText(newName);
            this.canRecomputeName = true;
        }
    }

    @Override
    protected boolean accept() {
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }
}

