/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import gaiasky.GaiaSky;
import gaiasky.gui.window.GenericDialog;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Logger;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.Link;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnTextTooltip;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class ArchiveViewWindow
extends GenericDialog {
    private static final Logger.Log logger = Logger.getLogger(ArchiveViewWindow.class);
    private static final String separator = "\n";
    private Table table;
    private OwnScrollPane scroll;
    private float pad;
    private FocusView st;
    private boolean updating = false;

    public ArchiveViewWindow(Stage stage, Skin skin) {
        super(I18n.msg("gui.data.catalog", "Gaia", "?"), skin, stage);
        this.setAcceptText(I18n.msg("gui.close"));
        this.setModal(false);
        this.buildSuper();
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public void update(FocusView st) {
        this.updating = true;
        this.st = st;
        this.getTitleLabel().setText((CharSequence)I18n.msg("gui.data.catalog", "Gaia", st.getName()));
        this.table.clear();
        this.requestData(new GaiaDataListener(st));
    }

    @Override
    protected void build() {
        this.pad = 8.0f;
        this.table = new Table(this.skin);
        this.table.pad(this.pad);
        this.scroll = new OwnScrollPane((Actor)this.table, this.skin, "minimalist-nobg");
        this.scroll.setFadeScrollBars(false);
        this.scroll.setScrollingDisabled(true, false);
        this.scroll.setOverscroll(false, false);
        this.scroll.setSmoothScrolling(true);
        this.content.add((Actor)this.scroll);
        this.getTitleTable().align(8);
        this.pack();
    }

    @Override
    protected boolean accept() {
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }

    private void requestData(GaiaDataListener listener) {
        if (this.st.getId() > 5000000L) {
            this.getTitleLabel().setText((CharSequence)I18n.msg("gui.data.catalog", "Gaia", this.st.getName()));
            this.getDataBySourceId(this.st.getId(), listener);
            return;
        }
        if (this.st.getHip() > 0) {
            this.getTitleLabel().setText((CharSequence)I18n.msg("gui.data.catalog", "Hipparcos", this.st.getName()));
            this.getDataByHipId(this.st.getHip(), listener);
            return;
        }
        listener.notFound();
    }

    private void getDataBySourceId(long sourceid, GaiaDataListener listener) {
        this.getTAPData("https://gaia.ari.uni-heidelberg.de/tap/sync?REQUEST=doQuery&LANG=ADQL&FORMAT=json&QUERY=SELECT+*+FROM+gaiadr3.gaia_source+WHERE+source_id=" + sourceid, false, "json", listener);
    }

    private void getDataByHipId(int hip, GaiaDataListener listener) {
        this.getTAPData("https://gaia.ari.uni-heidelberg.de/tap/sync?REQUEST=doQuery&LANG=ADQL&FORMAT=json&QUERY=SELECT+*+FROM+extcat.hipparcos+WHERE+hip=" + hip, true, "json", listener);
    }

    private void getTAPData(String url, final boolean hip, final String format, final GaiaDataListener listener) {
        Net.HttpRequest request = new Net.HttpRequest("GET");
        request.setUrl(url);
        request.setTimeOut(5000);
        Gdx.net.sendHttpRequest(request, new Net.HttpResponseListener(){
            final /* synthetic */ ArchiveViewWindow this$0;
            {
                this.this$0 = this$0;
            }

            public void handleHttpResponse(Net.HttpResponse httpResponse) {
                if (httpResponse.getStatus().getStatusCode() == 200) {
                    listener.ok(this.this$0.isToArray(httpResponse.getResultAsStream(), format), hip);
                } else {
                    listener.ko(httpResponse.getStatus().toString());
                }
            }

            public void failed(Throwable t) {
                listener.ko();
            }

            public void cancelled() {
                listener.ko();
            }
        });
    }

    public String trim(String stringToTrim, String stringToRemove) {
        String answer = stringToTrim;
        while (answer.startsWith(stringToRemove)) {
            answer = answer.substring(stringToRemove.length());
        }
        while (answer.endsWith(stringToRemove)) {
            answer = answer.substring(0, answer.length() - stringToRemove.length());
        }
        return answer;
    }

    private String slurp(InputStream is, int bufferSize) {
        char[] buffer = new char[bufferSize];
        StringBuilder out = new StringBuilder();
        try (InputStreamReader in = new InputStreamReader(is, StandardCharsets.UTF_8);){
            int rsz;
            while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
                out.append(buffer, 0, rsz);
            }
        }
        catch (IOException ex) {
            logger.error(ex);
        }
        return out.toString();
    }

    private String[][] isToArray(InputStream is, String format) {
        String data = this.slurp(is, 2064);
        if (format.equalsIgnoreCase("csv")) {
            String[] rows = data.split(separator);
            if (rows.length <= 1) {
                return null;
            }
            String[][] matrix = new String[rows.length][];
            int r = 0;
            for (String row : rows) {
                String[] tokens = row.split(",");
                int i = 0;
                for (String token : tokens) {
                    token = token.trim();
                    tokens[i] = this.trim(token, "\"");
                    ++i;
                }
                matrix[r] = tokens;
                ++r;
            }
            return matrix;
        }
        if (format.equalsIgnoreCase("json")) {
            JsonReader json = new JsonReader();
            JsonValue root = json.parse(data);
            JsonValue metadata = root.child;
            int size = metadata.size;
            JsonValue column = metadata.child;
            String[] colnames = new String[size];
            String[] descriptions = new String[size];
            String[] values = new String[size];
            int i = 0;
            do {
                colnames[i] = column.getString("name");
                descriptions[i] = column.getString("description") + (String)(column.has("unit") ? " [" + column.getString("unit") + "]" : "");
                ++i;
            } while ((column = column.next) != null);
            JsonValue datacol = metadata.next.child.child;
            i = 0;
            do {
                values[i] = datacol.asString();
                ++i;
            } while ((datacol = datacol.next) != null);
            String[][] matrix = new String[][]{colnames, values, descriptions};
            return matrix;
        }
        return null;
    }

    private class GaiaDataListener {
        private final FocusView st;

        public GaiaDataListener(FocusView st) {
            this.st = st;
        }

        public void ok(String[][] data, boolean hip) {
            GaiaSky.postRunnable(() -> {
                HorizontalGroup links = new HorizontalGroup();
                links.align(1);
                links.pad(ArchiveViewWindow.this.pad / 2.0f, ArchiveViewWindow.this.pad / 2.0f, ArchiveViewWindow.this.pad / 2.0f, ArchiveViewWindow.this.pad / 2.0f);
                links.space(ArchiveViewWindow.this.pad);
                if (hip) {
                    links.addActor((Actor)new Link((CharSequence)I18n.msg("gui.data.json"), ArchiveViewWindow.this.skin, "https://gaia.ari.uni-heidelberg.de/tap/sync?REQUEST=doQuery&LANG=ADQL&FORMAT=json&QUERY=SELECT+*+FROM+extcat.hipparcos+WHERE+hip=" + this.st.getHip()));
                } else {
                    links.addActor((Actor)new Link((CharSequence)I18n.msg("gui.data.json"), ArchiveViewWindow.this.skin, "https://gaia.ari.uni-heidelberg.de/tap/sync?REQUEST=doQuery&LANG=ADQL&FORMAT=json&QUERY=SELECT+*+FROM+gaiadr3.gaia_source+WHERE+source_id=" + this.st.getId()));
                    links.addActor((Actor)new OwnLabel((CharSequence)"|", ArchiveViewWindow.this.skin));
                    links.addActor((Actor)new Link((CharSequence)I18n.msg("gui.data.archive"), ArchiveViewWindow.this.skin, "https://gaia.ari.uni-heidelberg.de/singlesource.html#id=" + this.st.getId()));
                }
                ArchiveViewWindow.this.table.add((Actor)links).colspan(2).padTop(ArchiveViewWindow.this.pad * 2.0f).padBottom(ArchiveViewWindow.this.pad * 2.0f);
                ArchiveViewWindow.this.table.row();
                ArchiveViewWindow.this.table.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.data.name"), ArchiveViewWindow.this.skin, "big")).padLeft(ArchiveViewWindow.this.pad * 2.0f).left();
                ArchiveViewWindow.this.table.add((Actor)new OwnLabel((CharSequence)this.st.getName(), ArchiveViewWindow.this.skin, "big")).padLeft(ArchiveViewWindow.this.pad * 2.0f).padRight(ArchiveViewWindow.this.pad * 2.0f).left();
                ArchiveViewWindow.this.table.row().padTop(ArchiveViewWindow.this.pad * 2.0f);
                for (int col = 0; col < data[0].length; ++col) {
                    OwnLabel first;
                    if (data.length <= 2) {
                        first = new OwnLabel((CharSequence)data[0][col], ArchiveViewWindow.this.skin, "big");
                    } else {
                        HorizontalGroup hg = new HorizontalGroup();
                        hg.space(8.0f);
                        ImageButton tooltip = new ImageButton(ArchiveViewWindow.this.skin, "tooltip");
                        tooltip.addListener((EventListener)new OwnTextTooltip(data[0][col], ArchiveViewWindow.this.skin));
                        String text = TextUtils.capString(data[2][col], 70);
                        OwnLabel label = new OwnLabel((CharSequence)text, ArchiveViewWindow.this.skin, "header-blue");
                        label.addListener((EventListener)new OwnTextTooltip(data[2][col], ArchiveViewWindow.this.skin));
                        label.setWidth(Math.max(label.getWidth(), 880.0f));
                        hg.addActor((Actor)label);
                        hg.addActor((Actor)tooltip);
                        first = hg;
                    }
                    ArchiveViewWindow.this.table.add((Actor)first).padLeft(ArchiveViewWindow.this.pad * 2.0f).left();
                    ArchiveViewWindow.this.table.add((Actor)new OwnLabel((CharSequence)data[1][col], ArchiveViewWindow.this.skin, "big")).padLeft(ArchiveViewWindow.this.pad * 2.0f).padRight(ArchiveViewWindow.this.pad * 2.0f).left();
                    ArchiveViewWindow.this.left();
                    ArchiveViewWindow.this.table.row();
                }
                this.finish();
            });
        }

        public void ko() {
            GaiaSky.postRunnable(() -> {
                String msg = I18n.msg("error.gaiacatalog.data", this.st.getName());
                ArchiveViewWindow.this.table.add((Actor)new OwnLabel((CharSequence)msg, ArchiveViewWindow.this.skin, "big"));
                this.finish();
            });
        }

        public void ko(String error) {
            GaiaSky.postRunnable(() -> {
                ArchiveViewWindow.this.table.add((Actor)new OwnLabel((CharSequence)error, ArchiveViewWindow.this.skin, "big"));
                this.finish();
            });
        }

        public void notFound() {
            String msg = I18n.msg("error.gaiacatalog.notfound", this.st.getName());
            ArchiveViewWindow.this.table.add((Actor)new OwnLabel((CharSequence)msg, ArchiveViewWindow.this.skin, "big"));
            this.finish();
        }

        private void finish() {
            ArchiveViewWindow.this.table.pack();
            ArchiveViewWindow.this.scroll.setWidth(ArchiveViewWindow.this.table.getWidth() + ArchiveViewWindow.this.scroll.getStyle().vScroll.getMinWidth());
            ArchiveViewWindow.this.scroll.setHeight(Math.min(ArchiveViewWindow.this.table.getHeight(), (float)Gdx.graphics.getHeight() * 0.95f) + ArchiveViewWindow.this.pad);
            ArchiveViewWindow.this.pack();
            ArchiveViewWindow.this.updating = false;
        }
    }
}

