/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.gui.datasets.DatasetWatcher;
import gaiasky.gui.window.GenericDialog;
import gaiasky.util.DownloadHelper;
import gaiasky.util.GuiUtils;
import gaiasky.util.Logger;
import gaiasky.util.Pair;
import gaiasky.util.ProgressRunnable;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.TextUtils;
import gaiasky.util.datadesc.DatasetDesc;
import gaiasky.util.datadesc.DatasetDownloadUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnProgressBar;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.io.FilenameUtils;

public class BatchDownloadWindow
extends GenericDialog {
    private static final Logger.Log logger = Logger.getLogger(BatchDownloadWindow.class);
    private final String infoString;
    private final List<DatasetDesc> datasets;
    private final DecimalFormat nf = new DecimalFormat("##0.0");
    private final Set<DatasetWatcher> watchers;
    private Runnable success;
    private Runnable error;
    private final Map<String, Pair<DatasetDesc, Net.HttpRequest>> currentDownloads = Collections.synchronizedMap(new HashMap());

    public BatchDownloadWindow(String title, String info, Skin skin, Stage stage, List<DatasetDesc> datasets, Runnable success, Runnable error) {
        super(title, skin, stage);
        this.watchers = new HashSet<DatasetWatcher>();
        this.infoString = info;
        this.datasets = datasets;
        this.success = success;
        this.error = error;
        this.setModal(true);
        this.buildSuper();
    }

    public BatchDownloadWindow(String title, String info, Skin skin, Stage stage, List<DatasetDesc> datasets) {
        this(title, info, skin, stage, datasets, null, null);
    }

    public void setErrorRunnable(Runnable r) {
        this.error = r;
    }

    public void setSuccessRunnable(Runnable r) {
        this.success = r;
    }

    @Override
    protected void build() {
        this.content.clear();
        OwnLabel info = new OwnLabel((CharSequence)this.infoString, this.skin);
        info.setAlignment(1);
        this.content.add((Actor)info).colspan(2).padBottom(pad34).row();
        OwnLabel status = new OwnLabel((CharSequence)"idle", this.skin);
        for (DatasetDesc d : this.datasets) {
            OwnLabel name = new OwnLabel((CharSequence)d.name, this.skin, "header-s");
            this.content.add((Actor)name).left().padRight(pad20).padBottom(pad10);
            OwnProgressBar progress = new OwnProgressBar(0.0f, 100.0f, 0.1f, false, this.skin, "small-horizontal");
            progress.setPrefWidth(850.0f);
            progress.setValue(0.0f);
            progress.setVisible(true);
            Cell cell = this.content.add((Actor)progress);
            cell.left().padRight(pad20).padBottom(pad10).row();
            Runnable success = () -> {
                cell.clearActor();
                cell.setActor((Actor)new OwnLabel((CharSequence)I18n.msg("gui.done"), this.skin, "default-blue"));
            };
            DatasetWatcher watcher = new DatasetWatcher(d, progress, null, status, null, success);
            this.watchers.add(watcher);
        }
        this.content.add((Actor)status).colspan(2).padTop(pad34).padBottom(pad20).center();
    }

    public void downloadDatasets() {
        Runnable runnable = this.prepareDataset(0);
        runnable.run();
    }

    private Runnable prepareDataset(int i) {
        return i < this.datasets.size() - 1 ? () -> this.downloadDataset(this.datasets.get(i), this.prepareDataset(i + 1)) : () -> this.downloadDataset(this.datasets.get(i), this.success);
    }

    private void downloadDataset(DatasetDesc dataset, Runnable successRunnable) {
        Path tempDir = SysUtils.getDataTempDir(Settings.settings.data.location);
        try {
            FileStore fileStore = Files.getFileStore(tempDir);
            if (dataset.sizeBytes > 0L && (double)dataset.sizeBytes + (double)dataset.sizeBytes * 1.5 >= (double)fileStore.getUsableSpace()) {
                String title = I18n.msg("gui.download.space.error.title");
                String msg = I18n.msg("gui.download.space.error", fileStore.toString());
                logger.error(msg);
                GuiUtils.addNotificationWindow(title, msg, this.skin, this.stage, null);
                return;
            }
        }
        catch (IOException e) {
            logger.warn(I18n.msg("gui.batch.error.filestore", tempDir));
        }
        String name = dataset.name;
        String url = dataset.file.replace("@mirror-url@", Settings.settings.program.url.dataMirror);
        String filename = FilenameUtils.getName((String)url);
        FileHandle tempDownload = Gdx.files.absolute(String.valueOf(tempDir) + "/" + filename + ".part");
        ProgressRunnable progressDownload = (read, total, progress, speed) -> {
            try {
                double readMb = (double)read / 1000000.0;
                double totalMb = (double)total / 1000000.0;
                String progressString = progress >= 100.0 ? I18n.msg("gui.done") : I18n.msg("gui.download.downloading", this.nf.format(progress));
                double mbPerSecond = speed / 1000.0;
                String speedString = this.nf.format(readMb) + "/" + this.nf.format(totalMb) + " MB (" + this.nf.format(mbPerSecond) + " MB/s)";
                GaiaSky.postRunnable(() -> EventManager.publish(Event.DATASET_DOWNLOAD_PROGRESS_INFO, (Object)this, dataset.key, Float.valueOf((float)progress), progressString, speedString));
            }
            catch (Exception e) {
                logger.warn(I18n.msg("gui.download.error.progress"));
            }
        };
        ProgressRunnable progressHashResume = (read, total, progress, speed) -> {
            double readMb = (double)read / 1000000.0;
            double totalMb = (double)total / 1000000.0;
            String progressString = progress >= 100.0 ? I18n.msg("gui.done") : I18n.msg("gui.download.checksum.check", this.nf.format(progress));
            double mbPerSecond = speed / 1000.0;
            String speedString = this.nf.format(readMb) + "/" + this.nf.format(totalMb) + " MB (" + this.nf.format(mbPerSecond) + " MB/s)";
            GaiaSky.postRunnable(() -> EventManager.publish(Event.DATASET_DOWNLOAD_PROGRESS_INFO, (Object)this, dataset.key, Float.valueOf((float)progress), progressString, speedString));
        };
        Consumer<String> finish = digest -> {
            String dataLocation;
            int errors;
            String errorMsg;
            block10: {
                errorMsg = null;
                errors = 0;
                logger.info(I18n.msg("gui.download.extracting", tempDownload.path()));
                dataLocation = Settings.settings.data.location + File.separatorChar;
                if (digest != null && dataset.sha256 != null) {
                    String serverDigest = dataset.sha256;
                    try {
                        boolean ok = serverDigest.equals(digest);
                        if (ok) {
                            logger.info(I18n.msg("gui.download.checksum.ok", name));
                            break block10;
                        }
                        logger.error(I18n.msg("gui.download.checksum.fail", name));
                        errorMsg = I18n.msg("gui.download.checksum.fail.msg");
                        ++errors;
                        EventManager.publish(Event.POST_POPUP_NOTIFICATION, (Object)this, I18n.msg("gui.download.checksum.error", name), Float.valueOf(-1.0f));
                    }
                    catch (Exception e) {
                        logger.info(I18n.msg("gui.download.checksum.error", name));
                        errorMsg = I18n.msg("gui.download.checksum.fail.msg");
                        ++errors;
                        EventManager.publish(Event.POST_POPUP_NOTIFICATION, (Object)this, I18n.msg("gui.download.checksum.error", name), Float.valueOf(-1.0f));
                    }
                } else {
                    logger.info(I18n.msg("gui.download.checksum.notfound", name));
                    EventManager.publish(Event.POST_POPUP_NOTIFICATION, (Object)this, I18n.msg("gui.download.checksum.notfound", name), Float.valueOf(-1.0f));
                }
            }
            if (errors == 0) {
                try {
                    DatasetDownloadUtils.decompress(tempDownload.path(), new File(dataLocation), dataset);
                }
                catch (Exception e) {
                    try {
                        logger.error(e, I18n.msg("gui.download.decompress.error", name));
                        errorMsg = I18n.msg("gui.download.decompress.error.msg");
                        ++errors;
                    }
                    catch (Throwable throwable) {
                        EventManager.publish(Event.DATASET_DOWNLOAD_PROGRESS_INFO, (Object)this, dataset.key, Float.valueOf(100.0f), "complete", "-");
                        DatasetDownloadUtils.cleanupTempFile(tempDownload.path());
                        throw throwable;
                    }
                    EventManager.publish(Event.DATASET_DOWNLOAD_PROGRESS_INFO, (Object)this, dataset.key, Float.valueOf(100.0f), "complete", "-");
                    DatasetDownloadUtils.cleanupTempFile(tempDownload.path());
                }
                EventManager.publish(Event.DATASET_DOWNLOAD_PROGRESS_INFO, (Object)this, dataset.key, Float.valueOf(100.0f), "complete", "-");
                DatasetDownloadUtils.cleanupTempFile(tempDownload.path());
            }
            String errorMessage = errorMsg;
            int numErrors = errors;
            GaiaSky.postRunnable(() -> {
                this.currentDownloads.remove(dataset.key);
                if (numErrors == 0) {
                    EventManager.publish(Event.DATASET_DOWNLOAD_FINISH_INFO, (Object)this, dataset.key, 0);
                    dataset.exists = true;
                    this.actionEnableDataset(dataset);
                    if (successRunnable != null) {
                        successRunnable.run();
                    }
                    EventManager.publish(Event.POST_POPUP_NOTIFICATION, (Object)this, I18n.msg("gui.download.finished", name), Float.valueOf(-1.0f));
                } else {
                    logger.error(I18n.msg("gui.download.failed", name + " - " + url));
                    tempDownload.delete();
                    this.setStatusError(dataset, errorMessage);
                    this.currentDownloads.remove(dataset.key);
                    EventManager.publish(Event.POST_POPUP_NOTIFICATION, (Object)this, I18n.msg("gui.download.failed", name), Float.valueOf(-1.0f));
                    if (this.error != null) {
                        this.error.run();
                    }
                }
            });
        };
        Runnable fail = () -> {
            logger.error(I18n.msg("gui.download.failed", name + " - " + url));
            tempDownload.delete();
            this.setStatusError(dataset);
            this.currentDownloads.remove(dataset.key);
            EventManager.publish(Event.POST_POPUP_NOTIFICATION, (Object)this, I18n.msg("gui.download.failed", name), Float.valueOf(-1.0f));
            if (this.error != null) {
                this.error.run();
            }
        };
        Net.HttpRequest request = DownloadHelper.downloadFile(url, tempDownload, Settings.settings.program.offlineMode, progressDownload, progressHashResume, finish, fail, null);
        GaiaSky.postRunnable(() -> EventManager.publish(Event.DATASET_DOWNLOAD_START_INFO, (Object)this, dataset.key, request));
        this.currentDownloads.put(dataset.key, new Pair<DatasetDesc, Net.HttpRequest>(dataset, request));
    }

    private void setStatusError(DatasetDesc ds) {
        this.setStatusError(ds, null);
    }

    private void setStatusError(DatasetDesc ds, String message) {
        if (message != null && !message.isEmpty()) {
            EventManager.publish(Event.DATASET_DOWNLOAD_FINISH_INFO, (Object)this, ds.key, 1, message);
        } else {
            EventManager.publish(Event.DATASET_DOWNLOAD_FINISH_INFO, (Object)this, ds.key, 1);
        }
    }

    private void actionEnableDataset(DatasetDesc dataset) {
        if (dataset.type.equals("texture-pack")) {
            return;
        }
        String filePath = null;
        if (dataset.checkStr != null) {
            filePath = TextUtils.ensureStartsWith(dataset.checkStr, "$data/");
        }
        if (filePath != null && !filePath.isBlank()) {
            Settings.settings.data.dataFiles.add(filePath);
        }
    }

    private void actionDisableDataset(DatasetDesc dataset) {
        if (!dataset.baseData) {
            String filePath = null;
            if (dataset.checkStr != null) {
                filePath = TextUtils.ensureStartsWith(dataset.checkStr, "$data/");
            }
            if (filePath != null && !filePath.isBlank()) {
                Settings.settings.data.dataFiles.remove(filePath);
            }
        }
    }

    @Override
    protected boolean accept() {
        return false;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
        this.watchers.forEach(EventManager.instance::removeAllSubscriptions);
        this.watchers.clear();
    }
}

