/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextTooltip;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import gaiasky.gui.window.ColorPickerAbstract;
import gaiasky.gui.window.GenericDialog;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnSlider;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.validator.FloatValidator;
import gaiasky.util.validator.HexColorValidator;
import java.text.DecimalFormat;
import java.util.Arrays;

public class ColorPicker
extends ColorPickerAbstract {
    public ColorPicker(Stage stage, Skin skin) {
        super(I18n.msg("gui.colorpicker.title"), stage, skin);
        this.skin = skin;
        this.stage = stage;
        this.initialize();
    }

    public ColorPicker(String name, Stage stage, Skin skin) {
        super(name, stage, skin);
        this.skin = skin;
        this.stage = stage;
        this.initialize();
    }

    public ColorPicker(float[] rgba, Stage stage, Skin skin) {
        this(stage, skin);
        this.setPickedColor(rgba);
    }

    public ColorPicker(String name, float[] rgba, Stage stage, Skin skin) {
        this(name, stage, skin);
        this.setPickedColor(rgba);
    }

    @Override
    protected void initialize() {
        this.addListener(event -> {
            if (event instanceof InputEvent) {
                InputEvent ie = (InputEvent)event;
                InputEvent.Type type = ie.getType();
                if (type == InputEvent.Type.touchDown && ie.getButton() == 0) {
                    ColorPickerDialog cpd = new ColorPickerDialog(this.name, this.color, this.stage, this.skin);
                    cpd.setAcceptListener(() -> {
                        this.setPickedColor(cpd.color);
                        if (this.newColorRunnable != null) {
                            this.newColorRunnable.run();
                        }
                    });
                    cpd.show(this.stage);
                } else if (type == InputEvent.Type.enter) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Hand);
                } else if (type == InputEvent.Type.exit) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
                }
                return true;
            }
            return false;
        });
    }

    public void setNewColorRunnable(Runnable r) {
        this.newColorRunnable = r;
    }

    private class ColorPickerDialog
    extends GenericDialog {
        private final DecimalFormat nf;
        private final ColorPickerDialog cpd;
        private final float[] color;
        private final float[] colorBak;
        private OwnTextField[] textfields;
        private OwnTextField hexfield;
        private OwnSlider[] sliders;
        private Image newColorImage;
        private boolean changeEvents;

        public ColorPickerDialog(String elementName, float[] color, Stage stage, Skin skin) {
            super(I18n.msg("gui.colorpicker.title") + (String)(elementName != null ? ": " + elementName : ""), skin, stage);
            this.changeEvents = true;
            this.cpd = this;
            this.color = new float[4];
            this.colorBak = new float[4];
            this.color[0] = color[0];
            this.color[1] = color[1];
            this.color[2] = color[2];
            this.color[3] = color[3];
            this.nf = new DecimalFormat("0.00");
            this.setAcceptText(I18n.msg("gui.ok"));
            this.setCancelText(I18n.msg("gui.cancel"));
            this.setModal(true);
            this.buildSuper();
        }

        public ColorPickerDialog(float[] color, Stage stage, Skin skin) {
            this(null, color, stage, skin);
        }

        @Override
        protected void build() {
            float textfieldLen = 80.0f;
            float sliderLen = 240.0f;
            float colSize = 160.0f;
            this.content.clear();
            HorizontalGroup hg = new HorizontalGroup();
            hg.space(pad18);
            Image oldColorImage = new Image(this.skin.getDrawable("white"));
            oldColorImage.setColor(this.color[0], this.color[1], this.color[2], this.color[3]);
            Table oColor = new Table();
            oColor.add((Actor)oldColorImage).size(colSize);
            this.newColorImage = new Image(this.skin.getDrawable("white"));
            this.newColorImage.setColor(this.color[0], this.color[1], this.color[2], this.color[3]);
            Table col = new Table();
            col.add((Actor)this.newColorImage).size(colSize);
            hg.addActor((Actor)oColor);
            hg.addActor((Actor)new OwnLabel((CharSequence)">", this.skin));
            hg.addActor((Actor)col);
            this.sliders = new OwnSlider[4];
            OwnSlider sRed = new OwnSlider(0.0f, 1.0f, 0.01f, this.skin);
            sRed.showValueLabel(false);
            sRed.setWidth(sliderLen);
            sRed.setValue(this.color[0]);
            this.sliders[0] = sRed;
            OwnSlider sGreen = new OwnSlider(0.0f, 1.0f, 0.01f, this.skin);
            sGreen.showValueLabel(false);
            sGreen.setWidth(sliderLen);
            sGreen.setValue(this.color[1]);
            this.sliders[1] = sGreen;
            OwnSlider sBlue = new OwnSlider(0.0f, 1.0f, 0.01f, this.skin);
            sBlue.showValueLabel(false);
            sBlue.setWidth(sliderLen);
            sBlue.setValue(this.color[2]);
            this.sliders[2] = sBlue;
            OwnSlider sAlpha = new OwnSlider(0.0f, 1.0f, 0.01f, this.skin);
            sAlpha.showValueLabel(false);
            sAlpha.setWidth(sliderLen);
            sAlpha.setValue(this.color[3]);
            this.sliders[3] = sAlpha;
            this.textfields = new OwnTextField[4];
            FloatValidator floatValidator = new FloatValidator(0.0f, 1.0f);
            OwnTextField tRed = new OwnTextField(this.nf.format(this.color[0]), this.skin, floatValidator);
            tRed.setWidth(textfieldLen);
            this.textfields[0] = tRed;
            OwnTextField tGreen = new OwnTextField(this.nf.format(this.color[1]), this.skin, floatValidator);
            tGreen.setWidth(textfieldLen);
            this.textfields[1] = tGreen;
            OwnTextField tBlue = new OwnTextField(this.nf.format(this.color[2]), this.skin, floatValidator);
            tBlue.setWidth(textfieldLen);
            this.textfields[2] = tBlue;
            OwnTextField tAlpha = new OwnTextField(this.nf.format(this.color[3]), this.skin, floatValidator);
            tAlpha.setWidth(textfieldLen);
            this.textfields[3] = tAlpha;
            HexColorValidator hVal = new HexColorValidator(true);
            this.hexfield = new OwnTextField(ColorUtils.rgbaToHex(this.color), this.skin, hVal);
            this.hexfield.setWidth(sliderLen);
            Table colTable = new Table();
            float size = 24.0f;
            float cPad = 1.6f;
            int i = 1;
            int n = 64;
            float a = 1.0f;
            for (float r = 0.0f; r <= 1.0f; r += 0.3333f) {
                for (float g = 0.0f; g <= 1.0f; g += 0.3333f) {
                    for (float b = 0.0f; b <= 1.0f; b += 0.3333f) {
                        Image c = new Image(this.skin.getDrawable("white"));
                        c.setColor(r, g, b, a);
                        final float[] pick = new float[]{r, g, b, a};
                        c.addListener((EventListener)new ClickListener(this){
                            final /* synthetic */ ColorPickerDialog this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void clicked(InputEvent event, float x, float y) {
                                this.this$1.cpd.setColor(pick);
                            }
                        });
                        c.addListener((EventListener)new TextTooltip(Arrays.toString(pick), this.skin));
                        if (i % (n / 4) == 0) {
                            colTable.add((Actor)c).size(size).pad(cPad).row();
                        } else {
                            colTable.add((Actor)c).size(size).pad(cPad);
                        }
                        ++i;
                    }
                }
            }
            sRed.addListener(new UpdaterListener(ColorPicker.this, true, this, this.color, 0));
            sGreen.addListener(new UpdaterListener(ColorPicker.this, true, this, this.color, 1));
            sBlue.addListener(new UpdaterListener(ColorPicker.this, true, this, this.color, 2));
            sAlpha.addListener(new UpdaterListener(ColorPicker.this, true, this, this.color, 3));
            tRed.addListener(new UpdaterListener(ColorPicker.this, false, this, this.color, 0));
            tGreen.addListener(new UpdaterListener(ColorPicker.this, false, this, this.color, 1));
            tBlue.addListener(new UpdaterListener(ColorPicker.this, false, this, this.color, 2));
            tAlpha.addListener(new UpdaterListener(ColorPicker.this, false, this, this.color, 3));
            this.hexfield.addListener((EventListener)new ChangeListener(){

                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (ColorPickerDialog.this.changeEvents && ColorPickerDialog.this.hexfield.isValid()) {
                        float[] newcol = ColorUtils.hexToRgba(ColorPickerDialog.this.hexfield.getText());
                        System.arraycopy(newcol, 0, ColorPickerDialog.this.color, 0, newcol.length);
                        ColorPickerDialog.this.cpd.updateColor(true, true, false);
                    }
                }
            });
            this.content.add((Actor)hg).padBottom(pad18 * 2.0f).colspan(3).row();
            this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.colorpicker.red"), this.skin)).padRight(pad18).padBottom(pad18);
            this.content.add((Actor)sRed).left().padRight(pad18).padBottom(pad18);
            this.content.add((Actor)tRed).padBottom(pad18).row();
            this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.colorpicker.green"), this.skin)).padRight(pad18).padBottom(pad18);
            this.content.add((Actor)sGreen).left().padRight(pad18).padBottom(pad18);
            this.content.add((Actor)tGreen).padBottom(pad18).row();
            this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.colorpicker.blue"), this.skin)).padRight(pad18).padBottom(pad18);
            this.content.add((Actor)sBlue).left().padRight(pad18).padBottom(pad18);
            this.content.add((Actor)tBlue).padBottom(pad18).row();
            this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.colorpicker.alpha"), this.skin)).padRight(pad18).padBottom(pad18);
            this.content.add((Actor)sAlpha).left().padRight(pad18).padBottom(pad18);
            this.content.add((Actor)tAlpha).padBottom(pad18).row();
            this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.colorpicker.hex"), this.skin)).padRight(pad18).padBottom(pad18);
            this.content.add((Actor)this.hexfield).colspan(2).left().padBottom(pad18).row();
            this.content.add((Actor)colTable).colspan(3).padBottom(pad18).row();
        }

        @Override
        protected boolean accept() {
            return true;
        }

        @Override
        protected void cancel() {
            System.arraycopy(this.colorBak, 0, this.color, 0, this.color.length);
        }

        @Override
        public void dispose() {
        }

        @Override
        public GenericDialog show(Stage stage) {
            System.arraycopy(this.color, 0, this.colorBak, 0, this.color.length);
            return super.show(stage);
        }

        public void setColor(float[] color) {
            this.setColor(color[0], color[1], color[2], color[3]);
        }

        public void setColor(float red, float green, float blue, float alpha) {
            this.color[0] = red;
            this.color[1] = green;
            this.color[2] = blue;
            this.color[3] = alpha;
            this.updateColor();
        }

        public void updateColor() {
            this.updateColor(true, true, true);
        }

        public void updateColor(boolean updateSliders, boolean updateTextFields, boolean updateHex) {
            this.changeEvents = false;
            for (int i = 0; i < this.color.length; ++i) {
                if (updateSliders) {
                    this.sliders[i].setValue(this.color[i]);
                }
                if (!updateTextFields) continue;
                this.textfields[i].setText(this.nf.format(this.color[i]));
            }
            if (updateHex) {
                this.hexfield.setText(ColorUtils.rgbaToHex(this.color));
            }
            this.newColorImage.setColor(this.color[0], this.color[1], this.color[2], this.color[3]);
            this.changeEvents = true;
        }
    }

    private class UpdaterListener
    implements EventListener {
        private final ColorPickerDialog cpd;
        private final float[] color;
        private final int idx;
        private final boolean slider;

        public UpdaterListener(ColorPicker colorPicker, boolean slider, ColorPickerDialog cpd, float[] color, int idx) {
            this.cpd = cpd;
            this.slider = slider;
            this.color = color;
            this.idx = idx;
        }

        public boolean handle(Event event) {
            if (this.cpd.changeEvents && event instanceof ChangeListener.ChangeEvent) {
                float c = this.color[this.idx];
                boolean update = true;
                if (this.slider) {
                    c = this.cpd.sliders[this.idx].getValue();
                } else if (this.cpd.textfields[this.idx].isValid()) {
                    c = Float.parseFloat(this.cpd.textfields[this.idx].getText());
                } else {
                    update = false;
                }
                if (update && c != this.color[this.idx]) {
                    this.color[this.idx] = c;
                    this.cpd.updateColor(!this.slider, this.slider, true);
                }
                return true;
            }
            return false;
        }
    }
}

