/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;

public abstract class ColorPickerAbstract
extends Image {
    protected Stage stage;
    protected Skin skin;
    protected Runnable newColorRunnable;
    protected Runnable newColormapRunnable;
    protected float[] color;
    protected String name;

    protected ColorPickerAbstract(String name, Stage stage, Skin skin) {
        super(skin.getDrawable("white"));
        this.name = name;
        this.skin = skin;
        this.stage = stage;
    }

    protected abstract void initialize();

    protected void initColor() {
        if (this.color == null || this.color.length != 4) {
            this.color = new float[4];
        }
    }

    public float[] getPickedColor() {
        return this.color;
    }

    public void setPickedColor(float[] rgba) {
        this.initColor();
        System.arraycopy(rgba, 0, this.color, 0, rgba.length);
        super.setColor(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    public double[] getPickedColorDouble() {
        double[] c = new double[this.color.length];
        for (int i = 0; i < this.color.length; ++i) {
            c[i] = this.color[i];
        }
        return c;
    }

    public void setPickedColor(float r, float g, float b, float a) {
        this.initColor();
        this.color[0] = r;
        this.color[1] = g;
        this.color[2] = b;
        this.color[3] = a;
        super.setColor(r, g, b, a);
    }
}

