/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextTooltip;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.gui.beans.AttributeComboBoxBean;
import gaiasky.gui.beans.ComboBoxBean;
import gaiasky.gui.window.ColorPickerAbstract;
import gaiasky.gui.window.GenericDialog;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.view.FocusView;
import gaiasky.scene.view.OctreeObjectView;
import gaiasky.util.CatalogInfo;
import gaiasky.util.Pair;
import gaiasky.util.TextUtils;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.filter.attrib.AttributeAbsmag;
import gaiasky.util.filter.attrib.AttributeAppmag;
import gaiasky.util.filter.attrib.AttributeColorBlue;
import gaiasky.util.filter.attrib.AttributeColorGreen;
import gaiasky.util.filter.attrib.AttributeColorRed;
import gaiasky.util.filter.attrib.AttributeDEC;
import gaiasky.util.filter.attrib.AttributeDistance;
import gaiasky.util.filter.attrib.AttributeEclLatitude;
import gaiasky.util.filter.attrib.AttributeEclLongitude;
import gaiasky.util.filter.attrib.AttributeGalLatitude;
import gaiasky.util.filter.attrib.AttributeGalLongitude;
import gaiasky.util.filter.attrib.AttributeMualpha;
import gaiasky.util.filter.attrib.AttributeMudelta;
import gaiasky.util.filter.attrib.AttributeRA;
import gaiasky.util.filter.attrib.AttributeRadvel;
import gaiasky.util.filter.attrib.AttributeUCD;
import gaiasky.util.filter.attrib.IAttribute;
import gaiasky.util.i18n.I18n;
import gaiasky.util.parse.Parser;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnImageButton;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnSelectBox;
import gaiasky.util.scene2d.OwnSlider;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.scene2d.OwnTextTooltip;
import gaiasky.util.scene2d.Separator;
import gaiasky.util.tree.IOctreeObject;
import gaiasky.util.tree.OctreeNode;
import gaiasky.util.ucd.UCD;
import gaiasky.util.validator.FloatValidator;
import gaiasky.util.validator.HexColorValidator;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ColormapPicker
extends ColorPickerAbstract {
    private static final Map<String, double[]> minMaxMap = new HashMap<String, double[]>();
    public static Array<Pair<String, Integer>> cmapList = new Array(false, 9);
    private final CatalogInfo catalogInfo;
    private final FocusView view;
    private final Drawable drawableColor;
    private final Drawable drawableColormap;
    private int cmapIndex;
    private IAttribute cmapAttrib;
    private double cmapMin;
    private double cmapMax;

    private ColormapPicker(String name, CatalogInfo ci, Stage stage, Skin skin) {
        super(name, stage, skin);
        this.catalogInfo = ci;
        this.drawableColor = skin.getDrawable("white");
        this.drawableColormap = skin.getDrawable("iconic-star");
        this.view = new FocusView();
        this.initialize();
    }

    public ColormapPicker(float[] rgba, CatalogInfo ci, Stage stage, Skin skin) {
        this(null, rgba, ci, stage, skin);
    }

    public ColormapPicker(String name, float[] rgba, CatalogInfo ci, Stage stage, Skin skin) {
        this(name, ci, stage, skin);
        this.setPickedColor(rgba);
    }

    static int getCmapIndex(String name) {
        for (Pair cmapDef : cmapList) {
            if (!((String)cmapDef.getFirst()).equalsIgnoreCase(name)) continue;
            return (Integer)cmapDef.getSecond();
        }
        return -1;
    }

    static String getCmapName(int index) {
        return (String)((Pair)cmapList.get(index)).getFirst();
    }

    @Override
    protected void initialize() {
        this.addListener((EventListener)new ClickListener(){

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return super.touchDown(event, x, y, pointer, button);
            }

            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (event.getButton() == 0) {
                    ColorPickerColormapDialog cpd = new ColorPickerColormapDialog(ColormapPicker.this.name, ColormapPicker.this.color, ColormapPicker.this.stage, ColormapPicker.this.skin);
                    cpd.setAcceptListener(() -> {
                        if (cpd.plainColor.isChecked()) {
                            ColormapPicker.this.setPickedColor(cpd.color);
                            if (ColormapPicker.this.newColorRunnable != null) {
                                ColormapPicker.this.newColorRunnable.run();
                            }
                        } else if (cpd.colormap.isChecked()) {
                            ColormapPicker.this.setPickedColormap(cpd.cmapImage);
                            if (ColormapPicker.this.newColormapRunnable != null) {
                                ColormapPicker.this.newColormapRunnable.run();
                            }
                        }
                    });
                    cpd.show(ColormapPicker.this.stage);
                }
                super.touchUp(event, x, y, pointer, button);
            }
        });
        this.addListener(event -> {
            if (event instanceof InputEvent) {
                InputEvent.Type type = ((InputEvent)event).getType();
                if (type == InputEvent.Type.enter) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Hand);
                } else if (type == InputEvent.Type.exit) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
                }
                return true;
            }
            return false;
        });
    }

    public Drawable getDrawable() {
        if (this.catalogInfo.plainColor) {
            return this.drawableColor;
        }
        return this.drawableColormap;
    }

    public void setNewColorRunnable(Runnable r) {
        this.newColorRunnable = r;
    }

    public void setNewColormapRunnable(Runnable r) {
        this.newColormapRunnable = r;
    }

    @Override
    public void setPickedColor(float[] rgba) {
        this.catalogInfo.plainColor = true;
        this.initColor();
        System.arraycopy(rgba, 0, this.color, 0, rgba.length);
        super.setColor(rgba[0], rgba[1], rgba[2], rgba[3]);
        super.setDrawable(this.getDrawable());
    }

    public void setPickedColormap(Image cmapImageSmall) {
        this.catalogInfo.plainColor = false;
        this.catalogInfo.hlCmapAttribute = this.cmapAttrib;
        this.catalogInfo.hlCmapIndex = this.cmapIndex;
        this.catalogInfo.hlCmapMin = this.cmapMin;
        this.catalogInfo.hlCmapMax = this.cmapMax;
        super.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        super.setDrawable(cmapImageSmall.getDrawable());
    }

    public int getPickedCmapIndex() {
        return this.cmapIndex;
    }

    public IAttribute getPickedCmapAttribute() {
        return this.cmapAttrib;
    }

    public double getPickedCmapMin() {
        return this.cmapMin;
    }

    public double getPickedCmapMax() {
        return this.cmapMax;
    }

    static {
        cmapList.add(new Pair<String, Integer>("reds", 0));
        cmapList.add(new Pair<String, Integer>("greens", 1));
        cmapList.add(new Pair<String, Integer>("blues", 2));
        cmapList.add(new Pair<String, Integer>("rainbow18", 3));
        cmapList.add(new Pair<String, Integer>("rainbow", 4));
        cmapList.add(new Pair<String, Integer>("seismic", 5));
        cmapList.add(new Pair<String, Integer>("carnation", 6));
        cmapList.add(new Pair<String, Integer>("hotmetal", 7));
        cmapList.add(new Pair<String, Integer>("cool", 8));
    }

    private class UpdaterListener
    implements EventListener {
        private final ColorPickerColormapDialog cpd;
        private final float[] color;
        private final int idx;
        private final boolean slider;

        public UpdaterListener(ColormapPicker colormapPicker, boolean slider, ColorPickerColormapDialog cpd, float[] color, int idx) {
            this.cpd = cpd;
            this.slider = slider;
            this.color = color;
            this.idx = idx;
        }

        public boolean handle(Event event) {
            if (this.cpd.changeEvents && event instanceof ChangeListener.ChangeEvent) {
                float c = this.color[this.idx];
                boolean update = true;
                if (this.slider) {
                    c = this.cpd.sliders[this.idx].getValue();
                } else if (this.cpd.textfields[this.idx].isValid()) {
                    c = Float.parseFloat(this.cpd.textfields[this.idx].getText());
                } else {
                    update = false;
                }
                if (update && c != this.color[this.idx]) {
                    this.color[this.idx] = c;
                    this.cpd.updateColor(!this.slider, this.slider, true);
                }
                return true;
            }
            return false;
        }
    }

    private class ColorPickerColormapDialog
    extends GenericDialog {
        private final Map<Integer, Image> cmapImages;
        private final DecimalFormat nf;
        private final ColorPickerColormapDialog cpd;
        private final Array<Entity> pgarray;
        private final Array<IOctreeObject> apearray;
        private CheckBox plainColor;
        private CheckBox colormap;
        private Image cmapImage;
        private Cell cmapImageCell;
        private float[] color;
        private OwnTextField minMap;
        private OwnTextField maxMap;
        private OwnTextField[] textfields;
        private OwnTextField hexfield;
        private OwnSlider[] sliders;
        private Image newColorImage;
        private boolean changeEvents;

        public ColorPickerColormapDialog(String elementName, float[] color, Stage stage, Skin skin) {
            super(TextUtils.capString(I18n.msg("gui.colorpicker.title") + (String)(elementName != null ? ": " + elementName : ""), 30), skin, stage);
            this.changeEvents = true;
            this.cpd = this;
            this.color = new float[4];
            this.color[0] = color[0];
            this.color[1] = color[1];
            this.color[2] = color[2];
            this.color[3] = color[3];
            this.pgarray = new Array();
            this.apearray = new Array();
            this.nf = new DecimalFormat("0.00");
            this.cmapImages = new HashMap<Integer, Image>();
            for (Pair cmapDef : cmapList) {
                Texture tex = new Texture(Gdx.files.internal("img/cmap/cmap_" + (String)cmapDef.getFirst() + ".png"));
                Image image = new Image(tex);
                this.cmapImages.put((Integer)cmapDef.getSecond(), new Image(tex));
            }
            this.setAcceptText(I18n.msg("gui.ok"));
            this.setCancelText(I18n.msg("gui.cancel"));
            this.setModal(true);
            this.buildSuper();
        }

        public ColorPickerColormapDialog(float[] color, Stage stage, Skin skin) {
            this(null, color, stage, skin);
        }

        @Override
        protected void build() {
            this.content.clear();
            Table container = new Table(this.skin);
            Container cont = new Container((Actor)container);
            this.plainColor = new OwnCheckBox(I18n.msg("gui.colorpicker.plaincolor"), this.skin, "radio", pad10);
            this.plainColor.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    if (this.plainColor.isChecked()) {
                        container.clear();
                        this.addColorPickerWidget(container);
                        this.pack();
                    }
                    return true;
                }
                return false;
            });
            this.plainColor.setChecked(ColormapPicker.this.catalogInfo.plainColor);
            this.content.add((Actor)this.plainColor).left().padBottom(pad10).row();
            this.colormap = new OwnCheckBox(I18n.msg("gui.colorpicker.colormap"), this.skin, "radio", pad10);
            this.colormap.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    if (this.colormap.isChecked()) {
                        container.clear();
                        this.addColormapWidget(container);
                        this.pack();
                    }
                    return true;
                }
                return false;
            });
            this.colormap.setChecked(!ColormapPicker.this.catalogInfo.plainColor);
            this.content.add((Actor)this.colormap).left().padBottom(pad10 * 2.0f).row();
            this.content.add((Actor)new Separator(this.skin, "gray")).center().growX().padBottom(pad10 * 2.0f).row();
            new ButtonGroup((Button[])new CheckBox[]{this.plainColor, this.colormap});
            this.content.add((Actor)cont).left();
        }

        private void addColormapWidget(Table container) {
            IParticleRecord first;
            ParticleSet set;
            float sbWidth = 272.0f;
            container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.colorpicker.colormap"), this.skin)).left().padRight(pad18).padBottom(pad10).padTop(pad18 * 2.0f);
            Object[] gqs = new ComboBoxBean[ColormapPicker.cmapList.size];
            for (Pair cmapDef : cmapList) {
                gqs[((Integer)cmapDef.getSecond()).intValue()] = new ComboBoxBean(I18n.msg("gui.colormap." + (String)cmapDef.getFirst()), (Integer)cmapDef.getSecond());
            }
            OwnSelectBox cmap = new OwnSelectBox(this.skin);
            cmap.setItems(gqs);
            cmap.setWidth(sbWidth);
            cmap.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    ColormapPicker.this.cmapIndex = cmap.getSelectedIndex();
                    this.updateCmapImage(((ComboBoxBean)cmap.getSelected()).value, ColormapPicker.this.catalogInfo.hlCmapAlpha);
                    return true;
                }
                return false;
            });
            container.add(cmap).colspan(2).left().padBottom(pad10).padTop(pad18 * 2.0f).row();
            container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.colorpicker.alpha"), this.skin)).left().padRight(pad18).padBottom(pad10);
            OwnSlider alphaSlider = new OwnSlider(0.0f, 1.0f, 0.01f, this.skin);
            alphaSlider.showValueLabel(false);
            alphaSlider.setWidth(sbWidth);
            alphaSlider.setValue(this.color[3]);
            alphaSlider.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    ColormapPicker.this.catalogInfo.hlCmapAlpha = alphaSlider.getValue();
                    this.updateCmapImage(((ComboBoxBean)cmap.getSelected()).value, ColormapPicker.this.catalogInfo.hlCmapAlpha);
                    return true;
                }
                return false;
            });
            container.add((Actor)alphaSlider).colspan(2).left().padBottom(pad10).padTop(pad10).row();
            this.cmapImageCell = container.add();
            this.cmapImageCell.colspan(3).center().padBottom(pad18 * 2.0f).padTop(pad10).row();
            this.updateCmapImage(((ComboBoxBean)cmap.getSelected()).value, ColormapPicker.this.catalogInfo.hlCmapAlpha);
            container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.colorpicker.attribute"), this.skin)).left().padRight(pad18).padBottom(pad10);
            Entity catalog = ColormapPicker.this.catalogInfo.entity;
            ColormapPicker.this.view.setEntity(catalog);
            boolean stars = ColormapPicker.this.view.getStarSet() != null || ColormapPicker.this.view.isOctree();
            Array attrs = new Array(false, stars ? 12 : 7);
            attrs.add((Object)new AttributeComboBoxBean(new AttributeDistance()));
            attrs.add((Object)new AttributeComboBoxBean(new AttributeRA()));
            attrs.add((Object)new AttributeComboBoxBean(new AttributeDEC()));
            attrs.add((Object)new AttributeComboBoxBean(new AttributeEclLatitude()));
            attrs.add((Object)new AttributeComboBoxBean(new AttributeEclLongitude()));
            attrs.add((Object)new AttributeComboBoxBean(new AttributeGalLatitude()));
            attrs.add((Object)new AttributeComboBoxBean(new AttributeGalLongitude()));
            if (stars) {
                attrs.add((Object)new AttributeComboBoxBean(new AttributeAppmag()));
                attrs.add((Object)new AttributeComboBoxBean(new AttributeAbsmag()));
                attrs.add((Object)new AttributeComboBoxBean(new AttributeMualpha()));
                attrs.add((Object)new AttributeComboBoxBean(new AttributeMudelta()));
                attrs.add((Object)new AttributeComboBoxBean(new AttributeRadvel()));
            }
            attrs.add((Object)new AttributeComboBoxBean(new AttributeColorRed()));
            attrs.add((Object)new AttributeComboBoxBean(new AttributeColorGreen()));
            attrs.add((Object)new AttributeComboBoxBean(new AttributeColorBlue()));
            if (ColormapPicker.this.view.isSet() && !(set = ColormapPicker.this.view.getSet()).data().isEmpty() && (first = set.data().get(0)).hasExtra()) {
                ObjectMap.Keys<UCD> ucds = first.extraKeys();
                for (UCD ucd : ucds) {
                    attrs.add((Object)new AttributeComboBoxBean(new AttributeUCD(ucd)));
                }
            }
            OwnSelectBox attribs = new OwnSelectBox(this.skin);
            attribs.setItems(attrs);
            attribs.setWidth(sbWidth);
            attribs.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    ColormapPicker.this.cmapAttrib = ((AttributeComboBoxBean)attribs.getSelected()).attr;
                    this.recomputeAttributeMinMax(ColormapPicker.this.catalogInfo, ColormapPicker.this.cmapAttrib);
                    return true;
                }
                return false;
            });
            container.add(attribs).colspan(2).left().padBottom(pad10).row();
            container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.colorpicker.min"), this.skin)).left().padRight(pad18).padBottom(pad10);
            this.minMap = new OwnTextField(Double.toString(this.getCmapMin(ColormapPicker.this.cmapAttrib, ColormapPicker.this.catalogInfo)), this.skin);
            this.minMap.setWidth(sbWidth * 0.9f);
            this.minMap.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent && this.minMap.isValid()) {
                    ColormapPicker.this.cmapMin = Parser.parseFloat(this.minMap.getText());
                    this.updateMinMaxMap(ColormapPicker.this.catalogInfo, ColormapPicker.this.cmapAttrib, 0, ColormapPicker.this.cmapMin);
                    return true;
                }
                return false;
            });
            container.add((Actor)this.minMap).left().padBottom(pad10).padRight(pad10);
            OwnImageButton reloadCmap = new OwnImageButton(this.skin, "reload");
            reloadCmap.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.colorpicker.minmax.reload"), this.skin, 3));
            reloadCmap.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    this.recomputeAttributeMinMax(ColormapPicker.this.catalogInfo, ColormapPicker.this.cmapAttrib, true);
                    return true;
                }
                return false;
            });
            container.add((Actor)reloadCmap).left().padBottom(pad10).row();
            container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.colorpicker.max"), this.skin)).left().padRight(pad18).padBottom(pad10);
            this.maxMap = new OwnTextField(Double.toString(this.getCmapMax(ColormapPicker.this.cmapAttrib, ColormapPicker.this.catalogInfo)), this.skin);
            this.maxMap.setWidth(sbWidth * 0.9f);
            this.maxMap.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent && this.maxMap.isValid()) {
                    ColormapPicker.this.cmapMax = Parser.parseFloat(this.maxMap.getText());
                    this.updateMinMaxMap(ColormapPicker.this.catalogInfo, ColormapPicker.this.cmapAttrib, 1, ColormapPicker.this.cmapMax);
                    return true;
                }
                return false;
            });
            container.add((Actor)this.maxMap).colspan(2).left().padBottom(pad10);
            container.add().row();
            cmap.setSelectedIndex(ColormapPicker.this.catalogInfo.hlCmapIndex);
            alphaSlider.setValue(ColormapPicker.this.catalogInfo.hlCmapAlpha);
            attribs.setSelectedIndex(this.findIndex(ColormapPicker.this.catalogInfo.hlCmapAttribute, (Array<AttributeComboBoxBean>)attrs));
            attribs.getSelection().fireChangeEvent();
            cmap.getSelection().fireChangeEvent();
        }

        private void updateCmapImage(Integer colorMapIndex, float alpha) {
            this.cmapImage = this.cmapImages.get(colorMapIndex);
            this.cmapImage.setColor(1.0f, 1.0f, 1.0f, alpha);
            this.cmapImageCell.clearActor();
            this.cmapImageCell.setActor((Actor)this.cmapImage);
            this.pack();
        }

        private double getCmapMin(IAttribute attrib, CatalogInfo ci) {
            if (attrib != null && ci != null) {
                String key = this.key(ci, attrib);
                if (!minMaxMap.containsKey(key)) {
                    return ci.hlCmapMin;
                }
                return minMaxMap.get(key)[0];
            }
            return 0.0;
        }

        private double getCmapMax(IAttribute attrib, CatalogInfo ci) {
            String key = this.key(ci, attrib);
            if (!minMaxMap.containsKey(key)) {
                return ci.hlCmapMax;
            }
            return minMaxMap.get(key)[1];
        }

        private void updateMinMaxMap(CatalogInfo ci, IAttribute attrib, int index, double value) {
            String key = this.key(ci, attrib);
            if (!minMaxMap.containsKey(key)) {
                minMaxMap.put(key, new double[]{value, value});
            } else {
                ColormapPicker.minMaxMap.get((Object)key)[index] = value;
            }
        }

        private String key(CatalogInfo ci, IAttribute attrib) {
            return (String)(ci != null ? ci.name + "-" : "") + (attrib != null ? attrib.toString() : "dummy");
        }

        private void recomputeAttributeMinMax(CatalogInfo ci, IAttribute attrib) {
            this.recomputeAttributeMinMax(ci, attrib, false);
        }

        private void recomputeAttributeMinMax(CatalogInfo ci, IAttribute attrib, boolean force) {
            String key = this.key(ci, attrib);
            ColormapPicker.this.view.setEntity(ci.entity);
            if (!force && minMaxMap.containsKey(key)) {
                double[] minmax = minMaxMap.get(key);
                this.minMap.setText(Double.toString(minmax[0]));
                this.maxMap.setText(Double.toString(minmax[1]));
                ColormapPicker.this.cmapMin = minmax[0];
                ColormapPicker.this.cmapMax = minmax[1];
            } else if (ColormapPicker.this.view.isSet() || ColormapPicker.this.view.isOctree()) {
                this.pgarray.clear();
                this.apearray.clear();
                if (ColormapPicker.this.view.isOctree()) {
                    OctreeNode octant = ColormapPicker.this.view.getOctant();
                    octant.addParticlesTo(this.apearray);
                    for (IOctreeObject ape : this.apearray) {
                        this.pgarray.add((Object)((OctreeObjectView)ape).getEntity());
                    }
                } else {
                    this.pgarray.add((Object)ci.entity);
                }
                double min = Double.MAX_VALUE;
                double max = Double.MIN_VALUE;
                for (Entity pg : this.pgarray) {
                    ParticleSet set = Mapper.particleSet.has(pg) ? (ParticleSet)Mapper.particleSet.get(pg) : (ParticleSet)Mapper.starSet.get(pg);
                    for (IParticleRecord pb : set.data()) {
                        double val = attrib.getNumber(pb);
                        if (Double.isNaN(val) || Double.isInfinite(val)) continue;
                        if (val < min) {
                            min = val;
                        }
                        if (!(val > max)) continue;
                        max = val;
                    }
                }
                this.minMap.setText(Double.toString(min));
                this.maxMap.setText(Double.toString(max));
                ColormapPicker.this.cmapMin = min;
                ColormapPicker.this.cmapMax = max;
                minMaxMap.put(key, new double[]{min, max});
            }
        }

        private int findIndex(IAttribute attribute, Array<AttributeComboBoxBean> attribs) {
            int i = 0;
            for (AttributeComboBoxBean attr : attribs) {
                if (attr.attr.equals(attribute)) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        private void addColorPickerWidget(Table container) {
            float textfieldLen = 80.0f;
            float sliderLen = 240.0f;
            float colsize = 160.0f;
            HorizontalGroup hg = new HorizontalGroup();
            hg.space(pad18);
            Image oldColorImage = new Image(this.skin.getDrawable("white"));
            oldColorImage.setColor(this.color[0], this.color[1], this.color[2], this.color[3]);
            Table ocol = new Table();
            ocol.add((Actor)oldColorImage).size(colsize);
            this.newColorImage = new Image(this.skin.getDrawable("white"));
            this.newColorImage.setColor(this.color[0], this.color[1], this.color[2], this.color[3]);
            Table col = new Table();
            col.add((Actor)this.newColorImage).size(colsize);
            hg.addActor((Actor)ocol);
            hg.addActor((Actor)new OwnLabel((CharSequence)">", this.skin));
            hg.addActor((Actor)col);
            this.sliders = new OwnSlider[4];
            OwnSlider sred = new OwnSlider(0.0f, 1.0f, 0.01f, this.skin);
            sred.showValueLabel(false);
            sred.setWidth(sliderLen);
            sred.setValue(this.color[0]);
            this.sliders[0] = sred;
            OwnSlider sgreen = new OwnSlider(0.0f, 1.0f, 0.01f, this.skin);
            sgreen.showValueLabel(false);
            sgreen.setWidth(sliderLen);
            sgreen.setValue(this.color[1]);
            this.sliders[1] = sgreen;
            OwnSlider sblue = new OwnSlider(0.0f, 1.0f, 0.01f, this.skin);
            sblue.showValueLabel(false);
            sblue.setWidth(sliderLen);
            sblue.setValue(this.color[2]);
            this.sliders[2] = sblue;
            OwnSlider salpha = new OwnSlider(0.0f, 1.0f, 0.01f, this.skin);
            salpha.showValueLabel(false);
            salpha.setWidth(sliderLen);
            salpha.setValue(this.color[3]);
            this.sliders[3] = salpha;
            this.textfields = new OwnTextField[4];
            FloatValidator fval = new FloatValidator(0.0f, 1.0f);
            OwnTextField tred = new OwnTextField(this.nf.format(this.color[0]), this.skin, fval);
            tred.setWidth(textfieldLen);
            this.textfields[0] = tred;
            OwnTextField tgreen = new OwnTextField(this.nf.format(this.color[1]), this.skin, fval);
            tgreen.setWidth(textfieldLen);
            this.textfields[1] = tgreen;
            OwnTextField tblue = new OwnTextField(this.nf.format(this.color[2]), this.skin, fval);
            tblue.setWidth(textfieldLen);
            this.textfields[2] = tblue;
            OwnTextField talpha = new OwnTextField(this.nf.format(this.color[3]), this.skin, fval);
            talpha.setWidth(textfieldLen);
            this.textfields[3] = talpha;
            HexColorValidator hval = new HexColorValidator(true);
            this.hexfield = new OwnTextField(ColorUtils.rgbaToHex(this.color), this.skin, hval);
            this.hexfield.setWidth(sliderLen);
            Table coltable = new Table();
            float size = 24.0f;
            float cpad = 1.6f;
            int i = 1;
            int n = 64;
            float a = 1.0f;
            for (float r = 0.0f; r <= 1.0f; r += 0.3333f) {
                for (float g = 0.0f; g <= 1.0f; g += 0.3333f) {
                    for (float b = 0.0f; b <= 1.0f; b += 0.3333f) {
                        Image c = new Image(this.skin.getDrawable("white"));
                        c.setColor(r, g, b, a);
                        final float[] pick = new float[]{r, g, b, a};
                        c.addListener((EventListener)new ClickListener(this){
                            final /* synthetic */ ColorPickerColormapDialog this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void clicked(InputEvent event, float x, float y) {
                                this.this$1.cpd.setColor(pick);
                            }
                        });
                        c.addListener((EventListener)new TextTooltip(Arrays.toString(pick), this.skin));
                        if (i % (n / 4) == 0) {
                            coltable.add((Actor)c).size(size).pad(cpad).row();
                        } else {
                            coltable.add((Actor)c).size(size).pad(cpad);
                        }
                        ++i;
                    }
                }
            }
            sred.addListener(new UpdaterListener(ColormapPicker.this, true, this, this.color, 0));
            sgreen.addListener(new UpdaterListener(ColormapPicker.this, true, this, this.color, 1));
            sblue.addListener(new UpdaterListener(ColormapPicker.this, true, this, this.color, 2));
            salpha.addListener(new UpdaterListener(ColormapPicker.this, true, this, this.color, 3));
            tred.addListener(new UpdaterListener(ColormapPicker.this, false, this, this.color, 0));
            tgreen.addListener(new UpdaterListener(ColormapPicker.this, false, this, this.color, 1));
            tblue.addListener(new UpdaterListener(ColormapPicker.this, false, this, this.color, 2));
            talpha.addListener(new UpdaterListener(ColormapPicker.this, false, this, this.color, 3));
            this.hexfield.addListener((EventListener)new ChangeListener(){

                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (ColorPickerColormapDialog.this.changeEvents && ColorPickerColormapDialog.this.hexfield.isValid()) {
                        float[] newcol = ColorUtils.hexToRgba(ColorPickerColormapDialog.this.hexfield.getText());
                        System.arraycopy(newcol, 0, ColorPickerColormapDialog.this.color, 0, newcol.length);
                        ColorPickerColormapDialog.this.cpd.updateColor(true, true, false);
                    }
                }
            });
            container.add((Actor)hg).padBottom(pad18 * 2.0f).colspan(3).row();
            container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.colorpicker.red"), this.skin)).padRight(pad18).padBottom(pad18);
            container.add((Actor)sred).left().padRight(pad18).padBottom(pad18);
            container.add((Actor)tred).padBottom(pad18).row();
            container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.colorpicker.green"), this.skin)).padRight(pad18).padBottom(pad18);
            container.add((Actor)sgreen).left().padRight(pad18).padBottom(pad18);
            container.add((Actor)tgreen).padBottom(pad18).row();
            container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.colorpicker.blue"), this.skin)).padRight(pad18).padBottom(pad18);
            container.add((Actor)sblue).left().padRight(pad18).padBottom(pad18);
            container.add((Actor)tblue).padBottom(pad18).row();
            container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.colorpicker.alpha"), this.skin)).padRight(pad18).padBottom(pad18);
            container.add((Actor)salpha).left().padRight(pad18).padBottom(pad18);
            container.add((Actor)talpha).padBottom(pad18).row();
            container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.colorpicker.hex"), this.skin)).padRight(pad18).padBottom(pad18);
            container.add((Actor)this.hexfield).colspan(2).left().padBottom(pad18).row();
            container.add((Actor)coltable).colspan(3).padBottom(pad18).row();
        }

        @Override
        protected boolean accept() {
            return true;
        }

        @Override
        protected void cancel() {
            this.color = null;
        }

        @Override
        public void dispose() {
        }

        public void setColor(float[] color) {
            this.setColor(color[0], color[1], color[2], color[3]);
        }

        public void setColor(float red, float green, float blue, float alpha) {
            this.color[0] = red;
            this.color[1] = green;
            this.color[2] = blue;
            this.color[3] = alpha;
            this.updateColor();
        }

        public void updateColor() {
            this.updateColor(true, true, true);
        }

        public void updateColor(boolean updateSliders, boolean updateTextFields, boolean updateHex) {
            this.changeEvents = false;
            for (int i = 0; i < this.color.length; ++i) {
                if (updateSliders) {
                    this.sliders[i].setValue(this.color[i]);
                }
                if (!updateTextFields) continue;
                this.textfields[i].setText(this.nf.format(this.color[i]));
            }
            if (updateHex) {
                this.hexfield.setText(ColorUtils.rgbaToHex(this.color));
            }
            this.newColorImage.setColor(this.color[0], this.color[1], this.color[2], this.color[3]);
            this.changeEvents = true;
        }
    }
}

