/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TiledDrawable;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.components.BookmarksComponent;
import gaiasky.gui.components.CameraComponent;
import gaiasky.gui.components.DatasetsComponent;
import gaiasky.gui.components.LocationLogComponent;
import gaiasky.gui.components.TimeComponent;
import gaiasky.gui.components.VisibilityComponent;
import gaiasky.gui.components.VisualSettingsComponent;
import gaiasky.gui.main.KeyBindings;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Scene;
import gaiasky.util.CatalogManager;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.scene2d.CollapsiblePane;
import gaiasky.util.scene2d.CollapsibleWindow;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnTextHotkeyTooltip;
import gaiasky.util.scene2d.OwnTextIconButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.jafama.FastMath;

public class ControlsWindow
extends CollapsibleWindow
implements IObserver {
    private final CatalogManager catalogManager;
    protected Stage ui;
    protected Skin skin;
    protected VerticalGroup mainVertical;
    protected OwnScrollPane windowScroll;
    protected Table guiLayout;
    protected OwnTextIconButton buttonMinimap = null;
    protected TiledDrawable separator;
    private Scene scene;
    private ComponentTypes.ComponentType[] visibilityEntities;
    private boolean[] visible;
    private Map<String, CollapsiblePane> panes;

    public ControlsWindow(String title, Skin skin, Stage ui, CatalogManager catalogManager) {
        super(title, skin);
        this.setName(title);
        this.skin = skin;
        this.ui = ui;
        this.catalogManager = catalogManager;
        TextureRegion separatorTextureRegion = ((TextureRegionDrawable)skin.newDrawable("separator-dash")).getRegion();
        separatorTextureRegion.getTexture().setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.ClampToEdge);
        this.separator = new TiledDrawable(separatorTextureRegion);
        EventManager.instance.subscribe((IObserver)this, Event.GUI_SCROLL_POSITION_CMD, Event.GUI_FOLD_CMD, Event.GUI_MOVE_CMD, Event.RECALCULATE_CONTROLS_WINDOW_SIZE, Event.EXPAND_COLLAPSE_PANE_CMD, Event.TOGGLE_EXPANDCOLLAPSE_PANE_CMD, Event.MINIMAP_DISPLAY_CMD, Event.MINIMAP_TOGGLE_CMD);
    }

    public static float getContentWidth() {
        return 352.0f;
    }

    public void initialize() {
        this.guiLayout = new Table();
        this.guiLayout.pad(0.0f);
        this.guiLayout.align(8);
        ArrayList<CollapsiblePane> mainActors = new ArrayList<CollapsiblePane>();
        this.panes = new HashMap<String, CollapsiblePane>();
        TimeComponent timeComponent = new TimeComponent(this.skin, this.ui);
        timeComponent.initialize(ControlsWindow.getContentWidth());
        String shortcut = KeyBindings.instance.getStringKeys("action.expandcollapse.pane/gui.time");
        CollapsiblePane time = new CollapsiblePane(this.ui, I18n.msg("gui.time"), timeComponent.getActor(), ControlsWindow.getContentWidth(), this.skin, true, shortcut, new Actor[0]);
        time.align(8);
        mainActors.add(time);
        this.panes.put(timeComponent.getClass().getSimpleName(), time);
        CameraComponent cameraComponent = new CameraComponent(this.skin, this.ui);
        cameraComponent.initialize(ControlsWindow.getContentWidth());
        shortcut = KeyBindings.instance.getStringKeys("action.expandcollapse.pane/gui.camera");
        CollapsiblePane camera = new CollapsiblePane(this.ui, I18n.msg("gui.camera"), cameraComponent.getActor(), ControlsWindow.getContentWidth(), this.skin, false, shortcut, new Actor[0]);
        camera.align(8);
        mainActors.add(camera);
        this.panes.put(cameraComponent.getClass().getSimpleName(), camera);
        VisibilityComponent visibilityComponent = new VisibilityComponent(this.skin, this.ui);
        visibilityComponent.setVisibilityEntitites(this.visibilityEntities, this.visible);
        visibilityComponent.initialize(ControlsWindow.getContentWidth());
        shortcut = KeyBindings.instance.getStringKeys("action.expandcollapse.pane/gui.visibility");
        CollapsiblePane visibility = new CollapsiblePane(this.ui, I18n.msg("gui.visibility"), visibilityComponent.getActor(), ControlsWindow.getContentWidth(), this.skin, false, shortcut, new Actor[0]);
        visibility.align(8);
        mainActors.add(visibility);
        this.panes.put(visibilityComponent.getClass().getSimpleName(), visibility);
        VisualSettingsComponent visualSettingsComponent = new VisualSettingsComponent(this.skin, this.ui);
        visualSettingsComponent.initialize(ControlsWindow.getContentWidth());
        shortcut = KeyBindings.instance.getStringKeys("action.expandcollapse.pane/gui.lighting");
        CollapsiblePane visualEffects = new CollapsiblePane(this.ui, I18n.msg("gui.lighting"), visualSettingsComponent.getActor(), ControlsWindow.getContentWidth(), this.skin, false, shortcut, new Actor[0]);
        visualEffects.align(8);
        mainActors.add(visualEffects);
        this.panes.put(visualSettingsComponent.getClass().getSimpleName(), visualEffects);
        DatasetsComponent datasetsComponent = new DatasetsComponent(this.skin, this.ui, this.catalogManager);
        datasetsComponent.initialize(ControlsWindow.getContentWidth());
        shortcut = KeyBindings.instance.getStringKeys("action.expandcollapse.pane/gui.dataset.title");
        CollapsiblePane datasets = new CollapsiblePane(this.ui, I18n.msg("gui.dataset.title"), datasetsComponent.getActor(), ControlsWindow.getContentWidth(), this.skin, false, shortcut, new Actor[0]);
        datasets.align(8);
        mainActors.add(datasets);
        this.panes.put(datasetsComponent.getClass().getSimpleName(), datasets);
        LocationLogComponent locationLogComponent = new LocationLogComponent(this.skin, this.ui);
        locationLogComponent.initialize(ControlsWindow.getContentWidth());
        CollapsiblePane locationLog = new CollapsiblePane(this.ui, I18n.msg("gui.locationlog"), locationLogComponent.getActor(), ControlsWindow.getContentWidth(), this.skin, false, null, new Actor[0]);
        locationLog.align(8);
        mainActors.add(locationLog);
        this.panes.put(locationLogComponent.getClass().getSimpleName(), locationLog);
        BookmarksComponent bookmarksComponent = new BookmarksComponent(this.skin, this.ui);
        bookmarksComponent.setScene(this.scene);
        bookmarksComponent.initialize(ControlsWindow.getContentWidth());
        shortcut = KeyBindings.instance.getStringKeys("action.expandcollapse.pane/gui.bookmarks");
        CollapsiblePane bookmarks = new CollapsiblePane(this.ui, I18n.msg("gui.bookmarks"), bookmarksComponent.getActor(), ControlsWindow.getContentWidth(), this.skin, false, shortcut, new Actor[0]);
        bookmarks.align(8);
        mainActors.add(bookmarks);
        this.panes.put(bookmarksComponent.getClass().getSimpleName(), bookmarks);
        float bw = 48.0f;
        float bh = 48.0f;
        KeyBindings kb = KeyBindings.instance;
        this.buttonMinimap = new OwnTextIconButton("", this.skin, "menu-map");
        this.buttonMinimap.setSize(bw, bh);
        this.buttonMinimap.setName("map");
        this.buttonMinimap.setChecked(Settings.settings.program.minimap.active);
        String minimapHotkey = kb.getStringKeys("action.toggle/gui.minimap.title");
        this.buttonMinimap.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.map"), minimapHotkey, this.skin));
        this.buttonMinimap.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.MINIMAP_DISPLAY_CMD, (Object)this.buttonMinimap, this.buttonMinimap.isChecked());
            }
            return false;
        });
        OwnTextIconButton buttonLoad = new OwnTextIconButton("", this.skin, "load");
        buttonLoad.setSize(bw, bh);
        buttonLoad.setName("loadcatalog");
        buttonLoad.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.loadcatalog"), kb.getStringKeys("action.loadcatalog"), this.skin));
        buttonLoad.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_LOAD_CATALOG_ACTION, (Object)buttonLoad, new Object[0]);
                buttonLoad.setCheckedNoFire(false);
            }
            return false;
        });
        OwnTextIconButton buttonSettings = new OwnTextIconButton("", this.skin, "preferences");
        buttonSettings.setSize(bw, bh);
        buttonSettings.setName("preferences");
        String prefsHotkey = kb.getStringKeys("action.preferences");
        buttonSettings.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.preferences"), prefsHotkey, this.skin));
        buttonSettings.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_PREFERENCES_ACTION, (Object)buttonSettings, new Object[0]);
                buttonSettings.setCheckedNoFire(false);
            }
            return false;
        });
        OwnTextIconButton buttonLog = new OwnTextIconButton("", this.skin, "log");
        buttonLog.setSize(bw, bh);
        buttonLog.setName("show log");
        buttonLog.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.tooltip.log"), kb.getStringKeys("action.log"), this.skin));
        buttonLog.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_LOG_CMD, (Object)buttonLog, new Object[0]);
                buttonLog.setCheckedNoFire(false);
            }
            return false;
        });
        OwnTextIconButton buttonHelp = new OwnTextIconButton("", this.skin, "help");
        buttonHelp.setSize(bw, bh);
        buttonHelp.setName("about");
        String helpHotkey = kb.getStringKeys("action.help");
        buttonHelp.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.help"), helpHotkey, this.skin));
        buttonHelp.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_ABOUT_ACTION, (Object)buttonHelp, new Object[0]);
                buttonHelp.setCheckedNoFire(false);
            }
            return false;
        });
        OwnTextIconButton buttonQuit = new OwnTextIconButton("", this.skin, "quit");
        buttonQuit.setSize(bw, bh);
        buttonQuit.setName("quit");
        buttonQuit.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.quit.title"), kb.getStringKeys("action.exit"), this.skin));
        buttonQuit.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_QUIT_ACTION, (Object)buttonQuit, new Object[0]);
                buttonQuit.setCheckedNoFire(false);
            }
            return false;
        });
        float pad = 3.0f;
        Table buttonsTable = new Table(this.skin);
        buttonsTable.add((Actor)this.buttonMinimap).pad(pad).top().left();
        buttonsTable.add((Actor)buttonLoad).pad(pad).top().left();
        buttonsTable.add((Actor)buttonSettings).pad(pad).top().left();
        buttonsTable.add((Actor)buttonLog).pad(pad).top().left();
        buttonsTable.add((Actor)buttonHelp).pad(pad).top().left();
        buttonsTable.add((Actor)buttonQuit).pad(pad).top().left();
        buttonsTable.pack();
        int padBottom = FastMath.round((float)16.0f);
        int padSides = FastMath.round((float)8.0f);
        int padSeparator = FastMath.round((float)15.0f);
        this.guiLayout.padTop((float)padSides);
        int size = mainActors.size();
        for (int i = 0; i < size; ++i) {
            Actor actor = (Actor)mainActors.get(i);
            this.guiLayout.add(actor).prefWidth(188.0f).left().padBottom((float)padBottom).padLeft((float)padSides);
            if (i >= size - 1) continue;
            this.guiLayout.row();
            this.guiLayout.add((Actor)new Image((Drawable)this.separator)).left().fill(true, false).padTop((float)padSeparator).padLeft((float)padSides);
            this.guiLayout.row();
        }
        this.guiLayout.align(10);
        this.windowScroll = new OwnScrollPane((Actor)this.guiLayout, this.skin, "minimalist-nobg");
        this.windowScroll.setName("control panel scroll");
        this.windowScroll.setFadeScrollBars(false);
        this.windowScroll.setScrollingDisabled(true, false);
        this.windowScroll.setOverscroll(false, false);
        this.windowScroll.setSmoothScrolling(true);
        this.windowScroll.pack();
        this.windowScroll.setWidth(this.guiLayout.getWidth() + this.windowScroll.getStyle().vScroll.getMinWidth());
        this.mainVertical = new VerticalGroup();
        this.mainVertical.space((float)padSides);
        this.mainVertical.align(16).align(2);
        this.mainVertical.addActor((Actor)this.windowScroll);
        this.mainVertical.addActor((Actor)buttonsTable);
        this.mainVertical.pack();
        this.add((Actor)this.mainVertical).top().left().expand();
        this.setPosition(0.0f, FastMath.round((float)((float)Gdx.graphics.getHeight() - this.getHeight())));
        this.setWidth(this.mainVertical.getWidth());
        this.pack();
        this.recalculateSize();
    }

    public void recalculateSize() {
        float topy = this.getY() + this.getHeight();
        this.guiLayout.pack();
        if (this.windowScroll != null) {
            float unitsPerPixel = ((ScreenViewport)this.ui.getViewport()).getUnitsPerPixel();
            this.windowScroll.setHeight(Math.min(this.guiLayout.getHeight(), this.ui.getHeight() - 120.0f * unitsPerPixel));
            this.windowScroll.pack();
            this.mainVertical.setHeight(this.windowScroll.getHeight() + 30.0f * unitsPerPixel);
            this.mainVertical.pack();
            this.setHeight(this.windowScroll.getHeight() + 40.0f * unitsPerPixel);
        }
        this.pack();
        this.validate();
        this.setY(topy - this.getHeight());
    }

    public void setScene(Scene scene) {
        this.scene = scene;
    }

    public void setVisibilityToggles(ComponentTypes.ComponentType[] entities, boolean[] visible) {
        this.visibilityEntities = entities;
        this.visible = visible;
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case GUI_SCROLL_POSITION_CMD: {
                this.windowScroll.setScrollY(((Float)data[0]).floatValue());
                break;
            }
            case GUI_FOLD_CMD: {
                boolean collapse;
                if (data.length >= 1) {
                    collapse = (Boolean)data[0];
                } else {
                    boolean bl = collapse = !this.isCollapsed();
                }
                if (collapse) {
                    this.collapse();
                    break;
                }
                this.expand();
                break;
            }
            case GUI_MOVE_CMD: {
                float x = ((Float)data[0]).floatValue();
                float y = ((Float)data[1]).floatValue();
                float width = Gdx.graphics.getWidth();
                float height = Gdx.graphics.getHeight();
                float windowWidth = this.getWidth();
                float windowHeight = this.getHeight();
                x = MathUtilsDouble.clamp(x * width, 0.0f, width - windowWidth);
                y = MathUtilsDouble.clamp(y * height - windowHeight, 0.0f, height - windowHeight);
                this.setPosition(Math.round(x), FastMath.round((float)y));
                break;
            }
            case RECALCULATE_CONTROLS_WINDOW_SIZE: {
                this.recalculateSize();
                break;
            }
            case EXPAND_COLLAPSE_PANE_CMD: {
                String name = (String)data[0];
                if (!this.panes.containsKey(name)) break;
                boolean expand = (Boolean)data[1];
                CollapsiblePane pane = this.panes.get(name);
                if (expand) {
                    pane.expandPane();
                    break;
                }
                pane.collapsePane();
                break;
            }
            case TOGGLE_EXPANDCOLLAPSE_PANE_CMD: {
                String name = (String)data[0];
                CollapsiblePane pane = this.panes.get(name);
                pane.togglePane();
                break;
            }
            case MINIMAP_DISPLAY_CMD: {
                boolean show = (Boolean)data[0];
                if (source == this.buttonMinimap) break;
                this.buttonMinimap.setCheckedNoFire(show);
                break;
            }
            case MINIMAP_TOGGLE_CMD: {
                this.buttonMinimap.setCheckedNoFire(!this.buttonMinimap.isChecked());
                break;
            }
        }
    }

    public CollapsiblePane getCollapsiblePane(String name) {
        return this.panes.getOrDefault(name, null);
    }
}

