/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.GaiaSky;
import gaiasky.gui.api.LinkListener;
import gaiasky.gui.window.GenericDialog;
import gaiasky.gui.window.RedirectListener;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.component.Celestial;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Constants;
import gaiasky.util.GlobalResources;
import gaiasky.util.ImageUtils;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.TextUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Vector2D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.parse.Parser;
import gaiasky.util.scene2d.Link;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnTextTooltip;
import gaiasky.util.ucd.UCD;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FilenameUtils;
import uk.ac.starlink.table.ColumnInfo;

public class DataInfoWindow
extends GenericDialog {
    private static final Logger.Log logger = Logger.getLogger(DataInfoWindow.class);
    private static final String URL_WIKIPEDIA = "https://$LANG.wikipedia.org/wiki/";
    private static final String URL_WIKI_API_SUMMARY = "https://$LANG.wikipedia.org/api/rest_v1/page/summary/";
    private static final String URL_WIKI_REDIRECT = "https://en.wikipedia.org/w/api.php?action=query&titles=$NAME&redirects&format=json";
    private static final String URL_WIKI_LANGLINKS = "https://en.wikipedia.org/w/api.php?action=query&prop=langlinks&titles=$NAME&lllimit=500&format=json";
    private static final String USER_AGENT = "GaiaSky/" + Settings.settings.version.version + " (https://gaiasky.space)";
    private static final int REQUEST_TIMEOUT_MS = 15000;
    private static final int REQUEST_WAIT_MS = 1000;
    private final String[] prefixes = new String[]{"NGC", "IC"};
    private final String[] suffixes = new String[]{"_(planet)", "_(moon)", "_(star)", "_(asteroid)", "_(dwarf_planet)", "_(spacecraft)", "_(star_cluster)", ""};
    private final String[] suffixes_model = new String[]{"_(planet)", "_(moon)", "_(asteroid)", "_(dwarf_planet)", "_(spacecraft)", "_(galaxy)", "_Galaxy", "_Dwarf", ""};
    private final String[] suffixes_gal = new String[]{"_(dwarf_galaxy)", "_(galaxy)", "_Galaxy", "_Dwarf", "_Cluster", ""};
    private final String[] suffixes_cluster = new String[]{"_(planet)", "_(moon)", "_(asteroid)", "_(dwarf_planet)", "_(spacecraft)", ""};
    private final String[] suffixes_star = new String[]{"_(star)", ""};
    private final boolean useLanglinks = true;
    private Table mainTable;
    private Table wikiTable;
    private Table dataTable;
    private OwnScrollPane scroll;
    private final JsonReader reader;
    private Cell<?> linkCell;
    private final float pad;
    private final DecimalFormat nf;
    private final Vector3D pos;
    private final Vector3Q posQ;
    private final float padBottom = 10.0f;
    final String colNameStyle = "header-blue";
    final String contentStyle = "big";
    List<TrackedRequest> inFlightRequests = Collections.synchronizedList(new ArrayList());
    private long lastTrackedRequest = -1L;

    static String getWikipediaBaseURL(String languageCode) {
        return URL_WIKIPEDIA.replace("$LANG", languageCode);
    }

    static String getWikipediaAPISummaryURL(String languageCode) {
        return URL_WIKI_API_SUMMARY.replace("$LANG", languageCode);
    }

    static String getWikipediaLanglinksURL(String name) {
        return URL_WIKI_LANGLINKS.replace("$NAME", name);
    }

    static String getWikipediaRedirectURL(String name) {
        return URL_WIKI_REDIRECT.replace("$NAME", name);
    }

    static String encodeWikipediaTitle(String title) {
        return title.replace(" ", "_");
    }

    private void sendTrackedRequest(String url, String tag, final Net.HttpResponseListener listener) {
        Net.HttpRequest request = new Net.HttpRequest("GET");
        request.setUrl(url);
        request.setTimeOut(15000);
        request.setHeader("User-Agent", USER_AGENT);
        final TrackedRequest tracked = new TrackedRequest();
        tracked.request = request;
        tracked.tag = tag;
        tracked.incomeTime = System.currentTimeMillis();
        this.inFlightRequests.add(tracked);
        long now = System.currentTimeMillis();
        if (now - this.lastTrackedRequest < 1000L) {
            try {
                Thread.sleep(now - this.lastTrackedRequest);
            }
            catch (InterruptedException e) {
                logger.error("Error waiting to do next HTTP request", e);
            }
        }
        if (!tracked.isCancelled) {
            this.lastTrackedRequest = tracked.startTime = System.currentTimeMillis();
            Gdx.net.sendHttpRequest(request, new Net.HttpResponseListener(){
                final /* synthetic */ DataInfoWindow this$0;
                {
                    this.this$0 = this$0;
                }

                public void handleHttpResponse(Net.HttpResponse httpResponse) {
                    listener.handleHttpResponse(httpResponse);
                    this.this$0.inFlightRequests.remove(tracked);
                    tracked.isCompleted = true;
                }

                public void failed(Throwable t) {
                    listener.failed(t);
                    this.this$0.inFlightRequests.remove(tracked);
                    tracked.isCompleted = true;
                }

                public void cancelled() {
                    listener.cancelled();
                    this.this$0.inFlightRequests.remove(tracked);
                    tracked.isCancelled = true;
                }
            });
        }
    }

    private void cancelCurrentRequests() {
        for (TrackedRequest req : this.inFlightRequests) {
            if (req.isCancelled && req.isCompleted) continue;
            if (req.startTime <= 0L) {
                req.isCancelled = true;
                continue;
            }
            Gdx.net.cancelHttpRequest(req.request);
        }
    }

    public DataInfoWindow(Stage stg, Skin skin) {
        super(I18n.msg("gui.wiki.title", "?"), skin, stg);
        this.reader = new JsonReader();
        this.pad = 8.0f;
        this.nf = new DecimalFormat("##0.##");
        this.pos = new Vector3D();
        this.posQ = new Vector3Q();
        this.setCancelText(I18n.msg("gui.close"));
        this.setModal(false);
        this.buildSuper();
    }

    public void update(FocusView object) {
        this.cancelCurrentRequests();
        String name = object.getLocalizedName();
        this.getTitleLabel().setText((CharSequence)I18n.msg("gui.wiki.title", name));
        this.updateWikiInfo(object);
        this.updateLocalData(object);
        this.recalculateWindowSize();
    }

    public void updateWikiInfo(FocusView object) {
        this.wikiTable.clear();
        this.linkCell.clearActor();
        this.fillWikipediaTable(object, new LinkListener(){

            @Override
            public void ok(String link, String languageCode) {
                if (link == null || languageCode == null) {
                    return;
                }
                try {
                    String urlWiki = DataInfoWindow.getWikipediaBaseURL(languageCode);
                    String actualWikiName = link.substring(urlWiki.length());
                    DataInfoWindow.this.wikiTable.clear();
                    DataInfoWindow.this.linkCell.clearActor();
                    if (!actualWikiName.isEmpty()) {
                        DataInfoWindow.this.fetchWikipediaData(actualWikiName, languageCode, new WikiDataListener(actualWikiName));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void ko(String link) {
            }
        });
    }

    public void updateLocalData(FocusView object) {
        this.dataTable.clear();
        if (object != null && object.isValid()) {
            this.fetchData(object);
        }
    }

    @Override
    protected void build() {
        this.mainTable = new Table(this.skin);
        this.mainTable.pad(this.pad);
        this.wikiTable = new Table(this.skin);
        this.dataTable = new Table(this.skin);
        this.mainTable.add((Actor)this.wikiTable).expandX().left().row();
        this.linkCell = this.mainTable.add().expandX().padBottom(pad34);
        this.mainTable.row();
        this.mainTable.add((Actor)this.dataTable).expandX().left();
        this.mainTable.align(10);
        this.scroll = new OwnScrollPane((Actor)this.mainTable, this.skin, "minimalist-nobg");
        this.scroll.setFadeScrollBars(false);
        this.scroll.setScrollingDisabled(true, false);
        this.scroll.setOverscroll(false, false);
        this.scroll.setSmoothScrolling(true);
        this.content.add((Actor)this.scroll).left().expandX().expandY().row();
        this.getTitleTable().align(8);
        this.pack();
    }

    @Override
    protected boolean accept() {
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }

    private void fillWikipediaTable(IFocus focus, LinkListener listener) {
        try {
            String url = DataInfoWindow.getWikipediaBaseURL("en");
            Object wikiName = focus.getName().replace(' ', '_');
            FocusView view = (FocusView)focus;
            if (Mapper.hip.has(view.getEntity())) {
                this.urlCheckRedirectLocalization(url, (String)wikiName, this.suffixes_star, listener);
            } else if (view.isParticle()) {
                this.urlCheckRedirectLocalization(url, (String)wikiName, this.suffixes_gal, listener);
            } else if (Mapper.tagBillboardGalaxy.has(view.getEntity())) {
                this.urlCheckRedirectLocalization(url, (String)wikiName, this.suffixes_gal, listener);
            } else if (Mapper.celestial.has(view.getEntity())) {
                Celestial celestial = (Celestial)Mapper.celestial.get(view.getEntity());
                if (celestial.wikiName != null) {
                    this.urlCheckRedirectLocalization(url, celestial.wikiName.replace(' ', '_'), new String[]{""}, listener);
                } else {
                    this.urlCheckRedirectLocalization(url, (String)wikiName, this.suffixes_model, listener);
                }
            } else if (view.isCluster()) {
                this.urlCheckRedirectLocalization(url, (String)wikiName, this.suffixes_cluster, listener);
            } else if (Mapper.starSet.has(view.getEntity())) {
                this.urlCheckRedirectLocalization(url, (String)wikiName, this.suffixes_star, listener);
            } else if (((String)wikiName).startsWith("NGC") || ((String)wikiName).startsWith("ngc")) {
                char third = ((String)wikiName).charAt(3);
                if (third != '_') {
                    String numStr = ((String)wikiName).substring(3);
                    try {
                        int num = Parser.parseIntException(numStr);
                        wikiName = "NGC_" + num;
                        this.urlCheckRedirectLocalization(url, (String)wikiName, this.suffixes, listener);
                    }
                    catch (Exception e) {
                        this.urlCheckRedirectLocalization(url, (String)wikiName, this.suffixes, listener);
                    }
                } else {
                    this.urlCheckRedirectLocalization(url, (String)wikiName, this.suffixes, listener);
                }
            } else {
                boolean hit = false;
                for (String prefix : this.prefixes) {
                    int locNum;
                    char location;
                    if (!((String)wikiName).startsWith(prefix) && !((String)wikiName).startsWith(prefix.toLowerCase(Locale.ROOT)) && !((String)wikiName).startsWith(prefix.toUpperCase(Locale.ROOT)) || (location = ((String)wikiName).charAt(locNum = prefix.length())) == '_') continue;
                    String numStr = ((String)wikiName).substring(locNum);
                    try {
                        int num = Parser.parseIntException(numStr);
                        wikiName = prefix.toUpperCase() + "_" + num;
                        this.urlCheckRedirectLocalization(url, (String)wikiName, this.suffixes, listener);
                        hit = true;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!hit) {
                    this.urlCheckRedirectLocalization(url, (String)wikiName, this.suffixes, listener);
                }
            }
        }
        catch (Exception e) {
            logger.error(e);
            listener.ok(null, null);
        }
    }

    private void urlCheckRedirectLocalization(String base, String name, String[] suffixes, LinkListener listener) {
        AtomicInteger index = new AtomicInteger(0);
        this.urlCheckRedirectLocalization(base, name, suffixes, index, listener);
    }

    private void urlCheckRedirectLocalization(final String base, final String name, final String[] suffixes, final AtomicInteger index, final LinkListener listener) {
        if (index.get() < suffixes.length) {
            String fullName = name + suffixes[index.get()];
            String url = base + DataInfoWindow.encodeWikipediaTitle(fullName);
            this.sendTrackedRequest(url, "base", new Net.HttpResponseListener(){
                final /* synthetic */ DataInfoWindow this$0;
                {
                    this.this$0 = this$0;
                }

                public void handleHttpResponse(Net.HttpResponse httpResponse) {
                    if (httpResponse.getStatus().getStatusCode() == 200) {
                        String languageCode = I18n.locale.getLanguage();
                        if (languageCode.equals("en")) {
                            this.this$0.redirectStep(name, goodName -> listener.ok(base + goodName, languageCode));
                        } else {
                            this.this$0.redirectStep(name, goodName -> {
                                String urlEnglish = base + goodName;
                                String langlinksUrl = DataInfoWindow.getWikipediaLanglinksURL(goodName);
                                this.this$0.langlinksStep(langlinksUrl, urlEnglish, listener);
                            });
                        }
                    } else {
                        index.incrementAndGet();
                        this.this$0.urlCheckRedirectLocalization(base, name, suffixes, index, listener);
                    }
                }

                public void failed(Throwable t) {
                    index.incrementAndGet();
                    this.this$0.urlCheckRedirectLocalization(base, name, suffixes, index, listener);
                }

                public void cancelled() {
                    index.incrementAndGet();
                    this.this$0.urlCheckRedirectLocalization(base, name, suffixes, index, listener);
                }
            });
        } else {
            listener.ok(null, null);
        }
    }

    private void redirectStep(final String name, final RedirectListener listener) {
        String url = DataInfoWindow.getWikipediaRedirectURL(name);
        this.sendTrackedRequest(url, "redirect", new Net.HttpResponseListener(){

            public void handleHttpResponse(Net.HttpResponse httpResponse) {
                if (httpResponse.getStatus().getStatusCode() == 200) {
                    JsonReader parser = new JsonReader();
                    String jsonString = httpResponse.getResultAsString();
                    JsonValue json = parser.parse(jsonString);
                    JsonValue redirects = json.get("query").get("redirects");
                    if (redirects == null) {
                        listener.ok(name);
                    } else {
                        String newName = redirects.getString("to");
                        if (newName != null && !newName.isEmpty()) {
                            listener.ok(DataInfoWindow.encodeWikipediaTitle(newName));
                        } else {
                            logger.warn("We found a redirect, but could not get target: " + redirects.toString());
                            logger.warn("We proceed with the default name: " + name);
                            listener.ok(name);
                        }
                    }
                } else {
                    logger.warn("Redirect step returned HTTP error code: " + httpResponse.getStatus().getStatusCode());
                    logger.warn("We proceed with the default name without resolving redirects: " + name);
                    listener.ok(name);
                }
            }

            public void failed(Throwable t) {
                logger.warn("Redirect step failed.");
                logger.warn("We proceed with the default name without resolving redirects: " + name);
                listener.ok(name);
            }

            public void cancelled() {
                logger.warn("Redirect step cancelled.");
            }
        });
    }

    private void langlinksStep(String langlinksUrl, final String urlEnglish, final LinkListener listener) {
        this.sendTrackedRequest(langlinksUrl, "langlinks", new Net.HttpResponseListener(){

            public void handleHttpResponse(Net.HttpResponse httpResponse) {
                if (httpResponse.getStatus().getStatusCode() == 200) {
                    String lang = I18n.locale.getLanguage();
                    String jsonString = httpResponse.getResultAsString();
                    JsonReader reader = new JsonReader();
                    JsonValue root = reader.parse(jsonString);
                    JsonValue langlinks = root.get("query").get("pages").get(0).get("langlinks");
                    for (JsonValue current = langlinks.child; current != null; current = current.next()) {
                        String l = current.getString("lang");
                        if (l == null || !l.equals(lang)) continue;
                        String name = current.getString("*");
                        if (name != null && !name.isEmpty()) {
                            String link = DataInfoWindow.getWikipediaBaseURL(l) + DataInfoWindow.encodeWikipediaTitle(name);
                            listener.ok(link, l);
                            return;
                        }
                        listener.ok(urlEnglish, "en");
                    }
                } else {
                    logger.warn("Langlinks step returned HTTP error code: " + httpResponse.getStatus().getStatusCode());
                    logger.warn("We proceed with the English version.");
                    listener.ok(urlEnglish, "en");
                }
            }

            public void failed(Throwable t) {
                logger.warn("Langlinks step failed.");
                logger.warn("We proceed with the English version.");
                listener.ok(urlEnglish, "en");
            }

            public void cancelled() {
                logger.warn("Langlinks step cancelled.");
            }
        });
    }

    private void fetchData(FocusView object) {
        OwnLabel title = new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.data.local"), this.skin, "header");
        this.dataTable.add((Actor)title).colspan(2).left().padBottom(pad34).row();
        this.addNames(object);
        this.addType(object);
        this.addId(object);
        this.addCoordinates(object);
        this.addProperMotions(object);
        if (object.isSet()) {
            ParticleSet set = object.getSet();
            IParticleRecord bean = set.get(set.focusIndex);
            this.addExtraSet(set, bean);
        } else if (object.isCluster()) {
            this.addRadius(object);
        } else {
            this.addRadius(object);
        }
        this.addExtra(object);
    }

    private void addType(FocusView object) {
        OwnLabel objectType = new OwnLabel((CharSequence)"", this.skin, "object-name-large");
        try {
            objectType.setText(TextUtils.capitalise(I18n.msg("element." + ComponentTypes.ComponentType.values()[object.getCt().getFirstOrdinal()].toString().toLowerCase(Locale.ROOT) + ".singular")));
        }
        catch (Exception e) {
            objectType.setText("");
        }
        this.dataTable.add((Actor)this.getLabel(I18n.msg("gui.focusinfo.type"))).left().padRight(pad20).padBottom(10.0f);
        this.dataTable.add((Actor)objectType).left().padBottom(10.0f).row();
    }

    private void addId(FocusView object) {
        boolean cappedId = false;
        Object id = null;
        id = object.getExtra() != null || object.getStarSet() != null ? (object.getId() > 0L ? String.valueOf(object.getId()) : (object.getHip() > 0 ? "HIP " + object.getHip() : String.valueOf(object.getCandidateId()))) : I18n.msg("gui.focusinfo.na");
        String idString = id;
        if (((String)id).length() > 35) {
            idString = TextUtils.capString((String)id, 35);
            cappedId = true;
        }
        OwnLabel focusId = new OwnLabel((CharSequence)idString, this.skin, "big");
        OwnLabel focusIdExpand = new OwnLabel((CharSequence)"(?)", this.skin, "question");
        if (cappedId) {
            focusId.addListener((EventListener)new OwnTextTooltip((String)id, this.skin));
            focusIdExpand.addListener((EventListener)new OwnTextTooltip((String)id, this.skin));
            focusIdExpand.setVisible(true);
        } else {
            focusIdExpand.clearListeners();
            focusIdExpand.setVisible(false);
        }
        this.dataTable.add((Actor)this.getLabel(I18n.msg("gui.focusinfo.id"))).left().padRight(pad20).padBottom(10.0f);
        this.dataTable.add((Actor)this.hg(new Actor[]{focusId, focusIdExpand})).left().padBottom(10.0f).row();
    }

    private void addNames(FocusView object) {
        Table focusNames = new Table(this.skin);
        String localizedName = object.getLocalizedName();
        String[] names = object.getNames();
        if (!TextUtils.contains(names, localizedName, true)) {
            names = TextUtils.addToBeginningOfArray(names, localizedName);
        }
        if (names != null && names.length > 0) {
            int chars = 0;
            HorizontalGroup currGroup = new HorizontalGroup();
            currGroup.space(2.0f);
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                String nameCapped = TextUtils.capString(name, 35);
                OwnLabel nl = new OwnLabel((CharSequence)nameCapped, this.skin, "object-name-large");
                if (nameCapped.length() != name.length()) {
                    nl.addListener((EventListener)new OwnTextTooltip(name, this.skin));
                }
                currGroup.addActor((Actor)nl);
                chars += nameCapped.length() + 1;
                if (i < names.length - 1) {
                    currGroup.addActor((Actor)new OwnLabel((CharSequence)", ", this.skin));
                    ++chars;
                }
                if (i >= names.length - 1 || chars <= 35) continue;
                focusNames.add((Actor)currGroup).left().row();
                currGroup = new HorizontalGroup();
                chars = 0;
            }
            if (chars > 0) {
                focusNames.add((Actor)currGroup).left();
            }
        } else {
            focusNames.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.na"), this.skin));
        }
        this.dataTable.add((Actor)this.getLabel(I18n.msg("gui.focusinfo.names"))).left().padRight(pad20).padBottom(10.0f);
        this.dataTable.add((Actor)focusNames).left().padBottom(10.0f).row();
    }

    private void addCoordinates(FocusView object) {
        String deg = I18n.msg("gui.unit.deg");
        OwnLabel focusRA = new OwnLabel((CharSequence)"", this.skin, "big");
        OwnLabel focusDEC = new OwnLabel((CharSequence)"", this.skin, "big");
        Vector2D posSph = object.getPosSph();
        if (posSph != null && posSph.len() > 0.0) {
            focusRA.setText(this.nf.format(posSph.x) + deg);
            focusDEC.setText(this.nf.format(posSph.y) + deg);
        } else {
            Coordinates.cartesianToSpherical(object.getAbsolutePosition(this.posQ), this.pos);
            focusRA.setText(this.nf.format(57.29577951308232 * this.pos.x % 360.0) + deg);
            focusDEC.setText(this.nf.format(57.29577951308232 * this.pos.y % 360.0) + deg);
        }
        this.dataTable.add((Actor)this.getLabel(I18n.msg("gui.focusinfo.alpha"))).padBottom(10.0f).left();
        this.dataTable.add((Actor)focusRA).left().padBottom(10.0f).row();
        this.dataTable.add((Actor)this.getLabel(I18n.msg("gui.focusinfo.delta"))).padBottom(10.0f).left();
        this.dataTable.add((Actor)focusDEC).left().padBottom(10.0f).row();
    }

    private void addProperMotions(FocusView object) {
        OwnLabel focusMuAlpha = new OwnLabel((CharSequence)(this.nf.format(object.getMuAlpha()) + " " + I18n.msg("gui.unit.masyr")), this.skin, "big");
        OwnLabel focusMuDelta = new OwnLabel((CharSequence)(this.nf.format(object.getMuDelta()) + " " + I18n.msg("gui.unit.masyr")), this.skin, "big");
        OwnLabel focusRadVel = new OwnLabel((CharSequence)"", this.skin, "big");
        double rv = object.getRadialVelocity();
        if (Double.isFinite(rv)) {
            focusRadVel.setText(this.nf.format(object.getRadialVelocity()) + " " + I18n.msg("gui.unit.kms"));
        } else {
            focusRadVel.setText(I18n.msg("gui.focusinfo.na"));
        }
        this.dataTable.add((Actor)this.getLabel(I18n.msg("gui.focusinfo.mualpha"))).left().padBottom(10.0f);
        this.dataTable.add((Actor)focusMuAlpha).left().padBottom(10.0f).row();
        this.dataTable.add((Actor)this.getLabel(I18n.msg("gui.focusinfo.mudelta"))).padBottom(10.0f).left();
        this.dataTable.add((Actor)focusMuDelta).left().padBottom(10.0f).row();
        this.dataTable.add((Actor)this.getLabel(I18n.msg("gui.focusinfo.radvel"))).padBottom(10.0f).left();
        this.dataTable.add((Actor)focusRadVel).left().padBottom(10.0f).row();
    }

    private void addRadius(FocusView object) {
        OwnLabel focusRadius = new OwnLabel((CharSequence)"", this.skin, "big");
        focusRadius.setText(GlobalResources.formatNumber(object.getRadius() * Constants.U_TO_KM) + " " + I18n.msg("gui.unit.km"));
        this.dataTable.add((Actor)this.getLabel(I18n.msg("gui.focusinfo.radius"))).left().padRight(pad20).padBottom(10.0f);
        this.dataTable.add((Actor)focusRadius).left().padBottom(10.0f).row();
    }

    private void addExtraSet(ParticleSet set, IParticleRecord bean) {
        if (!bean.hasExtra()) {
            return;
        }
        List<ColumnInfo> columnInfoList = set.columnInfoList;
        ObjectMap<UCD, Object> map = bean.getExtra();
        ObjectMap.Keys keys = map.keys();
        Array arr = new Array();
        for (UCD ucd : keys) {
            arr.add((Object)ucd);
        }
        arr.sort();
        for (UCD ucd : arr) {
            Object value = map.get((Object)ucd);
            HorizontalGroup columnGroup = new HorizontalGroup();
            columnGroup.space(7.0f);
            OwnLabel columnLabel = new OwnLabel((CharSequence)TextUtils.capitalise(ucd.colName), this.skin, "header-blue");
            OwnLabel valueLabel = new OwnLabel((CharSequence)(value != null ? value.toString() : I18n.msg("gui.focusinfo.na")), this.skin, "big");
            ColumnInfo colInfo = null;
            if (columnInfoList != null) {
                for (ColumnInfo ci : columnInfoList) {
                    if (!ci.getName().equalsIgnoreCase(ucd.colName)) continue;
                    colInfo = ci;
                    break;
                }
            }
            columnGroup.addActor((Actor)columnLabel);
            if (colInfo != null) {
                if (colInfo.getDescription() != null) {
                    OwnLabel desc = new OwnLabel((CharSequence)"[d]", this.skin, "default-pink");
                    desc.addListener((EventListener)new OwnTextTooltip(colInfo.getDescription(), this.skin, 20));
                    columnGroup.addActor((Actor)desc);
                }
                if (colInfo.getUnitString() != null) {
                    OwnLabel units = new OwnLabel((CharSequence)"[u]", this.skin, "default-pink");
                    units.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.unit", colInfo.getUnitString()), this.skin, 20));
                    columnGroup.addActor((Actor)units);
                }
            }
            this.dataTable.add((Actor)columnGroup).left().padRight(pad20).padBottom(10.0f);
            this.dataTable.add((Actor)valueLabel).left().padBottom(10.0f).row();
        }
    }

    private void addExtra(FocusView object) {
        if (object.getBase() != null && object.getBase().hasExtraAttributes()) {
            ObjectMap<String, Object> map = object.getBase().getExtraAttributes();
            for (ObjectMap.Entry entry : map.entries()) {
                this.dataTable.add((Actor)this.getLabel(TextUtils.capitalise((String)entry.key))).padBottom(10.0f).left();
                this.dataTable.add((CharSequence)entry.value.toString()).left().padBottom(10.0f).row();
            }
        }
    }

    private OwnLabel getLabel(String text) {
        OwnLabel label = new OwnLabel((CharSequence)text, this.skin, "header-blue");
        label.setWidth(Math.max(label.getWidth(), 350.0f));
        return label;
    }

    private void fetchWikipediaData(String wikiName, String languageCode, WikiDataListener listener) {
        this.getJSONData(DataInfoWindow.getWikipediaAPISummaryURL(languageCode) + DataInfoWindow.encodeWikipediaTitle(wikiName), listener);
    }

    private void getJSONData(String url, final WikiDataListener listener) {
        if (Settings.settings.program.offlineMode) {
            listener.ko(I18n.msg("gui.system.offlinemode.tooltip"));
        } else {
            this.sendTrackedRequest(url, "json", new Net.HttpResponseListener(){
                final /* synthetic */ DataInfoWindow this$0;
                {
                    this.this$0 = this$0;
                }

                public void handleHttpResponse(Net.HttpResponse httpResponse) {
                    if (httpResponse.getStatus().getStatusCode() == 200) {
                        JsonValue root = this.this$0.reader.parse(httpResponse.getResultAsString());
                        listener.ok(root);
                    } else {
                        String err = I18n.msg("gui.download.error.httpstatus", httpResponse.getStatus().getStatusCode());
                        listener.ko(err);
                    }
                }

                public void failed(Throwable t) {
                    listener.ko();
                }

                public void cancelled() {
                    listener.ko();
                }
            });
        }
    }

    private void recalculateWindowSize() {
        this.mainTable.pack();
        this.scroll.setWidth(MathUtilsDouble.clamp(this.mainTable.getWidth() + this.scroll.getStyle().vScroll.getMinWidth(), 1200.0f, 3000.0f));
        this.scroll.setHeight(Math.min(this.mainTable.getHeight(), (float)Gdx.graphics.getHeight() * 0.7f) + this.pad);
        this.scroll.setPosition(0.0f, 0.0f);
        this.pack();
    }

    private static class TrackedRequest {
        Net.HttpRequest request;
        String tag;
        long incomeTime = -1L;
        long startTime = -1L;
        boolean isCompleted = false;
        boolean isCancelled = false;

        private TrackedRequest() {
        }
    }

    private class WikiDataListener {
        private final String wikiName;
        private Cell<?> imgCell;
        private Texture currentImageTexture;

        public WikiDataListener(String wikiName) {
            this.wikiName = wikiName;
        }

        private void buildImage(Path imageFile) {
            GaiaSky.postRunnable(() -> {
                try {
                    if (this.currentImageTexture != null) {
                        this.currentImageTexture.dispose();
                    }
                    this.currentImageTexture = new Texture(imageFile.toString());
                    Image thumbnailImage = new Image(this.currentImageTexture);
                    if (this.imgCell != null) {
                        this.imgCell.setActor((Actor)thumbnailImage);
                        DataInfoWindow.this.recalculateWindowSize();
                    }
                }
                catch (Exception e) {
                    logger.error(e);
                }
            });
        }

        public void ok(JsonValue root) {
            JsonValue thumb;
            if (!root.has("displaytitle")) {
                this.ko(I18n.msg("gui.wiki.attributemissing", "displaytitle"));
                return;
            }
            String title = TextUtils.html2text(root.getString("displaytitle"));
            DataInfoWindow.this.getTitleLabel().setText((CharSequence)I18n.msg("gui.wiki.title", title));
            if (root.has("thumbnail") && (thumb = root.get("thumbnail")).has("source")) {
                final String thumbUrl = thumb.getString("source");
                try {
                    URL turl = new URI(thumbUrl).toURL();
                    String filename = FilenameUtils.getName((String)turl.getPath());
                    Path cacheDir = SysUtils.getCacheDir();
                    final Path imageFile = cacheDir.resolve(filename);
                    if (!(Files.exists(imageFile, new LinkOption[0]) && Files.isRegularFile(imageFile, new LinkOption[0]) && Files.isReadable(imageFile))) {
                        logger.info(I18n.msg("gui.download.starting", thumbUrl));
                        DataInfoWindow.this.sendTrackedRequest(thumbUrl, "thumbnail", new Net.HttpResponseListener(){
                            final /* synthetic */ WikiDataListener this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void handleHttpResponse(Net.HttpResponse httpResponse) {
                                if (httpResponse.getStatus().getStatusCode() == 200) {
                                    InputStream is = httpResponse.getResultAsStream();
                                    try (FileOutputStream outputStream = new FileOutputStream(imageFile.toString());){
                                        int read;
                                        byte[] bytes = new byte[1024];
                                        while ((read = is.read(bytes)) != -1) {
                                            outputStream.write(bytes, 0, read);
                                        }
                                    }
                                    catch (IOException e) {
                                        logger.error(e);
                                    }
                                    try {
                                        if (ImageUtils.monochromeToRGB(imageFile.toFile())) {
                                            logger.info(I18n.msg("gui.wiki.imageconverted", imageFile.toString()));
                                        }
                                        this.this$1.buildImage(imageFile);
                                    }
                                    catch (Exception e) {
                                        logger.error(I18n.msg("error.wiki.rgbconversion", imageFile.toString()));
                                    }
                                } else {
                                    logger.error(I18n.msg("error.wiki.thumbnail", thumbUrl));
                                }
                            }

                            public void failed(Throwable t) {
                                logger.error(I18n.msg("error.wiki.thumbnail", thumbUrl));
                            }

                            public void cancelled() {
                                logger.error(I18n.msg("error.wiki.thumbnail", thumbUrl));
                            }
                        });
                    } else {
                        this.buildImage(imageFile);
                    }
                }
                catch (MalformedURLException | URISyntaxException e) {
                    logger.error("Error parsing thumbnail URL!");
                    logger.error(e);
                    return;
                }
            }
            OwnLabel titleLabel = new OwnLabel((CharSequence)title, DataInfoWindow.this.skin, "header-large");
            if (!root.has("extract")) {
                this.ko(I18n.msg("gui.wiki.attributemissing", "extract"));
                return;
            }
            String text = TextUtils.html2text(root.getString("extract"));
            OwnLabel textLabel = new OwnLabel((CharSequence)text, DataInfoWindow.this.skin, "big", 60);
            Link wikiLink = null;
            if (root.has("content_urls")) {
                String link = root.get("content_urls").get("desktop").getString("page");
                wikiLink = new Link((CharSequence)TextUtils.capString(link, 50), DataInfoWindow.this.skin, link);
            }
            if (DataInfoWindow.this.linkCell != null && wikiLink != null) {
                DataInfoWindow.this.linkCell.clearActor();
                DataInfoWindow.this.linkCell.setActor(wikiLink).padTop(DataInfoWindow.this.pad * 5.0f);
            }
            DataInfoWindow.this.wikiTable.add((Actor)titleLabel).left().colspan(2).padTop(DataInfoWindow.this.pad * 3.0f).padBottom(DataInfoWindow.this.pad * 3.0f).row();
            this.imgCell = DataInfoWindow.this.wikiTable.add().left().padBottom(DataInfoWindow.this.pad * 5.0f);
            DataInfoWindow.this.wikiTable.add((Actor)textLabel).left().padBottom(DataInfoWindow.this.pad * 5.0f).padLeft(DataInfoWindow.this.pad * 3.0f).row();
            DataInfoWindow.this.wikiTable.pack();
            DataInfoWindow.this.recalculateWindowSize();
        }

        public void ko() {
            GaiaSky.postRunnable(() -> {
                String msg = I18n.msg("error.wiki.data", this.wikiName);
                DataInfoWindow.this.wikiTable.add((Actor)new OwnLabel((CharSequence)msg, DataInfoWindow.this.skin, "big"));
                DataInfoWindow.this.wikiTable.pack();
                if (DataInfoWindow.this.linkCell != null) {
                    DataInfoWindow.this.linkCell.clearActor();
                }
                DataInfoWindow.this.recalculateWindowSize();
            });
        }

        public void ko(String error) {
            GaiaSky.postRunnable(() -> {
                DataInfoWindow.this.wikiTable.add((Actor)new OwnLabel((CharSequence)error, DataInfoWindow.this.skin, "big"));
                DataInfoWindow.this.wikiTable.pack();
                DataInfoWindow.this.recalculateWindowSize();
            });
        }
    }
}

