/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.gui.window.GenericDialog;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnTextButton;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.validator.DoubleValidator;
import gaiasky.util.validator.IntValidator;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.format.TextStyle;
import java.util.concurrent.atomic.AtomicBoolean;

public class DateDialog
extends GenericDialog {
    private static final Logger.Log logger = Logger.getLogger(DateDialog.class);
    private OwnTextField day;
    private OwnTextField year;
    private OwnTextField hour;
    private OwnTextField min;
    private OwnTextField sec;
    private OwnTextField jd;
    private OwnLabel jdLabel;
    private OwnLabel dateTimeLabel;
    private SelectBox<String> month;
    private final ZoneId timeZone;
    private final AtomicBoolean initialized;
    private Instant current;
    private final DateTimeFormatter dfDate;
    private final DateTimeFormatter dfEra;
    private final DateTimeFormatter dfTime;
    private DateDialogTab tab = DateDialogTab.TIME;

    public DateDialog(Stage stage, Skin skin) {
        super(I18n.msg("gui.pickdate"), skin, stage);
        this.timeZone = Settings.settings.program.timeZone.getTimeZone();
        this.initialized = new AtomicBoolean(false);
        this.current = Instant.now();
        this.dfDate = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(I18n.locale).withZone(this.timeZone);
        this.dfEra = DateTimeFormatter.ofPattern("G").withLocale(I18n.locale).withZone(this.timeZone);
        this.dfTime = DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).withLocale(I18n.locale).withZone(this.timeZone);
        this.setAcceptText(I18n.msg("gui.ok"));
        this.setCancelText(I18n.msg("gui.cancel"));
        this.buildSuper();
    }

    @Override
    protected void build() {
        HorizontalGroup tabGroup = new HorizontalGroup();
        tabGroup.align(1);
        float tabWidth = 300.0f;
        final OwnTextButton tabUTC = new OwnTextButton(I18n.msg("gui.time.time.zone", this.timeZone.getDisplayName(TextStyle.SHORT, I18n.locale)), this.skin, "toggle-big");
        tabUTC.pad(pad10);
        tabUTC.setWidth(tabWidth);
        final OwnTextButton tabJD = new OwnTextButton(I18n.msg("gui.time.julian"), this.skin, "toggle-big");
        tabJD.pad(pad10);
        tabJD.setWidth(tabWidth);
        tabGroup.addActor((Actor)tabUTC);
        tabGroup.addActor((Actor)tabJD);
        this.content.add((Actor)tabGroup).center().padBottom(pad18).expandX().row();
        final Table contentUTC = new Table(this.skin);
        contentUTC.align(2);
        contentUTC.pad(pad18);
        final Table contentJD = new Table(this.skin);
        contentJD.align(2);
        contentJD.pad(pad18);
        this.addTabContent((Group)contentUTC);
        this.addTabContent((Group)contentJD);
        this.content.add((Actor)this.tabStack).expand().fill().row();
        ChangeListener tabListener = new ChangeListener(this){
            final /* synthetic */ DateDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (tabUTC.isChecked()) {
                    this.this$0.tab = DateDialogTab.TIME;
                    if (this.this$0.initialized.get()) {
                        this.this$0.selectedTab = 0;
                    }
                    this.this$0.reloadUTC(contentUTC);
                }
                if (tabJD.isChecked()) {
                    this.this$0.tab = DateDialogTab.JD;
                    if (this.this$0.initialized.get()) {
                        this.this$0.selectedTab = 1;
                    }
                    this.this$0.reloadJD(contentJD);
                }
                contentUTC.setVisible(tabUTC.isChecked());
                contentJD.setVisible(tabJD.isChecked());
                this.this$0.updateTime(this.this$0.current, this.this$0.timeZone);
                this.this$0.content.pack();
                this.this$0.setKeyboardFocus();
            }
        };
        tabUTC.addListener((EventListener)tabListener);
        tabJD.addListener((EventListener)tabListener);
        ButtonGroup tabs = new ButtonGroup();
        tabs.setMinCheckCount(1);
        tabs.setMaxCheckCount(1);
        tabs.add((Button)tabUTC);
        tabs.add((Button)tabJD);
        this.initialized.set(true);
    }

    private void reloadUTC(Table content) {
        float inputWidth = 96.0f;
        float pad = 8.0f;
        content.clear();
        HorizontalGroup dayGroup = new HorizontalGroup();
        dayGroup.space(pad);
        IntValidator dayValidator = new IntValidator(1, 31);
        this.day = new OwnTextField("", this.skin, dayValidator);
        this.day.setMaxLength(2);
        this.day.setWidth(inputWidth);
        this.day.addListener(event -> {
            ChangeListener.ChangeEvent ce;
            if (event instanceof ChangeListener.ChangeEvent && (ce = (ChangeListener.ChangeEvent)event).getTarget() == this.day && !this.day.getText().isEmpty()) {
                return this.checkFullDate();
            }
            return false;
        });
        this.month = new SelectBox(this.skin);
        this.month.setItems((Object[])new String[]{I18n.msg("gui.date.jan"), I18n.msg("gui.date.feb"), I18n.msg("gui.date.mar"), I18n.msg("gui.date.apr"), I18n.msg("gui.date.may"), I18n.msg("gui.date.jun"), I18n.msg("gui.date.jul"), I18n.msg("gui.date.aug"), I18n.msg("gui.date.sep"), I18n.msg("gui.date.oct"), I18n.msg("gui.date.nov"), I18n.msg("gui.date.dec")});
        this.month.setWidth(inputWidth);
        IntValidator yearValidator = new IntValidator((int)((double)Settings.settings.runtime.minTimeMs * 3.168808781402895E-11), (int)((double)Settings.settings.runtime.maxTimeMs * 3.168808781402895E-11));
        this.year = new OwnTextField("", this.skin, yearValidator);
        this.year.setMaxLength(8);
        this.year.setWidth(inputWidth);
        this.year.addListener(event -> {
            ChangeListener.ChangeEvent ce;
            if (event instanceof ChangeListener.ChangeEvent && (ce = (ChangeListener.ChangeEvent)event).getTarget() == this.year && !this.year.getText().isEmpty()) {
                return this.checkFullDate();
            }
            return false;
        });
        dayGroup.addActor((Actor)this.day);
        dayGroup.addActor((Actor)new OwnLabel((CharSequence)"/", this.skin));
        dayGroup.addActor(this.month);
        dayGroup.addActor((Actor)new OwnLabel((CharSequence)"/", this.skin));
        dayGroup.addActor((Actor)this.year);
        content.add((Actor)new OwnLabel((CharSequence)(I18n.msg("gui.time.date") + " (" + I18n.msg("gui.time.date.format") + "):"), this.skin)).pad(pad, pad, 0.0f, pad * 2.0f).right();
        content.add((Actor)dayGroup).pad(pad, 0.0f, 0.0f, pad);
        content.row();
        HorizontalGroup hourGroup = new HorizontalGroup();
        hourGroup.space(pad);
        IntValidator hoursValidator = new IntValidator(0, 23);
        this.hour = new OwnTextField("", this.skin, hoursValidator);
        this.hour.setMaxLength(2);
        this.hour.setWidth(inputWidth);
        this.hour.addListener(event -> {
            ChangeListener.ChangeEvent ce;
            if (event instanceof ChangeListener.ChangeEvent && (ce = (ChangeListener.ChangeEvent)event).getTarget() == this.hour && !this.hour.getText().isEmpty()) {
                return this.checkFullDate();
            }
            return false;
        });
        IntValidator minutesValidator = new IntValidator(0, 59);
        this.min = new OwnTextField("", this.skin, minutesValidator);
        this.min.setMaxLength(2);
        this.min.setWidth(inputWidth);
        this.min.addListener(event -> {
            ChangeListener.ChangeEvent ce;
            if (event instanceof ChangeListener.ChangeEvent && (ce = (ChangeListener.ChangeEvent)event).getTarget() == this.min && !this.min.getText().isEmpty()) {
                return this.checkFullDate();
            }
            return false;
        });
        IntValidator secondsValidator = new IntValidator(0, 59);
        this.sec = new OwnTextField("", this.skin, secondsValidator);
        this.sec.setMaxLength(2);
        this.sec.setWidth(inputWidth);
        this.sec.addListener(event -> {
            ChangeListener.ChangeEvent ce;
            if (event instanceof ChangeListener.ChangeEvent && (ce = (ChangeListener.ChangeEvent)event).getTarget() == this.sec && !this.sec.getText().isEmpty()) {
                return this.checkFullDate();
            }
            return false;
        });
        hourGroup.addActor((Actor)this.hour);
        hourGroup.addActor((Actor)new OwnLabel((CharSequence)":", this.skin));
        hourGroup.addActor((Actor)this.min);
        hourGroup.addActor((Actor)new OwnLabel((CharSequence)":", this.skin));
        hourGroup.addActor((Actor)this.sec);
        content.add((Actor)new OwnLabel((CharSequence)(I18n.msg("gui.time.time") + " (" + I18n.msg("gui.time.time.format") + "):"), this.skin)).pad(pad, pad, 0.0f, pad * 2.0f).right();
        content.add((Actor)hourGroup).pad(pad, 0.0f, pad, pad).row();
        this.jdLabel = new OwnLabel((CharSequence)"", this.skin);
        content.add((Actor)new OwnLabel((CharSequence)(I18n.msg("gui.time.julian") + ":"), this.skin)).pad(pad, pad, pad18, pad * 2.0f).right();
        content.add((Actor)this.jdLabel).center().pad(pad, 0.0f, pad18, 0.0f).row();
        OwnTextButton setNow = new OwnTextButton(I18n.msg("gui.pickdate.setcurrent", this.timeZone.getDisplayName(TextStyle.SHORT, I18n.locale)), this.skin);
        setNow.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.updateTime(Instant.now(), this.timeZone);
                return true;
            }
            return false;
        });
        setNow.setSize(388.0f, 36.0f);
        setNow.pad(8.0f);
        content.add((Actor)setNow).center().colspan(2).padTop(pad * 2.0f);
    }

    private void reloadJD(Table content) {
        float inputWidth = 350.0f;
        float pad = 8.0f;
        content.clear();
        double jdMin = AstroUtils.getJulianDateUTC((int)((double)Settings.settings.runtime.minTimeMs * 3.168808781402895E-11), 1, 1, 0, 0, 0, 0);
        double jdMax = AstroUtils.getJulianDateUTC((int)((double)Settings.settings.runtime.maxTimeMs * 3.168808781402895E-11), 1, 1, 0, 0, 0, 0);
        DoubleValidator jdValidator = new DoubleValidator(jdMin, jdMax);
        this.jd = new OwnTextField("", this.skin, jdValidator);
        this.jd.setWidth(inputWidth);
        this.jd.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                ChangeListener.ChangeEvent ce = (ChangeListener.ChangeEvent)event;
                if (ce.getTarget() == this.jd && !this.jd.getText().isEmpty()) {
                    this.checkJulian();
                }
                return true;
            }
            return false;
        });
        this.dateTimeLabel = new OwnLabel((CharSequence)"", this.skin);
        content.add((Actor)new OwnLabel((CharSequence)(I18n.msg("gui.time.julian") + ":"), this.skin)).pad(pad, pad, pad, pad * 2.0f).right();
        content.add((Actor)this.jd).center().pad(pad, 0.0f, pad, 0.0f).row();
        content.add((Actor)new OwnLabel((CharSequence)(I18n.msg("gui.time.time.zone", this.timeZone.getDisplayName(TextStyle.SHORT, I18n.locale)) + ":"), this.skin)).pad(pad, pad, pad18, pad * 2.0f).right();
        content.add((Actor)this.dateTimeLabel).center().pad(pad, 0.0f, pad18, 0.0f).row();
        OwnTextButton setNow = new OwnTextButton(I18n.msg("gui.pickdate.julian.current"), this.skin);
        setNow.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.updateTime(Instant.now(), this.timeZone);
                return true;
            }
            return false;
        });
        setNow.setSize(388.0f, 32.0f);
        setNow.pad(8.0f);
        content.add((Actor)setNow).center().colspan(2).padTop(pad * 2.0f);
        content.row();
    }

    @Override
    protected boolean accept() {
        switch (this.tab.ordinal()) {
            case 0: {
                boolean cool;
                boolean bl = cool = this.year.isValid() && this.day.isValid() && this.hour.isValid() && this.min.isValid() && this.sec.isValid() && this.checkFullDate();
                if (cool) {
                    EventManager.publish(Event.TIME_CHANGE_CMD, (Object)this, this.current);
                    return true;
                }
                return false;
            }
            case 1: {
                boolean cool;
                boolean bl = cool = this.jd.isValid() && this.checkJulian();
                if (cool) {
                    EventManager.publish(Event.TIME_CHANGE_CMD, (Object)this, this.current);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    protected void cancel() {
    }

    public boolean checkFullDate() {
        try {
            LocalDateTime ldt = LocalDateTime.of(Integer.parseInt(this.year.getText()), this.month.getSelectedIndex() + 1, Integer.parseInt(this.day.getText()), Integer.parseInt(this.hour.getText()), Integer.parseInt(this.min.getText()), Integer.parseInt(this.sec.getText()));
            Instant instant = ldt.atZone(this.timeZone).toInstant();
            this.updateCurrent(instant);
            return true;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
            if (this.month.getSelectedIndex() == 1 && Integer.parseInt(this.day.getText()) == 29) {
                this.day.setColor(ColorUtils.gRedC);
            }
            return false;
        }
    }

    public boolean checkJulian() {
        try {
            double julianDate = Double.parseDouble(this.jd.getText());
            Instant instant = AstroUtils.julianDateToInstant(julianDate);
            this.updateCurrent(instant);
            return true;
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
            if (this.month.getSelectedIndex() == 1 && Integer.parseInt(this.day.getText()) == 29) {
                this.day.setColor(ColorUtils.gRedC);
            }
            return false;
        }
    }

    public void updateCurrent(Instant instant) {
        assert (instant != null);
        this.current = instant;
        if (this.jdLabel != null) {
            double jd = AstroUtils.getJulianDate(instant);
            this.jdLabel.setText(Double.toString(jd));
        }
        if (this.dateTimeLabel != null) {
            String dateText = this.dfDate.format(this.current) + " " + this.dfEra.format(this.current) + " " + this.dfTime.format(this.current) + " " + this.timeZone.getDisplayName(TextStyle.SHORT, I18n.locale);
            this.dateTimeLabel.setText(dateText);
        }
    }

    public void updateTime(Instant instant, ZoneId zid) {
        switch (this.tab.ordinal()) {
            case 0: {
                LocalDateTime date = LocalDateTime.ofInstant(instant, zid);
                int year = date.getYear();
                int month = date.getMonthValue();
                int day = date.getDayOfMonth();
                int hour = date.getHour();
                int min = date.getMinute();
                int sec = date.getSecond();
                this.day.setText(String.valueOf(day));
                this.month.setSelectedIndex(month - 1);
                this.year.setText(String.valueOf(year));
                this.hour.setText(String.valueOf(hour));
                this.min.setText(String.valueOf(min));
                this.sec.setText(String.valueOf(sec));
                break;
            }
            case 1: {
                double julian = AstroUtils.getJulianDate(instant);
                this.jd.setText(String.valueOf(julian));
            }
        }
        this.updateCurrent(instant);
    }

    @Override
    public void dispose() {
    }

    static enum DateDialogTab {
        TIME,
        JD;

    }
}

