/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import gaiasky.gui.window.GenericDialog;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.validator.LengthValidator;
import gaiasky.util.validator.RegexpValidator;

public class FileNameWindow
extends GenericDialog {
    private final String defaultName;
    private OwnTextField fileName;

    public FileNameWindow(String defaultName, Stage stage, Skin skin) {
        super(I18n.msg("gui.filename.choose"), skin, stage);
        this.setModal(true);
        this.defaultName = defaultName;
        this.setAcceptText(I18n.msg("gui.ok"));
        this.setCancelText(I18n.msg("gui.cancel"));
        this.buildSuper();
        this.pack();
    }

    @Override
    protected void build() {
        OwnLabel label = new OwnLabel((CharSequence)(I18n.msg("gui.filename.filename") + ": "), this.skin);
        LengthValidator lengthValidator = new LengthValidator(3, 40);
        RegexpValidator nameValidator = new RegexpValidator(lengthValidator, "^[^*&%\\s\\+\\=\\\\\\/@#\\$&\\*()~]+$");
        this.fileName = new OwnTextField(this.defaultName, this.skin, nameValidator);
        this.fileName.setWidth(400.0f);
        this.content.add((Actor)label).padRight(pad18).padBottom(pad18);
        this.content.add((Actor)this.fileName).padBottom(pad18);
    }

    public OwnTextField getFileNameField() {
        return this.fileName;
    }

    @Override
    protected boolean accept() {
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }
}

