/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.scenes.scene2d.utils.SpriteDrawable;
import com.badlogic.gdx.utils.TimeUtils;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.api.IGamepadMappings;
import gaiasky.gui.main.GamepadMappings;
import gaiasky.gui.window.GenericDialog;
import gaiasky.input.WindowGamepadListener;
import gaiasky.util.Logger;
import gaiasky.util.SysUtils;
import gaiasky.util.Trio;
import gaiasky.util.i18n.I18n;
import gaiasky.util.parse.Parser;
import gaiasky.util.scene2d.OwnImageButton;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnSlider;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.scene2d.OwnTextTooltip;
import gaiasky.util.validator.LengthValidator;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.jafama.FastMath;

public class GamepadConfigWindow
extends GenericDialog
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(GamepadConfigWindow.class);
    private static final int TYPE_BUTTON = 0;
    private static final int TYPE_AXIS = 1;
    private static final int TYPE_EITHER = 2;
    private final String none;
    private final String button;
    private final String axis;
    private final String controllerName;
    public Path savedFile = null;
    private Texture controller;
    private Map<GamepadInput, Trio<Texture, float[], String>> inputInfo;
    private Map<GamepadInput, OwnTextField> inputFields;
    private GamepadMappings mappings;
    private GamepadInput currGamepadInput;
    private OwnTextField currTextField;
    private OwnTextField filename;
    private OwnLabel currentInput;
    private OwnSlider lsx;
    private OwnSlider lsy;
    private OwnSlider rsx;
    private OwnSlider rsy;
    private OwnSlider lts;
    private OwnSlider rts;
    private OwnSlider axisPower;
    private Cell<Image> elementCell;

    public GamepadConfigWindow(String controllerName, GamepadMappings mappings, Stage stage, Skin skin) {
        super("Configure controller: " + controllerName, skin, stage);
        Texture rt;
        Texture lt;
        Texture rb;
        Texture lb;
        Texture y;
        Texture x;
        Texture b;
        Texture a;
        Texture startSelect;
        Texture dPadR;
        Texture dPadL;
        Texture dPadD;
        Texture dPadU;
        Texture stickV;
        Texture stickH;
        Texture stick;
        this.controllerName = controllerName;
        this.mappings = mappings;
        if (this.mappings == null) {
            this.mappings = new GamepadMappings(this.controllerName);
        }
        this.none = "-" + I18n.msg("gui.none").toLowerCase(Locale.ROOT) + "-";
        this.button = I18n.msg("gui.controller.button");
        this.axis = I18n.msg("gui.controller.axis");
        this.setModal(true);
        this.setAcceptText(I18n.msg("gui.save"));
        this.setCancelText(I18n.msg("gui.cancel"));
        try {
            this.controller = new Texture(Gdx.files.internal("img/controller/illustration/controller-nocontrast.png"));
            stick = new Texture(Gdx.files.internal("img/controller/illustration/button-stick.png"));
            stickH = new Texture(Gdx.files.internal("img/controller/illustration/axis-stick-h.png"));
            stickV = new Texture(Gdx.files.internal("img/controller/illustration/axis-stick-v.png"));
            dPadU = new Texture(Gdx.files.internal("img/controller/illustration/dpad-u.png"));
            dPadD = new Texture(Gdx.files.internal("img/controller/illustration/dpad-d.png"));
            dPadL = new Texture(Gdx.files.internal("img/controller/illustration/dpad-l.png"));
            dPadR = new Texture(Gdx.files.internal("img/controller/illustration/dpad-r.png"));
            startSelect = new Texture(Gdx.files.internal("img/controller/illustration/start-select.png"));
            a = new Texture(Gdx.files.internal("img/controller/illustration/button-a.png"));
            b = new Texture(Gdx.files.internal("img/controller/illustration/button-b.png"));
            x = new Texture(Gdx.files.internal("img/controller/illustration/button-x.png"));
            y = new Texture(Gdx.files.internal("img/controller/illustration/button-y.png"));
            lb = new Texture(Gdx.files.internal("img/controller/illustration/lb.png"));
            rb = new Texture(Gdx.files.internal("img/controller/illustration/rb.png"));
            lt = new Texture(Gdx.files.internal("img/controller/illustration/lt.png"));
            rt = new Texture(Gdx.files.internal("img/controller/illustration/rt.png"));
        }
        catch (Exception e) {
            logger.error(e);
            return;
        }
        this.inputFields = new HashMap<GamepadInput, OwnTextField>();
        this.inputInfo = new HashMap<GamepadInput, Trio<Texture, float[], String>>();
        this.inputInfo.put(GamepadInput.A, new Trio<Texture, float[], String>(a, new float[]{310.0f, -50.0f}, I18n.msg("gui.controller.action.primary")));
        this.inputInfo.put(GamepadInput.B, new Trio<Texture, float[], String>(b, new float[]{397.0f, -120.0f}, I18n.msg("gui.controller.action.back")));
        this.inputInfo.put(GamepadInput.X, new Trio<Texture, float[], String>(x, new float[]{227.0f, -120.0f}, I18n.msg("gui.controller.action.secondary")));
        this.inputInfo.put(GamepadInput.Y, new Trio<Texture, float[], String>(y, new float[]{310.0f, -190.0f}, I18n.msg("gui.controller.action.tertiary")));
        this.inputInfo.put(GamepadInput.LSTICK, new Trio<Texture, float[], String>(stick, new float[]{-322.0f, -122.0f}, I18n.msg("gui.controller.lstick.click")));
        this.inputInfo.put(GamepadInput.LSTICK_H, new Trio<Texture, float[], String>(stickH, new float[]{-322.0f, -122.0f}, I18n.msg("gui.controller.lstick.horizontal")));
        this.inputInfo.put(GamepadInput.LSTICK_V, new Trio<Texture, float[], String>(stickV, new float[]{-322.0f, -122.0f}, I18n.msg("gui.controller.lstick.vertical")));
        this.inputInfo.put(GamepadInput.RSTICK, new Trio<Texture, float[], String>(stick, new float[]{160.0f, 50.0f}, I18n.msg("gui.controller.rstick.click")));
        this.inputInfo.put(GamepadInput.RSTICK_H, new Trio<Texture, float[], String>(stickH, new float[]{160.0f, 50.0f}, I18n.msg("gui.controller.rstick.horizontal")));
        this.inputInfo.put(GamepadInput.RSTICK_V, new Trio<Texture, float[], String>(stickV, new float[]{160.0f, 50.0f}, I18n.msg("gui.controller.rstick.vertical")));
        this.inputInfo.put(GamepadInput.DPAD_UP, new Trio<Texture, float[], String>(dPadU, new float[]{-155.0f, 10.0f}, I18n.msg("gui.controller.dpad.up")));
        this.inputInfo.put(GamepadInput.DPAD_DOWN, new Trio<Texture, float[], String>(dPadD, new float[]{-155.0f, 85.0f}, I18n.msg("gui.controller.dpad.down")));
        this.inputInfo.put(GamepadInput.DPAD_LEFT, new Trio<Texture, float[], String>(dPadL, new float[]{-194.0f, 49.0f}, I18n.msg("gui.controller.dpad.left")));
        this.inputInfo.put(GamepadInput.DPAD_RIGHT, new Trio<Texture, float[], String>(dPadR, new float[]{-120.0f, 49.0f}, I18n.msg("gui.controller.dpad.right")));
        this.inputInfo.put(GamepadInput.START, new Trio<Texture, float[], String>(startSelect, new float[]{75.0f, -170.0f}, I18n.msg("gui.controller.start")));
        this.inputInfo.put(GamepadInput.SELECT, new Trio<Texture, float[], String>(startSelect, new float[]{-75.0f, -170.0f}, I18n.msg("gui.controller.select")));
        this.inputInfo.put(GamepadInput.LB, new Trio<Texture, float[], String>(lb, new float[]{-322.0f, -282.0f}, I18n.msg("gui.controller.lb")));
        this.inputInfo.put(GamepadInput.RB, new Trio<Texture, float[], String>(rb, new float[]{322.0f, -282.0f}, I18n.msg("gui.controller.rb")));
        this.inputInfo.put(GamepadInput.LT, new Trio<Texture, float[], String>(lt, new float[]{-354.0f, -265.0f}, I18n.msg("gui.controller.lt")));
        this.inputInfo.put(GamepadInput.RT, new Trio<Texture, float[], String>(rt, new float[]{354.0f, -265.0f}, I18n.msg("gui.controller.rt")));
        this.defaultGamepadListener = false;
        this.gamepadListener = new GamepadConfigListener(mappings);
        this.buildSuper();
    }

    @Override
    protected void build() {
        GamepadInput[] gpds;
        float lw = 224.0f;
        float iw = 176.0f;
        OwnLabel tip = new OwnLabel((CharSequence)I18n.msg("gui.controller.tip.config"), this.skin);
        this.content.add((Actor)tip).colspan(2).padBottom(pad18 * 2.0f).row();
        Cell controllerCell = this.content.add().padRight(pad18 * 2.0f);
        Table controllerTable = new Table(this.skin);
        controllerTable.setBackground((Drawable)new SpriteDrawable(new Sprite(this.controller)));
        controllerTable.setSize((float)this.controller.getWidth(), (float)this.controller.getHeight());
        controllerCell.setActor((Actor)controllerTable);
        this.elementCell = controllerTable.add((Actor)((Image)null));
        OwnLabel currentInputLabel = new OwnLabel((CharSequence)(I18n.msg("gui.controller.lastinput") + ":"), this.skin, "header");
        this.currentInput = new OwnLabel((CharSequence)this.none, this.skin, "default-blue");
        HorizontalGroup lastInputGroup = new HorizontalGroup();
        lastInputGroup.space(pad18);
        lastInputGroup.addActor((Actor)currentInputLabel);
        lastInputGroup.addActor((Actor)this.currentInput);
        OwnLabel fileLabel = new OwnLabel((CharSequence)(I18n.msg("gui.controller.filename") + ":"), this.skin, "header");
        LengthValidator lv = new LengthValidator(3, 100);
        this.filename = new OwnTextField(this.controllerName.replaceAll("\\s+", "_"), this.skin, lv);
        this.filename.setWidth(384.0f);
        OwnImageButton filenameTooltip = new OwnImageButton(this.skin, "tooltip");
        filenameTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.controller.filename.tooltip", SysUtils.getDefaultMappingsDir().toAbsolutePath()), this.skin));
        HorizontalGroup filenameGroup = new HorizontalGroup();
        filenameGroup.space(pad34);
        filenameGroup.addActor((Actor)fileLabel);
        filenameGroup.addActor((Actor)this.filename);
        filenameGroup.addActor((Actor)filenameTooltip);
        Table inputTable = new Table(this.skin);
        for (GamepadInput gpd : gpds = GamepadInput.values()) {
            Trio<Texture, float[], String> t = this.inputInfo.get((Object)gpd);
            inputTable.add((Actor)new OwnLabel((CharSequence)(t.getThird() + ": "), this.skin, lw)).left().padBottom(pad10).padRight(pad18);
            OwnTextField inputField = new OwnTextField(this.getMappingsValue(gpd, this.mappings), this.skin);
            inputField.setWidth(iw);
            Color origCol = inputField.getColor().cpy();
            this.inputFields.put(gpd, inputField);
            inputField.addListener(event -> {
                if (event instanceof FocusListener.FocusEvent) {
                    FocusListener.FocusEvent fe = (FocusListener.FocusEvent)event;
                    if (fe.isFocused()) {
                        inputField.setColor(0.4f, 0.4f, 1.0f, 1.0f);
                        this.displayElement(gpd);
                        this.makeCurrent(gpd, inputField);
                    } else {
                        inputField.setColor(origCol);
                        this.displayElement(null);
                        this.makeCurrent(null, null);
                    }
                    return true;
                }
                return false;
            });
            inputTable.add((Actor)inputField).left().padBottom(pad10).row();
        }
        this.lsx = new OwnSlider(0.1f, 10.0f, 0.1f, this.skin);
        this.lsx.setValue((float)this.mappings.AXIS_LSTICK_H_SENS);
        this.lsx.setWidth(iw);
        this.lsy = new OwnSlider(0.1f, 10.0f, 0.1f, this.skin);
        this.lsy.setValue((float)this.mappings.AXIS_LSTICK_V_SENS);
        this.lsy.setWidth(iw);
        this.rsx = new OwnSlider(0.1f, 10.0f, 0.1f, this.skin);
        this.rsx.setValue((float)this.mappings.AXIS_RSTICK_H_SENS);
        this.rsx.setWidth(iw);
        this.rsy = new OwnSlider(0.1f, 10.0f, 0.1f, this.skin);
        this.rsy.setValue((float)this.mappings.AXIS_RSTICK_V_SENS);
        this.rsy.setWidth(iw);
        this.lts = new OwnSlider(0.1f, 10.0f, 0.1f, this.skin);
        this.lts.setValue((float)this.mappings.AXIS_LT_SENS);
        this.lts.setWidth(iw);
        this.rts = new OwnSlider(0.1f, 10.0f, 0.1f, this.skin);
        this.rts.setValue((float)this.mappings.AXIS_RT_SENS);
        this.rts.setWidth(iw);
        this.axisPower = new OwnSlider(0.1f, 10.0f, 0.1f, this.skin);
        this.axisPower.setColor(1.0f, 0.5f, 0.5f, 1.0f);
        this.axisPower.setValue((float)this.mappings.AXIS_VALUE_POW);
        this.axisPower.setWidth(iw);
        Table sensitivityTable01 = new Table(this.skin);
        Table sensitivityTable02 = new Table(this.skin);
        OwnLabel titleSensitivity = new OwnLabel((CharSequence)I18n.msg("gui.controller.sensitivity"), this.skin, "header-s");
        sensitivityTable01.add((Actor)new OwnLabel((CharSequence)(I18n.msg("gui.controller.lstick") + " X:"), this.skin, lw)).left().padRight(pad18).padBottom(pad10);
        sensitivityTable01.add((Actor)this.lsx).left().padBottom(pad10).row();
        sensitivityTable01.add((Actor)new OwnLabel((CharSequence)(I18n.msg("gui.controller.lstick") + " Y:"), this.skin, lw)).left().padRight(pad18).padBottom(pad10);
        sensitivityTable01.add((Actor)this.lsy).left().padBottom(pad10).row();
        sensitivityTable01.add((Actor)new OwnLabel((CharSequence)(I18n.msg("gui.controller.rstick") + " X:"), this.skin, lw)).left().padRight(pad18).padBottom(pad10);
        sensitivityTable01.add((Actor)this.rsx).left().padBottom(pad10).row();
        sensitivityTable01.add((Actor)new OwnLabel((CharSequence)(I18n.msg("gui.controller.rstick") + " Y:"), this.skin, lw)).left().padRight(pad18).padBottom(pad10);
        sensitivityTable01.add((Actor)this.rsy).left().padBottom(pad10).row();
        sensitivityTable02.add((Actor)new OwnLabel((CharSequence)(I18n.msg("gui.controller.lt") + ":"), this.skin, lw)).left().padRight(pad18).padBottom(pad10);
        sensitivityTable02.add((Actor)this.lts).left().padBottom(pad10).row();
        sensitivityTable02.add((Actor)new OwnLabel((CharSequence)(I18n.msg("gui.controller.rt") + ":"), this.skin, lw)).left().padRight(pad18).padBottom(pad34);
        sensitivityTable02.add((Actor)this.rts).left().padBottom(pad34).row();
        sensitivityTable02.add((Actor)new OwnLabel((CharSequence)(I18n.msg("gui.controller.axis.pow") + ":"), this.skin, lw)).left().padRight(pad18).padBottom(pad10);
        sensitivityTable02.add((Actor)this.axisPower).left();
        this.content.add((Actor)inputTable).left();
        this.content.row();
        this.content.add((Actor)lastInputGroup).padBottom(pad18);
        this.content.row();
        this.content.add((Actor)titleSensitivity).left().colspan(2).padBottom(pad18);
        this.content.add();
        this.content.row();
        this.content.add((Actor)sensitivityTable01).left().top();
        this.content.add((Actor)sensitivityTable02).left().top();
        this.content.row();
        this.content.add((Actor)filenameGroup).colspan(2).padTop(pad34);
        GaiaSky.postRunnable(() -> this.stage.setKeyboardFocus((Actor)this.inputFields.get((Object)gpds[0])));
        this.content.pack();
    }

    private String getMappingsValue(GamepadInput gpd, GamepadMappings m) {
        if (m == null) {
            return this.none;
        }
        String b = this.button + " ";
        String a = this.axis + " ";
        return switch (gpd.ordinal()) {
            case 0 -> m.BUTTON_A >= 0 ? b + m.BUTTON_A : this.none;
            case 1 -> m.BUTTON_B >= 0 ? b + m.BUTTON_B : this.none;
            case 2 -> m.BUTTON_X >= 0 ? b + m.BUTTON_X : this.none;
            case 3 -> m.BUTTON_Y >= 0 ? b + m.BUTTON_Y : this.none;
            case 14 -> m.BUTTON_START >= 0 ? b + m.BUTTON_START : this.none;
            case 15 -> m.BUTTON_SELECT >= 0 ? b + m.BUTTON_SELECT : this.none;
            case 10 -> {
                if (m.BUTTON_DPAD_UP >= 0) {
                    yield b + m.BUTTON_DPAD_UP;
                }
                if (m.AXIS_DPAD_V >= 0) {
                    yield a + m.AXIS_DPAD_V;
                }
                yield this.none;
            }
            case 11 -> {
                if (m.BUTTON_DPAD_DOWN >= 0) {
                    yield b + m.BUTTON_DPAD_DOWN;
                }
                if (m.AXIS_DPAD_V >= 0) {
                    yield a + m.AXIS_DPAD_V;
                }
                yield this.none;
            }
            case 12 -> {
                if (m.BUTTON_DPAD_LEFT >= 0) {
                    yield b + m.BUTTON_DPAD_LEFT;
                }
                if (m.AXIS_DPAD_H >= 0) {
                    yield a + m.AXIS_DPAD_H;
                }
                yield this.none;
            }
            case 13 -> {
                if (m.BUTTON_DPAD_RIGHT >= 0) {
                    yield b + m.BUTTON_DPAD_RIGHT;
                }
                if (m.AXIS_DPAD_H >= 0) {
                    yield a + m.AXIS_DPAD_H;
                }
                yield this.none;
            }
            case 16 -> m.BUTTON_RB >= 0 ? b + m.BUTTON_RB : this.none;
            case 17 -> {
                if (m.BUTTON_RT >= 0) {
                    yield b + m.BUTTON_RT;
                }
                if (m.AXIS_RT >= 0) {
                    yield a + m.AXIS_RT;
                }
                yield this.none;
            }
            case 18 -> m.BUTTON_LB >= 0 ? b + m.BUTTON_LB : this.none;
            case 19 -> {
                if (m.BUTTON_LT >= 0) {
                    yield b + m.BUTTON_LT;
                }
                if (m.AXIS_LT >= 0) {
                    yield a + m.AXIS_LT;
                }
                yield this.none;
            }
            case 5 -> m.AXIS_LSTICK_H >= 0 ? a + m.AXIS_LSTICK_H : this.none;
            case 4 -> m.AXIS_LSTICK_V >= 0 ? a + m.AXIS_LSTICK_V : this.none;
            case 6 -> m.BUTTON_LSTICK >= 0 ? b + m.BUTTON_LSTICK : this.none;
            case 8 -> m.AXIS_RSTICK_H >= 0 ? a + m.AXIS_RSTICK_H : this.none;
            case 7 -> m.AXIS_RSTICK_V >= 0 ? a + m.AXIS_RSTICK_V : this.none;
            case 9 -> m.BUTTON_RSTICK >= 0 ? b + m.BUTTON_RSTICK : this.none;
            default -> this.none;
        };
    }

    private void makeCurrent(GamepadInput gp, OwnTextField tf) {
        this.currGamepadInput = gp;
        this.currTextField = tf;
    }

    private void displayElement(GamepadInput input) {
        if (input != null) {
            Trio<Texture, float[], String> data = this.inputInfo.get((Object)input);
            Image img = new Image(data.getFirst());
            this.elementCell.clearActor();
            this.elementCell.setActor((Actor)img).padLeft(data.getSecond()[0]).padTop(data.getSecond()[1]);
        } else {
            this.elementCell.clearActor();
        }
    }

    protected int[] getInput(GamepadInput gp) {
        OwnTextField i = this.inputFields.get((Object)gp);
        String text = i.getText();
        if (text.equalsIgnoreCase(this.none)) {
            return new int[]{-1, -1};
        }
        String[] tokens = text.split("\\s+");
        if (tokens.length != 2) {
            logger.error("Failed to parse " + String.valueOf((Object)gp));
            return new int[]{-1, -1};
        }
        try {
            int code = Parser.parseIntException(tokens[1]);
            int type = gp.type;
            if (type == 2) {
                type = tokens[0].equalsIgnoreCase(this.button) ? 0 : 1;
            }
            return new int[]{code, type};
        }
        catch (Exception e) {
            logger.error("Failed to parse " + String.valueOf((Object)gp));
            return new int[]{-1, -1};
        }
    }

    @Override
    protected boolean accept() {
        Path mappings = SysUtils.getDefaultMappingsDir();
        Path file = mappings.resolve(this.filename.getText() + ".controller");
        GamepadMappings cm = this.mappings;
        cm.AXIS_VALUE_POW = this.axisPower.getValue();
        cm.AXIS_LSTICK_H = this.getInput(GamepadInput.LSTICK_H)[0];
        cm.AXIS_LSTICK_H_SENS = this.lsx.getValue();
        cm.AXIS_LSTICK_V = this.getInput(GamepadInput.LSTICK_V)[0];
        cm.AXIS_LSTICK_V_SENS = this.lsy.getValue();
        cm.BUTTON_LSTICK = this.getInput(GamepadInput.LSTICK)[0];
        cm.AXIS_RSTICK_H = this.getInput(GamepadInput.RSTICK_H)[0];
        cm.AXIS_RSTICK_H_SENS = this.rsx.getValue();
        cm.AXIS_RSTICK_V = this.getInput(GamepadInput.RSTICK_V)[0];
        cm.AXIS_RSTICK_V_SENS = this.rsy.getValue();
        cm.BUTTON_RSTICK = this.getInput(GamepadInput.RSTICK)[0];
        cm.BUTTON_A = this.getInput(GamepadInput.A)[0];
        cm.BUTTON_B = this.getInput(GamepadInput.B)[0];
        cm.BUTTON_X = this.getInput(GamepadInput.X)[0];
        cm.BUTTON_Y = this.getInput(GamepadInput.Y)[0];
        cm.BUTTON_START = this.getInput(GamepadInput.START)[0];
        cm.BUTTON_SELECT = this.getInput(GamepadInput.SELECT)[0];
        int[] dpu = this.getInput(GamepadInput.DPAD_UP);
        if (dpu[1] == 0) {
            cm.BUTTON_DPAD_UP = dpu[0];
        } else {
            cm.AXIS_DPAD_V = dpu[0];
        }
        int[] dpd = this.getInput(GamepadInput.DPAD_DOWN);
        if (dpd[1] == 0) {
            cm.BUTTON_DPAD_DOWN = dpd[0];
        } else {
            cm.AXIS_DPAD_V = dpd[0];
        }
        int[] dpl = this.getInput(GamepadInput.DPAD_LEFT);
        if (dpl[1] == 0) {
            cm.BUTTON_DPAD_LEFT = dpl[0];
        } else {
            cm.AXIS_DPAD_H = dpl[0];
        }
        int[] dpr = this.getInput(GamepadInput.DPAD_RIGHT);
        if (dpr[1] == 0) {
            cm.BUTTON_DPAD_RIGHT = dpr[0];
        } else {
            cm.AXIS_DPAD_H = dpr[0];
        }
        cm.BUTTON_RB = this.getInput(GamepadInput.RB)[0];
        cm.BUTTON_LB = this.getInput(GamepadInput.LB)[0];
        int[] rt = this.getInput(GamepadInput.RT);
        if (rt[1] == 0) {
            cm.BUTTON_RT = rt[0];
        } else {
            cm.AXIS_RT = rt[0];
        }
        cm.AXIS_RT_SENS = this.rts.getValue();
        int[] lt = this.getInput(GamepadInput.LT);
        if (lt[1] == 0) {
            cm.BUTTON_LT = lt[0];
        } else {
            cm.AXIS_LT = lt[0];
        }
        cm.AXIS_LT_SENS = this.lts.getValue();
        if (cm.persist(file)) {
            this.savedFile = file;
        }
        EventManager.publish(Event.RELOAD_CONTROLLER_MAPPINGS, this, file.toAbsolutePath().toString());
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
    }

    private static enum GamepadInput {
        A(0),
        B(0),
        X(0),
        Y(0),
        LSTICK_V(1),
        LSTICK_H(1),
        LSTICK(0),
        RSTICK_V(1),
        RSTICK_H(1),
        RSTICK(0),
        DPAD_UP(2),
        DPAD_DOWN(2),
        DPAD_LEFT(2),
        DPAD_RIGHT(2),
        START(0),
        SELECT(0),
        RB(0),
        RT(2),
        LB(0),
        LT(2);

        public final int type;

        private GamepadInput(int type) {
            this.type = type;
        }

        public boolean isButton() {
            return this.type == 0 || this.type == 2;
        }

        public boolean isAxis() {
            return this.type == 1 || this.type == 2;
        }

        public boolean isEither() {
            return this.type == 2;
        }
    }

    private class GamepadConfigListener
    extends WindowGamepadListener {
        boolean capturingAxis;
        long lastT;
        long lastAxisT;
        long minDelayT;
        long minAxisT;
        double[] axes;

        public GamepadConfigListener(IGamepadMappings mappings) {
            super(mappings, GamepadConfigWindow.this.me);
            this.capturingAxis = false;
            this.lastT = System.currentTimeMillis();
            this.lastAxisT = System.currentTimeMillis();
            this.minDelayT = 500L;
            this.minAxisT = 300L;
            this.axes = new double[40];
        }

        @Override
        public boolean pollAxes() {
            return false;
        }

        @Override
        public boolean pollButtons() {
            return false;
        }

        @Override
        public boolean buttonDown(Controller controller, int buttonCode) {
            if (this.active.get()) {
                if (GamepadConfigWindow.this.currTextField == null) {
                    if (buttonCode == this.mappings.getButtonA()) {
                        this.actionDown();
                    } else if (buttonCode == this.mappings.getButtonB()) {
                        this.back();
                    } else if (buttonCode == this.mappings.getButtonSelect()) {
                        this.select();
                    }
                } else if (GamepadConfigWindow.this.currGamepadInput != null && GamepadConfigWindow.this.currGamepadInput.isButton() && System.currentTimeMillis() - this.lastT > this.minDelayT) {
                    GamepadConfigWindow.this.currTextField.setText(GamepadConfigWindow.this.button + " " + buttonCode);
                    this.jumpToNext();
                    this.lastT = System.currentTimeMillis();
                }
                GamepadConfigWindow.this.currentInput.setText(GamepadConfigWindow.this.button + " " + buttonCode);
                return true;
            }
            return false;
        }

        @Override
        public boolean buttonUp(Controller controller, int buttonCode) {
            if (this.active.get()) {
                super.buttonUp(controller, buttonCode);
                GamepadConfigWindow.this.currentInput.setText(GamepadConfigWindow.this.button + " " + buttonCode);
            }
            return false;
        }

        @Override
        public boolean axisMoved(Controller controller, int axisCode, float value) {
            if (this.active.get() && (value = (float)this.applyZeroPoint(value)) != 0.0f && GamepadConfigWindow.this.currTextField != null) {
                long now = TimeUtils.millis();
                if (GamepadConfigWindow.this.currGamepadInput != null && GamepadConfigWindow.this.currGamepadInput.isAxis() && (now - this.lastT > this.minDelayT || this.capturingAxis)) {
                    if (!this.capturingAxis) {
                        this.capturingAxis = true;
                        this.lastAxisT = now;
                        int n = axisCode;
                        this.axes[n] = this.axes[n] + (double)FastMath.abs((float)value);
                    } else if (now - this.lastAxisT < this.minAxisT) {
                        int n = axisCode;
                        this.axes[n] = this.axes[n] + (double)FastMath.abs((float)value);
                    } else {
                        int n = axisCode;
                        this.axes[n] = this.axes[n] + (double)FastMath.abs((float)value);
                        double max = 0.0;
                        int maxAxis = -1;
                        for (int i = 0; i < this.axes.length; ++i) {
                            if (!(this.axes[i] > max)) continue;
                            max = this.axes[i];
                            maxAxis = i;
                        }
                        this.axes = new double[40];
                        GamepadConfigWindow.this.currTextField.setText(GamepadConfigWindow.this.axis + " " + maxAxis);
                        this.jumpToNext();
                        this.capturingAxis = false;
                        this.lastT = now;
                    }
                }
                GamepadConfigWindow.this.currentInput.setText(GamepadConfigWindow.this.axis + " " + axisCode);
                return true;
            }
            return false;
        }

        private void jumpToNext() {
            if (GamepadConfigWindow.this.currTextField != GamepadConfigWindow.this.inputFields.get((Object)GamepadInput.values()[GamepadInput.values().length - 1])) {
                GamepadConfigWindow.this.currTextField.next(false);
            } else {
                this.stage.setKeyboardFocus((Actor)GamepadConfigWindow.this.acceptButton);
                GamepadConfigWindow.this.currTextField = null;
            }
        }
    }
}

