/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.utils.Array;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.input.AbstractGamepadListener;
import gaiasky.input.AbstractMouseKbdListener;
import gaiasky.input.WindowGamepadListener;
import gaiasky.input.WindowKbdListener;
import gaiasky.util.GuiUtils;
import gaiasky.util.Settings;
import gaiasky.util.scene2d.CollapsibleWindow;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnTextButton;
import gaiasky.util.scene2d.Separator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jafama.FastMath;

public abstract class GenericDialog
extends CollapsibleWindow {
    protected static float pad34;
    protected static float pad20;
    protected static float pad18;
    protected static float pad10;
    private static final Map<Class<? extends GenericDialog>, Integer> lastActiveTab;
    protected final Stage stage;
    protected final Skin skin;
    public TextButton acceptButton;
    public TextButton cancelButton;
    protected GenericDialog me;
    protected Table content;
    protected Table bottom;
    protected boolean modal = true;
    protected boolean defaultMouseKbdListener = true;
    protected boolean defaultGamepadListener = true;
    protected float lastPosX = -1.0f;
    protected float lastPosY = -1.0f;
    protected HorizontalGroup buttonGroup;
    protected boolean enterExit = true;
    protected boolean escExit = true;
    protected boolean keysListener = true;
    private boolean initializing = true;
    protected Runnable acceptListener;
    protected Runnable cancelListener;
    protected Runnable closeListener;
    protected AbstractMouseKbdListener mouseKbdListener;
    protected AbstractGamepadListener gamepadListener;
    protected Array<TextButton> tabButtons;
    protected int selectedTab = 0;
    protected Array<Group> tabContents;
    protected Stack tabStack;
    protected InputListener ignoreTouchDown = new InputListener(this){

        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            event.cancel();
            return false;
        }
    };
    protected Array<OwnScrollPane> scrolls;
    protected Set<AbstractMouseKbdListener> backupMouseKbdListeners = new HashSet<AbstractMouseKbdListener>();
    protected Set<ControllerListener> backupGamepadListeners = null;
    private String acceptText = null;
    private String cancelText = null;
    private String acceptStyle = "default";
    private String cancelStyle = "default";
    private Actor previousKeyboardFocus;
    private Actor previousScrollFocus;

    public GenericDialog(String title, Skin skin, Stage stage) {
        super(title, skin);
        this.skin = skin;
        this.stage = stage;
        this.me = this;
        this.content = new Table(skin);
        this.bottom = new Table(skin);
        this.scrolls = new Array(false, 5);
    }

    public static void updatePads() {
        pad34 = 34.0f;
        pad20 = 20.0f;
        pad18 = 18.0f;
        pad10 = 10.0f;
    }

    public void setAcceptText(String acceptText) {
        this.acceptText = acceptText;
        if (this.acceptButton != null) {
            this.acceptButton.setText(acceptText);
            this.recalculateButtonSize();
        }
    }

    public void setAcceptButtonStyle(String style) {
        this.acceptStyle = style;
        if (this.acceptButton != null) {
            this.acceptButton.setStyle((Button.ButtonStyle)this.skin.get(this.acceptStyle, TextButton.TextButtonStyle.class));
            this.recalculateButtonSize();
        }
    }

    public void setAcceptButtonColor(Color col) {
        if (this.acceptButton != null) {
            this.acceptButton.setColor(col);
        }
    }

    public void setCancelText(String cancelText) {
        this.cancelText = cancelText;
        if (this.cancelButton != null) {
            this.cancelButton.setText(cancelText);
            this.recalculateButtonSize();
        }
    }

    public void setCancelButtonStyle(String style) {
        this.cancelStyle = style;
        if (this.cancelButton != null) {
            this.cancelButton.setStyle((Button.ButtonStyle)this.skin.get(this.cancelStyle, TextButton.TextButtonStyle.class));
            this.recalculateButtonSize();
        }
    }

    public void setCancelButtonColors(Color textColor, Color buttonColor) {
        if (this.cancelButton != null) {
            this.cancelButton.setColor(buttonColor);
            this.cancelButton.getLabel().setColor(textColor);
        }
    }

    protected void addTabContent(Group tabContent) {
        if (this.tabStack == null) {
            this.tabStack = new Stack();
        }
        if (this.tabContents == null) {
            this.tabContents = new Array();
        }
        this.tabStack.add((Actor)tabContent);
        this.tabContents.add((Object)tabContent);
    }

    protected void setUpTabListeners() {
        if (this.tabContents != null && this.tabButtons != null && this.tabButtons.size == this.tabContents.size) {
            final ButtonGroup tabsGroup = new ButtonGroup();
            tabsGroup.setMinCheckCount(1);
            tabsGroup.setMaxCheckCount(1);
            ChangeListener tabListener = new ChangeListener(this){
                final /* synthetic */ GenericDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (((Button)actor).isChecked()) {
                        for (int i = 0; i < this.this$0.tabContents.size; ++i) {
                            ((Group)this.this$0.tabContents.get(i)).setVisible(((TextButton)this.this$0.tabButtons.get(i)).isChecked());
                        }
                        if (this.this$0.tabButtons != null) {
                            this.this$0.selectedTab = tabsGroup.getCheckedIndex();
                            if (!this.this$0.initializing) {
                                lastActiveTab.put(((Object)((Object)this.this$0.me)).getClass(), this.this$0.selectedTab);
                            }
                        }
                    }
                }
            };
            this.initializing = true;
            for (int i = 0; i < this.tabButtons.size; ++i) {
                ((TextButton)this.tabButtons.get(i)).addListener((EventListener)tabListener);
                tabsGroup.add((Button)this.tabButtons.get(i));
            }
            this.initializing = false;
            Integer lastSelected = lastActiveTab.getOrDefault(((Object)((Object)this.me)).getClass(), 0);
            tabsGroup.setChecked(((TextButton)this.tabButtons.get(lastSelected.intValue())).getText().toString());
        }
    }

    @Override
    public void setModal(boolean modal) {
        this.modal = modal;
        super.setModal(modal);
    }

    protected void recalculateButtonSize() {
        float w = 128.0f;
        for (Actor button : this.buttonGroup.getChildren()) {
            w = FastMath.max((float)(button.getWidth() + pad18 * 4.0f), (float)w);
        }
        for (Actor button : this.buttonGroup.getChildren()) {
            button.setWidth(w);
        }
        float h = 30.0f;
        for (Actor button : this.buttonGroup.getChildren()) {
            h = FastMath.max((float)button.getHeight(), (float)h);
        }
        for (Actor button : this.buttonGroup.getChildren()) {
            button.setHeight(h + 5.0f);
        }
    }

    public void buildSuper() {
        this.buttonGroup = new HorizontalGroup();
        this.buttonGroup.space(pad10);
        if (this.acceptText != null) {
            this.acceptButton = new OwnTextButton(this.acceptText, this.skin, this.acceptStyle);
            this.acceptButton.setName("accept");
            this.acceptButton.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    return this.closeAccept();
                }
                return false;
            });
            this.buttonGroup.addActor((Actor)this.acceptButton);
        }
        if (this.cancelText != null) {
            this.cancelButton = new OwnTextButton(this.cancelText, this.skin, this.cancelStyle);
            this.cancelButton.setName("cancel");
            this.cancelButton.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    return this.closeCancel();
                }
                return false;
            });
            this.buttonGroup.addActor((Actor)this.cancelButton);
        }
        this.recalculateButtonSize();
        this.add((Actor)this.content).left().pad(pad18).row();
        this.add((Actor)this.bottom).expandY().bottom().right().padRight(pad18).row();
        this.add((Actor)this.buttonGroup).pad(pad18).bottom().right();
        this.getTitleTable().align(8);
        this.align(10);
        this.pack();
        if (this.keysListener) {
            this.me.addListener(event -> {
                InputEvent ie;
                if (event instanceof InputEvent && (ie = (InputEvent)event).getType() == InputEvent.Type.keyUp) {
                    int key = ie.getKeyCode();
                    switch (key) {
                        case 111: {
                            if (this.escExit) {
                                this.closeCancel();
                            }
                            event.stop();
                            return true;
                        }
                        case 66: {
                            if (this.enterExit) {
                                this.closeAccept();
                            }
                            event.stop();
                            return true;
                        }
                        case 61: {
                            return true;
                        }
                    }
                }
                return false;
            });
        }
        this.stage.addListener(event -> {
            InputEvent ie;
            if (event instanceof InputEvent && (ie = (InputEvent)event).getType() == InputEvent.Type.mouseMoved) {
                for (OwnScrollPane scroll : this.scrolls) {
                    if (!ie.getTarget().isDescendantOf((Actor)scroll)) continue;
                    this.stage.setScrollFocus((Actor)scroll);
                }
            }
            return false;
        });
        this.build();
        this.setModal(this.modal);
        if (this.defaultMouseKbdListener) {
            this.mouseKbdListener = new WindowKbdListener(this);
        }
        if (this.defaultGamepadListener) {
            this.gamepadListener = new WindowGamepadListener(Settings.settings.controls.gamepad.mappingsFile, this);
        }
    }

    protected abstract void build();

    public boolean closeAccept() {
        boolean close = this.accept();
        if (this.acceptListener != null) {
            this.acceptListener.run();
        }
        if (this.closeListener != null) {
            this.closeListener.run();
        }
        if (close) {
            this.me.hide();
        }
        return close;
    }

    public boolean closeCancel() {
        this.cancel();
        if (this.cancelListener != null) {
            this.cancelListener.run();
        }
        if (this.closeListener != null) {
            this.closeListener.run();
        }
        this.me.hide();
        return true;
    }

    protected abstract boolean accept();

    protected abstract void cancel();

    public GenericDialog show(Stage stage, Action action) {
        this.clearActions();
        this.removeCaptureListener((EventListener)this.ignoreTouchDown);
        this.previousKeyboardFocus = null;
        Actor actor = stage.getKeyboardFocus();
        if (actor != null && !actor.isDescendantOf((Actor)this)) {
            this.previousKeyboardFocus = actor;
        }
        this.previousScrollFocus = null;
        actor = stage.getScrollFocus();
        if (actor != null && !actor.isDescendantOf((Actor)this)) {
            this.previousScrollFocus = actor;
        }
        this.pack();
        stage.addActor((Actor)this);
        stage.setKeyboardFocus((Actor)this);
        stage.setScrollFocus((Actor)this);
        if (action != null) {
            this.addAction(action);
        }
        this.addOwnListeners();
        this.touch();
        this.focusFirstInputWidget();
        EventManager.publish(Event.CLEAN_PRESSED_KEYS, (Object)this, new Object[0]);
        if (this.modal) {
            EventManager.publish(Event.INPUT_ENABLED_CMD, (Object)this, false);
        }
        return this;
    }

    public void touch() {
    }

    public Group getCurrentContentContainer() {
        if (this.tabButtons != null && !this.tabButtons.isEmpty()) {
            return (Group)this.tabContents.get(this.selectedTab);
        }
        return this.content;
    }

    public Group getBottmGroup() {
        return this.bottom;
    }

    public Group getButtonsGroup() {
        return this.buttonGroup;
    }

    public GenericDialog show(Stage stage) {
        this.show(stage, (Action)Actions.sequence((Action)Actions.alpha((float)0.0f), (Action)Actions.fadeIn((float)0.6f, (Interpolation)Interpolation.fade)));
        if (this.lastPosX >= 0.0f && this.lastPosY >= 0.0f) {
            this.setPosition(Math.round(this.lastPosX), FastMath.round((float)this.lastPosY));
        } else {
            this.setPosition(Math.round((stage.getWidth() - this.getWidth()) / 2.0f), FastMath.round((float)((stage.getHeight() - this.getHeight()) / 2.0f)));
        }
        this.setKeyboardFocus();
        this.showDialogHook(stage);
        return this;
    }

    protected void showDialogHook(Stage stage) {
    }

    public GenericDialog show(Stage stage, float x, float y) {
        this.show(stage, (Action)Actions.sequence((Action)Actions.alpha((float)0.0f), (Action)Actions.fadeIn((float)Settings.settings.program.ui.getAnimationSeconds(), (Interpolation)Interpolation.fade)));
        this.setPosition(Math.round(x), FastMath.round((float)y));
        this.setKeyboardFocus();
        return this;
    }

    public void setKeyboardFocus() {
    }

    public void hide(Action action) {
        this.lastPosX = this.getX();
        this.lastPosY = this.getY();
        Stage stage = this.getStage();
        if (stage != null) {
            Actor actor;
            if (this.previousKeyboardFocus != null && this.previousKeyboardFocus.getStage() == null) {
                this.previousKeyboardFocus = null;
            }
            if ((actor = stage.getKeyboardFocus()) == null || actor.isDescendantOf((Actor)this)) {
                stage.setKeyboardFocus(this.previousKeyboardFocus);
            }
            if (this.previousScrollFocus != null && this.previousScrollFocus.getStage() == null) {
                this.previousScrollFocus = null;
            }
            if ((actor = stage.getScrollFocus()) == null || actor.isDescendantOf((Actor)this)) {
                stage.setScrollFocus(this.previousScrollFocus);
            }
        }
        if (action != null) {
            this.addCaptureListener((EventListener)this.ignoreTouchDown);
            this.addAction((Action)Actions.sequence((Action)action, (Action)Actions.removeListener((EventListener)this.ignoreTouchDown, (boolean)true), (Action)Actions.removeActor()));
        } else {
            this.remove();
        }
        this.removeOwnListeners();
        EventManager.publish(Event.CLEAN_PRESSED_KEYS, (Object)this, new Object[0]);
        if (this.modal) {
            EventManager.publish(Event.INPUT_ENABLED_CMD, (Object)this, true);
        }
    }

    public void hide() {
        this.hide((Action)Actions.sequence((Action)Actions.alpha((float)1.0f), (Action)Actions.fadeOut((float)0.6f), (Action)Actions.removeActor((Actor)this)));
    }

    public void addSeparator() {
        this.addSeparator(1);
    }

    public void addSeparator(int colSpan) {
        if (this.content != null) {
            this.content.add((Actor)new Separator(this.skin, "gray")).colspan(colSpan).center().growX().padTop(pad18).padBottom(pad18).row();
        }
    }

    public void setAcceptListener(Runnable r) {
        this.acceptListener = r;
    }

    public boolean hasAcceptRunnable() {
        return this.acceptListener != null;
    }

    public void setCancelListener(Runnable r) {
        this.cancelListener = r;
    }

    public boolean hasCancelRunnable() {
        return this.cancelListener != null;
    }

    public void setCloseListener(Runnable r) {
        this.closeListener = r;
    }

    public boolean hasCloseRunnable() {
        return this.closeListener != null;
    }

    protected void enableComponents(boolean enabled, Disableable ... components) {
        for (Disableable c : components) {
            if (c == null) continue;
            c.setDisabled(!enabled);
        }
    }

    private void addOwnListeners() {
        InputProcessor inputProcessor;
        if (this.mouseKbdListener != null && (inputProcessor = Gdx.input.getInputProcessor()) instanceof InputMultiplexer) {
            InputMultiplexer inputMultiplexer = (InputMultiplexer)inputProcessor;
            for (InputProcessor processor : inputMultiplexer.getProcessors()) {
                AbstractMouseKbdListener abstractMouseKbdListener;
                if (!(processor instanceof AbstractMouseKbdListener) || !(abstractMouseKbdListener = (AbstractMouseKbdListener)processor).isActive() || !this.isModal()) continue;
                abstractMouseKbdListener.deactivate();
                this.backupMouseKbdListeners.add(abstractMouseKbdListener);
            }
            inputMultiplexer.addProcessor(0, (InputProcessor)this.mouseKbdListener);
        }
        if (this.gamepadListener != null) {
            Settings.ControlsSettings.GamepadSettings gamepadSettings = Settings.settings.controls.gamepad;
            this.backupGamepadListeners = gamepadSettings.getControllerListeners();
            gamepadSettings.removeAllControllerListeners();
            gamepadSettings.addControllerListener(this.gamepadListener);
        }
    }

    private void removeOwnListeners() {
        InputProcessor inputProcessor;
        if (this.mouseKbdListener != null && (inputProcessor = Gdx.input.getInputProcessor()) instanceof InputMultiplexer) {
            InputMultiplexer inputMultiplexer = (InputMultiplexer)inputProcessor;
            inputMultiplexer.removeProcessor((InputProcessor)this.mouseKbdListener);
            for (AbstractMouseKbdListener abstractMouseKbdListener : this.backupMouseKbdListeners) {
                abstractMouseKbdListener.activate();
            }
            this.backupMouseKbdListeners.clear();
        }
        if (this.gamepadListener != null) {
            Settings.ControlsSettings.GamepadSettings gamepadSettings = Settings.settings.controls.gamepad;
            gamepadSettings.removeControllerListener(this.gamepadListener);
            gamepadSettings.setControllerListeners(this.backupGamepadListeners);
            this.backupGamepadListeners = null;
        }
    }

    public boolean tabRight() {
        if (this.tabButtons != null) {
            this.selectedTab = (this.selectedTab + 1) % this.tabButtons.size;
            ((TextButton)this.tabButtons.get(this.selectedTab)).setChecked(true);
            this.focusFirstInputWidget();
            return true;
        }
        return false;
    }

    public boolean tabLeft() {
        if (this.tabButtons != null) {
            --this.selectedTab;
            if (this.selectedTab < 0) {
                this.selectedTab = this.tabButtons.size - 1;
            }
            ((TextButton)this.tabButtons.get(this.selectedTab)).setChecked(true);
            this.focusFirstInputWidget();
            return true;
        }
        return false;
    }

    public void focusFirstInputWidget() {
        Array<Actor> inputWidgets = GuiUtils.getInputWidgets((Actor)this.getCurrentContentContainer(), (Array<Actor>)new Array());
        if (!inputWidgets.isEmpty()) {
            this.stage.setKeyboardFocus((Actor)inputWidgets.get(0));
        }
    }

    public Table getContent() {
        return this.content;
    }

    public Table getBottom() {
        return this.bottom;
    }

    public Array<TextButton> getTabButtons() {
        return this.tabButtons;
    }

    public abstract void dispose();

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.gamepadListener != null && this.gamepadListener.isActive()) {
            this.gamepadListener.update();
        }
    }

    public Stage getStage() {
        return this.stage;
    }

    static {
        GenericDialog.updatePads();
        lastActiveTab = new HashMap<Class<? extends GenericDialog>, Integer>(20);
    }
}

