/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.main.KeyBindings;
import gaiasky.gui.window.GenericDialog;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.api.IVisibilitySwitch;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.LocationMark;
import gaiasky.scene.component.Mesh;
import gaiasky.scene.view.FocusView;
import gaiasky.util.GlobalResources;
import gaiasky.util.Pair;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.CollapsiblePane;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnImageButton;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.scene2d.OwnTextHotkeyTooltip;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class IndividualVisibilityWindow
extends GenericDialog
implements IObserver {
    protected final Scene scene;
    protected float space8;
    protected float space4;
    protected float space2;
    protected Cell<?> elementsCell;
    protected String currentComponentType = null;
    protected ComponentTypes.ComponentType currentCt = null;
    protected Map<String, CheckBox> cbMap;

    public IndividualVisibilityWindow(Scene scene, Stage stage, Skin skin) {
        super(I18n.msg("gui.visibility.individual"), skin, stage);
        this.scene = scene;
        this.space8 = 12.8f;
        this.space4 = 6.4f;
        this.space2 = 3.2f;
        this.cbMap = new HashMap<String, CheckBox>();
        this.setAcceptText(I18n.msg("gui.close"));
        this.setModal(false);
        this.setWidth(500.0f);
        this.buildSuper();
        this.pack();
        EventManager.instance.subscribe((IObserver)this, Event.PER_OBJECT_VISIBILITY_CMD, Event.CATALOG_VISIBLE);
    }

    @Override
    protected void build() {
        this.content.clear();
        String cct = this.currentComponentType;
        float buttonPadHor = 14.0f;
        float buttonPadVert = 8.0f;
        int visTableCols = 7;
        Table buttonTable = new Table(this.skin);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.setMinCheckCount(1);
        buttonGroup.setMaxCheckCount(1);
        this.content.add((Actor)buttonTable).top().center().padBottom(pad18).row();
        this.elementsCell = this.content.add().top().left();
        ComponentTypes.ComponentType[] visibilityEntities = ComponentTypes.ComponentType.values();
        int j = 0;
        for (ComponentTypes.ComponentType ct : visibilityEntities) {
            String name = ct.getName();
            if (name == null || !this.componentFilter(ct) || ct.style == null) continue;
            Image icon = new Image(this.skin.getDrawable(ct.style));
            OwnTextIconButton button = new OwnTextIconButton("", icon, this.skin, "toggle");
            button.setName(ct.key);
            String[] hk = KeyBindings.instance.getStringKeys("action.toggle/" + ct.key, true);
            if (hk != null) {
                button.addListener((EventListener)new OwnTextHotkeyTooltip(TextUtils.capitalise(ct.getName()), hk, this.skin));
            } else {
                button.addListener((EventListener)new OwnTextTooltip(TextUtils.capitalise(ct.getName()), this.skin));
            }
            button.addListener(arg_0 -> this.lambda$build$0((Button)button, ct, name, arg_0));
            if (name.equals(cct)) {
                button.setChecked(true);
            }
            Cell c = buttonTable.add((Actor)button).padBottom(buttonPadVert);
            if ((j + 1) % visTableCols == 0) {
                buttonTable.row();
            } else {
                c.padRight(buttonPadHor);
            }
            buttonGroup.add((Button)button);
            ++j;
        }
        if (cct != null) {
            buttonGroup.setChecked(cct);
        }
        this.content.pack();
    }

    private boolean componentFilter(ComponentTypes.ComponentType ct) {
        return ct != ComponentTypes.ComponentType.Labels && ct != ComponentTypes.ComponentType.Atmospheres && ct != ComponentTypes.ComponentType.Clouds && ct != ComponentTypes.ComponentType.Effects && ct != ComponentTypes.ComponentType.VelocityVectors && ct != ComponentTypes.ComponentType.Keyframes && ct != ComponentTypes.ComponentType.RecursiveGrid && ct != ComponentTypes.ComponentType.Equatorial && ct != ComponentTypes.ComponentType.Ecliptic && ct != ComponentTypes.ComponentType.Galactic && ct != ComponentTypes.ComponentType.Boundaries && ct != ComponentTypes.ComponentType.Systems;
    }

    private boolean filter(String[] names, String filter) {
        if (filter == null || filter.isEmpty()) {
            return true;
        }
        for (String name : names) {
            if (!name.toLowerCase(Locale.ROOT).contains(filter)) continue;
            return true;
        }
        return false;
    }

    private void addObjects(VerticalGroup objectsGroup, List<OwnCheckBox> checkBoxes, ComponentTypes.ComponentType ct, String filter) {
        if (ct == ComponentTypes.ComponentType.Locations) {
            this.addObjectsLocations(objectsGroup, checkBoxes, filter);
        } else {
            this.addObjectsRegular(objectsGroup, checkBoxes, ct, filter);
        }
    }

    private void addObjectsLocations(VerticalGroup objectsGroup, List<OwnCheckBox> checkBoxes, String filter) {
        objectsGroup.clear();
        checkBoxes.clear();
        Array objects = new Array();
        this.scene.findEntitiesByComponentType(ComponentTypes.ComponentType.Locations, (Array<Entity>)objects);
        Array typeNames = new Array(false, objects.size);
        HashMap<String, Pair> typeMap = new HashMap<String, Pair>();
        this.cbMap.clear();
        for (Entity object : objects) {
            String type;
            Base base = (Base)Mapper.base.get(object);
            if (!this.filter(base.names, filter) || this.isHookObject(base)) continue;
            LocationMark loc = (LocationMark)Mapper.loc.get(object);
            boolean hasLoc = loc != null;
            String name = base.getName();
            String defaultType = I18n.msg("gui.location.type.default");
            String string = hasLoc ? (loc.locationType != null ? loc.locationType : defaultType) : (type = ((GraphNode)Mapper.graph.get((Entity)object)).parentName);
            if (!typeMap.containsKey(type)) {
                Array objNames = new Array();
                HashMap objMap = new HashMap();
                typeMap.put(type, new Pair(objMap, objNames));
                typeNames.add((Object)type);
            }
            Pair pair = (Pair)typeMap.get(type);
            ((Array)pair.getSecond()).add((Object)name);
            ((Map)pair.getFirst()).put(name, new FocusView(object));
        }
        typeNames.sort();
        typeMap.forEach((key, value) -> ((Array)value.getSecond()).sort());
        if (typeNames.isEmpty()) {
            objectsGroup.addActor((Actor)new OwnLabel((CharSequence)I18n.msg("gui.elements.type.none"), this.skin));
        } else {
            for (String typeName : typeNames) {
                Pair pair = (Pair)typeMap.get(typeName);
                Array names = (Array)pair.getSecond();
                Map map = (Map)pair.getFirst();
                Array groupCheckBoxes = new Array();
                Table cbs = new Table(this.skin);
                cbs.top().left();
                for (String name : names) {
                    HorizontalGroup objectHGroup = new HorizontalGroup();
                    objectHGroup.space(this.space4);
                    objectHGroup.left();
                    OwnCheckBox cb = new OwnCheckBox(name, this.skin, this.space4);
                    cb.left();
                    IVisibilitySwitch obj = (IVisibilitySwitch)map.get(name);
                    cb.setChecked(obj.isVisible(true));
                    groupCheckBoxes.add((Object)cb);
                    this.cbMap.put(name, cb);
                    cb.addListener(event -> {
                        if (event instanceof ChangeListener.ChangeEvent && map.containsKey(name)) {
                            GaiaSky.postRunnable(() -> {
                                EventManager.publish(Event.PER_OBJECT_VISIBILITY_CMD, (Object)cb, obj, obj.getName(), cb.isChecked());
                                if (Mapper.mesh.has(((FocusView)obj).getEntity())) {
                                    EventManager.publish(Event.CATALOG_VISIBLE, (Object)cb, obj.getName(), cb.isChecked());
                                }
                            });
                            return true;
                        }
                        return false;
                    });
                    objectHGroup.addActor((Actor)cb);
                    if (obj.getDescription() != null) {
                        OwnImageButton meshDescTooltip = new OwnImageButton(this.skin, "tooltip");
                        meshDescTooltip.addListener((EventListener)new OwnTextTooltip(obj.getDescription() == null || obj.getDescription().isEmpty() ? "No description" : obj.getDescription(), this.skin));
                        objectHGroup.addActor((Actor)meshDescTooltip);
                    }
                    cbs.add((Actor)objectHGroup).top().left().padBottom(this.space2).row();
                    checkBoxes.add(cb);
                }
                OwnImageButton selectAll = new OwnImageButton(this.skin, "select-all");
                selectAll.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        for (OwnCheckBox checkBox : groupCheckBoxes) {
                            if (checkBox.isDisabled()) continue;
                            checkBox.setChecked(true);
                        }
                        return true;
                    }
                    return false;
                });
                selectAll.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.select.all"), this.skin));
                OwnImageButton selectNone = new OwnImageButton(this.skin, "select-none");
                selectNone.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        for (OwnCheckBox checkBox : groupCheckBoxes) {
                            if (checkBox.isDisabled()) continue;
                            checkBox.setChecked(false);
                        }
                        return true;
                    }
                    return false;
                });
                selectNone.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.select.none"), this.skin));
                float buttonSize = 17.0f;
                Table buttons = new Table(this.skin);
                buttons.padRight(pad20);
                buttons.add((Actor)selectAll).size(17.0f, 17.0f).right().bottom().padRight(pad10);
                buttons.add((Actor)selectNone).size(17.0f, 17.0f).right().bottom();
                CollapsiblePane cp = new CollapsiblePane(this.stage, typeName, (Actor)cbs, 510.0f, this.skin, "header", "expand-collapse", null, filter != null && !filter.isEmpty(), null, new Actor[]{buttons});
                objectsGroup.addActor((Actor)cp);
            }
        }
        objectsGroup.pack();
    }

    private void addObjectsRegular(VerticalGroup objectsGroup, List<OwnCheckBox> checkBoxes, ComponentTypes.ComponentType ct, String filter) {
        objectsGroup.clear();
        checkBoxes.clear();
        Array objects = new Array();
        this.scene.findEntitiesByComponentType(ct, (Array<Entity>)objects);
        Array names = new Array(false, objects.size);
        HashMap<String, FocusView> objMap = new HashMap<String, FocusView>();
        this.cbMap.clear();
        for (Entity object : objects) {
            Base base = (Base)Mapper.base.get(object);
            String name = base.getName();
            if (name == null || GlobalResources.isNumeric(name) || this.exception(ct, object) || !this.filter(base.names, filter) || this.isHookObject(base)) continue;
            names.add((Object)name);
            objMap.put(name, new FocusView(object));
        }
        names.sort();
        if (names.isEmpty()) {
            objectsGroup.addActor((Actor)new OwnLabel((CharSequence)I18n.msg("gui.elements.type.none"), this.skin));
        } else {
            for (String name : names) {
                HorizontalGroup objectHgroup = new HorizontalGroup();
                objectHgroup.space(this.space4);
                objectHgroup.left();
                OwnCheckBox cb = new OwnCheckBox(name, this.skin, this.space4);
                IVisibilitySwitch obj = (IVisibilitySwitch)objMap.get(name);
                cb.setChecked(obj.isVisible(true));
                this.cbMap.put(name, cb);
                cb.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent && objMap.containsKey(name)) {
                        GaiaSky.postRunnable(() -> {
                            EventManager.publish(Event.PER_OBJECT_VISIBILITY_CMD, (Object)cb, obj, obj.getName(), cb.isChecked());
                            if (Mapper.mesh.has(((FocusView)obj).getEntity())) {
                                EventManager.publish(Event.CATALOG_VISIBLE, (Object)cb, obj.getName(), cb.isChecked());
                            }
                        });
                        return true;
                    }
                    return false;
                });
                objectHgroup.addActor((Actor)cb);
                if (obj.getDescription() != null) {
                    OwnImageButton meshDescTooltip = new OwnImageButton(this.skin, "tooltip");
                    meshDescTooltip.addListener((EventListener)new OwnTextTooltip(obj.getDescription() == null || obj.getDescription().isEmpty() ? "No description" : obj.getDescription(), this.skin));
                    objectHgroup.addActor((Actor)meshDescTooltip);
                }
                objectsGroup.addActor((Actor)objectHgroup);
                checkBoxes.add(cb);
            }
        }
        if (ct.equals((Object)ComponentTypes.ComponentType.Stars)) {
            objectsGroup.addActor((Actor)new OwnLabel((CharSequence)"", this.skin));
            objectsGroup.addActor((Actor)new OwnLabel((CharSequence)TextUtils.breakCharacters(I18n.msg("notif.visibility.stars"), 40), this.skin));
        }
        objectsGroup.pack();
    }

    private Group visibilitySwitcher(ComponentTypes.ComponentType ct, String title, String id) {
        float componentWidth = 495.0f;
        VerticalGroup objectsGroup = new VerticalGroup();
        objectsGroup.space(this.space4);
        objectsGroup.left();
        objectsGroup.columnLeft();
        ArrayList<OwnCheckBox> checkBoxes = new ArrayList<OwnCheckBox>();
        this.addObjects(objectsGroup, checkBoxes, ct, null);
        OwnScrollPane scrollPane = new OwnScrollPane((Actor)objectsGroup, this.skin, "minimalist-nobg");
        scrollPane.setName(id + " scroll");
        scrollPane.setFadeScrollBars(false);
        scrollPane.setScrollingDisabled(true, false);
        scrollPane.setHeight(360.0f);
        scrollPane.setWidth(componentWidth);
        OwnTextField filter = new OwnTextField("", this.skin);
        filter.setWidth(componentWidth);
        filter.setMessageText(I18n.msg("gui.dataset.filter"));
        filter.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.addObjects(objectsGroup, checkBoxes, ct, filter.getText().trim().toLowerCase(Locale.ROOT));
                return true;
            }
            return false;
        });
        HorizontalGroup buttons = new HorizontalGroup();
        buttons.space(pad10);
        OwnTextIconButton selAll = new OwnTextIconButton("", this.skin, "select-all");
        selAll.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.select.all"), this.skin));
        selAll.pad(this.space2);
        selAll.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                GaiaSky.postRunnable(() -> checkBoxes.forEach(i -> i.setChecked(true)));
                return true;
            }
            return false;
        });
        OwnTextIconButton selNone = new OwnTextIconButton("", this.skin, "select-none");
        selNone.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.select.none"), this.skin));
        selNone.pad(this.space2);
        selNone.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                GaiaSky.postRunnable(() -> checkBoxes.forEach(i -> i.setChecked(false)));
                return true;
            }
            return false;
        });
        buttons.addActor((Actor)selAll);
        buttons.addActor((Actor)selNone);
        Table header = new Table(this.skin);
        header.add((Actor)new OwnLabel((CharSequence)TextUtils.trueCapitalise(title), this.skin, "header")).left().pad(5.0f).width(componentWidth - 100.0f);
        header.add((Actor)buttons).right().pad(5.0f).width(100.0f);
        VerticalGroup group = new VerticalGroup();
        group.left();
        group.columnLeft();
        group.space(this.space8);
        group.addActor((Actor)header);
        group.addActor((Actor)filter);
        group.addActor((Actor)scrollPane);
        return group;
    }

    private boolean isHookObject(Base b) {
        return b.archetype.getName().equals("FadeNode") || b.archetype.getName().equals("OrbitalElementsGroup") || b.archetype.getName().equals("GenericCatalog") || b.archetype.getName().equals("Invisible") || b.getName().endsWith("-hook");
    }

    private boolean exception(ComponentTypes.ComponentType ct, Entity object) {
        return ct == ComponentTypes.ComponentType.Planets && Mapper.trajectory.has(object) || Mapper.particleSet.has(object) || Mapper.starSet.has(object);
    }

    @Override
    protected boolean accept() {
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.PER_OBJECT_VISIBILITY_CMD) {
            Object name;
            Object object = data[0];
            if (object instanceof IVisibilitySwitch) {
                CheckBox cb;
                IVisibilitySwitch obj = (IVisibilitySwitch)object;
                name = (String)data[1];
                boolean checked = (Boolean)data[2];
                if (this.currentCt != null && obj.hasCt(this.currentCt) && (cb = this.cbMap.get(name)) != null && source != cb) {
                    cb.setProgrammaticChangeEvents(false);
                    cb.setChecked(checked);
                    cb.setProgrammaticChangeEvents(true);
                }
            }
            if ((name = data[0]) instanceof Entity) {
                CheckBox cb;
                Entity entity = (Entity)name;
                Base base = (Base)Mapper.base.get(entity);
                String name2 = (String)data[1];
                boolean checked = (Boolean)data[2];
                if (this.currentCt != null && base.hasCt(this.currentCt) && (cb = this.cbMap.get(name2)) != null && source != cb) {
                    cb.setProgrammaticChangeEvents(false);
                    cb.setChecked(checked);
                    cb.setProgrammaticChangeEvents(true);
                }
            }
        } else if (event == Event.CATALOG_VISIBLE) {
            String name = (String)data[0];
            boolean checked = (Boolean)data[1];
            Entity entity = this.scene.getEntity(name);
            if (entity != null) {
                CheckBox cb;
                Base base = (Base)Mapper.base.get(entity);
                Mesh mesh = (Mesh)Mapper.mesh.get(entity);
                if (mesh != null && this.currentCt != null && base.hasCt(this.currentCt) && (cb = this.cbMap.get(name)) != null && source != cb) {
                    cb.setProgrammaticChangeEvents(false);
                    cb.setChecked(checked);
                    cb.setProgrammaticChangeEvents(true);
                }
            }
        }
    }

    private /* synthetic */ boolean lambda$build$0(Button button, ComponentTypes.ComponentType ct, String name, com.badlogic.gdx.scenes.scene2d.Event event) {
        if (event instanceof ChangeListener.ChangeEvent && button.isChecked()) {
            Group elementsList = this.visibilitySwitcher(ct, TextUtils.capitalise(ct.getName()), ct.getName());
            this.elementsCell.clearActor();
            this.elementsCell.setActor((Actor)elementsList);
            this.content.pack();
            this.currentComponentType = name;
            this.currentCt = ct;
            return true;
        }
        return false;
    }
}

