/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.gui.beans.ComboBoxBean;
import gaiasky.gui.window.GenericDialog;
import gaiasky.util.Settings;
import gaiasky.util.camera.rec.KeyframesManager;
import gaiasky.util.i18n.I18n;
import gaiasky.util.parse.Parser;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnSelectBox;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.validator.DoubleValidator;
import java.text.DecimalFormat;

public class KeyframePreferencesWindow
extends GenericDialog {
    private final DecimalFormat nf3;
    public OwnTextField camcorderFps;
    private OwnSelectBox<ComboBoxBean> posMethod;

    public KeyframePreferencesWindow(Stage stage, Skin skin) {
        super(I18n.msg("gui.keyframes.preferences"), skin, stage);
        this.setModal(true);
        this.nf3 = new DecimalFormat("0.000");
        this.setAcceptText(I18n.msg("gui.saveprefs"));
        this.setCancelText(I18n.msg("gui.cancel"));
        this.buildSuper();
    }

    @Override
    protected void build() {
        Object[] interpolation = new ComboBoxBean[]{new ComboBoxBean(I18n.msg("gui.interpolation.linear"), KeyframesManager.PathType.LINEAR.ordinal()), new ComboBoxBean(I18n.msg("gui.interpolation.catmull"), KeyframesManager.PathType.CATMULL_ROM_SPLINE.ordinal()), new ComboBoxBean(I18n.msg("gui.interpolation.bspline"), KeyframesManager.PathType.B_SPLINE.ordinal())};
        OwnLabel generalTitle = new OwnLabel((CharSequence)I18n.msg("gui.general"), this.skin, "hud-header");
        OwnLabel camfpsLabel = new OwnLabel((CharSequence)I18n.msg("gui.target.fps"), this.skin);
        this.camcorderFps = new OwnTextField(this.nf3.format(Settings.settings.camrecorder.targetFps), this.skin, new DoubleValidator(0.05, 1000.0));
        this.camcorderFps.setWidth(240.0f);
        OwnLabel interpTitle = new OwnLabel((CharSequence)I18n.msg("gui.keyframes.interp"), this.skin, "hud-header");
        OwnLabel pos = new OwnLabel((CharSequence)I18n.msg("gui.cam.pos"), this.skin);
        this.posMethod = new OwnSelectBox(this.skin);
        this.posMethod.setItems(interpolation);
        this.posMethod.setSelectedIndex(Settings.settings.camrecorder.keyframe.position.ordinal());
        this.posMethod.setItems(interpolation);
        this.posMethod.setWidth(240.0f);
        OwnLabel orientation = new OwnLabel((CharSequence)I18n.msg("gui.cam.orientation"), this.skin);
        OwnLabel orientationMethod = new OwnLabel((CharSequence)I18n.msg("gui.interpolation.slerp"), this.skin);
        OwnLabel time = new OwnLabel((CharSequence)I18n.msg("gui.time"), this.skin);
        OwnLabel timeMethod = new OwnLabel((CharSequence)I18n.msg("gui.interpolation.linear"), this.skin);
        this.content.add((Actor)generalTitle).left().top().colspan(2).padBottom(pad18).row();
        this.content.add((Actor)camfpsLabel).left().padRight(pad18).padBottom(pad18 * 3.0f);
        this.content.add((Actor)this.camcorderFps).left().padBottom(pad18 * 3.0f).row();
        this.content.add((Actor)interpTitle).left().top().colspan(2).padBottom(pad18).row();
        this.content.add((Actor)pos).left().padRight(pad18).padBottom(pad18);
        this.content.add(this.posMethod).left().padBottom(pad18).row();
        this.content.add((Actor)orientation).left().padRight(pad18).padBottom(pad18);
        this.content.add((Actor)orientationMethod).left().padBottom(pad18).row();
        this.content.add((Actor)time).left().padRight(pad18).padBottom(pad18 * 3.0f);
        this.content.add((Actor)timeMethod).left().padBottom(pad18 * 3.0f).row();
    }

    @Override
    protected boolean accept() {
        EventManager.publish(Event.CAMRECORDER_FPS_CMD, (Object)this, Parser.parseDouble(this.camcorderFps.getText()));
        Settings.settings.camrecorder.keyframe.position = KeyframesManager.PathType.values()[this.posMethod.getSelectedIndex()];
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }
}

