/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import gaiasky.gui.window.FileNameWindow;
import gaiasky.util.GlobalResources;
import gaiasky.util.SysUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnTextArea;

public class KeyframesExportWindow
extends FileNameWindow {
    public OwnCheckBox useOptFlowCam;

    public KeyframesExportWindow(String defaultName, Stage stage, Skin skin) {
        super(defaultName, stage, skin);
    }

    @Override
    protected void build() {
        super.build();
        this.content.row();
        boolean optFlowCamEnabled = !SysUtils.isFlatpak();
        this.useOptFlowCam = new OwnCheckBox("Use OptFlowCam method to compute camera path", this.skin, 20.0f);
        this.useOptFlowCam.setChecked(false);
        this.useOptFlowCam.setDisabled(!optFlowCamEnabled);
        String plInfoStr = I18n.msg("gui.keyframes.export.optflowcam");
        int ssLines = GlobalResources.countOccurrences(plInfoStr, '\n');
        OwnTextArea plInfo = new OwnTextArea(plInfoStr, this.skin, "info");
        plInfo.setDisabled(true);
        plInfo.setPrefRows(ssLines + 6);
        plInfo.setWidth(600.0f);
        plInfo.clearListeners();
        if (optFlowCamEnabled) {
            this.content.add((Actor)this.useOptFlowCam).colspan(2).left().padTop(20.0f).row();
            this.content.add((Actor)plInfo).colspan(2).right().padTop(20.0f);
        }
    }
}

