/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.main.KeyBindings;
import gaiasky.gui.window.FileNameWindow;
import gaiasky.gui.window.GenericDialog;
import gaiasky.gui.window.KeyframePreferencesWindow;
import gaiasky.gui.window.KeyframesExportWindow;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Keyframes;
import gaiasky.scene.view.BaseView;
import gaiasky.scene.view.FocusView;
import gaiasky.scene.view.KeyframesView;
import gaiasky.scene.view.VertsView;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.TextUtils;
import gaiasky.util.camera.rec.Keyframe;
import gaiasky.util.camera.rec.KeyframesManager;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.InterpolationDouble;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.parse.Parser;
import gaiasky.util.scene2d.FileChooser;
import gaiasky.util.scene2d.OwnImageButton;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnSlider;
import gaiasky.util.scene2d.OwnTextButton;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.scene2d.OwnTextHotkeyTooltip;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import gaiasky.util.validator.FloatValidator;
import gaiasky.util.validator.LengthValidator;
import gaiasky.util.validator.RegexpValidator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.jafama.FastMath;

public class KeyframesWindow
extends GenericDialog
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(KeyframesWindow.class);
    private final DecimalFormat secondsFormatter;
    private final DateTimeFormatter dateFormat;
    private final KeyframesManager manager;
    private final Map<Keyframe, Cell<?>> secondsCells;
    private final Map<Keyframe, Cell<?>> namesCells;
    private final Map<Keyframe, OwnLabel> keyframeNames;
    private final Object windowLock = new Object();
    private final DateFormat df;
    private final VertsView vertsView;
    private final KeyframesView view;
    private final float buttonSize;
    private final Editing editing;
    private OwnTextField secondsInput;
    private OwnTextField nameInput;
    private Table keyframesTable;
    private Table mediaTable;
    private Cell<?> notice;
    private Button visibility;
    private OwnScrollPane rightScroll;
    private String lastKeyframeFileName = null;
    private final Entity keyframesPathEntity;
    private final Keyframes keyframesComponent;
    private long lastMs = 0L;
    private Color colorBak;
    private Button skipBack;
    private Button stepBack;
    private Button playPause;
    private Button stepForward;
    private Button skipForward;
    private Cell timelineCell;
    private OwnSlider timelineSlider;

    public KeyframesWindow(Scene scene, Stage stage, Skin skin) {
        super(I18n.msg("gui.keyframes.title"), skin, stage);
        this.manager = KeyframesManager.instance;
        this.buttonSize = 38.0f;
        this.view = new KeyframesView(scene);
        this.vertsView = new VertsView();
        this.enterExit = false;
        this.editing = new Editing();
        this.secondsCells = new HashMap();
        this.namesCells = new HashMap();
        this.keyframeNames = new HashMap<Keyframe, OwnLabel>();
        this.secondsFormatter = new DecimalFormat("000.00");
        this.df = new SimpleDateFormat("yyyyMMdd_HH-mm-ss-SSS");
        this.dateFormat = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.MEDIUM).withLocale(I18n.locale).withZone(ZoneOffset.UTC);
        this.setModal(false);
        this.setCancelText(I18n.msg("gui.close"));
        this.buildSuper();
        Entity entity = scene.archetypes().get("KeyframesPathObject").createEntity();
        Base base = (Base)Mapper.base.get(entity);
        base.setName("keyframed.camera.path");
        base.setComponentType(ComponentTypes.ComponentType.Keyframes);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        graph.setParent("Universe");
        scene.initializeEntity(entity);
        scene.setUpEntity(entity);
        this.keyframesComponent = (Keyframes)Mapper.keyframes.get(entity);
        this.keyframesComponent.keyframes = this.manager.keyframes;
        this.keyframesPathEntity = entity;
        EventManager.publish(Event.SCENE_ADD_OBJECT_CMD, this, this.keyframesPathEntity, false);
        this.view.setEntity(this.keyframesPathEntity);
    }

    @Override
    protected void build() {
        Table top = new Table(this.skin);
        Table left = new Table(this.skin);
        left.align(10);
        left.setBackground("textfield-disabled");
        Table right = new Table(this.skin);
        right.align(10);
        OwnTextIconButton addKeyframe = new OwnTextIconButton(I18n.msg("gui.keyframes.add.end"), this.skin, "add");
        String tooltip = I18n.msg("gui.tooltip.kf.add.end");
        String action = "action.keyframe";
        String shortcutKeys = KeyBindings.instance.getStringKeys(action);
        if (shortcutKeys != null) {
            addKeyframe.addListener((EventListener)new OwnTextHotkeyTooltip(tooltip, shortcutKeys, this.skin));
        } else {
            addKeyframe.addListener((EventListener)new OwnTextTooltip(tooltip, this.skin));
        }
        addKeyframe.pad(pad10);
        left.add((Actor)addKeyframe).left().pad(pad10, pad10, 0.0f, pad10).colspan(2).padBottom(pad34).row();
        addKeyframe.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                return this.addKeyframe();
            }
            return false;
        });
        FloatValidator secondsValidator = new FloatValidator(1.0E-4f, 9999.0f);
        secondsValidator.setIsValidCallback(() -> addKeyframe.setDisabled(false));
        secondsValidator.setIsInvalidCallback(() -> addKeyframe.setDisabled(true));
        this.secondsInput = new OwnTextField("1.0", this.skin, secondsValidator);
        this.secondsInput.setWidth(150.0f);
        OwnLabel secondsLabel = new OwnLabel((CharSequence)(I18n.msg("gui.keyframes.secsafter") + ":"), this.skin);
        left.add((Actor)secondsLabel).center().left().padRight(pad18).padBottom(pad18).padLeft(pad10);
        left.add((Actor)this.secondsInput).center().left().padBottom(pad18).padRight(pad10).row();
        LengthValidator lengthValidator = new LengthValidator(0, 15);
        RegexpValidator nameValidator = new RegexpValidator(lengthValidator, "^[^*&%\\s\\+\\=\\\\\\/@#\\$&\\*()~]*$");
        this.nameInput = new OwnTextField("", this.skin, nameValidator);
        this.nameInput.setWidth(150.0f);
        OwnLabel nameLabel = new OwnLabel((CharSequence)(I18n.msg("gui.keyframes.name") + ":"), this.skin);
        left.add((Actor)nameLabel).center().left().padRight(pad18).padBottom(pad18).padLeft(pad10);
        left.add((Actor)this.nameInput).center().left().padBottom(pad18).padRight(pad10).row();
        ComponentTypes.ComponentType ct = ComponentTypes.ComponentType.Keyframes;
        Image icon = new Image(this.skin.getDrawable(ct.style));
        this.visibility = new OwnTextIconButton(TextUtils.capitalise(I18n.msg("gui.keyframes.visibility")), icon, this.skin, "toggle");
        String[] hk = KeyBindings.instance.getStringKeys("action.toggle/" + ct.key, true);
        if (hk != null && hk.length > 0) {
            this.visibility.addListener((EventListener)new OwnTextHotkeyTooltip(TextUtils.capitalise(Objects.requireNonNull(ct.getName())), hk, this.skin));
        } else {
            this.visibility.addListener((EventListener)new OwnTextTooltip(TextUtils.capitalise(Objects.requireNonNull(ct.getName())), this.skin));
        }
        this.visibility.setChecked(GaiaSky.instance.sceneRenderer.isOn(ct));
        this.visibility.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this.visibility, ct.key, this.visibility.isChecked());
                return true;
            }
            return false;
        });
        left.add((Actor)this.visibility).colspan(2).center().pad(pad18).row();
        left.pack();
        OwnLabel keyframesTitle = new OwnLabel((CharSequence)I18n.msg("gui.keyframes.list"), this.skin, "hud-header");
        this.mediaTable = new Table(this.skin);
        this.mediaTable.setBackground("sc-engine-power-bg");
        this.keyframesTable = this.buildKeyframesTable();
        this.checkKeyframesTable();
        this.rightScroll = new OwnScrollPane((Actor)this.keyframesTable, this.skin, "minimalist-nobg");
        this.rightScroll.setExpand(true);
        this.rightScroll.setScrollingDisabled(true, false);
        this.rightScroll.setHeight(350.0f);
        this.rightScroll.setWidth(820.0f);
        this.rightScroll.setFadeScrollBars(false);
        right.add((Actor)keyframesTitle).top().left().padBottom(pad18).row();
        right.add((Actor)this.rightScroll).width(820.0f).height(250.0f).center().left().row();
        right.pack();
        float buttonSize = 56.0f;
        OwnTextIconButton normalizeTime = new OwnTextIconButton(I18n.msg("gui.keyframes.normalize"), this.skin, "project");
        normalizeTime.setHeight(buttonSize);
        normalizeTime.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.kf.normalize"), this.skin));
        normalizeTime.pad(pad18);
        normalizeTime.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.manager.keyframes != null && this.manager.keyframes.size() > 2) {
                    Keyframe kf1;
                    Keyframe kf0;
                    int i;
                    Vector3D aux = new Vector3D();
                    int n = this.manager.keyframes.size();
                    double totalTime = 0.0;
                    double totalDist = 0.0;
                    for (i = 1; i < n; ++i) {
                        kf0 = this.manager.keyframes.get(i - 1);
                        kf1 = this.manager.keyframes.get(i);
                        totalTime += kf1.seconds;
                        totalDist += aux.set(kf1.pos).sub(kf0.pos).len();
                    }
                    if (totalDist > 0.0) {
                        for (i = 1; i < n; ++i) {
                            kf0 = this.manager.keyframes.get(i - 1);
                            kf1 = this.manager.keyframes.get(i);
                            double dist = aux.set(kf1.pos).sub(kf0.pos).len();
                            kf1.seconds = totalTime * dist / totalDist;
                        }
                        this.reinitialiseKeyframes(this.manager.keyframes, null);
                    } else {
                        GaiaSky.popupNotification(I18n.msg("gui.keyframes.normalize.dist.zero"), 10.0f, this);
                    }
                    KeyframesView keyframesView = this.view;
                    synchronized (keyframesView) {
                        this.view.setEntity(this.keyframesPathEntity);
                        this.view.unselect();
                    }
                    logger.info(I18n.msg("gui.keyframes.normalize.done"));
                    this.checkKeyframeTimings();
                } else {
                    String text = I18n.msg("gui.keyframes.none");
                    GaiaSky.popupNotification(text, 10.0f, this, Logger.LoggerLevel.WARN, null);
                }
                return true;
            }
            return false;
        });
        OwnTextIconButton open = new OwnTextIconButton(I18n.msg("gui.keyframes.load"), this.skin, "open");
        open.setHeight(buttonSize);
        open.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.kf.load"), this.skin));
        open.pad(pad10);
        open.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                FileChooser fc = new FileChooser(I18n.msg("gui.download.pickloc"), this.skin, this.stage, SysUtils.getDefaultCameraDir(), FileChooser.FileChooserTarget.FILES);
                fc.setShowHidden(Settings.settings.program.fileChooser.showHidden);
                fc.setShowHiddenConsumer(showHidden -> {
                    Settings.settings.program.fileChooser.showHidden = showHidden;
                });
                fc.setFileFilter(pathname -> pathname.getFileName().toString().endsWith(".gkf"));
                fc.setAcceptedFiles("*.gkf");
                fc.setResultListener((success, result) -> {
                    if (success) {
                        if (Files.exists(result, new LinkOption[0]) && Files.isRegularFile(result, new LinkOption[0])) {
                            try {
                                List<Keyframe> kfs = this.manager.loadKeyframesFile(result);
                                this.reinitialiseKeyframes(kfs, null);
                                KeyframesView keyframesView = this.view;
                                synchronized (keyframesView) {
                                    this.view.setEntity(this.keyframesPathEntity);
                                    this.view.unselect();
                                }
                                this.lastKeyframeFileName = result.getFileName().toString();
                                GaiaSky.popupNotification(I18n.msg("gui.keyframes.load.success", this.manager.keyframes.size(), result.getFileName()), 10.0f, this);
                            }
                            catch (RuntimeException e) {
                                logger.error(I18n.msg("gui.keyframes.load.error", result.getFileName()), e);
                                OwnLabel warn = new OwnLabel((CharSequence)I18n.msg("error.loading.format", result.getFileName()), this.skin);
                                warn.setColor(1.0f, 0.4f, 0.4f, 1.0f);
                                this.notice.setActor((Actor)warn);
                                return false;
                            }
                        }
                        logger.error(I18n.msg("error.loading.notexistent", result.getFileName()));
                        OwnLabel warn = new OwnLabel((CharSequence)I18n.msg("error.loading.notexistent", result.getFileName()), this.skin);
                        warn.setColor(1.0f, 0.4f, 0.4f, 1.0f);
                        this.notice.setActor((Actor)warn);
                        return false;
                    }
                    this.notice.clearActor();
                    this.pack();
                    return true;
                });
                fc.show(this.stage);
                return true;
            }
            return false;
        });
        OwnTextIconButton save = new OwnTextIconButton(I18n.msg("gui.keyframes.save"), this.skin, "save");
        save.setHeight(buttonSize);
        save.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.kf.save"), this.skin));
        save.pad(pad10);
        save.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.manager.keyframes == null || this.manager.keyframes.isEmpty()) {
                    String text = I18n.msg("gui.keyframes.none");
                    GaiaSky.popupNotification(text, 10.0f, this, Logger.LoggerLevel.WARN, null);
                    return true;
                }
                String suggestedName = this.lastKeyframeFileName == null ? this.df.format(new Date()) + "_keyframes.gkf" : this.lastKeyframeFileName;
                FileNameWindow fnw = this.getFileNameWindow(suggestedName);
                fnw.show(this.stage);
                return true;
            }
            return false;
        });
        OwnTextIconButton export = new OwnTextIconButton(I18n.msg("gui.keyframes.export"), this.skin, "export");
        export.setHeight(buttonSize);
        export.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.kf.export"), this.skin));
        export.pad(pad10);
        export.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.manager.keyframes == null || this.manager.keyframes.isEmpty()) {
                    String text = I18n.msg("gui.keyframes.none");
                    GaiaSky.popupNotification(text, 10.0f, this, Logger.LoggerLevel.WARN, null);
                    return true;
                }
                String suggestedName = this.df.format(new Date()) + ".gsc";
                KeyframesExportWindow fnw = new KeyframesExportWindow(suggestedName, this.stage, this.skin);
                OwnTextField textField = fnw.getFileNameField();
                fnw.setAcceptListener(() -> {
                    if (textField.isValid()) {
                        if (fnw.useOptFlowCam.isChecked()) {
                            Path mainPath = SysUtils.getProgramDirectory();
                            Path outputFile = SysUtils.getDefaultCameraDir().resolve(textField.getText());
                            if (Files.exists(mainPath.resolve("core/scripts/optflowcam"), new LinkOption[0])) {
                                Path loc = mainPath.resolve("core/scripts/optflowcam");
                                this.manager.runOptFlowCamScript(loc, outputFile);
                            } else if (Files.exists(mainPath.resolve("../extra/optflowcam"), new LinkOption[0])) {
                                Path loc = mainPath.resolve("../extra/optflowcam");
                                this.manager.runOptFlowCamScript(loc, outputFile);
                            } else {
                                String msg = I18n.msg("error.loading.notexistent", "OptFlowCam script: " + String.valueOf(mainPath));
                                GaiaSky.popupNotification(msg, 10.0f, this, Logger.LoggerLevel.WARN, null);
                            }
                        } else {
                            EventManager.publish(Event.KEYFRAMES_EXPORT, (Object)fnw, this.manager.keyframes, textField.getText());
                            this.notice.clearActor();
                        }
                    } else {
                        OwnLabel warn = new OwnLabel((CharSequence)I18n.msg("error.file.name.notvalid", textField.getText()), this.skin);
                        warn.setColor(1.0f, 0.4f, 0.4f, 1.0f);
                        this.notice.setActor((Actor)warn);
                    }
                });
                fnw.show(this.stage);
                return true;
            }
            return false;
        });
        OwnTextIconButton preferences = new OwnTextIconButton(I18n.msg("gui.preferences"), this.skin, "preferences");
        preferences.setHeight(buttonSize);
        preferences.pad(pad10);
        preferences.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.kf.editprefs"), this.skin));
        preferences.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                KeyframePreferencesWindow kpw = new KeyframePreferencesWindow(this.stage, this.skin);
                kpw.setAcceptListener(() -> GaiaSky.postRunnable(() -> {
                    KeyframesView keyframesView = this.view;
                    synchronized (keyframesView) {
                        this.view.setEntity(this.keyframesPathEntity);
                        this.view.resamplePath();
                        this.reinitialiseKeyframes(this.manager.keyframes, null);
                    }
                }));
                kpw.setCancelListener(() -> {});
                kpw.show(this.stage, this.me.getWidth(), 0.0f);
                return true;
            }
            return false;
        });
        top.add((Actor)open).padRight(pad10);
        top.add((Actor)save).padRight(pad10);
        top.add((Actor)export).padRight(pad34 * 2.0f);
        top.add((Actor)normalizeTime).padRight(pad34 * 2.0f);
        top.add((Actor)preferences).padRight(pad10);
        this.content.add((Actor)top).colspan(2).top().left().padBottom(pad34).row();
        this.content.add((Actor)left).top().left().padRight(pad18 * 2.0f).padBottom(pad18 * 3.0f);
        this.content.add((Actor)right).width(830.0f).top().left().padBottom(pad18).row();
        this.content.add((Actor)this.mediaTable).colspan(2).expandX().top().center().padBottom(pad10).row();
        this.notice = this.content.add();
        this.notice.padBottom(pad10).colspan(2).expandY().center().colspan(2);
        OwnTextButton clear = new OwnTextButton(I18n.msg("gui.clear"), this.skin);
        clear.setName("clear");
        clear.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                GaiaSky.postRunnable(this::clean);
                return true;
            }
            return false;
        });
        this.buttonGroup.addActorAt(0, (Actor)clear);
        OwnTextButton hide = new OwnTextButton(I18n.msg("gui.hide"), this.skin);
        hide.setName("hide");
        hide.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.hide();
                return true;
            }
            return false;
        });
        this.buttonGroup.addActorAt(1, (Actor)hide);
        this.recalculateButtonSize();
    }

    private FileNameWindow getFileNameWindow(String suggestedName) {
        FileNameWindow fnw = new FileNameWindow(suggestedName, this.stage, this.skin);
        OwnTextField textField = fnw.getFileNameField();
        fnw.setAcceptListener(() -> {
            if (textField.isValid()) {
                EventManager.publish(Event.KEYFRAMES_FILE_SAVE, (Object)fnw, this.manager.keyframes, textField.getText());
                this.lastKeyframeFileName = textField.getText();
                this.notice.clearActor();
            } else {
                OwnLabel warn = new OwnLabel((CharSequence)I18n.msg("error.file.name.notvalid", textField.getText()), this.skin);
                warn.setColor(1.0f, 0.4f, 0.4f, 1.0f);
                this.notice.setActor((Actor)warn);
            }
            this.pack();
        });
        return fnw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addKeyframe(int index, Vector3D cPos, Vector3D cDir, Vector3D cUp, Vector3D cTarget, Instant cTime) {
        block12: {
            try {
                boolean secOk = this.secondsInput.isValid();
                boolean nameOk = this.nameInput.isValid();
                if (secOk && nameOk) {
                    boolean insert;
                    double secsAfter = this.manager.keyframes.isEmpty() ? 0.0 : Double.parseDouble(this.secondsInput.getText());
                    String ni = this.nameInput.getText();
                    String name = ni != null && !ni.isEmpty() ? ni : I18n.msg("gui.keyframes.name.default", this.manager.keyframes.size() + 1);
                    Keyframe kf = new Keyframe(name, cPos, cDir, cUp, cTarget, cTime, secsAfter, false);
                    boolean bl = insert = index >= 0 && index != this.manager.keyframes.size();
                    if (!insert) {
                        List<Keyframe> list = this.manager.keyframes;
                        synchronized (list) {
                            this.manager.keyframes.add(kf);
                        }
                        double prevT = 0.0;
                        for (Keyframe kfr : this.manager.keyframes) {
                            if (kfr == kf) break;
                            prevT += kfr.seconds;
                        }
                        this.addKeyframeToTable(kf, prevT, this.manager.keyframes.size() - 1, this.keyframesTable, true);
                    } else {
                        List<Keyframe> list = this.manager.keyframes;
                        synchronized (list) {
                            this.manager.keyframes.add(index, kf);
                        }
                    }
                    GaiaSky.postRunnable(() -> {
                        if (insert) {
                            this.reinitialiseKeyframes(this.manager.keyframes, kf);
                        } else {
                            this.checkKeyframesTable();
                        }
                        this.scrollToKeyframe(kf);
                    });
                    break block12;
                }
                logger.info(I18n.msg("gui.keyframes.notadded") + "-" + I18n.msg("gui.keyframes.error.values", secOk ? I18n.msg("gui.ok") : I18n.msg("gui.wrong"), nameOk ? I18n.msg("gui.ok") : I18n.msg("gui.wrong")));
            }
            catch (Exception e) {
                logger.error(I18n.msg("gui.keyframes.notadded") + " - " + I18n.msg("gui.keyframes.error.input"), e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addKeyframe() {
        Instant cTime;
        this.checkKeyframesTableBeforeAdd();
        Vector3D cPos = new Vector3D();
        Vector3D cDir = new Vector3D();
        Vector3D cUp = new Vector3D();
        Vector3D cTarget = null;
        ICamera cam = GaiaSky.instance.getICamera();
        Object object = this.windowLock;
        synchronized (object) {
            cTime = this.manager.t.getTime();
            cPos.set(this.manager.pos);
            cDir.set(this.manager.dir);
            cUp.set(this.manager.up);
            if (cam.hasFocus()) {
                Vector3Q focusPos = new Vector3Q();
                cam.getFocus().getAbsolutePosition(focusPos);
                cTarget = new Vector3D();
                focusPos.put(cTarget);
            }
        }
        boolean result = this.addKeyframe(-1, cPos, cDir, cUp, cTarget, cTime);
        this.updateCurrentPathAndTimeline();
        this.checkKeyframeTimings();
        return result;
    }

    private Table buildKeyframesTable() {
        Table table = new Table(this.skin);
        table.align(10);
        table.setWidth(700.0f);
        this.addKeyframesToTable(this.manager.keyframes, table);
        table.pack();
        return table;
    }

    private void addMediaControlsToTable(Table table) {
        table.setWidth(1250.0f);
        this.skipBack = new OwnImageButton(this.skin, "media-skip-backward");
        this.skipBack.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.KEYFRAME_PLAY_FRAME, this.skipBack, 0L);
                return true;
            }
            return false;
        });
        this.skipBack.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.keyframes.start"), this.skin));
        this.stepBack = new OwnImageButton(this.skin, "media-step-backward");
        this.stepBack.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.KEYFRAME_PLAY_FRAME, this.stepBack, FastMath.max((long)0L, (long)(this.manager.currentPath.i - 1L)));
                return true;
            }
            return false;
        });
        this.stepBack.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.keyframes.skip.backward"), this.skin));
        this.playPause = new OwnImageButton(this.skin, "media-play-pause");
        this.playPause.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.playPause.isChecked()) {
                    if (this.manager.currentPath != null) {
                        this.manager.play();
                    }
                } else if (this.manager.currentPath != null) {
                    this.manager.pause();
                }
                return true;
            }
            return false;
        });
        this.playPause.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.keyframes.play.pause"), this.skin));
        this.stepForward = new OwnImageButton(this.skin, "media-step-forward");
        this.stepForward.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.KEYFRAME_PLAY_FRAME, this.stepForward, FastMath.min((long)(this.manager.currentPath.n - 1L), (long)(this.manager.currentPath.i + 1L)));
                return true;
            }
            return false;
        });
        this.stepForward.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.keyframes.skip.forward"), this.skin));
        this.skipForward = new OwnImageButton(this.skin, "media-skip-forward");
        this.skipForward.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.KEYFRAME_PLAY_FRAME, this.skipForward, this.manager.currentPath.n - 1L);
                return true;
            }
            return false;
        });
        this.skipForward.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.keyframes.end"), this.skin));
        HorizontalGroup mediaButtons = new HorizontalGroup();
        mediaButtons.center();
        mediaButtons.space(pad18);
        mediaButtons.addActor((Actor)this.skipBack);
        mediaButtons.addActor((Actor)this.stepBack);
        mediaButtons.addActor((Actor)this.playPause);
        mediaButtons.addActor((Actor)this.stepForward);
        mediaButtons.addActor((Actor)this.skipForward);
        table.add((Actor)mediaButtons).center().pad(pad10).row();
        this.timelineCell = table.add().center().pad(pad10);
        this.updateCurrentPathAndTimeline();
    }

    private void updateCurrentPathAndTimeline() {
        if (this.timelineCell != null && this.manager.keyframes != null && this.manager.keyframes.size() > 1) {
            this.manager.regenerateCameraPath();
            this.timelineSlider = new OwnSlider(0.0f, this.manager.currentPath.n - 1L, 1.0f, this.skin);
            this.timelineSlider.setWidth(1250.0f);
            this.timelineSlider.setValuePrefix(I18n.msg("gui.keyframes.frame").strip() + " ");
            this.timelineSlider.setValueFormatter(new DecimalFormat("######0"));
            this.timelineSlider.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    long frame = (long)this.timelineSlider.getValue();
                    EventManager.publish(Event.KEYFRAME_PLAY_FRAME, (Object)this.timelineSlider, frame);
                    return true;
                }
                return false;
            });
            this.timelineCell.clearActor();
            this.timelineCell.setActor((Actor)this.timelineSlider);
            this.mediaTable.pack();
        }
    }

    private void checkKeyframesTableBeforeAdd() {
        if (this.manager.keyframes.isEmpty()) {
            this.keyframesTable.clear();
        }
    }

    private void checkKeyframesTable() {
        if (this.manager.keyframes.isEmpty()) {
            if (this.mediaTable != null) {
                this.mediaTable.setVisible(false);
            }
            if (this.keyframesTable != null) {
                OwnLabel emptyList = new OwnLabel((CharSequence)TextUtils.breakCharacters(I18n.msg("gui.keyframes.empty"), 65), this.skin, "default-pink");
                this.keyframesTable.add((Actor)emptyList).center();
            }
        } else if (this.manager.keyframes.size() == 1) {
            if (this.mediaTable != null) {
                this.mediaTable.setVisible(false);
            }
        } else if (this.mediaTable != null) {
            this.mediaTable.setVisible(true);
        }
        this.checkKeyframeTimings();
    }

    private void checkKeyframeTimings() {
        if (!this.manager.checkKeyframeTimings() && this.notice != null) {
            OwnLabel warn = new OwnLabel((CharSequence)I18n.msg("gui.keyframes.timings", Settings.settings.camrecorder.targetFps), this.skin);
            warn.setColor(1.0f, 0.4f, 0.4f, 1.0f);
            this.notice.setActor((Actor)warn);
        } else if (this.notice != null) {
            this.notice.clearActor();
        }
        this.pack();
    }

    private void addKeyframesToTable(List<Keyframe> keyframes, Table table) {
        if (!keyframes.isEmpty()) {
            int i = 0;
            double prevT = 0.0;
            for (Keyframe kf : keyframes) {
                this.addKeyframeToTable(kf, prevT, i, table);
                prevT += kf.seconds;
                ++i;
            }
        }
        this.addMediaControlsToTable(this.mediaTable);
        this.checkKeyframesTable();
        if (this.keyframesComponent != null) {
            GaiaSky.postRunnable(() -> {
                this.keyframesComponent.keyframes = keyframes;
                KeyframesView keyframesView = this.view;
                synchronized (keyframesView) {
                    this.view.setEntity(this.keyframesPathEntity);
                    this.view.refreshData();
                }
            });
        }
    }

    private void addKeyframeToTable(Keyframe kf, double prevT, int index, Table table) {
        this.addKeyframeToTable(kf, prevT, index, table, false);
    }

    private void addFrameSeconds(Keyframe kf, double prevT, int index, Table table) {
        Cell<?> secondsCell;
        OwnLabel secondsL = new OwnLabel((CharSequence)this.secondsFormatter.format(prevT + kf.seconds), this.skin, "hud-subheader");
        secondsL.setWidth(95.0f);
        if (this.secondsCells.containsKey(kf)) {
            secondsCell = this.secondsCells.get(kf);
        } else {
            secondsCell = table.add();
            this.secondsCells.put(kf, secondsCell);
        }
        secondsCell.setActor((Actor)secondsL).left().padRight(pad18 / 2.0f).padBottom(pad10);
        secondsL.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.kf.seconds", kf.seconds, Settings.settings.camrecorder.targetFps), this.skin));
        if (index > 0) {
            secondsL.addListener(event -> {
                InputEvent ie;
                if (event instanceof InputEvent && (ie = (InputEvent)event).getType().equals((Object)InputEvent.Type.touchDown)) {
                    if (this.editing.notEmpty()) {
                        this.editing.revert();
                        this.editing.unset();
                    }
                    String valText = secondsL.getText().toString();
                    secondsL.clear();
                    this.secondsCells.get(kf).clearActor();
                    OwnTextField secondsInput = new OwnTextField(valText, this.skin, new FloatValidator(1.0E-4f, 500.0f));
                    secondsInput.setWidth(88.0f);
                    secondsInput.selectAll();
                    this.stage.setKeyboardFocus((Actor)secondsInput);
                    this.editing.setSeconds(kf, index, secondsInput, prevT);
                    secondsInput.addListener(evt -> {
                        if (secondsInput.isValid() && evt instanceof InputEvent) {
                            InputEvent ie2 = (InputEvent)evt;
                            if (System.currentTimeMillis() - this.lastMs > 1500L) {
                                if (ie2.getType() == InputEvent.Type.keyDown && (ie2.getKeyCode() == 66 || ie2.getKeyCode() == 111)) {
                                    double val = Parser.parseDouble(secondsInput.getText());
                                    double t = 0.0;
                                    for (Keyframe k : this.manager.keyframes) {
                                        if (k == kf) break;
                                        t += k.seconds;
                                    }
                                    ie2.cancel();
                                    if (val > t) {
                                        kf.seconds = val - t;
                                        GaiaSky.postRunnable(() -> {
                                            this.secondsCells.get(kf).clearActor();
                                            secondsInput.clear();
                                            this.reinitialiseKeyframes(this.manager.keyframes, null);
                                        });
                                    }
                                    this.editing.unset();
                                } else if (ie2.getType() == InputEvent.Type.keyUp && (ie2.getKeyCode() == 66 || ie2.getKeyCode() == 111)) {
                                    ie2.cancel();
                                }
                            }
                        }
                        evt.setBubbles(false);
                        return true;
                    });
                    this.secondsCells.get(kf).setActor((Actor)secondsInput);
                    this.lastMs = System.currentTimeMillis();
                }
                return true;
            });
        }
        this.addHighlightListener((Actor)secondsL, kf);
    }

    private void addFrameName(Keyframe kf, int index, Table table) {
        Cell<?> nameCell;
        OwnLabel nameL = new OwnLabel((CharSequence)(index + 1 + ": " + kf.name), this.skin);
        nameL.setWidth(240.0f);
        if (kf.target != null) {
            nameL.setColor(ColorUtils.gYellowC);
        }
        if (this.namesCells.containsKey(kf)) {
            nameCell = this.namesCells.get(kf);
        } else {
            nameCell = table.add();
            this.namesCells.put(kf, nameCell);
        }
        nameCell.clearActor();
        nameCell.setActor((Actor)nameL).left().padRight(pad18).padBottom(pad10);
        this.keyframeNames.put(kf, nameL);
        nameL.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.kf.name"), this.skin));
        nameL.addListener(event -> {
            InputEvent ie;
            if (event instanceof InputEvent && (ie = (InputEvent)event).getType() == InputEvent.Type.touchDown) {
                if (this.editing.notEmpty()) {
                    this.editing.revert();
                    this.editing.unset();
                }
                String valText = nameL.getText().toString();
                valText = valText.substring(valText.indexOf(":") + 2);
                nameL.clear();
                this.keyframeNames.remove(kf);
                this.namesCells.get(kf).clearActor();
                LengthValidator lengthValidator = new LengthValidator(0, 15);
                RegexpValidator nameValidator = new RegexpValidator(lengthValidator, "^[^*&%\\+\\=\\\\\\/@#\\$&\\*()~]*$");
                OwnTextField nameInput = new OwnTextField(valText, this.skin, nameValidator);
                nameInput.setWidth(160.0f);
                nameInput.selectAll();
                this.stage.setKeyboardFocus((Actor)nameInput);
                this.editing.setName(kf, index, nameInput);
                nameInput.addListener(evt -> {
                    if (nameInput.isValid() && evt instanceof InputEvent) {
                        InputEvent ie2 = (InputEvent)evt;
                        if (System.currentTimeMillis() - this.lastMs > 1500L && ie2.getType() == InputEvent.Type.keyDown && (ie2.getKeyCode() == 66 || ie2.getKeyCode() == 111)) {
                            kf.name = nameInput.getText();
                            this.addFrameName(kf, index, table);
                            this.editing.unset();
                        }
                    }
                    evt.setBubbles(false);
                    return true;
                });
                this.namesCells.get(kf).setActor((Actor)nameInput);
                this.lastMs = System.currentTimeMillis();
            }
            return true;
        });
        this.addHighlightListener((Actor)nameL, kf);
    }

    private void addKeyframeToTable(Keyframe kf, double prevT, int index, Table table, boolean addToModel) {
        OwnTextIconButton moveUp = new OwnTextIconButton("", this.skin, "caret-up");
        moveUp.setSize(this.buttonSize * 0.8f, this.buttonSize * 0.8f);
        moveUp.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.kf.up"), this.skin));
        moveUp.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                int idx = this.manager.keyframes.indexOf(kf);
                if (idx > 0) {
                    this.manager.keyframes.remove(kf);
                    this.manager.keyframes.add(idx - 1, kf);
                    if (idx - 1 == 0) {
                        this.manager.keyframes.get((int)1).seconds = this.manager.keyframes.get((int)0).seconds;
                        this.manager.keyframes.get((int)0).seconds = 0.0;
                    }
                    this.reinitialiseKeyframes(this.manager.keyframes, kf);
                }
                return true;
            }
            return false;
        });
        this.addHighlightListener((Actor)moveUp, kf);
        float noPad = 0.0f;
        table.add((Actor)moveUp).left().padRight(noPad).padBottom(pad10);
        OwnTextIconButton moveDown = new OwnTextIconButton("", this.skin, "caret-down");
        moveDown.setSize(this.buttonSize * 0.8f, this.buttonSize * 0.8f);
        moveDown.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.kf.down"), this.skin));
        moveDown.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                int idx = this.manager.keyframes.indexOf(kf);
                if (idx < this.manager.keyframes.size() - 1) {
                    this.manager.keyframes.remove(kf);
                    this.manager.keyframes.add(idx + 1, kf);
                    this.reinitialiseKeyframes(this.manager.keyframes, kf);
                    if (idx == 0) {
                        this.manager.keyframes.get((int)1).seconds = this.manager.keyframes.get((int)0).seconds;
                        this.manager.keyframes.get((int)0).seconds = 0.0;
                    }
                }
                return true;
            }
            return false;
        });
        this.addHighlightListener((Actor)moveDown, kf);
        table.add((Actor)moveDown).left().padRight(pad10).padBottom(pad10);
        this.addFrameSeconds(kf, prevT, index, table);
        long frame = this.manager.getFrameNumber(kf);
        OwnLabel framesL = new OwnLabel((CharSequence)("(" + frame + ")"), this.skin);
        framesL.setWidth(75.0f);
        framesL.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.kf.frames", frame, 1.0 / Settings.settings.camrecorder.targetFps), this.skin));
        this.addHighlightListener((Actor)framesL, kf);
        table.add((Actor)framesL).left().padRight(pad18).padBottom(pad10);
        Image clockImg = new Image(this.skin.getDrawable("clock"));
        clockImg.addListener((EventListener)new OwnTextTooltip(this.dateFormat.format(kf.time), this.skin));
        clockImg.setScale(0.7f);
        clockImg.setOrigin(1);
        this.addHighlightListener((Actor)clockImg, kf);
        table.add((Actor)clockImg).width(clockImg.getWidth()).left().padRight(3.0f).padBottom(pad10);
        Image targetImg = new Image(this.skin.getDrawable("iconic-target"));
        targetImg.setScale(0.7f);
        targetImg.setOrigin(1);
        this.addHighlightListener((Actor)targetImg, kf);
        if (kf.target != null) {
            targetImg.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.keyframes.target", kf.target.toString()), this.skin));
            targetImg.setColor(ColorUtils.gYellowC);
        } else {
            targetImg.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.keyframes.target.no"), this.skin));
            targetImg.setColor(ColorUtils.oDarkGrayC);
        }
        table.add((Actor)targetImg).width(targetImg.getWidth()).left().padRight(pad18).padBottom(pad10);
        this.addFrameName(kf, index, table);
        float bs = this.buttonSize * 1.1f;
        OwnTextIconButton goTo = new OwnTextIconButton("", this.skin, "go-to");
        goTo.setSize(bs, bs);
        goTo.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.kf.goto"), this.skin));
        goTo.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.KEYFRAME_PLAY_FRAME, (Object)goTo, frame);
                return true;
            }
            return false;
        });
        this.addHighlightListener((Actor)goTo, kf);
        table.add((Actor)goTo).left().padRight(noPad).padBottom(pad10);
        OwnTextIconButton setCurrent = new OwnTextIconButton("", this.skin, "camera-slr");
        setCurrent.setSize(bs, bs);
        setCurrent.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.kf.setcurrent"), this.skin));
        setCurrent.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                kf.pos.set(this.manager.pos);
                kf.dir.set(this.manager.dir);
                kf.up.set(this.manager.up);
                ICamera cam = GaiaSky.instance.getICamera();
                if (cam.hasFocus()) {
                    Vector3Q focusPos = new Vector3Q();
                    cam.getFocus().getAbsolutePosition(focusPos);
                    if (kf.target == null) {
                        kf.target = new Vector3D();
                    }
                    focusPos.put(kf.target);
                } else {
                    kf.target = null;
                }
                this.reinitialiseKeyframes(this.manager.keyframes, null);
                return true;
            }
            return false;
        });
        this.addHighlightListener((Actor)setCurrent, kf);
        table.add((Actor)setCurrent).left().padRight(noPad).padBottom(pad10);
        OwnTextIconButton seam = new OwnTextIconButton("", this.skin, "seam", "toggle");
        seam.setSize(bs, bs);
        seam.setChecked(kf.seam);
        seam.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.kf.seam"), this.skin));
        seam.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                kf.seam = seam.isChecked();
                GaiaSky.postRunnable(() -> {
                    BaseView baseView = this.view;
                    synchronized (baseView) {
                        this.view.setEntity(this.keyframesPathEntity);
                        this.view.refreshData();
                    }
                    if (this.keyframesComponent.selected == kf) {
                        baseView = this.vertsView;
                        synchronized (baseView) {
                            this.vertsView.setEntity(this.keyframesComponent.selectedKnot);
                            if (seam.isChecked()) {
                                this.vertsView.setColor(ColorUtils.gRed);
                            } else {
                                this.vertsView.setColor(ColorUtils.gWhite);
                            }
                        }
                    }
                });
                return true;
            }
            return false;
        });
        this.addHighlightListener((Actor)seam, kf);
        table.add((Actor)seam).left().padRight(noPad).padBottom(pad10);
        OwnTextIconButton addKeyframe = new OwnTextIconButton("", this.skin, "add");
        addKeyframe.setSize(bs, bs);
        addKeyframe.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.kf.add.after"), this.skin));
        addKeyframe.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                Instant time;
                Vector3D up;
                Vector3D dir;
                Vector3D pos;
                Vector3D target;
                if (index < this.manager.keyframes.size() - 1) {
                    Keyframe k0 = this.manager.keyframes.get(index);
                    Keyframe k1 = this.manager.keyframes.get(index + 1);
                    target = k0.target != null && k1.target != null ? new Vector3D().set(k0.target).interpolate(k1.target, 0.5, InterpolationDouble.linear) : null;
                    pos = new Vector3D().set(k0.pos).interpolate(k1.pos, 0.5, InterpolationDouble.linear);
                    QuaternionDouble q0 = new QuaternionDouble();
                    q0.setFromCamera(k0.dir, k0.up);
                    QuaternionDouble q1 = new QuaternionDouble();
                    q1.setFromCamera(k1.dir, k1.up);
                    q0.slerp(q1, 0.5);
                    dir = q0.getDirection(new Vector3D());
                    up = q0.getUp(new Vector3D());
                    time = k0.time.plusMillis((long)((double)(k1.time.toEpochMilli() - k0.time.toEpochMilli()) / 2.0));
                } else {
                    Keyframe k0 = this.manager.keyframes.get(index - 1);
                    Keyframe k1 = this.manager.keyframes.get(index);
                    target = k0.target != null && k1.target != null ? new Vector3D().set(k0.target).interpolate(k1.target, 1.5, InterpolationDouble.linear) : null;
                    pos = new Vector3D().set(k0.pos).interpolate(k1.pos, 1.5, InterpolationDouble.linear);
                    dir = new Vector3D(k1.dir);
                    up = new Vector3D(k1.up);
                    time = k1.time.plusMillis((long)((double)(k1.time.toEpochMilli() - k0.time.toEpochMilli()) / 2.0));
                }
                return this.addKeyframe(index + 1, pos, dir, up, target, time);
            }
            return false;
        });
        this.addHighlightListener((Actor)addKeyframe, kf);
        table.add((Actor)addKeyframe).left().padRight(noPad).padBottom(pad10);
        OwnTextIconButton rubbish = new OwnTextIconButton("", this.skin, "rubbish");
        rubbish.setSize(bs, bs);
        rubbish.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.kf.remove"), this.skin));
        rubbish.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                List<Keyframe> newKfs = Collections.synchronizedList(new ArrayList(this.manager.keyframes.size() - 1));
                for (Keyframe k : this.manager.keyframes) {
                    if (k == kf) continue;
                    newKfs.add(k);
                }
                if (!this.editing.isEmpty() && this.editing.kf() == kf) {
                    this.editing.unset();
                }
                if (!newKfs.isEmpty()) {
                    ((Keyframe)newKfs.get((int)0)).seconds = 0.0;
                }
                this.reinitialiseKeyframes(newKfs, null);
                logger.info(I18n.msg("gui.keyframes.removed", kf.name));
                return true;
            }
            return false;
        });
        this.addHighlightListener((Actor)rubbish, kf);
        Cell rub = table.add((Actor)rubbish).left().padBottom(pad10);
        rub.row();
        table.pack();
        if (addToModel && this.keyframesComponent != null) {
            GaiaSky.postRunnable(() -> {
                BaseView baseView = this.view;
                synchronized (baseView) {
                    this.view.setEntity(this.keyframesPathEntity);
                    this.view.addKnot(kf.pos, kf.dir, kf.up, kf.seam);
                }
                baseView = this.vertsView;
                synchronized (baseView) {
                    this.vertsView.setEntity(this.keyframesComponent.segments);
                    this.vertsView.addPoint(kf.pos);
                }
                if (this.manager.keyframes.size() > 1) {
                    baseView = this.view;
                    synchronized (baseView) {
                        this.view.setEntity(this.keyframesPathEntity);
                        this.view.resamplePath();
                    }
                }
            });
        }
    }

    private void addHighlightListener(Actor a, Keyframe kf) {
        a.addListener(event -> {
            if (event instanceof InputEvent) {
                InputEvent ie = (InputEvent)event;
                KeyframesView keyframesView = this.view;
                synchronized (keyframesView) {
                    this.view.setEntity(this.keyframesPathEntity);
                    if (ie.getType() == InputEvent.Type.enter) {
                        this.view.highlight(kf);
                    } else if (ie.getType() == InputEvent.Type.exit) {
                        this.view.unhighlight(kf);
                    }
                }
                return true;
            }
            return false;
        });
    }

    @Override
    public GenericDialog show(Stage stage, Action action) {
        EventManager.instance.subscribe((IObserver)this, Event.KEYFRAME_PLAY_FRAME, Event.KEYFRAMES_REFRESH, Event.KEYFRAME_SELECT, Event.KEYFRAME_UNSELECT, Event.KEYFRAME_ADD, Event.TOGGLE_VISIBILITY_CMD);
        if (((GraphNode)Mapper.graph.get((Entity)this.keyframesPathEntity)).parent == null) {
            EventManager.publish(Event.SCENE_ADD_OBJECT_CMD, this, this.keyframesPathEntity, false);
        }
        return super.show(stage, action);
    }

    public void reset() {
        this.reinitialiseKeyframes(this.manager.keyframes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinitialiseKeyframes(List<Keyframe> kfs, Keyframe moveTo) {
        List<Keyframe> list = this.manager.keyframes;
        synchronized (list) {
            this.clean(kfs != this.manager.keyframes, false);
            if (kfs != this.manager.keyframes) {
                this.manager.keyframes.addAll(kfs);
            }
        }
        this.addKeyframesToTable(this.manager.keyframes, this.keyframesTable);
        if (moveTo != null) {
            this.scrollToKeyframe(moveTo);
        } else {
            this.scrollToSelected();
        }
        this.pack();
    }

    private void clean() {
        this.clean(true, true);
    }

    private void clean(boolean cleanKeyframesList, boolean cleanModel) {
        IFocus focus = GaiaSky.instance.getICamera().getFocus();
        if (focus != null && Mapper.tagInvisible.has(((FocusView)focus).getEntity()) && focus.getName().startsWith(I18n.msg("gui.keyframes.name.default", 0).substring(0, 6))) {
            EventManager.publish(Event.FOCUS_CHANGE_CMD, this, Settings.settings.scene.homeObject);
            EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FREE_MODE});
        }
        if (cleanKeyframesList) {
            this.manager.clean();
        }
        this.notice.clearActor();
        this.namesCells.clear();
        this.secondsCells.clear();
        this.keyframesTable.clearChildren();
        this.mediaTable.clearChildren();
        this.nameInput.setText("");
        this.secondsInput.setText("1.0");
        if (cleanModel) {
            GaiaSky.postRunnable(() -> {
                this.view.setEntity(this.keyframesPathEntity);
                this.view.clear();
            });
        }
    }

    private void scrollToSelected() {
        this.scrollToKeyframe(this.keyframesComponent.selected);
    }

    private void scrollToKeyframe(Keyframe kf) {
        if (this.rightScroll != null && kf != null) {
            int i = this.manager.keyframes.indexOf(kf);
            int n = this.manager.keyframes.size();
            if (i >= 0) {
                this.rightScroll.setScrollPercentY((float)i / ((float)n - 5.0f));
            }
        }
    }

    @Override
    protected boolean accept() {
        return true;
    }

    @Override
    protected void cancel() {
        this.clean();
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case KEYFRAME_ADD: {
                this.addKeyframe();
                break;
            }
            case KEYFRAME_PLAY_FRAME: {
                if (source != this.manager) break;
                this.timelineSlider.setProgrammaticChangeEvents(false);
                this.timelineSlider.setMappedValue(this.manager.currentPath.i);
                this.timelineSlider.setProgrammaticChangeEvents(true);
                if (!this.manager.isIdle()) break;
                this.playPause.setProgrammaticChangeEvents(false);
                this.playPause.setChecked(false);
                this.playPause.setProgrammaticChangeEvents(true);
                break;
            }
            case KEYFRAMES_REFRESH: {
                this.reinitialiseKeyframes(this.manager.keyframes, null);
                break;
            }
            case KEYFRAME_SELECT: {
                Keyframe kf = (Keyframe)data[0];
                OwnLabel nl = this.keyframeNames.get(kf);
                if (nl == null) break;
                this.colorBak = nl.getColor().cpy();
                nl.setColor(this.skin.getColor("theme"));
                this.scrollToKeyframe(kf);
                break;
            }
            case KEYFRAME_UNSELECT: {
                Keyframe kf = (Keyframe)data[0];
                OwnLabel nl = this.keyframeNames.get(kf);
                if (nl == null || this.colorBak == null) break;
                nl.setColor(this.colorBak);
                break;
            }
            case TOGGLE_VISIBILITY_CMD: {
                String key = (String)data[0];
                Button b = this.visibility;
                if (!key.equals(ComponentTypes.ComponentType.Keyframes.key) || b == null || source == b) break;
                b.setProgrammaticChangeEvents(false);
                if (data.length == 2) {
                    b.setChecked(((Boolean)data[1]).booleanValue());
                } else {
                    b.setChecked(!b.isChecked());
                }
                b.setProgrammaticChangeEvents(true);
                break;
            }
        }
    }

    @Override
    public void dispose() {
        this.clear();
        if (this.keyframesPathEntity != null && ((GraphNode)Mapper.graph.get((Entity)this.keyframesPathEntity)).parent != null) {
            GraphNode graph = (GraphNode)Mapper.graph.get(this.keyframesPathEntity);
            GaiaSky.postRunnable(() -> {
                GraphNode parentGraph = (GraphNode)Mapper.graph.get(graph.parent);
                parentGraph.removeChild(this.keyframesPathEntity, false);
                this.vertsView.setEntity(this.keyframesPathEntity);
                this.vertsView.clear();
            });
        }
    }

    private class Editing {
        private final Map<String, Object> map = new HashMap<String, Object>();
        private int type = -1;
        private Keyframe kf;
        private int index;
        private OwnTextField tf;

        public boolean notEmpty() {
            return this.tf != null;
        }

        public boolean isEmpty() {
            return this.tf == null;
        }

        public void revert() {
            if (this.isName()) {
                KeyframesWindow.this.addFrameName(this.kf, this.index, KeyframesWindow.this.keyframesTable);
            } else if (this.isSeconds()) {
                KeyframesWindow.this.addFrameSeconds(this.kf, (Double)this.map.get("prevT"), this.index, KeyframesWindow.this.keyframesTable);
            }
        }

        public void setParam(String key, Object value) {
            this.map.put(key, value);
        }

        public boolean isName() {
            return !this.isEmpty() && this.type == 1;
        }

        public boolean isSeconds() {
            return !this.isEmpty() && this.type == 0;
        }

        public void set(Keyframe kf, int idx, OwnTextField tf) {
            this.kf = kf;
            this.index = idx;
            this.tf = tf;
        }

        public void setName(Keyframe kf, int idx, OwnTextField tf) {
            this.type = 1;
            this.set(kf, idx, tf);
        }

        public void setSeconds(Keyframe kf, int idx, OwnTextField tf, double prevT) {
            this.type = 0;
            this.setParam("prevT", prevT);
            this.set(kf, idx, tf);
        }

        public void unset() {
            this.type = -1;
            this.kf = null;
            this.index = -1;
            this.tf = null;
            this.map.clear();
        }

        public Keyframe kf() {
            return this.kf;
        }

        public int index() {
            return this.index;
        }

        public OwnTextField tf() {
            return this.tf;
        }
    }
}

