/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.gui.window.GenericDialog;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.validator.ExistingLocationValidator;
import gaiasky.util.validator.FloatValidator;

public class LandAtWindow
extends GenericDialog {
    private final Entity target;
    private CheckBox latlonCb;
    private CheckBox locationCb;
    private OwnTextField location;
    private OwnTextField latitude;
    private OwnTextField longitude;

    public LandAtWindow(Entity target, Stage stage, Skin skin) {
        super(I18n.msg("context.landatcoord", ((Base)Mapper.base.get(target)).getName()), skin, stage);
        this.target = target;
        this.setAcceptText(I18n.msg("gui.ok"));
        this.setCancelText(I18n.msg("gui.cancel"));
        this.buildSuper();
    }

    @Override
    protected void build() {
        this.latlonCb = new OwnCheckBox(I18n.msg("context.lonlat"), this.skin, "radio", pad18);
        this.latlonCb.setChecked(false);
        this.latlonCb.addListener(new EventListener(){

            public boolean handle(com.badlogic.gdx.scenes.scene2d.Event event) {
                if (event instanceof ChangeListener.ChangeEvent) {
                    if (LandAtWindow.this.latlonCb.isChecked()) {
                        LandAtWindow.this.enableComponents(false, new Disableable[]{LandAtWindow.this.location});
                        LandAtWindow.this.enableComponents(true, new Disableable[]{LandAtWindow.this.longitude, LandAtWindow.this.latitude});
                        LandAtWindow.this.stage.setKeyboardFocus((Actor)LandAtWindow.this.longitude);
                    }
                    return true;
                }
                return false;
            }
        });
        this.longitude = new OwnTextField("", this.skin, new FloatValidator(0.0f, 360.0f));
        this.latitude = new OwnTextField("", this.skin, new FloatValidator(-90.0f, 90.0f));
        this.locationCb = new OwnCheckBox(I18n.msg("context.location"), this.skin, "radio", pad18);
        this.locationCb.setChecked(true);
        this.locationCb.addListener(new EventListener(){

            public boolean handle(com.badlogic.gdx.scenes.scene2d.Event event) {
                if (event instanceof ChangeListener.ChangeEvent) {
                    if (LandAtWindow.this.locationCb.isChecked()) {
                        LandAtWindow.this.enableComponents(true, new Disableable[]{LandAtWindow.this.location});
                        LandAtWindow.this.enableComponents(false, new Disableable[]{LandAtWindow.this.longitude, LandAtWindow.this.latitude});
                        LandAtWindow.this.stage.setKeyboardFocus((Actor)LandAtWindow.this.location);
                    }
                    return true;
                }
                return false;
            }
        });
        this.location = new OwnTextField("", this.skin, new ExistingLocationValidator(this.target));
        new ButtonGroup((Button[])new CheckBox[]{this.latlonCb, this.locationCb});
        this.content.add((Actor)this.locationCb).left().top().padBottom(pad18).colspan(4).row();
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("context.location"), this.skin)).left().top().padRight(pad18);
        this.content.add((Actor)this.location).left().top().padBottom(pad18 * 2.0f).row();
        this.content.add((Actor)this.latlonCb).left().top().padBottom(pad18).colspan(4).row();
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("context.longitude"), this.skin)).left().top().padRight(pad18);
        this.content.add((Actor)this.longitude).left().top().padRight(pad18 * 2.0f);
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("context.latitude"), this.skin)).left().top().padRight(pad18);
        this.content.add((Actor)this.latitude).left().top();
    }

    @Override
    protected boolean accept() {
        if (this.latlonCb.isChecked()) {
            EventManager.publish(Event.LAND_AT_LOCATION_OF_OBJECT, (Object)this, this.target, Double.parseDouble(this.longitude.getText()), Double.parseDouble(this.latitude.getText()));
        } else if (this.locationCb.isChecked()) {
            EventManager.publish(Event.LAND_AT_LOCATION_OF_OBJECT, (Object)this, this.target, this.location.getText());
        }
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    protected void enableComponents(boolean enabled, Disableable ... components) {
        for (Disableable c : components) {
            if (c == null) continue;
            c.setDisabled(!enabled);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setKeyboardFocus() {
        this.stage.setKeyboardFocus((Actor)this.location);
    }
}

