/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import gaiasky.gui.iface.NotificationsInterface;
import gaiasky.gui.main.MessageBean;
import gaiasky.gui.window.GenericDialog;
import gaiasky.util.Logger;
import gaiasky.util.SysUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnTextButton;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.LinkedList;
import net.jafama.FastMath;

public class LogWindow
extends GenericDialog {
    private final DateTimeFormatter format = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.MEDIUM).withLocale(I18n.locale).withZone(ZoneOffset.UTC);
    private Table logs;
    private ScrollPane scroll;
    private int numMessages = 0;
    private float w;
    private float h;
    private float pad;

    public LogWindow(Stage stage, Skin skin) {
        super(I18n.msg("gui.log.title"), skin, stage);
        this.setResizable(true);
        this.setCancelText(I18n.msg("gui.close"));
        this.buildSuper();
    }

    @Override
    protected void build() {
        this.w = FastMath.min((float)1200.0f, (float)(Gdx.graphics.getWidth() - 200));
        this.h = FastMath.min((float)860.0f, (float)(Gdx.graphics.getHeight() - 150));
        this.pad = 16.0f;
        this.logs = new Table(this.skin);
        LinkedList<MessageBean> list = NotificationsInterface.historical;
        for (MessageBean mb : list) {
            this.addMessage(mb);
        }
        this.scroll = new OwnScrollPane((Actor)this.logs, this.skin, "minimalist-nobg");
        this.scroll.setFadeScrollBars(false);
        this.scroll.setScrollingDisabled(false, false);
        this.scroll.setSmoothScrolling(true);
        this.scroll.setHeight(this.h);
        this.scroll.setWidth(this.w);
        this.scroll.pack();
        this.updateScroll();
        HorizontalGroup buttons = new HorizontalGroup();
        buttons.pad(this.pad);
        buttons.space(this.pad);
        OwnTextIconButton reload = new OwnTextIconButton("", this.skin, "reload");
        reload.setName("update log");
        reload.pad(pad10);
        reload.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.log.update"), this.skin));
        reload.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.update();
            }
            return false;
        });
        buttons.addActor((Actor)reload);
        OwnTextButton export = new OwnTextButton(I18n.msg("gui.log.export"), this.skin);
        export.setName("export log");
        export.pad(pad10);
        export.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.export();
            }
            return false;
        });
        buttons.addActor((Actor)export);
        this.content.add((Actor)this.scroll).left().top().padBottom(this.pad).row();
        this.content.add((Actor)buttons).align(1);
    }

    public void update() {
        if (this.logs != null) {
            LinkedList<MessageBean> list = NotificationsInterface.historical;
            if (list.size() > this.numMessages) {
                for (int i = this.numMessages; i < list.size(); ++i) {
                    this.addMessage((MessageBean)list.get(i));
                }
            }
            this.updateScroll();
        }
    }

    public void export() {
        Object filename = Instant.now().toString() + "_gaiasky.log";
        filename = ((String)filename).replace(":", "-");
        Path gsHome = SysUtils.getDataDir();
        Path log = gsHome.resolve((String)filename);
        try {
            FileWriter fw = new FileWriter(log.toFile());
            BufferedWriter bw = new BufferedWriter(fw);
            for (MessageBean mb : NotificationsInterface.historical) {
                fw.write(this.format.format(mb.date()) + " - " + mb.msg() + "\n");
            }
            bw.flush();
            bw.close();
            Logger.getLogger(((Object)((Object)this)).getClass()).info("Log file written to " + String.valueOf(log.toAbsolutePath()));
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error(e);
        }
    }

    public void updateScroll() {
        if (this.scroll == null) {
            return;
        }
        this.scroll.setScrollPercentX(0.0f);
        this.scroll.setScrollPercentY(1.0f);
        this.scroll.invalidate();
    }

    private void addMessage(MessageBean mb) {
        OwnLabel date = new OwnLabel((CharSequence)this.format.format(mb.date()), this.skin);
        OwnLabel msg = new OwnLabel((CharSequence)mb.msg(), this.skin);
        this.logs.add((Actor)date).left().padRight(this.pad);
        this.logs.add((Actor)msg).left().row();
        ++this.numMessages;
    }

    @Override
    protected boolean accept() {
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }

    protected void sizeChanged() {
        if (this.scroll == null) {
            return;
        }
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.scroll.setWidth(this.w);
        this.scroll.setHeight(this.h);
        this.content.setWidth(this.w);
        this.content.setHeight(this.h);
        this.updateScroll();
        this.invalidate();
    }
}

