/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import gaiasky.gui.window.GenericDialog;
import gaiasky.util.MemInfo;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnTextArea;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;

public class MemInfoWindow
extends GenericDialog {
    public MemInfoWindow(Stage stage, Skin skin) {
        super(I18n.msg("gui.help.meminfo"), skin, stage);
        this.setCancelText(I18n.msg("gui.close"));
        this.buildSuper();
    }

    @Override
    protected void build() {
        float pad = 8.0f;
        float taWidth = 1200.0f;
        StringBuilder memInfoStr = new StringBuilder();
        memInfoStr.append(TextUtils.capitalise(I18n.msg("gui.debug.ram.used"))).append(": ").append(MemInfo.getUsedMemory()).append(" ").append(I18n.msg("gui.debug.ram.unit")).append("\n");
        memInfoStr.append(TextUtils.capitalise(I18n.msg("gui.debug.ram.free"))).append(": ").append(MemInfo.getFreeMemory()).append(" ").append(I18n.msg("gui.debug.ram.unit")).append("\n");
        memInfoStr.append(TextUtils.capitalise(I18n.msg("gui.debug.ram.alloc"))).append(": ").append(MemInfo.getTotalMemory()).append(" ").append(I18n.msg("gui.debug.ram.unit")).append("\n");
        memInfoStr.append(TextUtils.capitalise(I18n.msg("gui.debug.ram.total"))).append(": ").append(MemInfo.getMaxMemory()).append(" ").append(I18n.msg("gui.debug.ram.unit")).append("\n\n");
        for (MemoryPoolMXBean mpBean : ManagementFactory.getMemoryPoolMXBeans()) {
            memInfoStr.append(mpBean.getName()).append(": ").append(mpBean.getUsage()).append("\n\n");
        }
        OwnScrollPane memInfoScroll = this.getOwnScrollPane(memInfoStr, taWidth);
        this.content.add((Actor)memInfoScroll).padBottom(pad).row();
    }

    private OwnScrollPane getOwnScrollPane(StringBuilder memInfoStr, float taWidth) {
        OwnTextArea memInfo = new OwnTextArea(memInfoStr.toString(), this.skin, "disabled-nobg");
        memInfo.setDisabled(true);
        memInfo.setPrefRows(13.0f);
        memInfo.setWidth(taWidth - 15.0f);
        float fontHeight = memInfo.getStyle().font.getLineHeight();
        memInfo.offsets();
        memInfo.setHeight((float)(memInfo.getLines() + 3) * fontHeight);
        memInfo.clearListeners();
        OwnScrollPane memInfoScroll = new OwnScrollPane((Actor)memInfo, this.skin, "minimalist-nobg");
        memInfoScroll.setWidth(taWidth);
        memInfoScroll.setForceScroll(false, false);
        memInfoScroll.setSmoothScrolling(true);
        memInfoScroll.setFadeScrollBars(false);
        return memInfoScroll;
    }

    @Override
    protected boolean accept() {
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }
}

