/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import gaiasky.gui.minimap.MinimapWidget;
import gaiasky.gui.window.GenericDialog;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;

public class MinimapWindow
extends GenericDialog {
    private final MinimapWidget minimap;
    private OwnLabel mapName;

    public MinimapWindow(Stage stage, Skin skin, ShaderProgram shapeShader, ShaderProgram spriteShader) {
        super(I18n.msg("gui.minimap.title"), skin, stage);
        this.minimap = new MinimapWidget(skin, shapeShader, spriteShader);
        this.setModal(false);
        this.setCancelText(I18n.msg("gui.close"));
        this.buildSuper();
        this.pack();
    }

    @Override
    protected void build() {
        float pb = 16.0f;
        this.mapName = new OwnLabel((CharSequence)"", this.skin, "header");
        OwnLabel headerSide = new OwnLabel((CharSequence)I18n.msg("gui.minimap.side"), this.skin);
        Container mapSide = new Container();
        mapSide.setActor((Actor)this.minimap.getSideProjection());
        OwnLabel headerTop = new OwnLabel((CharSequence)I18n.msg("gui.minimap.top"), this.skin);
        Container mapTop = new Container();
        mapTop.setActor((Actor)this.minimap.getTopProjection());
        this.content.add((Actor)this.mapName).left().padBottom(pad18).row();
        this.content.add((Actor)headerSide).left().padBottom(pb).row();
        this.content.add((Actor)mapSide).left().padBottom(pb).row();
        this.content.add((Actor)headerTop).left().padBottom(pb).row();
        this.content.add((Actor)mapTop).left();
    }

    @Override
    protected boolean accept() {
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }

    private void updateMapName(String mapName) {
        if (this.mapName != null) {
            this.mapName.setText(mapName);
        }
    }

    @Override
    public void act(float delta) {
        super.act(delta);
    }
}

