/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Timer;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.window.GenericDialog;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.component.Base;
import gaiasky.scene.view.FilterView;
import gaiasky.scene.view.FocusView;
import gaiasky.util.CatalogInfo;
import gaiasky.util.Logger;
import gaiasky.util.TextUtils;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.CollapsiblePane;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import gaiasky.util.scene2d.Separator;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ObjectDebugWindow
extends GenericDialog
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(ObjectDebugWindow.class);
    private final Scene scene;
    private final FocusView view;
    private final FilterView filterView;
    private final SortedSet<String> matching;
    private final Array<OwnLabel> matchingLabels;
    private final Vector2 aux;
    private String currentInputText = "";
    private OwnTextField searchInput;
    private final Array<Timer.Task> tasks;
    private Cell<?> infoCell;
    private Cell<?> contentCell;
    private OwnLabel infoMessage;
    private Table candidates;
    private int cIdx = -1;
    private static final float width = 950.0f;
    private static final float height = 820.0f;
    private static final Set<Class<?>> WRAPPER_TYPE_MAP = new HashSet(16);

    public ObjectDebugWindow(Stage ui, Skin skin, Scene scene) {
        super(I18n.msg("gui.debug.object.title"), skin, ui);
        this.scene = scene;
        this.view = new FocusView();
        this.filterView = new FilterView();
        this.matching = new TreeSet<String>();
        this.matchingLabels = new Array(10);
        this.tasks = new Array(20);
        this.aux = new Vector2();
        this.keysListener = false;
        this.setModal(false);
        this.setAcceptText(I18n.msg("gui.close"));
        this.buildSuper();
        this.info(I18n.msg("gui.debug.info"));
        EventManager.instance.subscribe((IObserver)this, Event.FOCUS_CHANGED);
    }

    @Override
    protected void build() {
        this.content.clear();
        this.candidates = new Table(this.skin);
        this.candidates.setBackground("table-bg");
        this.candidates.setFillParent(false);
        this.searchInput = new OwnTextField("", this.skin);
        this.searchInput.setWidth(950.0f);
        this.searchInput.setMessageText(I18n.msg("gui.objects.search"));
        this.searchInput.addListener(event -> {
            if (event instanceof InputEvent) {
                InputEvent ie = (InputEvent)event;
                int matchingSize = this.matching.size();
                int code = ie.getKeyCode();
                if (ie.getType() == InputEvent.Type.keyUp) {
                    if (code == 111 || code == 66) {
                        if (this.cIdx >= 0) {
                            this.checkString(this.searchInput.getText(), this.scene);
                        }
                        this.removeCandidates();
                        return false;
                    }
                    if (code == 61 && Gdx.input.isKeyPressed(59) && matchingSize > 0) {
                        this.cIdx = this.cIdx - 1 < 0 ? matchingSize - 1 : this.cIdx - 1;
                        this.selectMatch();
                        return false;
                    }
                    if (code == 61 && !Gdx.input.isKeyPressed(59) && matchingSize > 0) {
                        this.cIdx = (this.cIdx + 1) % matchingSize;
                        this.selectMatch();
                        return false;
                    }
                    if (!this.searchInput.getText().equals(this.currentInputText) && !this.searchInput.getText().isBlank()) {
                        this.currentInputText = this.searchInput.getText();
                        final String name = this.currentInputText.toLowerCase(Locale.ROOT).trim();
                        Timer.Task task = new Timer.Task(this){
                            final /* synthetic */ ObjectDebugWindow this$0;
                            {
                                this.this$0 = this$0;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                SortedSet<String> sortedSet = this.this$0.matching;
                                synchronized (sortedSet) {
                                    this.this$0.matchingNodes(name, this.this$0.scene);
                                    if (!this.this$0.matching.isEmpty()) {
                                        this.this$0.cIdx = -1;
                                        this.this$0.candidates.clear();
                                        this.this$0.matching.forEach(match -> {
                                            OwnLabel m = new OwnLabel((CharSequence)match, this.this$0.skin);
                                            m.addListener(evt -> {
                                                InputEvent iEvt;
                                                if (evt instanceof InputEvent && (iEvt = (InputEvent)evt).getType() == InputEvent.Type.touchDown) {
                                                    this.this$0.checkString((String)match, this.this$0.scene);
                                                    this.this$0.searchInput.setText((String)match);
                                                    this.this$0.accept();
                                                    return true;
                                                }
                                                return false;
                                            });
                                            this.this$0.matchingLabels.add((Object)m);
                                            m.setWidth(this.this$0.searchInput.getWidth());
                                            Cell c = this.this$0.candidates.add((Actor)m).left().padBottom(GenericDialog.pad10);
                                            c.row();
                                        });
                                        this.this$0.candidates.pack();
                                        this.this$0.searchInput.localToStageCoordinates(this.this$0.aux.set(0.0f, 0.0f));
                                        this.this$0.candidates.setPosition(this.this$0.aux.x, this.this$0.aux.y, 10);
                                        this.this$0.stage.addActor((Actor)this.this$0.candidates);
                                    } else {
                                        this.this$0.removeCandidates();
                                    }
                                }
                            }
                        };
                        this.cancelTasks();
                        this.tasks.add((Object)task);
                        Timer.schedule((Timer.Task)task, (float)0.5f);
                        if (!this.checkString(name, this.scene)) {
                            if (name.matches("[0-9]+")) {
                                if (this.checkString("hip " + name, this.scene)) {
                                    this.cancelTasks();
                                    this.removeCandidates();
                                }
                            } else if ((name.matches("hip [0-9]+") || name.matches("HIP [0-9]+")) && this.checkString(name.substring(4), this.scene)) {
                                this.cancelTasks();
                                this.removeCandidates();
                            }
                        } else {
                            this.cancelTasks();
                            this.removeCandidates();
                        }
                        return false;
                    }
                    this.removeCandidates();
                    return false;
                }
            }
            return false;
        });
        this.infoMessage = new OwnLabel((CharSequence)"", this.skin, "default-blue");
        this.content.add((Actor)this.searchInput).top().left().expand().row();
        this.infoCell = this.content.add();
        this.infoCell.top().left().padTop(pad10).expand().row();
        this.contentCell = this.content.add();
        this.contentCell.top().left().padTop(pad10).expandX().expandY();
        this.pack();
    }

    private void updateContent(Entity e) {
        if (e == null) {
            return;
        }
        this.contentCell.clearActor();
        Table c = new Table(this.skin);
        this.view.setEntity(e);
        OwnLabel title = new OwnLabel((CharSequence)this.view.getName(), this.skin, "header");
        c.add((Actor)title).padBottom(pad10).row();
        c.add((Actor)new Separator(this.skin)).padBottom(pad10).fillX().expandX().row();
        Table cc = new Table(this.skin);
        ImmutableArray comps = e.getComponents();
        for (Component comp : comps) {
            cc.add(this.getComponentActor(comp)).expandX().left().padBottom(pad10).row();
        }
        OwnScrollPane scroll = new OwnScrollPane((Actor)cc, this.skin, "minimalist-nobg");
        scroll.setWidth(950.0f);
        scroll.setHeight(820.0f);
        c.add((Actor)scroll).row();
        this.contentCell.setActor((Actor)c);
        this.pack();
    }

    @Override
    public GenericDialog show(Stage stage) {
        GenericDialog gd = super.show(stage);
        FocusView focus = (FocusView)GaiaSky.instance.getCameraManager().getFocus();
        if (focus != null) {
            this.updateContent(focus.getEntity());
        }
        return gd;
    }

    private Actor getComponentActor(Component component) {
        Field[] fields;
        Table c = new Table(this.skin);
        c.left();
        c.padLeft(pad20);
        for (Field field : fields = component.getClass().getDeclaredFields()) {
            int modifiers = field.getModifiers();
            Class<?> type = field.getType();
            HorizontalGroup hg = new HorizontalGroup();
            hg.space(pad10);
            String name = TextUtils.capString(field.getName(), 20);
            OwnLabel nameLabel = new OwnLabel((CharSequence)name, this.skin);
            String typeStr = TextUtils.capString(type.getSimpleName(), 13);
            OwnLabel typeLabel = new OwnLabel((CharSequence)typeStr, this.skin, "default-blue");
            hg.addActor((Actor)nameLabel);
            hg.addActor((Actor)typeLabel);
            hg.setWidth(300.0f);
            c.add((Actor)hg).left().padBottom(pad10).padRight(pad18);
            try {
                Object fieldActor;
                Object value = field.get(component);
                boolean fin = Modifier.isFinal(modifiers);
                boolean priv = Modifier.isPrivate(modifiers);
                boolean nil = value == null;
                boolean primStr = ObjectDebugWindow.isPrimitiveOrStringType(type);
                boolean bool = ObjectDebugWindow.isBoolean(type);
                String valueStr = ObjectDebugWindow.toString(value, type);
                String valueCapped = TextUtils.capString(valueStr, 40);
                if (fin || priv || nil || !primStr) {
                    fieldActor = new OwnLabel((CharSequence)valueCapped, this.skin);
                    fieldActor.setColor(ColorUtils.oDarkGrayC);
                    fieldActor.addListener((EventListener)new OwnTextTooltip(valueStr, this.skin));
                } else if (bool) {
                    fieldActor = new OwnCheckBox("", this.skin);
                    ((OwnCheckBox)((Object)fieldActor)).setChecked((Boolean)value);
                    fieldActor.addListener(arg_0 -> ObjectDebugWindow.lambda$getComponentActor$0(field, component, (Actor)fieldActor, name, arg_0));
                } else {
                    HorizontalGroup hor = new HorizontalGroup();
                    hor.space(pad10);
                    OwnTextField tf = new OwnTextField(valueCapped, this.skin);
                    tf.setWidth(450.0f);
                    tf.setErrorColor(ColorUtils.gRedC);
                    Image applyImage = new Image(this.skin.getDrawable("iconic-check"));
                    OwnTextIconButton button = new OwnTextIconButton("", applyImage, this.skin);
                    button.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.debug.object.setval"), this.skin));
                    button.addListener(event -> {
                        if (event instanceof ChangeListener.ChangeEvent) {
                            try {
                                String t = tf.getText();
                                Object val = ObjectDebugWindow.parse(field.getType(), t);
                                field.set(component, val);
                                tf.setToRegularColor();
                            }
                            catch (IllegalAccessException e) {
                                logger.debug(I18n.msg("gui.debug.error.set", tf.getText(), name));
                            }
                            catch (Exception e) {
                                logger.debug(I18n.msg("gui.debug.error.parse", tf.getText(), name));
                                tf.setToErrorColor();
                            }
                        }
                        return false;
                    });
                    hor.addActor((Actor)tf);
                    hor.addActor((Actor)button);
                    fieldActor = hor;
                }
                c.add((Actor)fieldActor).left().padBottom(pad10).expandX().row();
            }
            catch (IllegalAccessException e) {
                logger.debug(I18n.msg("gui.debug.error.access", name), e);
            }
        }
        return new CollapsiblePane(this.stage, component.getClass().getSimpleName(), (Actor)c, 950.0f, this.skin, "header-s", "expand-collapse", null, false, null, new Actor[0]);
    }

    private static boolean isPrimitiveOrStringType(Class source) {
        return source.isPrimitive() || WRAPPER_TYPE_MAP.contains(source) || ObjectDebugWindow.isString(source);
    }

    private static boolean isBoolean(Class source) {
        return source.equals(Boolean.TYPE) || source.equals(Boolean.class);
    }

    private static boolean isString(Class source) {
        return source.equals(String.class);
    }

    public static Object parse(Class clazz, String value) throws NumberFormatException, NullPointerException {
        if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            return Boolean.parseBoolean(value);
        }
        if (Byte.class == clazz || Byte.TYPE == clazz) {
            return Byte.parseByte(value);
        }
        if (Short.class == clazz || Short.TYPE == clazz) {
            return Short.parseShort(value);
        }
        if (Integer.class == clazz || Integer.TYPE == clazz) {
            return Integer.parseInt(value);
        }
        if (Long.class == clazz || Long.TYPE == clazz) {
            return Long.parseLong(value);
        }
        if (Float.class == clazz || Float.TYPE == clazz) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Double.class == clazz || Double.TYPE == clazz) {
            return Double.parseDouble(value);
        }
        return value;
    }

    private static String toString(Object value, Class type) {
        if (value == null) {
            return "EMPTY";
        }
        if (Entity.class.isAssignableFrom(type)) {
            Entity entity = (Entity)value;
            Base base = (Base)Mapper.base.get(entity);
            return base != null ? base.getName() : Entity.class.getSimpleName();
        }
        if (type.isArray()) {
            int length = java.lang.reflect.Array.getLength(value);
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < length; ++i) {
                Object element = java.lang.reflect.Array.get(value, i);
                sb.append(ObjectDebugWindow.toString(element, element.getClass()));
                if (i >= length - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
            return sb.toString();
        }
        if (type.isAssignableFrom(Array.class)) {
            Array arr = (Array)value;
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < arr.size; ++i) {
                Object element = arr.get(i);
                sb.append(ObjectDebugWindow.toString(element, element.getClass()));
                if (i >= arr.size - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
            return sb.toString();
        }
        if (type.isAnnotationPresent(FunctionalInterface.class)) {
            return "Functional interface";
        }
        return value.toString();
    }

    private boolean checkString(String text, Scene scene) {
        try {
            if (scene.index().containsEntity(text)) {
                Entity entity = scene.getEntity(text);
                if (Mapper.focus.has(entity)) {
                    boolean datasetVisible;
                    this.view.setEntity(entity);
                    this.view.getFocus(text);
                    this.filterView.setEntity(entity);
                    boolean timeOverflow = this.view.isCoordinatesTimeOverflow();
                    boolean canSelect = this.view.getSet() == null || this.view.getSet().canSelect(this.filterView);
                    boolean ctOn = GaiaSky.instance.isOn(this.view.getCt());
                    Optional<CatalogInfo> ci = GaiaSky.instance.getCatalogInfoFromEntity(entity);
                    boolean bl = datasetVisible = ci.isEmpty() || ci.get().isVisible(true);
                    if (!timeOverflow && canSelect && ctOn && datasetVisible) {
                        GaiaSky.postRunnable(() -> this.updateContent(entity));
                        this.info(null);
                    } else if (timeOverflow) {
                        this.info(I18n.msg("gui.objects.search.timerange", text));
                    } else if (!canSelect) {
                        this.info(I18n.msg("gui.objects.search.filter", text));
                    } else if (!datasetVisible) {
                        this.info(I18n.msg("gui.objects.search.dataset.invisible", text, ci.get().name));
                    } else {
                        this.info(I18n.msg("gui.objects.search.invisible", text, ((Base)Mapper.base.get((Entity)entity)).ct.toString()));
                    }
                    return true;
                }
            } else {
                this.info(null);
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        return false;
    }

    private void info(String info) {
        if (info == null) {
            this.infoMessage.setText("");
            this.info(false);
        } else {
            this.infoMessage.setText(info);
            this.info(true);
        }
    }

    private void info(boolean visible) {
        if (visible) {
            this.infoCell.setActor((Actor)this.infoMessage);
        } else {
            this.infoCell.setActor(null);
        }
        this.pack();
    }

    public void clearText() {
        this.removeCandidates();
        this.searchInput.setText("");
    }

    private void cancelTasks() {
        if (!this.tasks.isEmpty()) {
            for (Timer.Task t : this.tasks) {
                t.cancel();
            }
        }
        this.tasks.clear();
    }

    private void removeCandidates() {
        if (this.candidates != null) {
            this.candidates.clear();
            this.candidates.remove();
        }
        this.cIdx = -1;
    }

    private void selectMatch() {
        for (int i = 0; i < this.matchingLabels.size; ++i) {
            OwnLabel l = (OwnLabel)((Object)this.matchingLabels.get(i));
            if (i == this.cIdx) {
                l.setColor(ColorUtils.gYellowC);
                this.searchInput.setText(l.getText().toString());
                continue;
            }
            l.setColor(ColorUtils.gWhiteC);
        }
    }

    private void matchingNodes(String text, Scene scene) {
        this.matching.clear();
        this.matchingLabels.clear();
        scene.matchingFocusableNodes(text, this.matching, 10, null);
    }

    @Override
    protected boolean accept() {
        this.cancelTasks();
        this.removeCandidates();
        this.info(null);
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        FocusView focus;
        if (this.me.hasParent() && event == Event.FOCUS_CHANGED && (focus = (FocusView)data[0]) != null && focus.getEntity() != null) {
            GaiaSky.postRunnable(() -> this.updateContent(focus.getEntity()));
        }
    }

    private static /* synthetic */ boolean lambda$getComponentActor$0(Field field, Component component, Actor fieldActor, String name, com.badlogic.gdx.scenes.scene2d.Event event) {
        if (event instanceof ChangeListener.ChangeEvent) {
            try {
                field.set(component, ((OwnCheckBox)fieldActor).isChecked());
            }
            catch (IllegalAccessException e) {
                logger.error("Error setting value '" + ((OwnCheckBox)fieldActor).isChecked() + "' to " + name);
            }
        }
        return false;
    }

    static {
        WRAPPER_TYPE_MAP.add(Integer.class);
        WRAPPER_TYPE_MAP.add(Byte.class);
        WRAPPER_TYPE_MAP.add(Character.class);
        WRAPPER_TYPE_MAP.add(Boolean.class);
        WRAPPER_TYPE_MAP.add(Double.class);
        WRAPPER_TYPE_MAP.add(Float.class);
        WRAPPER_TYPE_MAP.add(Long.class);
        WRAPPER_TYPE_MAP.add(Short.class);
        WRAPPER_TYPE_MAP.add(Void.class);
    }
}

