/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import gaiasky.GaiaSky;
import gaiasky.GaiaSkyView;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.beans.ComboBoxBean;
import gaiasky.gui.beans.ElevationComboBoxBean;
import gaiasky.gui.beans.FileComboBoxBean;
import gaiasky.gui.beans.LangComboBoxBean;
import gaiasky.gui.beans.MappingFileComboBoxBean;
import gaiasky.gui.beans.StringComobBoxBean;
import gaiasky.gui.datasets.DatasetManagerWindow;
import gaiasky.gui.main.GSKeys;
import gaiasky.gui.main.GamepadMappings;
import gaiasky.gui.main.KeyBindings;
import gaiasky.gui.window.ColorPicker;
import gaiasky.gui.window.GamepadConfigWindow;
import gaiasky.gui.window.GenericDialog;
import gaiasky.gui.window.KeyframePreferencesWindow;
import gaiasky.util.DownloadHelper;
import gaiasky.util.GlobalResources;
import gaiasky.util.GuiUtils;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SettingsManager;
import gaiasky.util.SysUtils;
import gaiasky.util.TextUtils;
import gaiasky.util.datadesc.DataDescriptor;
import gaiasky.util.datadesc.DataDescriptorUtils;
import gaiasky.util.gdx.loader.WarpMeshReader;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.parse.Parser;
import gaiasky.util.scene2d.FileChooser;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnImageButton;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnSelectBox;
import gaiasky.util.scene2d.OwnSliderPlus;
import gaiasky.util.scene2d.OwnTextArea;
import gaiasky.util.scene2d.OwnTextButton;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import gaiasky.util.scene2d.Separator;
import gaiasky.util.screenshot.ImageRenderer;
import gaiasky.util.validator.DoubleValidator;
import gaiasky.util.validator.FloatValidator;
import gaiasky.util.validator.IntValidator;
import gaiasky.util.validator.LongValidator;
import gaiasky.util.validator.RegexpValidator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import net.jafama.FastMath;
import org.apache.commons.io.FileUtils;

public class PreferencesWindow
extends GenericDialog
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(PreferencesWindow.class);
    private final Array<OwnLabel> labels;
    private final DecimalFormat nf3;
    private final GlobalResources globalResources;
    private final boolean welcomeScreen;
    private OwnCheckBox fullScreen;
    private OwnCheckBox windowed;
    private OwnCheckBox maxFps;
    private OwnCheckBox multithreadCb;
    private OwnCheckBox lodFadeCb;
    private OwnCheckBox cbAutoCamRec;
    private OwnCheckBox real;
    private OwnCheckBox invertX;
    private OwnCheckBox invertY;
    private OwnCheckBox highAccuracyPositions;
    private OwnCheckBox shadowsCb;
    private OwnCheckBox displayNotifications;
    private OwnCheckBox displayTimeNoUi;
    private OwnCheckBox pointerCoords;
    private OwnCheckBox modeChangeInfo;
    private OwnCheckBox debugInfo;
    private OwnCheckBox crosshairFocus;
    private OwnCheckBox crosshairClosest;
    private OwnCheckBox crosshairHome;
    private OwnCheckBox pointerGuides;
    private OwnCheckBox newUI;
    private OwnCheckBox exitConfirmation;
    private OwnCheckBox recGridProjectionLines;
    private OwnCheckBox frameCoordinates;
    private OwnCheckBox dynamicResolution;
    private OwnCheckBox ssr;
    private OwnCheckBox eclipses;
    private OwnCheckBox eclipseOutlines;
    private OwnCheckBox starSpheres;
    private OwnCheckBox starDistanceScaling;
    private OwnCheckBox motionTrails;
    private OwnCheckBox shaderCache;
    private OwnCheckBox saveTextures;
    private OwnSelectBox<Graphics.DisplayMode> fullScreenResolutions;
    private OwnSelectBox<ComboBoxBean> graphicsQuality;
    private OwnSelectBox<ComboBoxBean> antiAlias;
    private OwnSelectBox<ComboBoxBean> pointCloudRenderer;
    private OwnSelectBox<ComboBoxBean> lineRenderer;
    private OwnSelectBox<ComboBoxBean> numThreads;
    private OwnSelectBox<ComboBoxBean> screenshotMode;
    private OwnSelectBox<ComboBoxBean> screenshotFormat;
    private OwnSelectBox<ComboBoxBean> frameOutputMode;
    private OwnSelectBox<ComboBoxBean> frameOutputFormat;
    private OwnSelectBox<ComboBoxBean> nShadows;
    private OwnSelectBox<ComboBoxBean> distUnitsSelect;
    private OwnSelectBox<ComboBoxBean> toneMappingSelect;
    private OwnSelectBox<ComboBoxBean> textureIndex;
    private OwnSelectBox<LangComboBoxBean> lang;
    private OwnSelectBox<ElevationComboBoxBean> elevationSb;
    private OwnSelectBox<String> recGridOrigin;
    private OwnSelectBox<String> recGridStyle;
    private OwnSelectBox<StringComobBoxBean> theme;
    private OwnSelectBox<FileComboBoxBean> gamepadMappings;
    private OwnSelectBox<Settings.ReprojectionMode> reprojectionMode;
    private OwnSelectBox<Settings.UpscaleFilter> upscaleFilter;
    private OwnTextField fadeTimeField;
    private OwnTextField widthField;
    private OwnTextField heightField;
    private OwnTextField ssWidthField;
    private OwnTextField ssHeightField;
    private OwnTextField frameOutputPrefix;
    private OwnTextField frameOutputFps;
    private OwnTextField foWidthField;
    private OwnTextField foHeightField;
    private OwnTextField camRecFps;
    private OwnTextField cmResolution;
    private OwnTextField plResolution;
    private OwnTextField plAperture;
    private OwnTextField plAngle;
    private OwnTextField smResolution;
    private OwnTextField maxFpsInput;
    private OwnTextField evwField;
    private OwnTextField evhField;
    private OwnSliderPlus lodTransitions;
    private OwnSliderPlus tessQuality;
    private OwnSliderPlus minimapSize;
    private OwnSliderPlus pointerGuidesWidth;
    private OwnSliderPlus uiScale;
    private OwnSliderPlus backBufferScale;
    private OwnSliderPlus celestialSphereIndexOfRefraction;
    private OwnSliderPlus bloomEffect;
    private OwnSliderPlus screenshotQuality;
    private OwnSliderPlus frameQuality;
    private OwnSliderPlus unsharpMask;
    private OwnSliderPlus svtCacheSize;
    private OwnSliderPlus chromaticAberration;
    private OwnSliderPlus filmGrain;
    private OwnSliderPlus lensFlare;
    private OwnSliderPlus velocityVectors;
    private OwnSliderPlus motionBlur;
    private OwnSliderPlus pgResolution;
    private OwnTextButton screenshotsLocation;
    private OwnTextButton frameOutputLocation;
    private OwnTextButton meshWarpFileLocation;
    private Path screenshotsPath;
    private Path frameOutputPath;
    private Path meshWarpFilePath;
    private OwnLabel frameSequenceNumber;
    private ColorPicker pointerGuidesColor;
    private OwnLabel tessQualityLabel;
    private Cell<?> noticeHiResCell;
    private Table controllersTable;
    private Settings.ToneMapping toneMappingBak;
    private float brightnessBak;
    private float contrastBak;
    private float hueBak;
    private float saturationBak;
    private float gammaBak;
    private float exposureBak;
    private float bloomBak;
    private float unsharpMaskBak;
    private float aberrationBak;
    private float lensFlareBak;
    private float filmGrainBak;
    private boolean lightGlowBak;
    private boolean debugInfoBak;
    private boolean frameCoordinatesBak;
    private int FXAAQuality;
    private int FXAAQualityBak;
    private Settings.ReprojectionMode reprojectionBak;
    private Settings.UpscaleFilter upscaleFilterBak;
    private AtomicBoolean vsyncValue;

    public PreferencesWindow(Stage stage, Skin skin, GlobalResources globalResources) {
        this(stage, skin, globalResources, false);
    }

    public PreferencesWindow(Stage stage, Skin skin, GlobalResources globalResources, boolean welcomeScreen) {
        super(I18n.msg("gui.settings") + " - " + Settings.settings.version.version + " - " + I18n.msg("gui.build", Settings.settings.version.build), skin, stage);
        this.tabContents = new Array();
        this.labels = new Array();
        this.globalResources = globalResources;
        this.welcomeScreen = welcomeScreen;
        this.nf3 = new DecimalFormat("0.000");
        this.setAcceptText(I18n.msg("gui.saveprefs"));
        this.setCancelText(I18n.msg("gui.cancel"));
        this.buildSuper();
        EventManager.instance.subscribe((IObserver)this, Event.CONTROLLER_CONNECTED_INFO, Event.CONTROLLER_DISCONNECTED_INFO);
        EventManager.instance.subscribe((IObserver)this, Event.INVERT_Y_CMD, Event.INVERT_X_CMD, Event.WINDOW_RESOLUTION_INFO);
    }

    private OwnTextIconButton createTab(String title, Image img, Skin skin) {
        OwnTextIconButton tab = new OwnTextIconButton(TextUtils.capString(title, 26), 8, img, skin, "toggle-big");
        tab.addListener((EventListener)new OwnTextTooltip(title, skin));
        tab.pad(pad10);
        tab.setWidth(480.0f);
        return tab;
    }

    private void addContentGroup(Table container, Label title, WidgetGroup content, float padTop) {
        container.add((Actor)title).left().padTop(padTop).row();
        container.add((Actor)new Separator(this.skin, "small")).bottom().left().expandX().fillX().padBottom(pad20).row();
        container.add((Actor)content).left().row();
    }

    private void addContentGroup(Table container, Label title, WidgetGroup content) {
        this.addContentGroup(container, title, content, pad34 * 2.0f);
    }

    @Override
    protected void build() {
        float taWidth = 960.0f;
        float inputSmallWidth = 283.0f;
        float inputWidth = 600.0f;
        float selectWidth = 600.0f;
        float scrollHeight = 640.0f;
        float controlsScrollWidth = 1430.0f;
        float controlsScrollHeight = 600.0f;
        float sliderWidth = 600.0f;
        float buttonHeight = 40.0f;
        Settings settings = Settings.settings;
        boolean safeMode = settings.program.safeMode;
        boolean vr = settings.runtime.openXr;
        Table tabsTable = new Table(this.skin);
        tabsTable.align(10);
        OwnTextIconButton tabGraphics = this.createTab(I18n.msg("gui.graphicssettings"), new Image(this.skin.getDrawable("iconic-bolt")), this.skin);
        OwnTextIconButton tabScene = this.createTab(I18n.msg("gui.ui.scene.settings"), new Image(this.skin.getDrawable("iconic-compass")), this.skin);
        OwnTextIconButton tabUI = this.createTab(I18n.msg("gui.ui.interfacesettings"), new Image(this.skin.getDrawable("iconic-browser")), this.skin);
        OwnTextIconButton tabPerformance = this.createTab(I18n.msg("gui.performance"), new Image(this.skin.getDrawable("iconic-dial")), this.skin);
        OwnTextIconButton tabControls = this.createTab(I18n.msg("gui.controls"), new Image(this.skin.getDrawable("iconic-laptop")), this.skin);
        OwnTextIconButton tabScreenshots = this.createTab(I18n.msg("gui.screenshots"), new Image(this.skin.getDrawable("iconic-image")), this.skin);
        OwnTextIconButton tabFrames = this.createTab(I18n.msg("gui.frameoutput.title"), new Image(this.skin.getDrawable("iconic-layers")), this.skin);
        OwnTextIconButton tabCamera = this.createTab(I18n.msg("gui.camerarec.title"), new Image(this.skin.getDrawable("iconic-camera-slr")), this.skin);
        OwnTextIconButton tab360 = this.createTab(I18n.msg("gui.360.title"), new Image(this.skin.getDrawable("iconic-cubemap")), this.skin);
        OwnTextIconButton tabPlanetarium = this.createTab(I18n.msg("gui.planetarium.title"), new Image(this.skin.getDrawable("iconic-dome")), this.skin);
        OwnTextIconButton tabData = this.createTab(I18n.msg("gui.data"), new Image(this.skin.getDrawable("iconic-clipboard")), this.skin);
        OwnTextIconButton tabSystem = this.createTab(I18n.msg("gui.system"), new Image(this.skin.getDrawable("iconic-terminal")), this.skin);
        tabsTable.add((Actor)tabGraphics).row();
        tabsTable.add((Actor)tabScene).row();
        tabsTable.add((Actor)tabUI).row();
        tabsTable.add((Actor)tabPerformance).row();
        tabsTable.add((Actor)tabControls).row();
        tabsTable.add((Actor)tabScreenshots).row();
        tabsTable.add((Actor)tabFrames).row();
        tabsTable.add((Actor)tabCamera).row();
        tabsTable.add((Actor)tab360).row();
        tabsTable.add((Actor)tabPlanetarium).row();
        tabsTable.add((Actor)tabData).row();
        tabsTable.add((Actor)tabSystem).row();
        this.content.add((Actor)tabsTable).align(10).padLeft(pad10);
        this.tabButtons = new Array();
        this.tabButtons.add((Object)tabGraphics);
        this.tabButtons.add((Object)tabScene);
        this.tabButtons.add((Object)tabUI);
        this.tabButtons.add((Object)tabPerformance);
        this.tabButtons.add((Object)tabControls);
        this.tabButtons.add((Object)tabScreenshots);
        this.tabButtons.add((Object)tabFrames);
        this.tabButtons.add((Object)tabCamera);
        this.tabButtons.add((Object)tab360);
        this.tabButtons.add((Object)tabPlanetarium);
        this.tabButtons.add((Object)tabData);
        this.tabButtons.add((Object)tabSystem);
        this.tabStack = new Stack();
        IntValidator widthValidator = new IntValidator(100, 10000);
        IntValidator heightValidator = new IntValidator(100, 10000);
        Table contentGraphicsTable = new Table(this.skin);
        OwnScrollPane contentGraphics = new OwnScrollPane((Actor)contentGraphicsTable, this.skin, "minimalist-nobg");
        contentGraphics.setHeight(640.0f);
        contentGraphics.setScrollingDisabled(true, false);
        contentGraphics.setFadeScrollBars(false);
        contentGraphicsTable.align(10);
        OwnLabel titlePresets = new OwnLabel((CharSequence)I18n.msg("gui.presets"), this.skin, "header");
        Table presets = new Table();
        float buttonWidth = 200.0f;
        OwnTextButton low = new OwnTextButton(I18n.msg("gui.presets.low"), this.skin);
        low.setWidth(buttonWidth);
        low.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                PreferencesWindow.this.graphicsQuality.setSelectedIndex(Settings.GraphicsQuality.LOW.ordinal());
                PreferencesWindow.this.antiAlias.setSelectedIndex(PreferencesWindow.this.idxAa(Settings.PostprocessSettings.AntialiasType.NONE));
                PreferencesWindow.this.FXAAQuality = 0;
                PreferencesWindow.this.pointCloudRenderer.setSelectedIndex(Settings.PointCloudMode.POINTS.ordinal());
                PreferencesWindow.this.lineRenderer.setSelectedIndex(Settings.LineMode.GL_LINES.ordinal());
                PreferencesWindow.this.lensFlare.setValue(0.0f);
                Settings.settings.postprocess.lensFlare.type = Settings.LensFlareType.SIMPLE;
                PreferencesWindow.this.bloomEffect.setValue(0.0f);
                PreferencesWindow.this.unsharpMask.setValue(0.0f);
                PreferencesWindow.this.chromaticAberration.setValue(0.0f);
                PreferencesWindow.this.filmGrain.setValue(0.0f);
                PreferencesWindow.this.elevationSb.setSelectedIndex(Settings.ElevationType.NONE.ordinal());
                PreferencesWindow.this.shadowsCb.setChecked(false);
                PreferencesWindow.this.motionBlur.setValue(0.0f);
                PreferencesWindow.this.toneMappingSelect.setSelectedIndex(Settings.ToneMapping.NONE.ordinal());
            }
        });
        low.pad(pad10, pad20, pad10, pad20);
        low.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.presets.low.info"), this.skin));
        OwnTextButton medium = new OwnTextButton(I18n.msg("gui.presets.med"), this.skin);
        medium.setWidth(buttonWidth);
        medium.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                PreferencesWindow.this.graphicsQuality.setSelectedIndex(Settings.GraphicsQuality.NORMAL.ordinal());
                PreferencesWindow.this.antiAlias.setSelectedIndex(PreferencesWindow.this.idxAa(Settings.PostprocessSettings.AntialiasType.FXAA));
                PreferencesWindow.this.FXAAQuality = 1;
                PreferencesWindow.this.pointCloudRenderer.setSelectedIndex(Settings.PointCloudMode.TRIANGLES.ordinal());
                PreferencesWindow.this.lineRenderer.setSelectedIndex(Settings.LineMode.POLYLINE_QUADSTRIP.ordinal());
                PreferencesWindow.this.lensFlare.setValue(1.0f);
                Settings.settings.postprocess.lensFlare.type = Settings.LensFlareType.SIMPLE;
                PreferencesWindow.this.elevationSb.setSelectedIndex(Settings.ElevationType.REGULAR.ordinal());
                PreferencesWindow.this.shadowsCb.setChecked(true);
                PreferencesWindow.this.nShadows.setSelectedIndex(4);
                if (PreferencesWindow.this.smResolution.getDoubleValue(0.0) < 1024.0) {
                    PreferencesWindow.this.smResolution.setText("1024");
                }
            }
        });
        medium.pad(pad10, pad20, pad10, pad20);
        medium.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.presets.med.info"), this.skin));
        OwnTextButton ownTextButton = new OwnTextButton(I18n.msg("gui.presets.high"), this.skin);
        ownTextButton.setWidth(buttonWidth);
        ownTextButton.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                PreferencesWindow.this.graphicsQuality.setSelectedIndex(Settings.GraphicsQuality.HIGH.ordinal());
                PreferencesWindow.this.antiAlias.setSelectedIndex(PreferencesWindow.this.idxAa(Settings.PostprocessSettings.AntialiasType.FXAA));
                PreferencesWindow.this.FXAAQuality = 2;
                PreferencesWindow.this.pointCloudRenderer.setSelectedIndex(Settings.PointCloudMode.TRIANGLES.ordinal());
                PreferencesWindow.this.lineRenderer.setSelectedIndex(Settings.LineMode.POLYLINE_QUADSTRIP.ordinal());
                PreferencesWindow.this.lensFlare.setValue(1.0f);
                Settings.settings.postprocess.lensFlare.type = Settings.LensFlareType.COMPLEX;
                PreferencesWindow.this.elevationSb.setSelectedIndex(Settings.ElevationType.TESSELLATION.ordinal());
                PreferencesWindow.this.shadowsCb.setChecked(true);
                PreferencesWindow.this.nShadows.setSelectedIndex(5);
                if (PreferencesWindow.this.smResolution.getDoubleValue(0.0) < 2048.0) {
                    PreferencesWindow.this.smResolution.setText("2048");
                }
            }
        });
        ownTextButton.pad(pad10, pad20, pad10, pad20);
        ownTextButton.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.presets.high.info"), this.skin));
        presets.add((Actor)low).left().padRight(pad34).padBottom(pad10);
        presets.add((Actor)new OwnLabel((CharSequence)TextUtils.breakCharacters(I18n.msg("gui.presets.low.info"), 80), this.skin)).left().padBottom(pad10).padRight(pad34);
        presets.add((Actor)this.getRequiresRestartLabel()).left().padBottom(pad10).row();
        presets.add((Actor)medium).center().padRight(pad34).padBottom(pad10);
        presets.add((Actor)new OwnLabel((CharSequence)TextUtils.breakCharacters(I18n.msg("gui.presets.med.info"), 80), this.skin)).left().padBottom(pad10).padRight(pad34);
        presets.add((Actor)this.getRequiresRestartLabel()).left().padBottom(pad10).row();
        presets.add((Actor)ownTextButton).center().padRight(pad34).padBottom(pad10);
        presets.add((Actor)new OwnLabel((CharSequence)TextUtils.breakCharacters(I18n.msg("gui.presets.high.info"), 80), this.skin)).left().padBottom(pad10).padRight(pad34);
        presets.add((Actor)this.getRequiresRestartLabel()).left().padBottom(pad10).row();
        this.addContentGroup(contentGraphicsTable, titlePresets, (WidgetGroup)presets, 0.0f);
        OwnLabel titleResolution = new OwnLabel((CharSequence)I18n.msg("gui.resolutionmode"), this.skin, "header");
        Table mode = new Table();
        Array modes = new Array((Object[])Gdx.graphics.getDisplayModes());
        modes.sort((o1, o2) -> Integer.compare(o2.height * o2.width, o1.height * o1.width));
        this.fullScreenResolutions = new OwnSelectBox(this.skin);
        this.fullScreenResolutions.setWidth(600.0f);
        this.fullScreenResolutions.setItems(modes);
        Graphics.DisplayMode selectedMode = null;
        for (Graphics.DisplayMode displayMode : modes) {
            if (displayMode.width != settings.graphics.fullScreen.resolution[0] || displayMode.height != settings.graphics.fullScreen.resolution[1] || displayMode.bitsPerPixel != settings.graphics.fullScreen.bitDepth || displayMode.refreshRate != settings.graphics.fullScreen.refreshRate) continue;
            selectedMode = displayMode;
            break;
        }
        if (selectedMode != null) {
            this.fullScreenResolutions.setSelected(selectedMode);
        }
        Table windowedResolutions = new Table(this.skin);
        this.widthField = new OwnTextField("", this.skin, widthValidator);
        this.widthField.setWidth(283.0f);
        this.heightField = new OwnTextField("", this.skin, heightValidator);
        this.heightField.setWidth(283.0f);
        OwnLabel ownLabel = new OwnLabel((CharSequence)"x", this.skin);
        this.populateWidthHeight(false);
        windowedResolutions.add((Actor)this.widthField).left().padRight(pad10);
        windowedResolutions.add((Actor)ownLabel).left().padRight(pad10);
        windowedResolutions.add((Actor)this.heightField).left().row();
        this.fullScreen = new OwnCheckBox(I18n.msg("gui.fullscreen"), this.skin, "radio", pad10);
        this.fullScreen.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.selectFullscreen(this.fullScreen.isChecked(), this.widthField, this.heightField, this.fullScreenResolutions, ownLabel);
                return true;
            }
            return false;
        });
        this.fullScreen.setChecked(settings.graphics.fullScreen.active);
        this.windowed = new OwnCheckBox(I18n.msg("gui.windowed"), this.skin, "radio", pad10);
        this.windowed.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.selectFullscreen(!this.windowed.isChecked(), this.widthField, this.heightField, this.fullScreenResolutions, ownLabel);
                return true;
            }
            return false;
        });
        this.windowed.setChecked(!settings.graphics.fullScreen.active);
        this.selectFullscreen(settings.graphics.fullScreen.active, this.widthField, this.heightField, this.fullScreenResolutions, ownLabel);
        new ButtonGroup((Button[])new OwnCheckBox[]{this.fullScreen, this.windowed});
        OwnLabel vsyncLabel = new OwnLabel((CharSequence)I18n.msg("gui.vsync"), this.skin);
        OwnCheckBox vSync = new OwnCheckBox("", this.skin);
        vSync.setName("V-sync");
        vSync.setChecked(settings.graphics.vsync);
        this.vsyncValue = new AtomicBoolean(settings.graphics.vsync);
        vSync.addListener(e -> {
            if (e instanceof ChangeListener.ChangeEvent) {
                ChangeListener.ChangeEvent ce = (ChangeListener.ChangeEvent)e;
                this.vsyncValue.set(((OwnCheckBox)ce.getTarget()).isChecked());
                return true;
            }
            return false;
        });
        DoubleValidator limitFpsValidator = new DoubleValidator(0.05, 1000.0);
        double limitFps = settings.graphics.fpsLimit <= 0.0 ? 60.0 : settings.graphics.fpsLimit;
        this.maxFpsInput = new OwnTextField(this.nf3.format(MathUtilsDouble.clamp(limitFps, 0.05, 1000.0)), this.skin, limitFpsValidator);
        this.maxFpsInput.setDisabled(settings.graphics.fpsLimit <= 0.0);
        OwnLabel maxFpsLabel = new OwnLabel((CharSequence)I18n.msg("gui.limitfps"), this.skin);
        this.maxFps = new OwnCheckBox("", this.skin);
        this.maxFps.setChecked(settings.graphics.fpsLimit > 0.0);
        this.maxFps.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.enableComponents(this.maxFps.isChecked(), new Disableable[]{this.maxFpsInput});
                return true;
            }
            return false;
        });
        HorizontalGroup maxFpsGroup = new HorizontalGroup();
        maxFpsGroup.space(pad18);
        maxFpsGroup.addActor((Actor)this.maxFps);
        maxFpsGroup.addActor((Actor)this.maxFpsInput);
        this.labels.addAll((Object[])new OwnLabel[]{vsyncLabel, maxFpsLabel});
        mode.add((Actor)this.fullScreen).left().padRight(pad18);
        mode.add(this.fullScreenResolutions).left().row();
        mode.add((Actor)this.windowed).left().padRight(pad18).padTop(pad18).padBottom(pad18);
        mode.add((Actor)windowedResolutions).left().padTop(pad18).padBottom(pad18).row();
        mode.add((Actor)vsyncLabel).left().padRight(pad34).padBottom(pad10);
        mode.add((Actor)vSync).left().padBottom(pad10).row();
        mode.add((Actor)maxFpsLabel).left().padRight(pad34).padBottom(pad10);
        mode.add((Actor)maxFpsGroup).left().padBottom(pad10).row();
        this.addContentGroup(contentGraphicsTable, titleResolution, (WidgetGroup)mode);
        if (GaiaSky.instance.isExternalView()) {
            GaiaSkyView externalView = GaiaSky.instance.gaiaSkyView;
            OwnLabel titleExternal = new OwnLabel((CharSequence)I18n.msg("gui.extview.settings"), this.skin, "header");
            Table extView = new Table();
            OwnLabel winSizeLabel = new OwnLabel((CharSequence)I18n.msg("gui.extview.windowsize"), this.skin);
            Table extViewSize = new Table(this.skin);
            this.evwField = new OwnTextField("", this.skin, widthValidator);
            this.evwField.setWidth(283.0f);
            this.evhField = new OwnTextField("", this.skin, heightValidator);
            this.evhField.setWidth(283.0f);
            OwnLabel ownLabel2 = new OwnLabel((CharSequence)"x", this.skin);
            this.populateWidthHeight(true, this.evwField, this.evhField, (Graphics)externalView.graphics);
            extViewSize.add((Actor)this.evwField).left().padRight(pad10);
            extViewSize.add((Actor)ownLabel2).left().padRight(pad10);
            extViewSize.add((Actor)this.evhField).left().row();
            OwnLabel resolutionLabel = new OwnLabel((CharSequence)I18n.msg("gui.extview.resolution"), this.skin);
            float w = (float)((double)Gdx.graphics.getWidth() * Settings.settings.graphics.backBufferScale);
            float h = (float)((double)Gdx.graphics.getHeight() * Settings.settings.graphics.backBufferScale);
            String resInfo = TextUtils.breakCharacters(I18n.msg("gui.extview.resolution.info", Integer.toString(MathUtils.round((float)w)), Integer.toString(MathUtils.round((float)h))), 45);
            OwnLabel infoLabel = new OwnLabel((CharSequence)resInfo, this.skin);
            this.labels.add((Object)winSizeLabel, (Object)resolutionLabel);
            extView.add((Actor)winSizeLabel).left().padRight(pad18);
            extView.add((Actor)extViewSize).left().padBottom(pad18).row();
            extView.add((Actor)resolutionLabel).left().padTop(pad18).padRight(pad18);
            extView.add((Actor)infoLabel).left().padTop(pad18).row();
            this.addContentGroup(contentGraphicsTable, titleExternal, (WidgetGroup)extView);
        }
        OwnLabel titleGraphics = new OwnLabel((CharSequence)I18n.msg("gui.graphicssettings"), this.skin, "header");
        Table graphics = new Table();
        OwnLabel graphicsQualityLabel = new OwnLabel((CharSequence)I18n.msg("gui.gquality"), this.skin);
        graphicsQualityLabel.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.gquality.info"), this.skin));
        Object[] gqs = new ComboBoxBean[Settings.GraphicsQuality.values().length];
        int i = 0;
        for (Settings.GraphicsQuality q : Settings.GraphicsQuality.values()) {
            gqs[i] = new ComboBoxBean(I18n.msg(q.key), q.ordinal());
            ++i;
        }
        this.graphicsQuality = new OwnSelectBox(this.skin);
        this.graphicsQuality.setItems(gqs);
        this.graphicsQuality.setWidth(600.0f);
        this.graphicsQuality.setSelected(gqs[settings.graphics.quality.ordinal()]);
        this.graphicsQuality.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                ComboBoxBean s = (ComboBoxBean)this.graphicsQuality.getSelected();
                Settings.GraphicsQuality gq = Settings.GraphicsQuality.values()[s.value];
                if (!(DataDescriptor.localDataDescriptor != null && DataDescriptor.localDataDescriptor.datasetPresent("hi-res-textures") || !gq.isHigh() && !gq.isUltra())) {
                    if (this.noticeHiResCell != null && this.noticeHiResCell.getActor() == null) {
                        String infoString = I18n.msg("gui.gquality.hires.info") + "\n";
                        int lines1 = GlobalResources.countOccurrences(infoString, '\n');
                        OwnTextArea noticeHiRes = new OwnTextArea(infoString, this.skin, "info");
                        noticeHiRes.setDisabled(true);
                        noticeHiRes.setPrefRows(lines1 + 1);
                        noticeHiRes.setWidth(1200.0f);
                        noticeHiRes.clearListeners();
                        this.noticeHiResCell.setActor((Actor)noticeHiRes);
                    }
                } else if (this.noticeHiResCell != null) {
                    this.noticeHiResCell.setActor(null);
                }
            }
            return false;
        });
        OwnImageButton ownImageButton = new OwnImageButton(this.skin, "tooltip");
        ownImageButton.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.gquality.info"), this.skin));
        OwnLabel aaLabel = new OwnLabel((CharSequence)I18n.msg("gui.aa"), this.skin);
        aaLabel.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.aa.info"), this.skin));
        Object[] aas = new ComboBoxBean[]{new ComboBoxBean(I18n.msg("gui.aa.no"), 0), new ComboBoxBean(I18n.msg("gui.aa.fxaa"), -1), new ComboBoxBean(I18n.msg("gui.aa.nfaa"), -2)};
        this.antiAlias = new OwnSelectBox(this.skin);
        this.antiAlias.setItems(aas);
        this.antiAlias.setWidth(600.0f);
        this.antiAlias.setSelected(aas[this.idxAa(settings.postprocess.antialiasing.type)]);
        this.FXAAQuality = settings.postprocess.antialiasing.quality;
        OwnImageButton aaTooltip = new OwnImageButton(this.skin, "tooltip");
        aaTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.aa.info"), this.skin));
        Object[] pointCloudItems = new ComboBoxBean[]{new ComboBoxBean(I18n.msg("gui.pointcloud.tris"), Settings.PointCloudMode.TRIANGLES.ordinal()), new ComboBoxBean(I18n.msg("gui.pointcloud.points"), Settings.PointCloudMode.POINTS.ordinal())};
        this.pointCloudRenderer = new OwnSelectBox(this.skin);
        this.pointCloudRenderer.setItems(pointCloudItems);
        this.pointCloudRenderer.setWidth(600.0f);
        this.pointCloudRenderer.setSelected(pointCloudItems[settings.scene.renderer.pointCloud.ordinal()]);
        OwnLabel lrLabel = new OwnLabel((CharSequence)I18n.msg("gui.linerenderer"), this.skin);
        Object[] lineRenderers = new ComboBoxBean[]{new ComboBoxBean(I18n.msg("gui.linerenderer.quads"), Settings.LineMode.POLYLINE_QUADSTRIP.ordinal()), new ComboBoxBean(I18n.msg("gui.linerenderer.lines"), Settings.LineMode.GL_LINES.ordinal())};
        this.lineRenderer = new OwnSelectBox(this.skin);
        this.lineRenderer.setItems(lineRenderers);
        this.lineRenderer.setWidth(600.0f);
        this.lineRenderer.setSelected(lineRenderers[settings.scene.renderer.line.mode.ordinal()]);
        lrLabel.setDisabled(safeMode);
        this.lineRenderer.setDisabled(safeMode);
        OwnLabel bloomLabel = new OwnLabel((CharSequence)I18n.msg("gui.bloom"), this.skin, "default");
        this.bloomEffect = new OwnSliderPlus("", 0.0f, 2.0f, 0.01f, this.skin);
        this.bloomEffect.setName("bloom effect");
        this.bloomEffect.setWidth(600.0f);
        this.bloomEffect.setValue(settings.postprocess.bloom.intensity);
        this.bloomEffect.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.BLOOM_CMD, (Object)this.bloomEffect, Float.valueOf(this.bloomEffect.getValue()));
                return true;
            }
            return false;
        });
        OwnLabel unsharpMaskLabel = new OwnLabel((CharSequence)I18n.msg("gui.unsharpmask"), this.skin, "default");
        this.unsharpMask = new OwnSliderPlus("", 0.0f, 3.0f, 0.01f, this.skin);
        this.unsharpMask.setName("unsharp mask factor");
        this.unsharpMask.setWidth(600.0f);
        this.unsharpMask.setValue(settings.postprocess.unsharpMask.factor);
        this.unsharpMask.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.UNSHARP_MASK_CMD, (Object)this.unsharpMask, Float.valueOf(this.unsharpMask.getValue()));
                return true;
            }
            return false;
        });
        OwnLabel chromaticAberrationLabel = new OwnLabel((CharSequence)I18n.msg("gui.chromaticaberration"), this.skin, "default");
        this.chromaticAberration = new OwnSliderPlus("", 0.0f, 0.05f, 0.001f, this.skin);
        this.chromaticAberration.setName("chromatic aberration amount");
        this.chromaticAberration.setWidth(600.0f);
        this.chromaticAberration.setValue(settings.postprocess.chromaticAberration.amount);
        this.chromaticAberration.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.CHROMATIC_ABERRATION_CMD, (Object)this.chromaticAberration, Float.valueOf(this.chromaticAberration.getValue()));
                return true;
            }
            return false;
        });
        OwnLabel filmGrainLabel = new OwnLabel((CharSequence)I18n.msg("gui.filmgrain"), this.skin, "default");
        this.filmGrain = new OwnSliderPlus("", 0.0f, 1.0f, 0.001f, this.skin);
        this.filmGrain.setName("film grain intensity");
        this.filmGrain.setWidth(600.0f);
        this.filmGrain.setValue(settings.postprocess.filmGrain.intensity);
        this.filmGrain.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.FILM_GRAIN_CMD, (Object)this.filmGrain, Float.valueOf(this.filmGrain.getValue()));
                return true;
            }
            return false;
        });
        this.labels.addAll((Object[])new OwnLabel[]{graphicsQualityLabel, aaLabel, lrLabel, bloomLabel, chromaticAberrationLabel, filmGrainLabel});
        OwnLabel lensFlareLabel = new OwnLabel((CharSequence)I18n.msg("gui.lensflare"), this.skin);
        this.lensFlare = new OwnSliderPlus("", 0.0f, 1.5f, 0.01f, this.skin);
        this.lensFlare.setName("lens flare strength");
        this.lensFlare.setWidth(600.0f);
        this.lensFlare.setValue(settings.postprocess.lensFlare.strength);
        this.lensFlare.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.LENS_FLARE_CMD, (Object)this.lensFlare, Float.valueOf(this.lensFlare.getValue()));
                return true;
            }
            return false;
        });
        OwnLabel fadeTimeLabel = new OwnLabel((CharSequence)I18n.msg("gui.fadetime"), this.skin, "default");
        LongValidator fadeTimeValidator = new LongValidator(0L, 30000L);
        this.fadeTimeField = new OwnTextField(Long.toString(settings.scene.fadeMs), this.skin, fadeTimeValidator);
        this.fadeTimeField.setWidth(600.0f);
        OwnImageButton fadeTimeTooltip = new OwnImageButton(this.skin, "tooltip");
        fadeTimeTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.fadetime.info"), this.skin));
        graphics.add((Actor)graphicsQualityLabel).left().padRight(pad34).padBottom(pad10);
        graphics.add(this.graphicsQuality).left().padRight(pad18).padBottom(pad10);
        graphics.add((Actor)ownImageButton).left().padBottom(pad10).padRight(pad10);
        graphics.add((Actor)this.getRequiresRestartLabel()).left().padBottom(pad10).row();
        this.noticeHiResCell = graphics.add();
        this.noticeHiResCell.colspan(4).left().row();
        graphics.add((Actor)aaLabel).left().padRight(pad34).padBottom(pad10);
        graphics.add(this.antiAlias).left().padRight(pad18).padBottom(pad10);
        graphics.add((Actor)aaTooltip).colspan(2).left().padBottom(pad10).row();
        OwnLabel pointCloudLabel = new OwnLabel((CharSequence)I18n.msg("gui.pointcloud"), this.skin);
        OwnImageButton pointCloudTooltip = new OwnImageButton(this.skin, "tooltip");
        pointCloudTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.pointcloud.info"), this.skin));
        graphics.add((Actor)pointCloudLabel).left().padRight(pad34).padBottom(pad10);
        graphics.add(this.pointCloudRenderer).left().padBottom(pad10);
        graphics.add((Actor)pointCloudTooltip).left().padRight(pad10).padBottom(pad10);
        graphics.add((Actor)this.getRequiresRestartLabel()).left().padBottom(pad10).row();
        OwnImageButton lineTooltip = new OwnImageButton(this.skin, "tooltip");
        lineTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.linerenderer.info"), this.skin));
        graphics.add((Actor)lrLabel).left().padRight(pad34).padBottom(pad10);
        graphics.add(this.lineRenderer).left().padBottom(pad10);
        graphics.add((Actor)lineTooltip).colspan(2).left().padRight(pad10).padBottom(pad10).row();
        graphics.add((Actor)lensFlareLabel).left().padRight(pad34).padBottom(pad10);
        graphics.add((Actor)this.lensFlare).colspan(3).left().padBottom(pad10).row();
        graphics.add((Actor)bloomLabel).left().padRight(pad34).padBottom(pad10);
        graphics.add((Actor)this.bloomEffect).colspan(3).left().padBottom(pad10).row();
        graphics.add((Actor)unsharpMaskLabel).left().padRight(pad34).padBottom(pad10);
        graphics.add((Actor)this.unsharpMask).colspan(3).left().padBottom(pad10).row();
        graphics.add((Actor)chromaticAberrationLabel).left().padRight(pad34).padBottom(pad10);
        graphics.add((Actor)this.chromaticAberration).colspan(3).left().padBottom(pad10).row();
        graphics.add((Actor)filmGrainLabel).left().padRight(pad34).padBottom(pad10);
        graphics.add((Actor)this.filmGrain).colspan(3).left().padBottom(pad10).row();
        graphics.add((Actor)fadeTimeLabel).left().padRight(pad34).padBottom(pad10);
        graphics.add((Actor)this.fadeTimeField).left().padRight(pad18).padBottom(pad10);
        graphics.add((Actor)fadeTimeTooltip).colspan(2).left().padRight(pad34).padBottom(pad10).row();
        this.addContentGroup(contentGraphicsTable, titleGraphics, (WidgetGroup)graphics);
        OwnLabel titleElevation = new OwnLabel((CharSequence)I18n.msg("gui.elevation.title"), this.skin, "header");
        Table elevation = new Table();
        OwnLabel elevationTypeLabel = new OwnLabel((CharSequence)I18n.msg("gui.elevation.type"), this.skin);
        Object[] ecbb = new ElevationComboBoxBean[Settings.ElevationType.values().length];
        i = 0;
        for (Settings.ElevationType et : Settings.ElevationType.values()) {
            ecbb[i] = new ElevationComboBoxBean(I18n.msg("gui.elevation.type." + et.toString().toLowerCase(Locale.ROOT)), et);
            ++i;
        }
        this.elevationSb = new OwnSelectBox(this.skin);
        this.elevationSb.setItems(ecbb);
        this.elevationSb.setWidth(600.0f);
        this.elevationSb.setSelectedIndex(Settings.settings.scene.renderer.elevation.type.ordinal());
        this.elevationSb.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.enableComponents(((ElevationComboBoxBean)this.elevationSb.getSelected()).type.isTessellation(), new Disableable[]{this.tessQuality, this.tessQualityLabel});
            }
            return false;
        });
        elevationTypeLabel.setDisabled(safeMode);
        this.elevationSb.setDisabled(safeMode);
        this.tessQualityLabel = new OwnLabel((CharSequence)I18n.msg("gui.elevation.tessellation.quality"), this.skin);
        this.tessQualityLabel.setDisabled(!settings.scene.renderer.elevation.type.isTessellation());
        this.tessQuality = new OwnSliderPlus("", 1.0f, 10.0f, 0.1f, this.skin);
        this.tessQuality.setDisabled(!settings.scene.renderer.elevation.type.isTessellation());
        this.tessQuality.setWidth(600.0f);
        this.tessQuality.setValue((float)settings.scene.renderer.elevation.quality);
        this.labels.add((Object)elevationTypeLabel, (Object)this.tessQualityLabel);
        elevation.add((Actor)elevationTypeLabel).left().padRight(pad34).padBottom(pad10);
        elevation.add(this.elevationSb).left().padRight(pad18).padBottom(pad10);
        elevation.add((Actor)this.getRequiresRestartLabel()).left().padBottom(pad10).row();
        elevation.add((Actor)this.tessQualityLabel).left().padRight(pad34).padBottom(pad10);
        elevation.add((Actor)this.tessQuality).left().padRight(pad18).padBottom(pad10);
        this.addContentGroup(contentGraphicsTable, titleElevation, (WidgetGroup)elevation);
        OwnLabel titleShadows = new OwnLabel((CharSequence)I18n.msg("gui.graphics.shadows"), this.skin, "header");
        Table shadows = new Table();
        OwnLabel smResolutionLabel = new OwnLabel((CharSequence)I18n.msg("gui.graphics.shadows.resolution"), this.skin);
        smResolutionLabel.setDisabled(!settings.scene.renderer.shadow.active);
        IntValidator smResValidator = new IntValidator(128, GaiaSky.instance.maxTextureSize);
        this.smResolution = new OwnTextField(Integer.toString(MathUtils.clamp((int)settings.scene.renderer.shadow.resolution, (int)128, (int)GaiaSky.instance.maxTextureSize)), this.skin, smResValidator);
        this.smResolution.setWidth(600.0f);
        this.smResolution.setDisabled(!settings.scene.renderer.shadow.active);
        OwnLabel nShadowsLabel = new OwnLabel((CharSequence)("#" + I18n.msg("gui.graphics.shadows")), this.skin);
        nShadowsLabel.setDisabled(!settings.scene.renderer.shadow.active);
        int n = 10;
        Object[] nsh = new ComboBoxBean[n];
        IntStream.rangeClosed(1, n).forEach(arg_0 -> PreferencesWindow.lambda$build$12((ComboBoxBean[])nsh, arg_0));
        this.nShadows = new OwnSelectBox(this.skin);
        this.nShadows.setItems(nsh);
        this.nShadows.setWidth(600.0f);
        this.nShadows.setSelected(nsh[settings.scene.renderer.shadow.number - 1]);
        this.nShadows.setDisabled(!settings.scene.renderer.shadow.active);
        OwnLabel shadowsLabel = new OwnLabel((CharSequence)I18n.msg("gui.graphics.shadows.enable"), this.skin);
        this.shadowsCb = new OwnCheckBox("", this.skin);
        this.shadowsCb.setChecked(settings.scene.renderer.shadow.active);
        this.shadowsCb.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.enableComponents(this.shadowsCb.isChecked(), new Disableable[]{this.smResolution, smResolutionLabel, this.nShadows, nShadowsLabel});
                return true;
            }
            return false;
        });
        this.labels.add((Object)smResolutionLabel);
        shadows.add((Actor)shadowsLabel).left().padRight(pad34).padBottom(pad10);
        shadows.add((Actor)this.shadowsCb).left().padRight(pad18).padBottom(pad10).row();
        shadows.add((Actor)smResolutionLabel).left().padRight(pad34).padBottom(pad10);
        shadows.add((Actor)this.smResolution).left().padRight(pad18).padBottom(pad10).row();
        shadows.add((Actor)nShadowsLabel).left().padRight(pad34).padBottom(pad10);
        shadows.add(this.nShadows).left().padRight(pad18).padBottom(pad10);
        this.addContentGroup(contentGraphicsTable, titleShadows, (WidgetGroup)shadows);
        OwnLabel titleDisplay = new OwnLabel((CharSequence)I18n.msg("gui.graphics.imglevels"), this.skin, "header");
        Table imageLevels = new Table();
        OwnLabel brightnessLabel = new OwnLabel((CharSequence)I18n.msg("gui.brightness"), this.skin, "default");
        OwnSliderPlus brightness = new OwnSliderPlus("", 0.0f, 100.0f, 1.0f, this.skin);
        brightness.setName("brightness");
        brightness.setWidth(600.0f);
        brightness.setValue(MathUtilsDouble.lint(settings.postprocess.levels.brightness, -1.0f, 1.0f, 0.0f, 100.0f));
        brightness.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.BRIGHTNESS_CMD, brightness, Float.valueOf(MathUtilsDouble.lint(brightness.getValue(), 0.0f, 100.0f, -1.0f, 1.0f)), true);
                return true;
            }
            return false;
        });
        imageLevels.add((Actor)brightnessLabel).left().padRight(pad34).padBottom(pad10);
        imageLevels.add((Actor)brightness).left().padRight(pad18).padBottom(pad10).row();
        OwnLabel contrastLabel = new OwnLabel((CharSequence)I18n.msg("gui.contrast"), this.skin, "default");
        OwnSliderPlus ownSliderPlus = new OwnSliderPlus("", 0.0f, 100.0f, 1.0f, this.skin);
        ownSliderPlus.setName("contrast");
        ownSliderPlus.setWidth(600.0f);
        ownSliderPlus.setValue(MathUtilsDouble.lint(settings.postprocess.levels.contrast, 0.0f, 2.0f, 0.0f, 100.0f));
        ownSliderPlus.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.CONTRAST_CMD, ownSliderPlus, Float.valueOf(MathUtilsDouble.lint(ownSliderPlus.getValue(), 0.0f, 100.0f, 0.0f, 2.0f)), true);
                return true;
            }
            return false;
        });
        imageLevels.add((Actor)contrastLabel).left().padRight(pad34).padBottom(pad10);
        imageLevels.add((Actor)ownSliderPlus).left().padRight(pad18).padBottom(pad10).row();
        OwnLabel hueLabel = new OwnLabel((CharSequence)I18n.msg("gui.hue"), this.skin, "default");
        OwnSliderPlus hue = new OwnSliderPlus("", 0.0f, 100.0f, 1.0f, this.skin);
        hue.setName("hue");
        hue.setWidth(600.0f);
        hue.setValue(MathUtilsDouble.lint(settings.postprocess.levels.hue, 0.0f, 2.0f, 0.0f, 100.0f));
        hue.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.HUE_CMD, hue, Float.valueOf(MathUtilsDouble.lint(hue.getValue(), 0.0f, 100.0f, 0.0f, 2.0f)), true);
                return true;
            }
            return false;
        });
        imageLevels.add((Actor)hueLabel).left().padRight(pad34).padBottom(pad10);
        imageLevels.add((Actor)hue).left().padRight(pad18).padBottom(pad10).row();
        OwnLabel saturationLabel = new OwnLabel((CharSequence)I18n.msg("gui.saturation"), this.skin, "default");
        OwnSliderPlus saturation = new OwnSliderPlus("", 0.0f, 100.0f, 1.0f, this.skin);
        saturation.setName("saturation");
        saturation.setWidth(600.0f);
        saturation.setValue(MathUtilsDouble.lint(settings.postprocess.levels.saturation, 0.0f, 2.0f, 0.0f, 100.0f));
        saturation.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SATURATION_CMD, saturation, Float.valueOf(MathUtilsDouble.lint(saturation.getValue(), 0.0f, 100.0f, 0.0f, 2.0f)), true);
                return true;
            }
            return false;
        });
        imageLevels.add((Actor)saturationLabel).left().padRight(pad34).padBottom(pad10);
        imageLevels.add((Actor)saturation).left().padRight(pad18).padBottom(pad10).row();
        OwnLabel gammaLabel = new OwnLabel((CharSequence)I18n.msg("gui.gamma"), this.skin, "default");
        OwnSliderPlus gamma = new OwnSliderPlus("", 0.001f, 3.0f, 0.01f, false, this.skin);
        gamma.setName("gamma");
        gamma.setWidth(600.0f);
        gamma.setValue(settings.postprocess.levels.gamma);
        gamma.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.GAMMA_CMD, gamma, Float.valueOf(gamma.getValue()), true);
                return true;
            }
            return false;
        });
        imageLevels.add((Actor)gammaLabel).left().padRight(pad34).padBottom(pad10);
        imageLevels.add((Actor)gamma).left().padRight(pad18).padBottom(pad10).row();
        OwnLabel toneMappingLabel = new OwnLabel((CharSequence)I18n.msg("gui.tonemapping.type"), this.skin, "default");
        int nToneMapping = Settings.ToneMapping.values().length;
        Object[] toneMappingTypes = new ComboBoxBean[nToneMapping];
        for (int itm = 0; itm < nToneMapping; ++itm) {
            Settings.ToneMapping tm = Settings.ToneMapping.values()[itm];
            toneMappingTypes[itm] = new ComboBoxBean(I18n.msg("gui.tonemapping." + tm.name().toLowerCase(Locale.ROOT)), tm.ordinal());
        }
        this.toneMappingSelect = new OwnSelectBox(this.skin);
        this.toneMappingSelect.setItems(toneMappingTypes);
        this.toneMappingSelect.setWidth(600.0f);
        this.toneMappingSelect.setSelectedIndex(settings.postprocess.toneMapping.type.ordinal());
        imageLevels.add((Actor)toneMappingLabel).left().padRight(pad34).padBottom(pad10);
        imageLevels.add(this.toneMappingSelect).left().padBottom(pad10).row();
        OwnLabel exposureLabel = new OwnLabel((CharSequence)I18n.msg("gui.exposure"), this.skin, "default");
        exposureLabel.setDisabled(settings.postprocess.toneMapping.type != Settings.ToneMapping.EXPOSURE);
        OwnSliderPlus exposure = new OwnSliderPlus("", 0.0f, 10.0f, 0.1f, false, this.skin);
        exposure.setName("exposure");
        exposure.setWidth(600.0f);
        exposure.setValue(settings.postprocess.toneMapping.exposure);
        exposure.setDisabled(settings.postprocess.toneMapping.type != Settings.ToneMapping.EXPOSURE);
        exposure.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.EXPOSURE_CMD, exposure, Float.valueOf(exposure.getValue()));
                return true;
            }
            return false;
        });
        this.toneMappingSelect.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                Settings.ToneMapping newTM = Settings.ToneMapping.values()[this.toneMappingSelect.getSelectedIndex()];
                EventManager.publish(Event.TONEMAPPING_TYPE_CMD, this.toneMappingSelect, new Object[]{newTM});
                boolean disabled = newTM != Settings.ToneMapping.EXPOSURE;
                exposureLabel.setDisabled(disabled);
                exposure.setDisabled(disabled);
                return true;
            }
            return false;
        });
        imageLevels.add((Actor)exposureLabel).left().padRight(pad34).padBottom(pad10);
        imageLevels.add((Actor)exposure).left().padRight(pad18).padBottom(pad10).row();
        this.labels.addAll((Object[])new OwnLabel[]{brightnessLabel, contrastLabel, hueLabel, saturationLabel, gammaLabel});
        this.addContentGroup(contentGraphicsTable, titleDisplay, (WidgetGroup)imageLevels);
        if (!vr) {
            OwnLabel titleSVT = new OwnLabel((CharSequence)I18n.msg("gui.svt"), this.skin, "header");
            Table svtTable = new Table();
            OwnLabel svtCacheSizeLabel = new OwnLabel((CharSequence)I18n.msg("gui.svt.cachesize"), this.skin, "default");
            this.svtCacheSize = new OwnSliderPlus("", 4.0f, 20.0f, 1.0f, this.skin);
            this.svtCacheSize.setValueLabelTransform(val -> {
                int valInt = val.intValue();
                String value = Integer.toString(valInt * valInt);
                return value.toString() + " (" + valInt + "x" + valInt + ")";
            });
            this.svtCacheSize.setName("cacheSize");
            this.svtCacheSize.setWidth(600.0f);
            this.svtCacheSize.setValue(settings.scene.renderer.virtualTextures.cacheSize);
            OwnImageButton cacheSizeTooltip = new OwnImageButton(this.skin, "tooltip");
            cacheSizeTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.svt.cachesize.info"), this.skin));
            svtTable.add((Actor)svtCacheSizeLabel).left().padRight(pad34).padBottom(pad10);
            svtTable.add((Actor)this.svtCacheSize).left().padRight(pad18).padBottom(pad10);
            svtTable.add((Actor)cacheSizeTooltip).left().padRight(pad18).padBottom(pad10);
            svtTable.add((Actor)this.getRequiresRestartLabel()).left().padBottom(pad10).row();
            this.labels.addAll((Object[])new OwnLabel[]{svtCacheSizeLabel});
            this.addContentGroup(contentGraphicsTable, titleSVT, (WidgetGroup)svtTable);
            OwnLabel titleExperimental = new OwnLabel((CharSequence)I18n.msg("gui.experimental"), this.skin, "header");
            Table experimental = new Table();
            OwnLabel reprojectionLabel = new OwnLabel((CharSequence)I18n.msg("gui.reproj"), this.skin);
            Settings.ReprojectionMode[] reprojectionModes = Settings.ReprojectionMode.values();
            this.reprojectionMode = new OwnSelectBox(this.skin);
            this.reprojectionMode.setItems((Object[])reprojectionModes);
            this.reprojectionMode.setWidth(600.0f);
            if (!settings.postprocess.reprojection.active) {
                this.reprojectionMode.setSelected((Object)reprojectionModes[Settings.ReprojectionMode.DISABLED.ordinal()]);
            } else {
                this.reprojectionMode.setSelected((Object)reprojectionModes[settings.postprocess.reprojection.mode.ordinal()]);
            }
            this.reprojectionMode.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    Settings.ReprojectionMode newMode = (Settings.ReprojectionMode)((Object)((Object)this.reprojectionMode.getSelected()));
                    EventManager.publish(Event.REPROJECTION_CMD, this, new Object[]{newMode != Settings.ReprojectionMode.DISABLED, newMode});
                    return true;
                }
                return false;
            });
            experimental.add((Actor)reprojectionLabel).left().padRight(pad34).padBottom(pad10);
            experimental.add(this.reprojectionMode).left().padRight(pad18).padBottom(pad10).row();
            OwnLabel dynamicResolutionLabel = new OwnLabel((CharSequence)I18n.msg("gui.dynamicresolution"), this.skin);
            this.dynamicResolution = new OwnCheckBox("", this.skin);
            this.dynamicResolution.setChecked(settings.graphics.dynamicResolution);
            OwnImageButton ownImageButton2 = new OwnImageButton(this.skin, "tooltip");
            ownImageButton2.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.dynamicresolution.info"), this.skin));
            experimental.add((Actor)dynamicResolutionLabel).left().padRight(pad34).padBottom(pad10);
            experimental.add((Actor)this.dynamicResolution).left().padRight(pad18).padBottom(pad10);
            experimental.add((Actor)ownImageButton2).left().padBottom(pad10).row();
            OwnLabel backBufferScaleLabel = new OwnLabel((CharSequence)I18n.msg("gui.backbuffer.scale"), this.skin);
            backBufferScaleLabel.setDisabled(settings.graphics.dynamicResolution);
            this.backBufferScale = new OwnSliderPlus("", 0.1f, 4.0f, 0.1f, this.skin);
            this.backBufferScale.setWidth(600.0f);
            this.backBufferScale.setMappedValue(settings.graphics.backBufferScale);
            this.backBufferScale.setDisabled(settings.graphics.dynamicResolution);
            OwnImageButton backBufferTooltip = new OwnImageButton(this.skin, "tooltip");
            backBufferTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.backbuffer.scale.info"), this.skin));
            this.dynamicResolution.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    this.backBufferScale.setDisabled(this.dynamicResolution.isChecked());
                    backBufferScaleLabel.setDisabled(this.dynamicResolution.isChecked());
                    return true;
                }
                return false;
            });
            experimental.add((Actor)backBufferScaleLabel).left().padRight(pad34).padBottom(pad10);
            experimental.add((Actor)this.backBufferScale).left().padRight(pad18).padBottom(pad10);
            experimental.add((Actor)backBufferTooltip).left().padBottom(pad10).row();
            OwnLabel upscaleFilterLabel = new OwnLabel((CharSequence)I18n.msg("gui.upscale.filter"), this.skin);
            Settings.UpscaleFilter[] upscaleFilterValues = Settings.UpscaleFilter.values();
            this.upscaleFilter = new OwnSelectBox(this.skin);
            this.upscaleFilter.setItems((Object[])upscaleFilterValues);
            this.upscaleFilter.setWidth(600.0f);
            this.upscaleFilter.setSelected((Object)upscaleFilterValues[settings.postprocess.upscaleFilter.ordinal()]);
            this.upscaleFilter.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.upscale.filter.info"), this.skin));
            this.upscaleFilter.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    Settings.UpscaleFilter newMode = (Settings.UpscaleFilter)((Object)((Object)this.upscaleFilter.getSelected()));
                    EventManager.publish(Event.UPSCALE_FILTER_CMD, this, this.upscaleFilter.getSelected());
                    return true;
                }
                return false;
            });
            experimental.add((Actor)upscaleFilterLabel).left().padRight(pad34).padBottom(pad10);
            experimental.add(this.upscaleFilter).left().padRight(pad18).padBottom(pad10).row();
            OwnLabel celestialSphereIndexOfRefractionLabel = new OwnLabel((CharSequence)I18n.msg("gui.indexofrefraction"), this.skin);
            this.celestialSphereIndexOfRefraction = new OwnSliderPlus("", 1.0f, 2.5f, 0.05f, this.skin);
            this.celestialSphereIndexOfRefraction.setWidth(600.0f);
            this.celestialSphereIndexOfRefraction.setMappedValue(settings.program.modeCubemap.celestialSphereIndexOfRefraction);
            OwnImageButton celestialSphereIndexOfRefractionTooltip = new OwnImageButton(this.skin, "tooltip");
            celestialSphereIndexOfRefractionTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.indexofrefraction.info"), this.skin));
            experimental.add((Actor)celestialSphereIndexOfRefractionLabel).left().padRight(pad34).padBottom(pad10);
            experimental.add((Actor)this.celestialSphereIndexOfRefraction).left().padRight(pad18).padBottom(pad10);
            experimental.add((Actor)celestialSphereIndexOfRefractionTooltip).left().padBottom(pad10).row();
            OwnLabel ssrLabel = new OwnLabel((CharSequence)I18n.msg("gui.ssr"), this.skin);
            this.ssr = new OwnCheckBox("", this.skin);
            this.ssr.setChecked(!safeMode && settings.postprocess.ssr.active);
            this.ssr.setDisabled(safeMode);
            OwnImageButton ssrTooltip = new OwnImageButton(this.skin, "tooltip");
            ssrTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.ssr.info"), this.skin));
            experimental.add((Actor)ssrLabel).left().padRight(pad34).padBottom(pad10);
            experimental.add((Actor)this.ssr).left().padRight(pad18).padBottom(pad10);
            experimental.add((Actor)ssrTooltip).left().padBottom(pad10).row();
            OwnLabel motionBlurLabel = new OwnLabel((CharSequence)I18n.msg("gui.motionblur"), this.skin);
            this.motionBlur = new OwnSliderPlus("", 0.0f, 2.0f, 0.01f, this.skin);
            this.motionBlur.setWidth(600.0f);
            this.motionBlur.setMappedValue(settings.postprocess.motionBlur.strength);
            this.motionBlur.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    ChangeListener.ChangeEvent ce = (ChangeListener.ChangeEvent)event;
                    EventManager.publish(Event.MOTION_BLUR_CMD, this, Float.valueOf(this.motionBlur.getMappedValue()));
                }
                return false;
            });
            experimental.add((Actor)motionBlurLabel).left().padRight(pad34).padBottom(pad10);
            experimental.add((Actor)this.motionBlur).left().padRight(pad18).padBottom(pad10);
            this.labels.addAll((Object[])new OwnLabel[]{dynamicResolutionLabel});
            this.labels.addAll((Object[])new OwnLabel[]{ssrLabel});
            this.addContentGroup(contentGraphicsTable, titleExperimental, (WidgetGroup)experimental);
        }
        Table contentSceneTable = new Table(this.skin);
        OwnScrollPane contentScene = new OwnScrollPane((Actor)contentSceneTable, this.skin, "minimalist-nobg");
        contentScene.setHeight(640.0f);
        contentScene.setScrollingDisabled(true, false);
        contentScene.setFadeScrollBars(false);
        contentSceneTable.align(10);
        OwnLabel titleStars = new OwnLabel((CharSequence)I18n.msg("gui.ui.scene.stars"), this.skin, "header");
        Table starsTable = new Table();
        OwnLabel textureIndexLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.scene.star.texture"), this.skin);
        IntArray intArray = settings.scene.star.getStarTextureIndices();
        Array indices = new Array(intArray.size);
        ComboBoxBean selected = null;
        for (int y = 0; y < intArray.size; ++y) {
            int idx = intArray.get(y);
            ComboBoxBean cbb = new ComboBoxBean(Integer.toString(idx), idx);
            indices.add((Object)cbb);
            if (idx != settings.scene.star.textureIndex) continue;
            selected = cbb;
        }
        if (!intArray.isEmpty()) {
            this.textureIndex = new OwnSelectBox(this.skin);
            this.textureIndex.setItems(indices);
            if (selected != null) {
                this.textureIndex.setSelected(selected);
            }
        }
        OwnLabel starSpheresLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.scene.star.spheres"), this.skin);
        this.starSpheres = new OwnCheckBox("", this.skin);
        this.starSpheres.setChecked(settings.scene.star.renderStarSpheres);
        OwnLabel glowOverObjectsLabel = new OwnLabel((CharSequence)I18n.msg("gui.lightscattering"), this.skin);
        OwnCheckBox glowOverObjects = new OwnCheckBox("", this.skin);
        glowOverObjects.setName("light scattering");
        glowOverObjects.setChecked(settings.postprocess.lightGlow.active);
        glowOverObjects.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.LIGHT_GLOW_CMD, glowOverObjects, glowOverObjects.isChecked());
                return true;
            }
            return false;
        });
        OwnLabel motionTrailsLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.scene.star.trails"), this.skin);
        this.motionTrails = new OwnCheckBox("", this.skin);
        this.motionTrails.setChecked(settings.scene.particleGroups.motionTrails);
        String[] starDistanceScalingLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.scene.star.distance.scaling"), this.skin);
        this.starDistanceScaling = new OwnCheckBox("", this.skin);
        this.starDistanceScaling.setChecked(settings.scene.camera.starDistanceScaling);
        this.labels.add((Object)textureIndexLabel, (Object)starSpheresLabel, (Object)starDistanceScalingLabel, (Object)glowOverObjectsLabel);
        starsTable.add((Actor)glowOverObjectsLabel).left().padRight(pad34).padBottom(pad10);
        starsTable.add((Actor)glowOverObjects).left().padRight(pad18).padBottom(pad10).row();
        starsTable.add((Actor)motionTrailsLabel).left().padRight(pad34).padBottom(pad10);
        starsTable.add((Actor)this.motionTrails).left().padRight(pad18).padBottom(pad10).row();
        if (this.textureIndex != null) {
            starsTable.add((Actor)textureIndexLabel).left().padRight(pad34).padBottom(pad10);
            starsTable.add(this.textureIndex).left().padRight(pad18).padBottom(pad10).row();
        }
        starsTable.add((Actor)starSpheresLabel).left().padRight(pad34).padBottom(pad10);
        starsTable.add((Actor)this.starSpheres).left().padRight(pad18).padBottom(pad10).row();
        starsTable.add((Actor)starDistanceScalingLabel).left().padRight(pad34).padBottom(pad10);
        starsTable.add((Actor)this.starDistanceScaling).left().padRight(pad18).padBottom(pad10).row();
        this.addContentGroup(contentSceneTable, titleStars, (WidgetGroup)starsTable, 0.0f);
        OwnLabel titleRecgrid = new OwnLabel((CharSequence)I18n.msg("gui.ui.recursivegrid"), this.skin, "header");
        Table rg = new Table();
        OwnLabel originLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.recursivegrid.origin"), this.skin);
        Object[] objectArray = new String[]{I18n.msg("gui.ui.recursivegrid.origin.refsys"), I18n.msg("gui.ui.recursivegrid.origin.focus")};
        this.recGridOrigin = new OwnSelectBox(this.skin);
        this.recGridOrigin.setWidth(600.0f);
        this.recGridOrigin.setItems(objectArray);
        this.recGridOrigin.setSelectedIndex(settings.program.recursiveGrid.origin.ordinal());
        OwnLabel styleLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.recursivegrid.style"), this.skin);
        Object[] styles = new String[]{I18n.msg("gui.ui.recursivegrid.style.circular"), I18n.msg("gui.ui.recursivegrid.style.square")};
        this.recGridStyle = new OwnSelectBox(this.skin);
        this.recGridStyle.setWidth(600.0f);
        this.recGridStyle.setItems(styles);
        this.recGridStyle.setSelectedIndex(settings.program.recursiveGrid.style.ordinal());
        OwnLabel recGridProjectionLinesLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.recursivegrid.projlines"), this.skin);
        this.recGridProjectionLines = new OwnCheckBox("", this.skin);
        this.recGridProjectionLines.setName("origin projection lines cb");
        this.recGridProjectionLines.setChecked(settings.program.recursiveGrid.projectionLines);
        this.labels.add((Object)originLabel, (Object)styleLabel, (Object)recGridProjectionLinesLabel);
        rg.add((Actor)originLabel).left().padBottom(pad10).padRight(pad34);
        rg.add(this.recGridOrigin).left().padBottom(pad10).row();
        rg.add((Actor)styleLabel).left().padBottom(pad10).padRight(pad34);
        rg.add(this.recGridStyle).left().padBottom(pad10).row();
        rg.add((Actor)recGridProjectionLinesLabel).left().padBottom(pad10).padRight(pad34);
        rg.add((Actor)this.recGridProjectionLines).left().padBottom(pad10).row();
        this.addContentGroup(contentSceneTable, titleRecgrid, (WidgetGroup)rg);
        OwnLabel titleEclipses = new OwnLabel((CharSequence)I18n.msg("gui.graphics.eclipses"), this.skin, "header");
        Table eclipsesTable = new Table();
        OwnLabel eclipsesLabel = new OwnLabel((CharSequence)I18n.msg("gui.graphics.eclipses.enable"), this.skin);
        this.eclipses = new OwnCheckBox("", this.skin);
        this.eclipses.setChecked(settings.scene.renderer.eclipses.active);
        this.eclipses.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.enableComponents(this.eclipses.isChecked(), new Disableable[]{this.eclipseOutlines});
                return true;
            }
            return false;
        });
        OwnLabel ownLabel3 = new OwnLabel((CharSequence)I18n.msg("gui.graphics.eclipses.outlines"), this.skin);
        this.eclipseOutlines = new OwnCheckBox("", this.skin);
        this.eclipseOutlines.setChecked(settings.scene.renderer.eclipses.outlines);
        this.labels.add((Object)eclipsesLabel, (Object)ownLabel3);
        eclipsesTable.add((Actor)eclipsesLabel).left().padRight(pad34).padBottom(pad10);
        eclipsesTable.add((Actor)this.eclipses).left().padRight(pad18).padBottom(pad10).row();
        eclipsesTable.add((Actor)ownLabel3).left().padRight(pad34).padBottom(pad10);
        eclipsesTable.add((Actor)this.eclipseOutlines).left().padRight(pad18).padBottom(pad10);
        this.addContentGroup(contentSceneTable, titleEclipses, (WidgetGroup)eclipsesTable);
        OwnLabel titleProcedural = new OwnLabel((CharSequence)I18n.msg("gui.ui.procedural"), this.skin, "header");
        Table procGenTable = new Table();
        OwnLabel pgResolutionLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.procedural.resolution"), this.skin);
        this.pgResolution = new OwnSliderPlus("", 400.0f, 6000.0f, 1.0f, this.skin);
        this.pgResolution.setValueLabelTransform(value -> value.intValue() * 2 + "x" + value.intValue());
        this.pgResolution.setWidth(600.0f);
        this.pgResolution.setValue(settings.graphics.proceduralGenerationResolution[1]);
        this.labels.add((Object)pgResolutionLabel);
        procGenTable.add((Actor)pgResolutionLabel).left().padBottom(pad10).padRight(pad34);
        procGenTable.add((Actor)this.pgResolution).left().padBottom(pad10).row();
        OwnLabel ownLabel4 = new OwnLabel((CharSequence)I18n.msg("gui.procedural.savetextures"), this.skin);
        this.saveTextures = new OwnCheckBox("", this.skin, pad10);
        this.saveTextures.setChecked(Settings.settings.program.saveProceduralTextures);
        OwnImageButton saveTexturesTooltip = new OwnImageButton(this.skin, "tooltip");
        saveTexturesTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.savetextures", SysUtils.getProceduralPixmapDir().toString()), this.skin));
        HorizontalGroup saveTexturesGroup = new HorizontalGroup();
        saveTexturesGroup.space(pad10);
        saveTexturesGroup.addActor((Actor)this.saveTextures);
        saveTexturesGroup.addActor((Actor)saveTexturesTooltip);
        procGenTable.add((Actor)ownLabel4).left().padBottom(pad10).padRight(pad34);
        procGenTable.add((Actor)saveTexturesGroup).left().padBottom(pad10).padRight(pad34);
        this.addContentGroup(contentSceneTable, titleProcedural, (WidgetGroup)procGenTable);
        Table contentUITable = new Table(this.skin);
        OwnScrollPane contentUI = new OwnScrollPane((Actor)contentUITable, this.skin, "minimalist-nobg");
        contentUI.setHeight(640.0f);
        contentUI.setScrollingDisabled(true, false);
        contentUI.setFadeScrollBars(false);
        contentUITable.align(10);
        OwnLabel titleUI = new OwnLabel((CharSequence)I18n.msg("gui.ui.interfacesettings"), this.skin, "header");
        Table table = new Table();
        OwnLabel langLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.language"), this.skin);
        File i18nDir = new File(Settings.ASSETS_LOC + File.separator + "i18n");
        String i18nName = "gsbundle";
        String[] files = i18nDir.list();
        assert (files != null);
        Array langs = new Array();
        int i2 = 0;
        for (String file : files) {
            if (file.startsWith(i18nName) && file.endsWith(".properties")) {
                String locale = file.substring(i18nName.length(), file.length() - ".properties".length());
                if (locale.isEmpty()) {
                    locale = "-en-GB";
                }
                locale = locale.substring(1).replace("_", "-");
                Locale loc = Locale.forLanguageTag(locale);
                langs.add((Object)new LangComboBoxBean(loc));
            }
            ++i2;
        }
        langs.sort();
        this.lang = new OwnSelectBox(this.skin);
        this.lang.setWidth(600.0f);
        this.lang.setItems(langs);
        String locale = settings.program.getLocale();
        int localeIndex = this.idxLang(locale, (Array<LangComboBoxBean>)langs);
        if (localeIndex < 0 || localeIndex >= langs.size) {
            localeIndex = 2;
        }
        this.lang.setSelected((LangComboBoxBean)langs.get(localeIndex));
        OwnLabel themeLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.theme"), this.skin);
        Object[] themes = new StringComobBoxBean[]{new StringComobBoxBean(I18n.msg("gui.theme.default"), "default")};
        this.theme = new OwnSelectBox(this.skin);
        this.theme.setWidth(600.0f);
        this.theme.setItems(themes);
        int themeIndex = 0;
        this.theme.setSelectedIndex(themeIndex);
        OwnLabel uiScaleLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.theme.scale"), this.skin);
        this.uiScale = new OwnSliderPlus("", 0.7f, 2.0f, 0.01f, this.skin);
        this.uiScale.setWidth(600.0f);
        this.uiScale.setValue(settings.program.ui.scale);
        Image applyImage = new Image(this.skin.getDrawable("iconic-check"));
        OwnTextIconButton applyUiScale = new OwnTextIconButton("", applyImage, this.skin);
        applyUiScale.setSize(40.0f, 40.0f);
        applyUiScale.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.apply"), this.skin));
        applyUiScale.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.UI_SCALE_FACTOR_CMD, (Object)this.uiScale, Float.valueOf(this.uiScale.getValue()));
                EventManager.publish(Event.UI_SCALE_RECOMPUTE_CMD, (Object)this.uiScale, new Object[0]);
                return true;
            }
            return false;
        });
        OwnLabel minimapSizeLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.minimap.size"), this.skin, "default");
        this.minimapSize = new OwnSliderPlus("", 150.0f, 350.0f, 1.0f, this.skin);
        this.minimapSize.setName("minimapSize");
        this.minimapSize.setWidth(600.0f);
        this.minimapSize.setValue(settings.program.minimap.size);
        OwnLabel distUnitsLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.distance.units"), this.skin, "default");
        Settings.DistanceUnits[] dus = Settings.DistanceUnits.values();
        Object[] distUnits = new ComboBoxBean[dus.length];
        for (int idu = 0; idu < dus.length; ++idu) {
            Settings.DistanceUnits du = dus[idu];
            distUnits[idu] = new ComboBoxBean(I18n.msg("gui.ui.distance.units." + du.name().toLowerCase(Locale.ROOT)), du.ordinal());
        }
        this.distUnitsSelect = new OwnSelectBox(this.skin);
        this.distUnitsSelect.setItems(distUnits);
        this.distUnitsSelect.setWidth(600.0f);
        this.distUnitsSelect.setSelectedIndex(settings.program.ui.distanceUnits.ordinal());
        OwnLabel displayNotificationsLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.notifications"), this.skin);
        this.displayNotifications = new OwnCheckBox("", this.skin);
        this.displayNotifications.setChecked(settings.program.ui.notifications);
        OwnLabel displayTimeNoUiLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.nogui.time"), this.skin);
        this.displayTimeNoUi = new OwnCheckBox("", this.skin);
        this.displayTimeNoUi.setChecked(settings.program.displayTimeNoUi);
        OwnLabel modeChangeInfoLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.modechangeinfo"), this.skin);
        this.modeChangeInfo = new OwnCheckBox("", this.skin);
        this.modeChangeInfo.setChecked(settings.program.ui.modeChangeInfo);
        OwnLabel newUILabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.newui"), this.skin);
        this.newUI = new OwnCheckBox("", this.skin);
        this.newUI.setName("new ui cb");
        this.newUI.setChecked(settings.program.ui.newUI);
        OwnImageButton newUITooltip = new OwnImageButton(this.skin, "tooltip");
        newUITooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.ui.newui.info"), this.skin));
        HorizontalGroup newUIGroup = new HorizontalGroup();
        newUIGroup.space(pad18);
        newUIGroup.addActor((Actor)this.newUI);
        newUIGroup.addActor((Actor)newUITooltip);
        this.labels.addAll((Object[])new OwnLabel[]{langLabel, themeLabel, uiScaleLabel, minimapSizeLabel, distUnitsLabel, modeChangeInfoLabel, newUILabel});
        table.add((Actor)langLabel).left().padRight(pad34).padBottom(pad18);
        table.add(this.lang).colspan(2).left().padBottom(pad18).row();
        table.add((Actor)themeLabel).left().padRight(pad34).padBottom(pad18);
        table.add(this.theme).colspan(2).left().padBottom(pad18).row();
        table.add((Actor)uiScaleLabel).left().padRight(pad34).padBottom(pad18);
        table.add((Actor)this.uiScale).left().padRight(pad10).padBottom(pad18);
        table.add((Actor)applyUiScale).left().padBottom(pad18).row();
        table.add((Actor)minimapSizeLabel).left().padRight(pad10).padBottom(pad18);
        table.add((Actor)this.minimapSize).colspan(2).left().padRight(pad10).padBottom(pad18).row();
        table.add((Actor)distUnitsLabel).left().padRight(pad10).padBottom(pad18);
        table.add(this.distUnitsSelect).colspan(2).left().padRight(pad10).padBottom(pad18).row();
        table.add((Actor)displayNotificationsLabel).left().padRight(pad10).padBottom(pad18);
        table.add((Actor)this.displayNotifications).colspan(2).left().padRight(pad10).padBottom(pad18).row();
        table.add((Actor)displayTimeNoUiLabel).left().padRight(pad10).padBottom(pad18);
        table.add((Actor)this.displayTimeNoUi).colspan(2).left().padRight(pad10).padBottom(pad18).row();
        table.add((Actor)modeChangeInfoLabel).left().padRight(pad10).padBottom(pad18);
        table.add((Actor)this.modeChangeInfo).colspan(2).left().padRight(pad10).padBottom(pad18).row();
        table.add((Actor)newUILabel).left().padRight(pad10).padBottom(pad18);
        table.add((Actor)newUIGroup).left().colspan(2).padBottom(pad10).row();
        OwnLabel titleCrosshair = new OwnLabel((CharSequence)I18n.msg("gui.ui.crosshair"), this.skin, "header");
        Table ch = new Table();
        OwnLabel crosshairFocusLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.crosshair.focus"), this.skin);
        this.crosshairFocus = new OwnCheckBox("", this.skin);
        this.crosshairFocus.setName("ch focus");
        this.crosshairFocus.setChecked(settings.scene.crosshair.focus);
        OwnLabel crosshairClosestLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.crosshair.closest"), this.skin);
        this.crosshairClosest = new OwnCheckBox("", this.skin);
        this.crosshairClosest.setName("ch closest");
        this.crosshairClosest.setChecked(settings.scene.crosshair.closest);
        OwnLabel crosshairHomeLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.crosshair.home"), this.skin);
        this.crosshairHome = new OwnCheckBox("", this.skin);
        this.crosshairHome.setName("ch home");
        this.crosshairHome.setChecked(settings.scene.crosshair.home);
        this.labels.add((Object)crosshairClosestLabel, (Object)crosshairHomeLabel, (Object)crosshairFocusLabel);
        ch.add((Actor)crosshairFocusLabel).left().padRight(pad34).padBottom(pad10);
        ch.add((Actor)this.crosshairFocus).left().padBottom(pad10).row();
        ch.add((Actor)crosshairClosestLabel).left().padRight(pad34).padBottom(pad10);
        ch.add((Actor)this.crosshairClosest).left().padBottom(pad10).row();
        ch.add((Actor)crosshairHomeLabel).left().padRight(pad34).padBottom(pad10);
        ch.add((Actor)this.crosshairHome).left().padBottom(pad10).row();
        OwnLabel titleGuides = new OwnLabel((CharSequence)I18n.msg("gui.ui.pointer.guides"), this.skin, "header");
        Table pg = new Table();
        OwnLabel pointerCoordsLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.pointercoordinates"), this.skin);
        this.pointerCoords = new OwnCheckBox("", this.skin);
        this.pointerCoords.setChecked(settings.program.pointer.coordinates);
        OwnLabel pointerGuidesLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.pointer.guides.display"), this.skin);
        this.pointerGuides = new OwnCheckBox("", this.skin);
        this.pointerGuides.setName("pointer guides cb");
        this.pointerGuides.setChecked(settings.program.pointer.guides.active);
        OwnImageButton guidesTooltip = new OwnImageButton(this.skin, "tooltip");
        guidesTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.ui.pointer.guides.info"), this.skin));
        HorizontalGroup pointerGuidesCbGroup = new HorizontalGroup();
        pointerGuidesCbGroup.space(pad18);
        pointerGuidesCbGroup.addActor((Actor)this.pointerGuides);
        pointerGuidesCbGroup.addActor((Actor)guidesTooltip);
        OwnLabel pointerGuidesColorLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.pointer.guides.color"), this.skin);
        float colorPickerSize = 32.0f;
        this.pointerGuidesColor = new ColorPicker(this.stage, this.skin);
        this.pointerGuidesColor.setPickedColor(settings.program.pointer.guides.color);
        OwnLabel pointerGuidesWidthLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.pointer.guides.width"), this.skin, "default");
        this.pointerGuidesWidth = new OwnSliderPlus("", 0.5f, 20.0f, 0.01f, this.skin);
        this.pointerGuidesWidth.setName("pointerguideswidth");
        this.pointerGuidesWidth.setWidth(600.0f);
        this.pointerGuidesWidth.setValue(settings.program.pointer.guides.width);
        this.labels.add((Object)pointerGuidesLabel, (Object)pointerGuidesColorLabel, (Object)pointerGuidesWidthLabel);
        pg.add((Actor)pointerGuidesLabel).left().padBottom(pad10).padRight(pad34);
        pg.add((Actor)pointerGuidesCbGroup).left().colspan(2).padBottom(pad10).row();
        pg.add((Actor)pointerCoordsLabel).left().padRight(pad34).padBottom(pad18);
        pg.add((Actor)this.pointerCoords).left().padRight(pad10).padBottom(pad18).row();
        pg.add((Actor)pointerGuidesColorLabel).left().padBottom(pad10).padRight(pad34);
        pg.add((Actor)this.pointerGuidesColor).left().size(colorPickerSize).padBottom(pad10).row();
        pg.add((Actor)pointerGuidesWidthLabel).left().padBottom(pad10).padRight(pad34);
        pg.add((Actor)this.pointerGuidesWidth).left().padBottom(pad10).padRight(pad34).row();
        OwnLabel titleUVGrids = new OwnLabel((CharSequence)I18n.msg("gui.ui.uvgrid"), this.skin, "header");
        Table uvg = new Table();
        OwnLabel frameCoordinatesLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.uvgrid.framecoords"), this.skin);
        this.frameCoordinates = new OwnCheckBox("", this.skin);
        this.frameCoordinates.setChecked(settings.program.uvGrid.frameCoordinates);
        this.frameCoordinates.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                ChangeListener.ChangeEvent ce = (ChangeListener.ChangeEvent)event;
                EventManager.publish(Event.UV_GRID_FRAME_COORDINATES_CMD, this, this.frameCoordinates.isChecked());
            }
            return false;
        });
        this.labels.add((Object)frameCoordinatesLabel);
        uvg.add((Actor)frameCoordinatesLabel).left().padBottom(pad10).padRight(pad34);
        uvg.add((Actor)this.frameCoordinates).left().padBottom(pad10);
        this.addContentGroup(contentUITable, titleUI, (WidgetGroup)table, 0.0f);
        this.addContentGroup(contentUITable, titleCrosshair, (WidgetGroup)ch);
        this.addContentGroup(contentUITable, titleGuides, (WidgetGroup)pg);
        this.addContentGroup(contentUITable, titleUVGrids, (WidgetGroup)uvg);
        Table contentPerformance = new Table(this.skin);
        contentPerformance.align(10);
        OwnLabel titleMultiThread = new OwnLabel((CharSequence)I18n.msg("gui.multithreading"), this.skin, "header");
        Table multiThread = new Table(this.skin);
        OwnLabel numThreadsLabel = new OwnLabel((CharSequence)I18n.msg("gui.thread.number"), this.skin);
        int maxThreads = Runtime.getRuntime().availableProcessors();
        Object[] cbs = new ComboBoxBean[maxThreads + 1];
        cbs[0] = new ComboBoxBean(I18n.msg("gui.letdecide"), 0);
        for (i2 = 1; i2 <= maxThreads; ++i2) {
            cbs[i2] = new ComboBoxBean(I18n.msg("gui.thread", i2), i2);
        }
        this.numThreads = new OwnSelectBox(this.skin);
        this.numThreads.setWidth(600.0f);
        this.numThreads.setItems(cbs);
        this.numThreads.setSelectedIndex(settings.performance.numberThreads);
        OwnLabel multithreadLabel = new OwnLabel((CharSequence)I18n.msg("gui.thread.enable"), this.skin);
        this.multithreadCb = new OwnCheckBox("", this.skin);
        this.multithreadCb.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.numThreads.setDisabled(!this.multithreadCb.isChecked());
                return true;
            }
            return false;
        });
        this.multithreadCb.setChecked(settings.performance.multithreading);
        this.numThreads.setDisabled(!this.multithreadCb.isChecked());
        multiThread.add((Actor)multithreadLabel).left().padRight(pad34).padBottom(pad10);
        multiThread.add((Actor)this.multithreadCb).left().padBottom(pad10).row();
        multiThread.add((Actor)numThreadsLabel).left().padRight(pad34).padBottom(pad10);
        multiThread.add(this.numThreads).left().padBottom(pad10).row();
        Cell noticeMultiThreadCell = multiThread.add((Actor)null);
        noticeMultiThreadCell.colspan(2).left();
        this.multithreadCb.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (noticeMultiThreadCell.getActor() == null) {
                    String nextInfoStr = I18n.msg("gui.ui.info") + "\n";
                    int lines = GlobalResources.countOccurrences(nextInfoStr, '\n');
                    OwnTextArea nextTimeInfo = new OwnTextArea(nextInfoStr, this.skin, "info");
                    nextTimeInfo.setDisabled(true);
                    nextTimeInfo.setWidth(400.0f);
                    nextTimeInfo.setPrefRows(lines + 1);
                    nextTimeInfo.clearListeners();
                    noticeMultiThreadCell.setActor((Actor)nextTimeInfo);
                }
                return true;
            }
            return false;
        });
        this.addContentGroup(contentPerformance, titleMultiThread, (WidgetGroup)multiThread, 0.0f);
        OwnLabel titleLod = new OwnLabel((CharSequence)I18n.msg("gui.lod"), this.skin, "header");
        Table lod = new Table(this.skin);
        OwnLabel lodFadeLabel = new OwnLabel((CharSequence)I18n.msg("gui.lod.fade"), this.skin);
        this.lodFadeCb = new OwnCheckBox("", this.skin);
        this.lodFadeCb.setChecked(settings.scene.octree.fade);
        OwnLabel ddLabel = new OwnLabel((CharSequence)I18n.msg("gui.lod.thresholds"), this.skin);
        this.lodTransitions = new OwnSliderPlus("", 0.0f, 100.0f, 0.1f, 0.0f, 120.0f, this.skin);
        this.lodTransitions.setDisplayValueMapped(true);
        this.lodTransitions.setWidth(600.0f);
        this.lodTransitions.setMappedValue((double)settings.scene.octree.threshold[0] * 57.29577951308232);
        OwnImageButton lodTooltip = new OwnImageButton(this.skin, "tooltip");
        lodTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.lod.thresholds.info"), this.skin));
        lod.add((Actor)lodFadeLabel).left().padRight(pad34).padBottom(pad10);
        lod.add((Actor)this.lodFadeCb).colspan(2).left().padBottom(pad10).row();
        lod.add((Actor)ddLabel).left().padRight(pad34).padBottom(pad10);
        lod.add((Actor)this.lodTransitions).left().padRight(pad18).padBottom(pad10);
        lod.add((Actor)lodTooltip).left().padBottom(pad10);
        this.addContentGroup(contentPerformance, titleLod, (WidgetGroup)lod);
        OwnLabel titleVelVectors = new OwnLabel((CharSequence)I18n.msg("gui.velvec"), this.skin, "header");
        Table velVectors = new Table(this.skin);
        OwnLabel velVectorsLabel = new OwnLabel((CharSequence)I18n.msg("gui.velvec.num"), this.skin);
        this.velocityVectors = new OwnSliderPlus("", 40.0f, 500.0f, 1.0f, this.skin);
        this.velocityVectors.setWidth(600.0f);
        this.velocityVectors.setValue(settings.scene.star.group.numVelocityVector);
        OwnImageButton velVectorsTooltip = new OwnImageButton(this.skin, "tooltip");
        velVectorsTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.velvec.num.info"), this.skin));
        this.labels.addAll((Object[])new OwnLabel[]{numThreadsLabel, ddLabel, lodFadeLabel, velVectorsLabel});
        velVectors.add((Actor)velVectorsLabel).left().padRight(pad34).padBottom(pad10);
        velVectors.add((Actor)this.velocityVectors).left().padRight(pad18).padBottom(pad10);
        velVectors.add((Actor)velVectorsTooltip).left().padBottom(pad10);
        this.addContentGroup(contentPerformance, titleVelVectors, (WidgetGroup)velVectors);
        Table contentControls = new Table(this.skin);
        contentControls.align(10);
        OwnLabel titleController = new OwnLabel((CharSequence)I18n.msg("gui.controller"), this.skin, "header");
        this.controllersTable = new Table(this.skin);
        OwnLabel detectedLabel = new OwnLabel((CharSequence)I18n.msg("gui.controller.detected"), this.skin);
        this.generateGamepadsList(this.controllersTable);
        OwnLabel mappingsLabel = new OwnLabel((CharSequence)I18n.msg("gui.controller.mappingsfile"), this.skin);
        this.gamepadMappings = new OwnSelectBox(this.skin);
        this.reloadGamepadMappings(null);
        OwnLabel invertXLabel = new OwnLabel((CharSequence)I18n.msg("gui.controller.axis.invert", "X"), this.skin);
        this.invertX = new OwnCheckBox("", this.skin);
        this.invertX.setChecked(settings.controls.gamepad.invertX);
        OwnLabel invertYLabel = new OwnLabel((CharSequence)I18n.msg("gui.controller.axis.invert", "Y"), this.skin);
        this.invertY = new OwnCheckBox("", this.skin);
        this.invertY.setChecked(settings.controls.gamepad.invertY);
        this.labels.add((Object)detectedLabel, (Object)mappingsLabel, (Object)invertXLabel, (Object)invertYLabel);
        OwnLabel titleKeybindings = new OwnLabel((CharSequence)I18n.msg("gui.keymappings"), this.skin, "header");
        Map<KeyBindings.ProgramAction, Array<TreeSet<Integer>>> keyboardMappings = KeyBindings.instance.getSortedMappingsInv();
        String[][] data = new String[keyboardMappings.size()][];
        i2 = 0;
        for (KeyBindings.ProgramAction action : keyboardMappings.keySet()) {
            String[][] keys = keyboardMappings.get(action);
            if (keys != null) {
                String[] act = new String[1 + keys.size];
                act[0] = action.actionName;
                for (int j = 0; j < keys.size; ++j) {
                    act[j + 1] = this.keysToString((TreeSet)keys.get(j));
                }
                data[i2] = act;
            } else {
                data[i2] = new String[]{"?"};
            }
            ++i2;
        }
        Table controls = new Table(this.skin);
        controls.align(10);
        controls.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.keymappings.action"), this.skin, "header")).padBottom(pad18).left();
        controls.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.keymappings.keys"), this.skin, "header")).padBottom(pad18).left().row();
        controls.add((Actor)new OwnLabel((CharSequence)I18n.msg("action.forward"), this.skin)).left().padRight(pad34).padBottom(pad10);
        controls.add((Actor)new OwnLabel((CharSequence)GSKeys.toString(19).toUpperCase(Locale.ROOT), this.skin, "mono-pink")).padBottom(pad10).left().row();
        controls.add((Actor)new OwnLabel((CharSequence)I18n.msg("action.backward"), this.skin)).left().padRight(pad34).padBottom(pad10);
        controls.add((Actor)new OwnLabel((CharSequence)GSKeys.toString(20).toUpperCase(Locale.ROOT), this.skin, "mono-pink")).padBottom(pad10).left().row();
        controls.add((Actor)new OwnLabel((CharSequence)I18n.msg("action.left"), this.skin)).left().padRight(pad34).padBottom(pad10);
        controls.add((Actor)new OwnLabel((CharSequence)GSKeys.toString(21).toUpperCase(Locale.ROOT), this.skin, "mono-pink")).padBottom(pad10).left().row();
        controls.add((Actor)new OwnLabel((CharSequence)I18n.msg("action.right"), this.skin)).left().padRight(pad34).padBottom(pad10);
        controls.add((Actor)new OwnLabel((CharSequence)GSKeys.toString(22).toUpperCase(Locale.ROOT), this.skin, "mono-pink")).padBottom(pad10).left().row();
        boolean plus = false;
        for (String[] action : data) {
            HorizontalGroup keysGroup = new HorizontalGroup();
            keysGroup.space(pad10);
            for (int j = 1; j < action.length; ++j) {
                String[] keys = action[j].split("\\+");
                for (int k = 0; k < keys.length; ++k) {
                    keysGroup.addActor((Actor)new OwnLabel((CharSequence)keys[k].trim().replace('_', '-').replace("PL", "+"), this.skin, "mono-pink"));
                    if (k >= keys.length - 1) continue;
                    keysGroup.addActor((Actor)new OwnLabel((CharSequence)"+", this.skin));
                }
                if (j >= action.length - 1) continue;
                keysGroup.addActor((Actor)new OwnLabel((CharSequence)"/", this.skin));
            }
            controls.add((Actor)new OwnLabel((CharSequence)action[0], this.skin)).left().padRight(pad34).padBottom(pad10);
            controls.add((Actor)keysGroup).padBottom(pad10).left().row();
        }
        OwnScrollPane controlsScroll = new OwnScrollPane((Actor)controls, this.skin, "minimalist-nobg");
        controlsScroll.setWidth(1430.0f);
        controlsScroll.setHeight(600.0f);
        controlsScroll.setScrollingDisabled(true, false);
        controlsScroll.setSmoothScrolling(true);
        controlsScroll.setFadeScrollBars(false);
        this.scrolls.add((Object)controlsScroll);
        Table controller = new Table(this.skin);
        controller.add((Actor)detectedLabel).left().padBottom(pad18).padRight(pad18);
        controller.add((Actor)this.controllersTable).left().padBottom(pad18).row();
        controller.add((Actor)mappingsLabel).left().padBottom(pad18).padRight(pad18);
        controller.add(this.gamepadMappings).left().padBottom(pad18).row();
        controller.add((Actor)invertXLabel).left().padBottom(pad18).padRight(pad18);
        controller.add((Actor)this.invertX).left().padBottom(pad18).row();
        controller.add((Actor)invertYLabel).left().padBottom(pad34).padRight(pad18);
        controller.add((Actor)this.invertY).left().padBottom(pad34).row();
        this.addContentGroup(contentControls, titleController, (WidgetGroup)controller, 0.0f);
        this.addContentGroup(contentControls, titleKeybindings, (WidgetGroup)controlsScroll);
        Table contentScreenshots = new Table(this.skin);
        contentScreenshots.align(10);
        OwnLabel titleScreenshots = new OwnLabel((CharSequence)I18n.msg("gui.screencapture"), this.skin, "header");
        Table screenshots = new Table(this.skin);
        String ssInfoStr = I18n.msg("gui.screencapture.info") + "\n";
        int ssLines = GlobalResources.countOccurrences(ssInfoStr, '\n');
        OwnTextArea screenshotsInfo = new OwnTextArea(ssInfoStr, this.skin, "info");
        screenshotsInfo.setDisabled(true);
        screenshotsInfo.setPrefRows(ssLines + 1);
        screenshotsInfo.setWidth(960.0f);
        screenshotsInfo.clearListeners();
        OwnLabel screenshotsLocationLabel = new OwnLabel((CharSequence)I18n.msg("gui.screenshots.save"), this.skin);
        this.screenshotsLocation = new OwnTextButton(TextUtils.capString(settings.screenshot.location, 55), this.skin);
        this.screenshotsLocation.addListener((EventListener)new OwnTextTooltip(settings.screenshot.location, this.skin));
        this.screenshotsLocation.setWidth(600.0f);
        this.screenshotsPath = Path.of(settings.screenshot.location, new String[0]);
        this.screenshotsLocation.pad(pad10);
        this.screenshotsLocation.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                FileChooser fc = new FileChooser(I18n.msg("gui.screenshots.directory.choose"), this.skin, this.stage, Paths.get(settings.screenshot.location, new String[0]), FileChooser.FileChooserTarget.DIRECTORIES);
                fc.setShowHidden(settings.program.fileChooser.showHidden);
                fc.setShowHiddenConsumer(showHidden -> {
                    settings.program.fileChooser.showHidden = showHidden;
                });
                fc.setResultListener((success, result) -> {
                    if (success) {
                        this.screenshotsLocation.setText(TextUtils.capString(result.toString(), 55));
                        this.screenshotsPath = result;
                        this.screenshotsLocation.addListener((EventListener)new OwnTextTooltip(result.toString(), this.skin));
                    }
                    return true;
                });
                fc.show(this.stage);
                return true;
            }
            return false;
        });
        OwnLabel screenshotsSizeLabel = new OwnLabel((CharSequence)I18n.msg("gui.screenshots.size"), this.skin);
        screenshotsSizeLabel.setDisabled(settings.screenshot.isSimpleMode());
        OwnLabel xScreenshotsLabel = new OwnLabel((CharSequence)"x", this.skin);
        IntValidator screenshotsSizeValidator = new IntValidator(50, 25000);
        this.ssWidthField = new OwnTextField(Integer.toString(MathUtils.clamp((int)settings.screenshot.resolution[0], (int)50, (int)25000)), this.skin, screenshotsSizeValidator);
        this.ssWidthField.setWidth(283.0f);
        this.ssWidthField.setDisabled(settings.screenshot.isSimpleMode());
        this.ssHeightField = new OwnTextField(Integer.toString(MathUtils.clamp((int)settings.screenshot.resolution[1], (int)50, (int)25000)), this.skin, screenshotsSizeValidator);
        this.ssHeightField.setWidth(283.0f);
        this.ssHeightField.setDisabled(settings.screenshot.isSimpleMode());
        HorizontalGroup ssSizeGroup = new HorizontalGroup();
        ssSizeGroup.space(pad10);
        ssSizeGroup.addActor((Actor)this.ssWidthField);
        ssSizeGroup.addActor((Actor)xScreenshotsLabel);
        ssSizeGroup.addActor((Actor)this.ssHeightField);
        OwnLabel ssModeLabel = new OwnLabel((CharSequence)I18n.msg("gui.screenshots.mode"), this.skin);
        Object[] screenshotModes = new ComboBoxBean[]{new ComboBoxBean(I18n.msg("gui.screenshots.mode.simple"), 0), new ComboBoxBean(I18n.msg("gui.screenshots.mode.redraw"), 1)};
        this.screenshotMode = new OwnSelectBox(this.skin);
        this.screenshotMode.setItems(screenshotModes);
        this.screenshotMode.setWidth(600.0f);
        this.screenshotMode.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.enableComponents(((ComboBoxBean)this.screenshotMode.getSelected()).value != 0, new Disableable[]{this.ssWidthField, this.ssHeightField, screenshotsSizeLabel, xScreenshotsLabel});
                return true;
            }
            return false;
        });
        this.screenshotMode.setSelected(screenshotModes[settings.screenshot.mode.ordinal()]);
        this.screenshotMode.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.screenshotmode"), this.skin));
        OwnLabel ssQualityLabel = new OwnLabel((CharSequence)I18n.msg("gui.screenshots.quality"), this.skin);
        this.screenshotQuality = new OwnSliderPlus("", 1.0f, 100.0f, 1.0f, this.skin);
        this.screenshotQuality.setName("screenshot quality");
        this.screenshotQuality.setWidth(600.0f);
        this.screenshotQuality.setValue(settings.screenshot.quality * 100.0f);
        OwnLabel ssFormatLabel = new OwnLabel((CharSequence)I18n.msg("gui.screenshots.format"), this.skin);
        Object[] screenshotFormats = new ComboBoxBean[]{new ComboBoxBean(I18n.msg("gui.screenshots.format.png"), 0), new ComboBoxBean(I18n.msg("gui.screenshots.format.jpg"), 1)};
        this.screenshotFormat = new OwnSelectBox(this.skin);
        this.screenshotFormat.setItems(screenshotFormats);
        this.screenshotFormat.setWidth(600.0f);
        this.screenshotFormat.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.enableComponents(((ComboBoxBean)this.screenshotFormat.getSelected()).value == 1, new Disableable[]{this.screenshotQuality, ssQualityLabel});
                return true;
            }
            return false;
        });
        this.screenshotFormat.setSelected(screenshotFormats[settings.screenshot.format.ordinal()]);
        this.enableComponents(((ComboBoxBean)this.screenshotFormat.getSelected()).value == 1, new Disableable[]{this.screenshotQuality, ssQualityLabel});
        OwnImageButton screenshotsModeTooltip = new OwnImageButton(this.skin, "tooltip");
        screenshotsModeTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.screenshotmode"), this.skin));
        HorizontalGroup ssModeGroup = new HorizontalGroup();
        ssModeGroup.space(pad10);
        ssModeGroup.addActor(this.screenshotMode);
        ssModeGroup.addActor((Actor)screenshotsModeTooltip);
        this.labels.addAll((Object[])new OwnLabel[]{screenshotsLocationLabel, ssModeLabel, screenshotsSizeLabel, ssFormatLabel, ssQualityLabel});
        screenshots.add((Actor)screenshotsInfo).colspan(2).left().padBottom(pad10).row();
        screenshots.add((Actor)screenshotsLocationLabel).left().padRight(pad34).padBottom(pad10);
        screenshots.add((Actor)this.screenshotsLocation).left().padBottom(pad10).row();
        screenshots.add((Actor)ssModeLabel).left().padRight(pad34).padBottom(pad10);
        screenshots.add((Actor)ssModeGroup).left().padBottom(pad10).row();
        screenshots.add((Actor)screenshotsSizeLabel).left().padRight(pad34).padBottom(pad10);
        screenshots.add((Actor)ssSizeGroup).left().padBottom(pad10).row();
        screenshots.add((Actor)ssFormatLabel).left().padRight(pad34).padBottom(pad10);
        screenshots.add(this.screenshotFormat).left().padBottom(pad10).row();
        screenshots.add((Actor)ssQualityLabel).left().padRight(pad34).padBottom(pad10);
        screenshots.add((Actor)this.screenshotQuality).left().padBottom(pad10).row();
        this.addContentGroup(contentScreenshots, titleScreenshots, (WidgetGroup)screenshots, 0.0f);
        Table contentFrames = new Table(this.skin);
        contentFrames.align(10);
        OwnLabel titleFrameOutput = new OwnLabel((CharSequence)I18n.msg("gui.frameoutput"), this.skin, "header");
        Table frameOutput = new Table(this.skin);
        String frameOutputInfoString = I18n.msg("gui.frameoutput.info") + "\n";
        ssLines = GlobalResources.countOccurrences(frameOutputInfoString, '\n');
        OwnTextArea frameOutputInfo = new OwnTextArea(frameOutputInfoString, this.skin, "info");
        frameOutputInfo.setDisabled(true);
        frameOutputInfo.setPrefRows(ssLines + 1);
        frameOutputInfo.setWidth(960.0f);
        frameOutputInfo.clearListeners();
        OwnLabel frameOutputLocationLabel = new OwnLabel((CharSequence)I18n.msg("gui.frameoutput.location"), this.skin);
        this.frameOutputLocation = new OwnTextButton(TextUtils.capString(settings.frame.location, 55), this.skin);
        this.frameOutputLocation.setWidth(600.0f);
        this.frameOutputLocation.addListener((EventListener)new OwnTextTooltip(settings.frame.location, this.skin));
        this.frameOutputPath = Path.of(settings.frame.location, new String[0]);
        this.frameOutputLocation.pad(pad10);
        this.frameOutputLocation.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                FileChooser fc = new FileChooser(I18n.msg("gui.frameoutput.directory.choose"), this.skin, this.stage, Paths.get(settings.frame.location, new String[0]), FileChooser.FileChooserTarget.DIRECTORIES);
                fc.setShowHidden(settings.program.fileChooser.showHidden);
                fc.setShowHiddenConsumer(showHidden -> {
                    settings.program.fileChooser.showHidden = showHidden;
                });
                fc.setResultListener((success, result) -> {
                    if (success) {
                        this.frameOutputLocation.setText(TextUtils.capString(result.toString(), 55));
                        this.frameOutputPath = result;
                        this.frameOutputLocation.addListener((EventListener)new OwnTextTooltip(result.toString(), this.skin));
                    }
                    return true;
                });
                fc.show(this.stage);
                return true;
            }
            return false;
        });
        OwnLabel prefixLabel = new OwnLabel((CharSequence)I18n.msg("gui.frameoutput.prefix"), this.skin);
        this.frameOutputPrefix = new OwnTextField(settings.frame.prefix, this.skin, new RegexpValidator("^\\w+$"));
        this.frameOutputPrefix.setWidth(600.0f);
        OwnLabel fpsLabel = new OwnLabel((CharSequence)I18n.msg("gui.target.fps"), this.skin);
        this.frameOutputFps = new OwnTextField(this.nf3.format(settings.frame.targetFps), this.skin, new DoubleValidator(0.05, 1000.0));
        this.frameOutputFps.setWidth(600.0f);
        OwnLabel frameoutputSizeLabel = new OwnLabel((CharSequence)I18n.msg("gui.frameoutput.size"), this.skin);
        frameoutputSizeLabel.setDisabled(settings.frame.isSimpleMode());
        OwnLabel xFrameLabel = new OwnLabel((CharSequence)"x", this.skin);
        IntValidator frameoutputSizeValidator = new IntValidator(50, 25000);
        this.foWidthField = new OwnTextField(Integer.toString(MathUtils.clamp((int)settings.frame.resolution[0], (int)50, (int)25000)), this.skin, frameoutputSizeValidator);
        this.foWidthField.setWidth(283.0f);
        this.foWidthField.setDisabled(settings.frame.isSimpleMode());
        this.foHeightField = new OwnTextField(Integer.toString(MathUtils.clamp((int)settings.frame.resolution[1], (int)50, (int)25000)), this.skin, frameoutputSizeValidator);
        this.foHeightField.setWidth(283.0f);
        this.foHeightField.setDisabled(settings.frame.isSimpleMode());
        HorizontalGroup foSizeGroup = new HorizontalGroup();
        foSizeGroup.space(pad10);
        foSizeGroup.addActor((Actor)this.foWidthField);
        foSizeGroup.addActor((Actor)xFrameLabel);
        foSizeGroup.addActor((Actor)this.foHeightField);
        OwnLabel foQualityLabel = new OwnLabel((CharSequence)I18n.msg("gui.screenshots.quality"), this.skin);
        this.frameQuality = new OwnSliderPlus("", 1.0f, 100.0f, 1.0f, this.skin);
        this.frameQuality.setName("frame quality");
        this.frameQuality.setWidth(600.0f);
        this.frameQuality.setValue(settings.frame.quality * 100.0f);
        OwnLabel foFormatLabel = new OwnLabel((CharSequence)I18n.msg("gui.screenshots.format"), this.skin);
        ComboBoxBean[] frameFormats = new ComboBoxBean[]{new ComboBoxBean(I18n.msg("gui.screenshots.format.png"), 0), new ComboBoxBean(I18n.msg("gui.screenshots.format.jpg"), 1)};
        this.frameOutputFormat = new OwnSelectBox(this.skin);
        this.frameOutputFormat.setItems(screenshotFormats);
        this.frameOutputFormat.setWidth(600.0f);
        this.frameOutputFormat.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.enableComponents(((ComboBoxBean)this.frameOutputFormat.getSelected()).value == 1, new Disableable[]{this.frameQuality, foQualityLabel});
                return true;
            }
            return false;
        });
        this.frameOutputFormat.setSelected(screenshotFormats[settings.frame.format.ordinal()]);
        this.enableComponents(((ComboBoxBean)this.frameOutputFormat.getSelected()).value == 1, new Disableable[]{this.frameQuality, foQualityLabel});
        OwnLabel fomodeLabel = new OwnLabel((CharSequence)I18n.msg("gui.screenshots.mode"), this.skin);
        Object[] frameoutputModes = new ComboBoxBean[]{new ComboBoxBean(I18n.msg("gui.screenshots.mode.simple"), 0), new ComboBoxBean(I18n.msg("gui.screenshots.mode.redraw"), 1)};
        this.frameOutputMode = new OwnSelectBox(this.skin);
        this.frameOutputMode.setItems(frameoutputModes);
        this.frameOutputMode.setWidth(600.0f);
        this.frameOutputMode.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.enableComponents(((ComboBoxBean)this.frameOutputMode.getSelected()).value != 0, new Disableable[]{this.foWidthField, this.foHeightField, frameoutputSizeLabel, xFrameLabel});
                return true;
            }
            return false;
        });
        this.frameOutputMode.setSelected(frameoutputModes[settings.frame.mode.ordinal()]);
        this.frameOutputMode.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.screenshotmode"), this.skin));
        OwnImageButton frameoutputModeTooltip = new OwnImageButton(this.skin, "tooltip");
        frameoutputModeTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.screenshotmode"), this.skin));
        HorizontalGroup foModeGroup = new HorizontalGroup();
        foModeGroup.space(pad10);
        foModeGroup.addActor(this.frameOutputMode);
        foModeGroup.addActor((Actor)frameoutputModeTooltip);
        OwnLabel counterLabel = new OwnLabel((CharSequence)I18n.msg("gui.frameoutput.sequence"), this.skin);
        HorizontalGroup counterGroup = new HorizontalGroup();
        counterGroup.space(pad10);
        this.frameSequenceNumber = new OwnLabel((CharSequence)Integer.toString(ImageRenderer.getSequenceNumber()), this.skin);
        this.frameSequenceNumber.setWidth(600.0f);
        OwnTextButton resetCounter = new OwnTextButton(I18n.msg("gui.frameoutput.sequence.reset"), this.skin);
        resetCounter.pad(pad18);
        resetCounter.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                ImageRenderer.resetSequenceNumber();
                this.frameSequenceNumber.setText("0");
            }
            return false;
        });
        counterGroup.addActor((Actor)this.frameSequenceNumber);
        this.labels.addAll((Object[])new OwnLabel[]{frameOutputLocationLabel, prefixLabel, fpsLabel, fomodeLabel, frameoutputSizeLabel});
        frameOutput.add((Actor)frameOutputInfo).colspan(2).left().padBottom(pad10).row();
        frameOutput.add((Actor)frameOutputLocationLabel).left().padRight(pad34).padBottom(pad10);
        frameOutput.add((Actor)this.frameOutputLocation).left().padBottom(pad10).row();
        frameOutput.add((Actor)prefixLabel).left().padRight(pad34).padBottom(pad10);
        frameOutput.add((Actor)this.frameOutputPrefix).left().padBottom(pad10).row();
        frameOutput.add((Actor)fpsLabel).left().padRight(pad34).padBottom(pad10);
        frameOutput.add((Actor)this.frameOutputFps).left().padBottom(pad10).row();
        frameOutput.add((Actor)fomodeLabel).left().padRight(pad34).padBottom(pad10);
        frameOutput.add((Actor)foModeGroup).left().padBottom(pad10).row();
        frameOutput.add((Actor)frameoutputSizeLabel).left().padRight(pad34).padBottom(pad10);
        frameOutput.add((Actor)foSizeGroup).left().padBottom(pad10).row();
        frameOutput.add((Actor)foFormatLabel).left().padRight(pad34).padBottom(pad10);
        frameOutput.add(this.frameOutputFormat).left().padBottom(pad10).row();
        frameOutput.add((Actor)foQualityLabel).left().padRight(pad34).padBottom(pad10);
        frameOutput.add((Actor)this.frameQuality).left().padBottom(pad10).row();
        frameOutput.add((Actor)counterLabel).left().padRight(pad34).padBottom(pad10);
        frameOutput.add((Actor)counterGroup).left().padBottom(pad10).row();
        frameOutput.add().padRight(pad34);
        frameOutput.add((Actor)resetCounter).left();
        this.addContentGroup(contentFrames, titleFrameOutput, (WidgetGroup)frameOutput, 0.0f);
        Table contentCamera = new Table(this.skin);
        contentCamera.align(10);
        Table camrec = new Table(this.skin);
        OwnLabel titleCamrec = new OwnLabel((CharSequence)I18n.msg("gui.camerarec.title"), this.skin, "header");
        OwnLabel camfpsLabel = new OwnLabel((CharSequence)I18n.msg("gui.target.fps"), this.skin);
        this.camRecFps = new OwnTextField(this.nf3.format(settings.camrecorder.targetFps), this.skin, new DoubleValidator(0.05, 1000.0));
        this.camRecFps.setWidth(600.0f);
        OwnImageButton camrecFpsTooltip = new OwnImageButton(this.skin, "tooltip");
        camrecFpsTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.playcamera.targetfps"), this.skin));
        OwnTextIconButton keyframePrefs = new OwnTextIconButton(I18n.msg("gui.keyframes.preferences"), this.skin, "preferences");
        keyframePrefs.setName("keyframe preferences");
        keyframePrefs.pad(pad18);
        keyframePrefs.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.kf.editprefs"), this.skin));
        keyframePrefs.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                KeyframePreferencesWindow kpw = new KeyframePreferencesWindow(this.stage, this.skin);
                kpw.setAcceptListener(() -> {
                    if (kpw.camcorderFps != null && kpw.camcorderFps.isValid()) {
                        this.camRecFps.setText(kpw.camcorderFps.getText());
                    }
                });
                kpw.show(this.stage);
                return true;
            }
            return false;
        });
        OwnLabel autoCamrecLabel = new OwnLabel((CharSequence)I18n.msg("gui.camerarec.frameoutput"), this.skin);
        this.cbAutoCamRec = new OwnCheckBox("", this.skin);
        this.cbAutoCamRec.setChecked(settings.camrecorder.auto);
        this.cbAutoCamRec.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.playcamera.frameoutput"), this.skin));
        OwnImageButton camrecAutoTooltip = new OwnImageButton(this.skin, "tooltip");
        camrecAutoTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.playcamera.frameoutput"), this.skin));
        this.labels.add((Object)autoCamrecLabel);
        camrec.add((Actor)camfpsLabel).left().padRight(pad34).padBottom(pad10);
        camrec.add((Actor)this.camRecFps).left().fillX().padBottom(pad10);
        camrec.add((Actor)camrecFpsTooltip).left().padLeft(pad10).padBottom(pad10).row();
        camrec.add((Actor)autoCamrecLabel).left().padRight(pad34).padBottom(pad10);
        camrec.add((Actor)this.cbAutoCamRec).left().padBottom(pad10);
        camrec.add((Actor)camrecAutoTooltip).left().padLeft(pad10).padBottom(pad10).row();
        camrec.add((Actor)keyframePrefs).colspan(3).left().padTop(pad34 * 2.0f).row();
        this.addContentGroup(contentCamera, titleCamrec, (WidgetGroup)camrec, 0.0f);
        Table content360 = new Table(this.skin);
        content360.align(10);
        OwnLabel titleCubemap = new OwnLabel((CharSequence)I18n.msg("gui.360"), this.skin, "header");
        Table cubemap = new Table(this.skin);
        String cminfostr = I18n.msg("gui.360.info") + "\n";
        ssLines = GlobalResources.countOccurrences(cminfostr, '\n');
        OwnTextArea cmInfo = new OwnTextArea(cminfostr, this.skin, "info");
        cmInfo.setDisabled(true);
        cmInfo.setPrefRows(ssLines + 1);
        cmInfo.setWidth(960.0f);
        cmInfo.clearListeners();
        OwnLabel cmResolutionLabel = new OwnLabel((CharSequence)I18n.msg("gui.360.resolution"), this.skin);
        this.cmResolution = new OwnTextField(Integer.toString(settings.program.modeCubemap.faceResolution), this.skin, new IntValidator(20, 15000));
        this.cmResolution.setWidth(600.0f);
        this.cmResolution.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.cmResolution.isValid()) {
                    this.plResolution.setText(this.cmResolution.getText());
                }
                return true;
            }
            return false;
        });
        this.labels.add((Object)cmResolutionLabel);
        cubemap.add((Actor)cmInfo).colspan(2).left().padBottom(pad10).row();
        cubemap.add((Actor)cmResolutionLabel).left().padRight(pad34).padBottom(pad10);
        cubemap.add((Actor)this.cmResolution).left().fillX().padBottom(pad10).row();
        this.addContentGroup(content360, titleCubemap, (WidgetGroup)cubemap, 0.0f);
        Table contentPlanetarium = new Table(this.skin);
        contentPlanetarium.align(10);
        OwnLabel titlePlanetarium = new OwnLabel((CharSequence)I18n.msg("gui.planetarium"), this.skin, "header");
        Table planetarium = new Table(this.skin);
        OwnLabel apertureLabel = new OwnLabel((CharSequence)I18n.msg("gui.planetarium.aperture"), this.skin);
        this.plAperture = new OwnTextField(Float.toString(settings.program.modeCubemap.planetarium.aperture), this.skin, new FloatValidator(30.0f, 360.0f));
        this.plAperture.setWidth(600.0f);
        OwnLabel plAngleLabel = new OwnLabel((CharSequence)I18n.msg("gui.planetarium.angle"), this.skin);
        this.plAngle = new OwnTextField(Float.toString(settings.program.modeCubemap.planetarium.angle), this.skin, new FloatValidator(-180.0f, 180.0f));
        this.plAngle.setWidth(600.0f);
        String plInfoStr = I18n.msg("gui.planetarium.info") + "\n";
        ssLines = GlobalResources.countOccurrences(plInfoStr, '\n');
        OwnTextArea plInfo = new OwnTextArea(plInfoStr, this.skin, "info");
        plInfo.setDisabled(true);
        plInfo.setPrefRows(ssLines + 1);
        plInfo.setWidth(960.0f);
        plInfo.clearListeners();
        OwnLabel plResolutionLabel = new OwnLabel((CharSequence)I18n.msg("gui.360.resolution"), this.skin);
        this.plResolution = new OwnTextField(Integer.toString(settings.program.modeCubemap.faceResolution), this.skin, new IntValidator(20, 15000));
        this.plResolution.setWidth(600.0f);
        this.plResolution.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.plResolution.isValid()) {
                    this.cmResolution.setText(this.plResolution.getText());
                }
                return true;
            }
            return false;
        });
        this.labels.add((Object)plResolutionLabel, (Object)plAngleLabel, (Object)plResolutionLabel);
        planetarium.add((Actor)apertureLabel).left().padRight(pad34).padBottom(pad18 * 3.0f);
        planetarium.add((Actor)this.plAperture).left().fillX().padBottom(pad18 * 3.0f).row();
        planetarium.add((Actor)plAngleLabel).left().padRight(pad34).padBottom(pad18 * 3.0f);
        planetarium.add((Actor)this.plAngle).left().fillX().padBottom(pad18 * 3.0f).row();
        planetarium.add((Actor)plInfo).colspan(2).left().padBottom(pad10).row();
        planetarium.add((Actor)plResolutionLabel).left().padRight(pad34).padBottom(pad10);
        planetarium.add((Actor)this.plResolution).left().fillX().padBottom(pad10).row();
        OwnLabel titleSphericalMirror = new OwnLabel((CharSequence)I18n.msg("gui.planetarium.sphericalmirror"), this.skin, "header");
        Table sphericalMirror = new Table(this.skin);
        OwnLabel warpFileLabel = new OwnLabel((CharSequence)I18n.msg("gui.planetarium.sphericalmirror.warpfile"), this.skin);
        Path currentMeshWarp = settings.program.modeCubemap.planetarium.sphericalMirrorWarp;
        String meshWarpText = currentMeshWarp != null ? currentMeshWarp.getFileName().toString() : I18n.msg("gui.planetarium.sphericalmirror.warpfile.select");
        Path meshWarpPath = currentMeshWarp != null ? currentMeshWarp.getParent() : SysUtils.getUserHome();
        this.meshWarpFileLocation = new OwnTextButton(TextUtils.capString(meshWarpText, 45), this.skin);
        this.meshWarpFileLocation.pad(pad10, pad34, pad10, pad34);
        this.meshWarpFileLocation.addListener((EventListener)new OwnTextTooltip(currentMeshWarp != null ? currentMeshWarp.toString() : I18n.msg("gui.planetarium.sphericalmirror.warpfile.select"), this.skin));
        this.meshWarpFilePath = settings.program.modeCubemap.planetarium.sphericalMirrorWarp;
        this.meshWarpFileLocation.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                FileChooser fc = new FileChooser(I18n.msg("gui.planetarium.sphericalmirror.warpfile"), this.skin, this.stage, meshWarpPath, FileChooser.FileChooserTarget.FILES);
                fc.setShowHidden(settings.program.fileChooser.showHidden);
                fc.setShowHiddenConsumer(showHidden -> {
                    settings.program.fileChooser.showHidden = showHidden;
                });
                fc.setFileFilter(pathname -> Files.exists(pathname, new LinkOption[0]) && Files.isRegularFile(pathname, new LinkOption[0]));
                fc.setAcceptedFiles("*.*");
                fc.setResultListener((success, result) -> {
                    if (success) {
                        if (WarpMeshReader.isValidWarpMeshAscii(result)) {
                            this.meshWarpFileLocation.setText(TextUtils.capString(result.getFileName().toString(), 45));
                            this.meshWarpFilePath = result;
                            this.meshWarpFileLocation.addListener((EventListener)new OwnTextTooltip(result.toString(), this.skin));
                        } else {
                            EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("gui.planetarium.sphericalmirror.warpfile.invalid", result.toString()));
                        }
                    }
                    return true;
                });
                fc.show(this.stage);
                return true;
            }
            return false;
        });
        OwnImageButton meshWarpTooltip = new OwnImageButton(this.skin, "tooltip");
        meshWarpTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.planetarium.sphericalmirror.warpfile.tooltip"), this.skin));
        this.labels.add((Object)warpFileLabel);
        sphericalMirror.add((Actor)warpFileLabel).left().padRight(pad34).padBottom(pad18 * 3.0f);
        sphericalMirror.add((Actor)this.meshWarpFileLocation).left().fillX().padBottom(pad18 * 3.0f).padRight(pad18);
        sphericalMirror.add((Actor)meshWarpTooltip).left().padBottom(pad18 * 3.0f);
        this.addContentGroup(contentPlanetarium, titlePlanetarium, (WidgetGroup)planetarium, 0.0f);
        this.addContentGroup(contentPlanetarium, titleSphericalMirror, (WidgetGroup)sphericalMirror);
        Table contentDataTable = new Table(this.skin);
        contentDataTable.align(10);
        OwnScrollPane contentData = new OwnScrollPane((Actor)contentDataTable, this.skin, "minimalist-nobg");
        contentData.setHeight(640.0f);
        contentData.setScrollingDisabled(true, false);
        contentData.setFadeScrollBars(false);
        OwnLabel titleGeneralData = new OwnLabel((CharSequence)I18n.msg("gui.data.options"), this.skin, "header");
        OwnLabel highAccuracyPositionsLabel = new OwnLabel((CharSequence)I18n.msg("gui.data.highaccuracy"), this.skin);
        this.highAccuracyPositions = new OwnCheckBox("", this.skin);
        this.highAccuracyPositions.setChecked(settings.data.highAccuracy);
        this.highAccuracyPositions.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.data.highaccuracy"), this.skin));
        OwnImageButton highAccTooltip = new OwnImageButton(this.skin, "tooltip");
        highAccTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.data.highaccuracy"), this.skin));
        this.labels.add((Object)highAccuracyPositionsLabel);
        OwnLabel titleData = new OwnLabel((CharSequence)I18n.msg("gui.data.source"), this.skin, "header");
        String dsInfoStr = I18n.msg("gui.data.source.info") + "\n";
        int dsLines = GlobalResources.countOccurrences(dsInfoStr, '\n');
        OwnTextArea dataSourceInfo = new OwnTextArea(dsInfoStr, this.skin, "info");
        dataSourceInfo.setDisabled(true);
        dataSourceInfo.setPrefRows(dsLines + 1);
        dataSourceInfo.setWidth(960.0f);
        dataSourceInfo.clearListeners();
        OwnTextButton dataDownload = new OwnTextButton(I18n.msg("gui.download.title"), this.skin);
        dataDownload.pad(pad34, pad34 * 2.0f, pad34, pad34 * 2.0f);
        dataDownload.setHeight(40.0f);
        dataDownload.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (DataDescriptor.serverDataDescriptor != null || DataDescriptor.localDataDescriptor != null) {
                    DataDescriptor dd = DataDescriptor.serverDataDescriptor != null ? DataDescriptor.serverDataDescriptor : DataDescriptor.localDataDescriptor;
                    DatasetManagerWindow ddw = new DatasetManagerWindow(this.stage, this.skin, dd, false, I18n.msg("gui.save"));
                    ddw.setModal(true);
                    ddw.show(this.stage);
                } else {
                    FileHandle dataDescriptor = Gdx.files.absolute(String.valueOf(SysUtils.getDataTempDir(settings.data.location)) + "/gaiasky-data.json");
                    DownloadHelper.downloadFile(settings.program.url.dataDescriptor, dataDescriptor, Settings.settings.program.offlineMode, null, null, digest -> {
                        DataDescriptor dd = DataDescriptorUtils.instance().buildServerDatasets(dataDescriptor);
                        DatasetManagerWindow ddw = new DatasetManagerWindow(this.stage, this.skin, dd, false, null);
                        ddw.setModal(true);
                        ddw.show(this.stage);
                    }, () -> {
                        logger.error("No internet connection or server is down!");
                        GuiUtils.addNoConnectionWindow(this.skin, this.stage);
                    }, null);
                }
                return true;
            }
            return false;
        });
        OwnLabel titleAttitude = new OwnLabel((CharSequence)I18n.msg("gui.gaia.attitude"), this.skin, "header");
        Table attitude = new Table(this.skin);
        this.real = new OwnCheckBox(I18n.msg("gui.gaia.real"), this.skin, "radio", pad10);
        this.real.setChecked(settings.data.realGaiaAttitude);
        OwnCheckBox nsl = new OwnCheckBox(I18n.msg("gui.gaia.nsl"), this.skin, "radio", pad10);
        nsl.setChecked(!settings.data.realGaiaAttitude);
        new ButtonGroup((Button[])new OwnCheckBox[]{this.real, nsl});
        attitude.add((Actor)nsl).left().padBottom(pad10).padRight(pad20);
        attitude.add((Actor)this.getRequiresRestartLabel()).left().padBottom(pad10).row();
        attitude.add((Actor)this.real).left().padBottom(pad10).padRight(pad20);
        attitude.add((Actor)this.getRequiresRestartLabel()).left().padBottom(pad10).row();
        Cell noticeAttCell = attitude.add((Actor)null);
        noticeAttCell.colspan(2).left();
        EventListener attNoticeListener = event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (noticeAttCell.getActor() == null) {
                    String nextInfoStr = I18n.msg("gui.ui.info") + "\n";
                    int lines1 = GlobalResources.countOccurrences(nextInfoStr, '\n');
                    OwnTextArea nextTimeInfo = new OwnTextArea(nextInfoStr, this.skin, "info");
                    nextTimeInfo.setDisabled(true);
                    nextTimeInfo.setPrefRows(lines1 + 1);
                    nextTimeInfo.setWidth(960.0f);
                    nextTimeInfo.clearListeners();
                    noticeAttCell.setActor((Actor)nextTimeInfo);
                }
                return true;
            }
            return false;
        };
        this.real.addListener(attNoticeListener);
        nsl.addListener(attNoticeListener);
        Table generalData = new Table(this.skin);
        generalData.add((Actor)highAccuracyPositionsLabel).left().padBottom(pad34);
        generalData.add((Actor)this.highAccuracyPositions).left().padRight(pad34).padBottom(pad34);
        generalData.add((Actor)highAccTooltip).left().padBottom(pad34).row();
        this.addContentGroup(contentDataTable, titleGeneralData, (WidgetGroup)generalData, 0.0f);
        if (!this.welcomeScreen) {
            Table dataSource = new Table(this.skin);
            dataSource.add((Actor)dataSourceInfo).left().padBottom(pad10).row();
            dataSource.add((Actor)dataDownload).left().padBottom(pad34).row();
            this.addContentGroup(contentDataTable, titleData, (WidgetGroup)dataSource);
        }
        this.addContentGroup(contentDataTable, titleAttitude, (WidgetGroup)attitude);
        Table contentSystem = new Table(this.skin);
        contentSystem.align(10);
        OwnLabel titleSystemPrefs = new OwnLabel((CharSequence)I18n.msg("gui.system.reporting"), this.skin, "header");
        Table stats = new Table(this.skin);
        OwnLabel debugInfoLabel = new OwnLabel((CharSequence)I18n.msg("gui.system.debuginfo"), this.skin);
        this.debugInfo = new OwnCheckBox("", this.skin);
        this.debugInfo.setChecked(settings.program.debugInfo);
        this.debugInfo.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_DEBUG_CMD, (Object)this.debugInfo, !settings.program.debugInfo);
                return true;
            }
            return false;
        });
        OwnLabel cacheLabel = new OwnLabel((CharSequence)I18n.msg("gui.system.shader.cache"), this.skin);
        this.shaderCache = new OwnCheckBox("", this.skin);
        this.shaderCache.setChecked(settings.program.shaderCache);
        OwnImageButton shaderCacheTooltip = new OwnImageButton(this.skin, "tooltip");
        shaderCacheTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.system.shader.cache.info"), this.skin));
        OwnTextButton clearCache = new OwnTextButton(I18n.msg("gui.system.shader.cache.clear"), this.skin);
        clearCache.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                ChangeListener.ChangeEvent ce = (ChangeListener.ChangeEvent)event;
                Path path = SysUtils.getShaderCacheDir();
                try {
                    FileUtils.cleanDirectory((File)path.toFile());
                    EventManager.publish(Event.POST_POPUP_NOTIFICATION, (Object)clearCache, I18n.msg("gui.system.shader.cache.clean", path.toString()), Float.valueOf(4.0f));
                }
                catch (IOException e) {
                    logger.error(e);
                }
                return true;
            }
            return false;
        });
        clearCache.pad(0.0f, pad34, 0.0f, pad34);
        clearCache.setHeight(40.0f);
        OwnLabel exitConfirmationLabel = new OwnLabel((CharSequence)I18n.msg("gui.quit.confirmation"), this.skin);
        this.exitConfirmation = new OwnCheckBox("", this.skin);
        this.exitConfirmation.setChecked(settings.program.exitConfirmation);
        this.labels.addAll((Object[])new OwnLabel[]{debugInfoLabel, cacheLabel, exitConfirmationLabel});
        OwnTextButton reloadDefaults = new OwnTextButton(I18n.msg("gui.system.reloaddefaults"), this.skin);
        reloadDefaults.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.reloadDefaultPreferences();
                this.me.hide();
                GaiaSky.instance.saveState = false;
                Gdx.app.exit();
                return true;
            }
            return false;
        });
        reloadDefaults.pad(0.0f, pad34, 0.0f, pad34);
        reloadDefaults.setHeight(40.0f);
        OwnLabel warningLabel = new OwnLabel((CharSequence)I18n.msg("gui.system.reloaddefaults.warn"), this.skin, "default-red");
        stats.add((Actor)debugInfoLabel).left().padBottom(pad10);
        stats.add((Actor)this.debugInfo).left().padBottom(pad10).row();
        stats.add((Actor)exitConfirmationLabel).left().padBottom(pad10);
        stats.add((Actor)this.exitConfirmation).left().padBottom(pad10).row();
        stats.add((Actor)cacheLabel).left().padBottom(pad10);
        stats.add((Actor)this.shaderCache).left().padBottom(pad10).padRight(pad18);
        stats.add((Actor)shaderCacheTooltip).left().padBottom(pad10).row();
        stats.add((Actor)clearCache).left().colspan(2).padBottom(pad34 * 3.0f).row();
        stats.add((Actor)warningLabel).left().colspan(2).padBottom(pad34).row();
        stats.add((Actor)reloadDefaults).left().colspan(2);
        this.addContentGroup(contentSystem, titleSystemPrefs, (WidgetGroup)stats, 0.0f);
        float maxLabelWidth = 707.5f;
        for (OwnLabel l : this.labels) {
            l.pack();
            if (!(l.getWidth() > maxLabelWidth)) continue;
            maxLabelWidth = l.getWidth();
        }
        for (OwnLabel l : this.labels) {
            l.setWidth(maxLabelWidth);
        }
        this.addTabContent((Group)contentGraphics);
        this.addTabContent((Group)contentScene);
        this.addTabContent((Group)contentUI);
        this.addTabContent((Group)contentPerformance);
        this.addTabContent((Group)contentControls);
        this.addTabContent((Group)contentScreenshots);
        this.addTabContent((Group)contentFrames);
        this.addTabContent((Group)contentCamera);
        this.addTabContent((Group)content360);
        this.addTabContent((Group)contentPlanetarium);
        this.addTabContent((Group)contentData);
        this.addTabContent((Group)contentSystem);
        this.content.add((Actor)this.tabStack).left().padLeft(pad20).expand().fill();
        this.setUpTabListeners();
    }

    private void populateWidthHeight(boolean force) {
        this.populateWidthHeight(force, this.widthField, this.heightField, Gdx.graphics);
    }

    private void populateWidthHeight(boolean force, OwnTextField w, OwnTextField h, Graphics g) {
        if (force || w != null && w.getText().isBlank()) {
            w.setText(Integer.toString(MathUtils.clamp((int)g.getWidth(), (int)100, (int)10000)));
        }
        if (force || h != null && h.getText().isBlank()) {
            h.setText(Integer.toString(MathUtils.clamp((int)g.getHeight(), (int)100, (int)10000)));
        }
    }

    private Label getRequiresRestartLabel() {
        OwnLabel restart = new OwnLabel((CharSequence)"*", this.skin, "mono-pink-big");
        restart.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.restart"), this.skin));
        return restart;
    }

    @Override
    public GenericDialog show(Stage stage, Action action) {
        GenericDialog result = super.show(stage, action);
        this.updateBackupValues();
        this.populateWidthHeight(true);
        return result;
    }

    @Override
    public void touch() {
        Settings settings = Settings.settings;
        this.setSlider(this.bloomEffect, settings.postprocess.bloom.intensity);
        this.setSlider(this.unsharpMask, settings.postprocess.unsharpMask.factor);
        this.setSlider(this.chromaticAberration, settings.postprocess.chromaticAberration.amount);
        this.setSlider(this.tessQuality, (float)settings.scene.renderer.elevation.quality);
        boolean fullscreen = settings.graphics.fullScreen.active;
        this.setCheckBox(this.fullScreen, fullscreen);
        this.setCheckBox(this.windowed, !fullscreen);
        this.enableComponents(!fullscreen, new Disableable[]{this.widthField, this.heightField});
        this.enableComponents(fullscreen, new Disableable[]{this.fullScreenResolutions});
    }

    private void setSlider(OwnSliderPlus slider, float value) {
        slider.setProgrammaticChangeEvents(false);
        slider.setValue(value);
        slider.setProgrammaticChangeEvents(true);
    }

    private void setCheckBox(CheckBox cb, boolean checked) {
        cb.setProgrammaticChangeEvents(false);
        cb.setChecked(checked);
        cb.setProgrammaticChangeEvents(true);
    }

    private void updateBackupValues() {
        Settings settings = Settings.settings;
        this.bloomBak = settings.postprocess.bloom.intensity;
        this.unsharpMaskBak = settings.postprocess.unsharpMask.factor;
        this.aberrationBak = settings.postprocess.chromaticAberration.amount;
        this.filmGrainBak = settings.postprocess.filmGrain.intensity;
        this.lensFlareBak = settings.postprocess.lensFlare.strength;
        this.lightGlowBak = settings.postprocess.lightGlow.active;
        this.brightnessBak = settings.postprocess.levels.brightness;
        this.contrastBak = settings.postprocess.levels.contrast;
        this.hueBak = settings.postprocess.levels.hue;
        this.saturationBak = settings.postprocess.levels.saturation;
        this.gammaBak = settings.postprocess.levels.gamma;
        this.toneMappingBak = settings.postprocess.toneMapping.type;
        this.exposureBak = settings.postprocess.toneMapping.exposure;
        this.debugInfoBak = settings.program.debugInfo;
        this.reprojectionBak = settings.postprocess.reprojection.mode;
        this.upscaleFilterBak = settings.postprocess.upscaleFilter;
        this.frameCoordinatesBak = settings.program.uvGrid.frameCoordinates;
        this.FXAAQualityBak = settings.postprocess.antialiasing.quality;
    }

    protected void reloadGamepadMappings(Path selectedFile) {
        Array gamepadMappingsFile = new Array();
        Path mappingsAssets = Path.of(Settings.ASSETS_LOC, SysUtils.getMappingsDirName());
        Path mappingsData = SysUtils.getDefaultMappingsDir();
        Array mappingFiles = new Array();
        GlobalResources.listRecursive(mappingsAssets, (Array<Path>)mappingFiles, ".inputListener", ".controller");
        GlobalResources.listRecursive(mappingsData, (Array<Path>)mappingFiles, ".inputListener", ".controller");
        MappingFileComboBoxBean selected = null;
        for (Path path : mappingFiles) {
            MappingFileComboBoxBean fileBean = new MappingFileComboBoxBean(path);
            gamepadMappingsFile.add((Object)fileBean);
            if (selectedFile == null && Settings.settings.controls.gamepad.mappingsFile.endsWith(path.getFileName().toString())) {
                selected = fileBean;
                continue;
            }
            if (selectedFile == null || !selectedFile.toAbsolutePath().toString().endsWith(path.getFileName().toString())) continue;
            selected = fileBean;
        }
        this.gamepadMappings.setItems(gamepadMappingsFile);
        this.gamepadMappings.setSelected(selected);
        this.gamepadMappings.pack();
    }

    protected void generateGamepadsList(Table table) {
        Array controllers = Controllers.getControllers();
        Array controllerNames = new Array();
        for (Controller c : controllers) {
            OwnLabel cl = new OwnLabel((CharSequence)c.getName(), this.skin, "default-blue");
            cl.setName(c.getName());
            if (Settings.settings.controls.gamepad.isControllerBlacklisted(c.getName())) {
                cl.setText(String.valueOf(cl.getText()) + " [*]");
                cl.setColor(1.0f, 0.0f, 0.0f, 1.0f);
                cl.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.controller.blacklist"), this.skin));
            }
            controllerNames.add((Object)cl);
        }
        if (controllerNames.isEmpty()) {
            controllerNames.add((Object)new OwnLabel((CharSequence)I18n.msg("gui.controller.nocontrollers"), this.skin));
        }
        if (table == null) {
            table = new Table(this.skin);
        }
        table.clear();
        int i = 0;
        for (OwnLabel cn : controllerNames) {
            String controllerName = cn.getName();
            table.add((Actor)cn).left().padBottom(i == controllerNames.size - 1 ? 0.0f : pad18).padRight(pad34);
            if (controllerName != null && !Settings.settings.controls.gamepad.isControllerBlacklisted(controllerName)) {
                OwnTextButton config = new OwnTextButton(I18n.msg("gui.controller.configure"), this.skin);
                config.pad(pad10, pad18, pad10, pad18);
                config.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        GamepadMappings cm = new GamepadMappings(controllerName, Path.of(((FileComboBoxBean)this.gamepadMappings.getSelected()).file, new String[0]));
                        GamepadConfigWindow ccw = new GamepadConfigWindow(controllerName, cm, this.stage, this.skin);
                        ccw.setAcceptListener(() -> {
                            if (ccw.savedFile != null) {
                                this.reloadGamepadMappings(ccw.savedFile);
                            }
                        });
                        ccw.show(this.stage);
                        return true;
                    }
                    return false;
                });
                table.add((Actor)config).left().padBottom(i == controllerNames.size - 1 ? 0.0f : pad18).row();
            } else {
                table.add().left().row();
            }
            ++i;
        }
        table.pack();
    }

    @Override
    protected boolean accept() {
        this.saveCurrentPreferences();
        this.unsubscribe();
        return true;
    }

    @Override
    public void cancel() {
        this.revertLivePreferences();
        this.unsubscribe();
    }

    @Override
    public void dispose() {
        this.unsubscribe();
    }

    private void reloadDefaultPreferences() {
        Path userFolder = SysUtils.getConfigDir();
        Path userFolderConfFile = userFolder.resolve("config.yaml");
        Path confFolder = Paths.get(Settings.ASSETS_LOC, "conf" + File.separator);
        Path internalFolderConfFile = confFolder.resolve("config.yaml");
        if (Files.exists(userFolderConfFile, new LinkOption[0])) {
            try {
                Files.delete(userFolderConfFile);
            }
            catch (IOException e) {
                logger.error(e);
            }
        }
        try {
            if (!Files.exists(confFolder, new LinkOption[0]) || !Files.isDirectory(confFolder, new LinkOption[0])) {
                throw new IOException("File " + String.valueOf(confFolder) + " does not exist!");
            }
            GlobalResources.copyFile(internalFolderConfFile, userFolderConfFile, true);
            logger.info("Default configuration file applied successfully! Gaia Sky will shut down now");
        }
        catch (Exception e) {
            logger.error(e, "Error copying default preferences file to user folder: " + String.valueOf(userFolderConfFile));
        }
    }

    private void saveCurrentPreferences() {
        String mappingsFile;
        float pa;
        float ap;
        String text;
        File ssFile;
        boolean restartDialog;
        Settings settings = Settings.settings;
        boolean reloadFullScreenMode = this.fullScreen.isChecked() != settings.graphics.fullScreen.active;
        Graphics.DisplayMode selected = (Graphics.DisplayMode)this.fullScreenResolutions.getSelected();
        boolean reloadScreenMode = reloadFullScreenMode || settings.graphics.fullScreen.active && (settings.graphics.fullScreen.resolution[0] != selected.width || settings.graphics.fullScreen.resolution[1] != selected.height || settings.graphics.fullScreen.refreshRate != selected.refreshRate || settings.graphics.fullScreen.bitDepth != selected.bitsPerPixel) || !settings.graphics.fullScreen.active && settings.graphics.resolution[0] != Integer.parseInt(this.widthField.getText()) || settings.graphics.resolution[1] != Integer.parseInt(this.heightField.getText());
        boolean resetRenderFlags = false;
        settings.graphics.fullScreen.active = this.fullScreen.isChecked();
        settings.graphics.fullScreen.resolution[0] = selected.width;
        settings.graphics.fullScreen.resolution[1] = selected.height;
        settings.graphics.fullScreen.bitDepth = selected.bitsPerPixel;
        settings.graphics.fullScreen.refreshRate = selected.refreshRate;
        settings.graphics.resolution[0] = Integer.parseInt(this.widthField.getText());
        settings.graphics.resolution[1] = Integer.parseInt(this.heightField.getText());
        ComboBoxBean bean = (ComboBoxBean)this.graphicsQuality.getSelected();
        boolean bl = restartDialog = settings.graphics.quality.ordinal() != bean.value;
        if (settings.graphics.quality.ordinal() != bean.value) {
            settings.graphics.quality = Settings.GraphicsQuality.values()[bean.value];
        }
        if (GaiaSky.instance.isExternalView()) {
            GaiaSkyView ev = GaiaSky.instance.gaiaSkyView;
            ev.graphics.setWindowedMode((int)this.evwField.getIntValue(1920), (int)this.evhField.getIntValue(1080));
        }
        bean = (ComboBoxBean)this.antiAlias.getSelected();
        Settings.PostprocessSettings.AntialiasType newAntiAlias = settings.postprocess.getAntialias(bean.value);
        if (settings.postprocess.antialiasing.type != newAntiAlias) {
            EventManager.publish(Event.ANTIALIASING_CMD, this, new Object[]{newAntiAlias});
        }
        EventManager.publish(Event.FXAA_QUALITY_CMD, this, this.FXAAQuality);
        settings.graphics.vsync = this.vsyncValue.get();
        try {
            Gdx.graphics.setVSync(settings.graphics.vsync);
        }
        catch (Exception e) {
            logger.error(e);
        }
        if (this.maxFps.isChecked()) {
            EventManager.publish(Event.LIMIT_FPS_CMD, this, Parser.parseDouble(this.maxFpsInput.getText()));
        } else {
            EventManager.publish(Event.LIMIT_FPS_CMD, this, 0.0);
        }
        Settings.PointCloudMode newPointCloudMode = Settings.PointCloudMode.values()[((ComboBoxBean)this.pointCloudRenderer.getSelected()).value];
        restartDialog = restartDialog || newPointCloudMode != settings.scene.renderer.pointCloud;
        settings.scene.renderer.pointCloud = newPointCloudMode;
        restartDialog = restartDialog || Settings.settings.data.realGaiaAttitude != this.real.isChecked();
        boolean reloadLineRenderer = settings.scene.renderer.line.mode != Settings.LineMode.values()[((ComboBoxBean)this.lineRenderer.getSelected()).value];
        bean = (ComboBoxBean)this.lineRenderer.getSelected();
        settings.scene.renderer.line.mode = Settings.LineMode.values()[bean.value];
        Settings.ElevationType newType = ((ElevationComboBoxBean)this.elevationSb.getSelected()).type;
        if (SysUtils.isMac() && newType.isTessellation()) {
            newType = Settings.ElevationType.REGULAR;
            EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("gui.elevation.macos"));
            logger.info(I18n.msg("gui.elevation.macos"));
        }
        boolean reloadElevation = newType != settings.scene.renderer.elevation.type;
        settings.scene.renderer.elevation.type = newType;
        restartDialog = restartDialog || reloadElevation;
        EventManager.publish(Event.TESSELLATION_QUALITY_CMD, this, Float.valueOf(this.tessQuality.getValue()));
        settings.scene.renderer.shadow.active = this.shadowsCb.isChecked();
        int newShadowResolution = Integer.parseInt(this.smResolution.getText());
        int newShadowNumber = ((ComboBoxBean)this.nShadows.getSelected()).value;
        boolean reloadShadows = this.shadowsCb.isChecked() && (settings.scene.renderer.shadow.resolution != newShadowResolution || settings.scene.renderer.shadow.number != newShadowNumber);
        int pgHeight = (int)this.pgResolution.getValue();
        int pgWidth = pgHeight * 2;
        EventManager.publish(Event.PROCEDURAL_GENERATION_RESOLUTION_CMD, this, pgWidth, pgHeight);
        EventManager.publish(Event.PROCEDURAL_GENERATION_SAVE_TEXTURES_CMD, this, this.saveTextures.isChecked());
        boolean eclipsesActiveBefore = settings.scene.renderer.eclipses.active;
        settings.scene.renderer.eclipses.active = this.eclipses.isChecked();
        settings.scene.renderer.eclipses.outlines = this.eclipseOutlines.isChecked();
        if (eclipsesActiveBefore && !this.eclipses.isChecked()) {
            EventManager.publish(Event.ECLIPSES_CMD, this, this.eclipses.isChecked());
        }
        settings.scene.star.renderStarSpheres = this.starSpheres.isChecked();
        settings.scene.particleGroups.motionTrails = this.motionTrails.isChecked();
        settings.scene.camera.starDistanceScaling = this.starDistanceScaling.isChecked();
        if (this.textureIndex != null && settings.scene.star.textureIndex != ((ComboBoxBean)this.textureIndex.getSelected()).value) {
            EventManager.publish(Event.BILLBOARD_TEXTURE_IDX_CMD, this, ((ComboBoxBean)this.textureIndex.getSelected()).value);
        }
        settings.scene.fadeMs = MathUtils.clamp((long)this.fadeTimeField.getLongValue(settings.scene.fadeMs), (long)0L, (long)30000L);
        boolean bl2 = settings.graphics.dynamicResolution = !settings.runtime.openXr && this.dynamicResolution.isChecked();
        if (!settings.graphics.dynamicResolution) {
            GaiaSky.postRunnable(() -> GaiaSky.instance.resetDynamicResolution());
        }
        if (this.svtCacheSize != null) {
            boolean reloadSVT = (int)this.svtCacheSize.getValue() != settings.scene.renderer.virtualTextures.cacheSize;
            boolean bl3 = restartDialog = restartDialog || reloadSVT;
            if (reloadSVT) {
                GaiaSky.postRunnable(() -> EventManager.publish(Event.SVT_CACHE_SIZE_CMD, this, (int)this.svtCacheSize.getValue()));
            }
        }
        if (this.ssr != null) {
            boolean reloadSSR;
            resetRenderFlags = reloadSSR = settings.postprocess.ssr.active != this.ssr.isChecked();
            if (reloadSSR) {
                GaiaSky.postRunnable(() -> EventManager.publish(Event.SSR_CMD, (Object)this.ssr, this.ssr.isChecked()));
            }
        }
        if (this.backBufferScale != null && !this.backBufferScale.isDisabled() && settings.graphics.backBufferScale != (double)this.backBufferScale.getValue()) {
            GaiaSky.postRunnable(() -> EventManager.publish(Event.BACKBUFFER_SCALE_CMD, (Object)this.backBufferScale, Float.valueOf(this.backBufferScale.getValue())));
        }
        LangComboBoxBean languageBean = (LangComboBoxBean)this.lang.getSelected();
        StringComobBoxBean newTheme = (StringComobBoxBean)this.theme.getSelected();
        float factor = this.uiScale.getMappedValue();
        EventManager.publish(Event.UI_SCALE_FACTOR_CMD, this, Float.valueOf(factor));
        EventManager.publish(Event.UI_SCALE_RECOMPUTE_CMD, this, new Object[0]);
        boolean reloadLang = !languageBean.locale.toLanguageTag().equals(settings.program.getLocale());
        boolean reloadUI = reloadLang || !settings.program.ui.theme.equals(newTheme.value) || settings.program.minimap.size != this.minimapSize.getValue() || settings.program.ui.newUI != this.newUI.isChecked();
        settings.program.locale = languageBean.locale.toLanguageTag();
        I18n.forceInit(new FileHandle(Settings.ASSETS_LOC + File.separator + "i18n/gsbundle"), new FileHandle(Settings.ASSETS_LOC + File.separator + "i18n/objects"));
        settings.program.ui.theme = newTheme.value;
        boolean previousPointerCoords = settings.program.pointer.coordinates;
        settings.program.pointer.coordinates = this.pointerCoords.isChecked();
        if (previousPointerCoords != settings.program.pointer.coordinates) {
            EventManager.publish(Event.DISPLAY_POINTER_COORDS_CMD, this, settings.program.pointer.coordinates);
        }
        EventManager.publish(Event.SHOW_NOTIFICATIONS_CMD, this, this.displayNotifications.isChecked());
        EventManager.publish(Event.CROSSHAIR_FOCUS_CMD, this, this.crosshairFocus.isChecked());
        EventManager.publish(Event.CROSSHAIR_CLOSEST_CMD, this, this.crosshairClosest.isChecked());
        EventManager.publish(Event.CROSSHAIR_HOME_CMD, this, this.crosshairHome.isChecked());
        EventManager.publish(Event.POINTER_GUIDES_CMD, this, this.pointerGuides.isChecked(), this.pointerGuidesColor.getPickedColor(), Float.valueOf(this.pointerGuidesWidth.getMappedValue()));
        settings.program.recursiveGrid.origin = Settings.OriginType.values()[this.recGridOrigin.getSelectedIndex()];
        settings.program.recursiveGrid.style = Settings.GridStyle.values()[this.recGridStyle.getSelectedIndex()];
        settings.program.recursiveGrid.projectionLines = this.recGridProjectionLines.isChecked();
        settings.program.minimap.size = this.minimapSize.getValue();
        settings.program.ui.newUI = this.newUI.isChecked();
        settings.program.ui.distanceUnits = Settings.DistanceUnits.values()[this.distUnitsSelect.getSelectedIndex()];
        settings.program.displayTimeNoUi = this.displayTimeNoUi.isChecked();
        settings.program.ui.modeChangeInfo = this.modeChangeInfo.isChecked();
        bean = (ComboBoxBean)this.numThreads.getSelected();
        settings.performance.numberThreads = bean.value;
        settings.performance.multithreading = this.multithreadCb.isChecked();
        settings.scene.octree.fade = this.lodFadeCb.isChecked();
        settings.scene.octree.threshold[0] = MathUtilsDouble.lint(this.lodTransitions.getValue(), 0.0f, 100.0f, 0.0f, 120.0f) * ((float)Math.PI / 180);
        settings.scene.octree.threshold[1] = settings.scene.octree.fade ? settings.scene.octree.threshold[0] + 0.4f : settings.scene.octree.threshold[0];
        settings.scene.star.group.numVelocityVector = (int)this.velocityVectors.getValue();
        boolean highAccuracy = settings.data.highAccuracy;
        settings.data.highAccuracy = this.highAccuracyPositions.isChecked();
        if (highAccuracy != settings.data.highAccuracy) {
            EventManager.publish(Event.HIGH_ACCURACY_CMD, this, settings.data.highAccuracy);
        }
        if ((ssFile = this.screenshotsPath.toFile()).exists() && ssFile.isDirectory()) {
            settings.screenshot.location = ssFile.getAbsolutePath();
        }
        Settings.ScreenshotMode prev = settings.screenshot.mode;
        settings.screenshot.mode = Settings.ScreenshotMode.values()[this.screenshotMode.getSelectedIndex()];
        int ssw = Integer.parseInt(this.ssWidthField.getText());
        int ssh = Integer.parseInt(this.ssHeightField.getText());
        boolean ssUpdate = ssw != settings.screenshot.resolution[0] || ssh != settings.screenshot.resolution[1] || !prev.equals((Object)settings.screenshot.mode);
        settings.screenshot.resolution[0] = ssw;
        settings.screenshot.resolution[1] = ssh;
        if (ssUpdate) {
            EventManager.publish(Event.SCREENSHOT_SIZE_UPDATE, this, settings.screenshot.resolution[0], settings.screenshot.resolution[1]);
        }
        settings.screenshot.format = Settings.ImageFormat.values()[((ComboBoxBean)this.screenshotFormat.getSelected()).value];
        settings.screenshot.quality = this.screenshotQuality.getValue() / 100.0f;
        File foFile = this.frameOutputPath.toFile();
        if (foFile.exists() && foFile.isDirectory()) {
            settings.frame.location = foFile.getAbsolutePath();
        }
        if ((text = this.frameOutputPrefix.getText()).matches("^\\w+$")) {
            settings.frame.prefix = text;
        }
        prev = settings.frame.mode;
        settings.frame.mode = Settings.ScreenshotMode.values()[this.frameOutputMode.getSelectedIndex()];
        int fow = Integer.parseInt(this.foWidthField.getText());
        int foh = Integer.parseInt(this.foHeightField.getText());
        boolean frameOutputUpdate = fow != settings.frame.resolution[0] || foh != settings.frame.resolution[1] || !prev.equals((Object)settings.frame.mode);
        settings.frame.resolution[0] = fow;
        settings.frame.resolution[1] = foh;
        settings.frame.targetFps = Parser.parseDouble(this.frameOutputFps.getText());
        if (frameOutputUpdate) {
            EventManager.publish(Event.FRAME_SIZE_UPDATE, this, settings.frame.resolution[0], settings.frame.resolution[1]);
        }
        settings.frame.format = Settings.ImageFormat.values()[((ComboBoxBean)this.frameOutputFormat.getSelected()).value];
        settings.frame.quality = this.frameQuality.getValue() / 100.0f;
        EventManager.publish(Event.CAMRECORDER_FPS_CMD, this, Parser.parseDouble(this.camRecFps.getText()));
        settings.camrecorder.auto = this.cbAutoCamRec.isChecked();
        int newResolution = Integer.parseInt(this.cmResolution.getText());
        if (newResolution != settings.program.modeCubemap.faceResolution) {
            EventManager.publish(Event.CUBEMAP_RESOLUTION_CMD, this, newResolution);
        }
        if ((ap = Float.parseFloat(this.plAperture.getText())) != settings.program.modeCubemap.planetarium.aperture) {
            EventManager.publish(Event.PLANETARIUM_APERTURE_CMD, this, Float.valueOf(ap));
        }
        if ((pa = Float.parseFloat(this.plAngle.getText())) != settings.program.modeCubemap.planetarium.angle) {
            EventManager.publish(Event.PLANETARIUM_ANGLE_CMD, this, Float.valueOf(pa));
        }
        if (settings.program.modeCubemap.planetarium.sphericalMirrorWarp != this.meshWarpFilePath) {
            EventManager.publish(Event.PLANETARIUM_GEOMETRYWARP_FILE_CMD, this, this.meshWarpFilePath);
        }
        if (this.celestialSphereIndexOfRefraction != null) {
            EventManager.publish(Event.INDEXOFREFRACTION_CMD, this, Float.valueOf(this.celestialSphereIndexOfRefraction.getValue()));
        }
        if (this.gamepadMappings.getSelected() != null && !(mappingsFile = ((FileComboBoxBean)this.gamepadMappings.getSelected()).file).equals(settings.controls.gamepad.mappingsFile) && !SysUtils.isAppImagePath(mappingsFile)) {
            settings.controls.gamepad.mappingsFile = mappingsFile;
            EventManager.publish(Event.RELOAD_CONTROLLER_MAPPINGS, this, mappingsFile);
        }
        EventManager.publish(Event.INVERT_X_CMD, this, this.invertX.isChecked());
        EventManager.publish(Event.INVERT_Y_CMD, this, this.invertY.isChecked());
        settings.data.realGaiaAttitude = this.real.isChecked();
        if (settings.program.debugInfo != this.debugInfoBak) {
            EventManager.publish(Event.SHOW_DEBUG_CMD, this, !this.debugInfoBak);
        }
        settings.program.shaderCache = this.shaderCache.isChecked();
        settings.program.exitConfirmation = this.exitConfirmation.isChecked();
        SettingsManager.persistSettings(new File(System.getProperty("properties.file")));
        EventManager.publish(Event.PROPERTIES_WRITTEN, this, new Object[0]);
        if (reloadScreenMode) {
            GaiaSky.postRunnable(() -> EventManager.publish(Event.SCREEN_MODE_CMD, this, new Object[0]));
        }
        if (reloadLineRenderer) {
            GaiaSky.postRunnable(() -> EventManager.publish(Event.LINE_RENDERER_UPDATE, this, new Object[0]));
        }
        if (reloadShadows) {
            GaiaSky.postRunnable(() -> {
                settings.scene.renderer.shadow.resolution = newShadowResolution;
                settings.scene.renderer.shadow.number = newShadowNumber;
                EventManager.publish(Event.REBUILD_SHADOW_MAP_DATA_CMD, this, new Object[0]);
            });
        }
        if (resetRenderFlags) {
            GaiaSky.postRunnable(() -> EventManager.publish(Event.RESET_RENDERER, this, new Object[0]));
        }
        if (reloadLang) {
            this.reloadLanguage();
        }
        if (reloadUI) {
            this.reloadUI(this.globalResources);
        }
        if (restartDialog) {
            this.showRestartDialog(I18n.msg("gui.restart.setting"));
        }
    }

    private void unsubscribe() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }

    private void revertLivePreferences() {
        EventManager.publish(Event.BRIGHTNESS_CMD, this, Float.valueOf(this.brightnessBak));
        EventManager.publish(Event.CONTRAST_CMD, this, Float.valueOf(this.contrastBak));
        EventManager.publish(Event.HUE_CMD, this, Float.valueOf(this.hueBak));
        EventManager.publish(Event.SATURATION_CMD, this, Float.valueOf(this.saturationBak));
        EventManager.publish(Event.GAMMA_CMD, this, Float.valueOf(this.gammaBak));
        EventManager.publish(Event.LENS_FLARE_CMD, this, Float.valueOf(this.lensFlareBak));
        EventManager.publish(Event.LIGHT_GLOW_CMD, this, this.lightGlowBak);
        EventManager.publish(Event.BLOOM_CMD, this, Float.valueOf(this.bloomBak));
        EventManager.publish(Event.UNSHARP_MASK_CMD, this, Float.valueOf(this.unsharpMaskBak));
        EventManager.publish(Event.CHROMATIC_ABERRATION_CMD, this, Float.valueOf(this.aberrationBak));
        EventManager.publish(Event.FILM_GRAIN_CMD, this, Float.valueOf(this.filmGrainBak));
        EventManager.publish(Event.EXPOSURE_CMD, this, Float.valueOf(this.exposureBak));
        EventManager.publish(Event.TONEMAPPING_TYPE_CMD, this, new Object[]{this.toneMappingBak});
        EventManager.publish(Event.SHOW_DEBUG_CMD, this, this.debugInfoBak);
        EventManager.publish(Event.REPROJECTION_CMD, this, new Object[]{this.reprojectionBak != Settings.ReprojectionMode.DISABLED, this.reprojectionBak});
        EventManager.publish(Event.UPSCALE_FILTER_CMD, this, new Object[]{this.upscaleFilterBak});
        EventManager.publish(Event.UV_GRID_FRAME_COORDINATES_CMD, this, this.frameCoordinatesBak);
        EventManager.publish(Event.FXAA_QUALITY_CMD, this, this.FXAAQualityBak);
    }

    private void reloadLanguage() {
        EventManager.publish(Event.SCENE_RELOAD_NAMES_CMD, this, new Object[0]);
        KeyBindings.initialize(true);
    }

    private void reloadUI(GlobalResources globalResources) {
        EventManager.publish(Event.UI_RELOAD_CMD, this, globalResources);
    }

    @Override
    protected void showDialogHook(Stage stage) {
        if (this.frameSequenceNumber != null) {
            this.frameSequenceNumber.setText(Integer.toString(ImageRenderer.getSequenceNumber()));
        }
    }

    private void showRestartDialog(String text) {
        EventManager.publish(Event.SHOW_RESTART_ACTION, this, text);
    }

    private void selectFullscreen(boolean fullscreen, OwnTextField widthField, OwnTextField heightField, SelectBox<Graphics.DisplayMode> fullScreenResolutions, OwnLabel xLabel) {
        Settings settings = Settings.settings;
        if (fullscreen) {
            settings.graphics.resolution[0] = ((Graphics.DisplayMode)fullScreenResolutions.getSelected()).width;
            settings.graphics.resolution[1] = ((Graphics.DisplayMode)fullScreenResolutions.getSelected()).height;
        } else if (!widthField.getText().isBlank() && !heightField.getText().isBlank()) {
            settings.graphics.resolution[0] = Integer.parseInt(widthField.getText());
            settings.graphics.resolution[1] = Integer.parseInt(heightField.getText());
        } else {
            this.populateWidthHeight(true);
        }
        this.enableComponents(!fullscreen, new Disableable[]{widthField, heightField, xLabel});
        this.enableComponents(fullscreen, new Disableable[]{fullScreenResolutions});
    }

    private int idxAa(Settings.PostprocessSettings.AntialiasType x) {
        if (x.getAACode() == -1) {
            return 1;
        }
        if (x.getAACode() == -2) {
            return 2;
        }
        if (x.getAACode() == 0) {
            return 0;
        }
        return (int)(Math.log(x.getAACode()) / FastMath.log((double)2.0) + 1.0E-10) + 2;
    }

    private int idxLang(String code, Array<LangComboBoxBean> langs) {
        if (code == null || code.isEmpty()) {
            code = I18n.messages.getLocale().toLanguageTag();
        }
        for (int i = 0; i < langs.size; ++i) {
            if (!((LangComboBoxBean)langs.get((int)i)).locale.toLanguageTag().equals(code)) continue;
            return i;
        }
        return -1;
    }

    private String keysToString(TreeSet<Integer> keys) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        int n = keys.size();
        for (Integer key : keys) {
            s.append(this.keyToString(key).toUpperCase().replace(' ', '_'));
            if (i < n - 1) {
                s.append("+");
            }
            ++i;
        }
        return s.toString();
    }

    private String keyToString(int key) {
        String str = Input.Keys.toString((int)key);
        if (str.equals("+")) {
            str = "PL";
        }
        return str;
    }

    public void resize(int width, int height) {
        this.populateWidthHeight(true);
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case CONTROLLER_CONNECTED_INFO: 
            case CONTROLLER_DISCONNECTED_INFO: {
                this.generateGamepadsList(this.controllersTable);
                break;
            }
            case INVERT_X_CMD: {
                if (source == this || this.invertX == null) break;
                this.invertX.setProgrammaticChangeEvents(false);
                this.invertX.setChecked((Boolean)data[0]);
                this.invertX.setProgrammaticChangeEvents(true);
                break;
            }
            case INVERT_Y_CMD: {
                if (source == this || this.invertY == null) break;
                this.invertY.setProgrammaticChangeEvents(false);
                this.invertY.setChecked((Boolean)data[0]);
                this.invertY.setProgrammaticChangeEvents(true);
                break;
            }
            case WINDOW_RESOLUTION_INFO: {
                if (source == this) break;
                Integer width = (Integer)data[0];
                Integer height = (Integer)data[1];
                this.widthField.setText(width.toString());
                this.heightField.setText(height.toString());
                break;
            }
        }
    }

    private static /* synthetic */ void lambda$build$12(ComboBoxBean[] nsh, int s) {
        nsh[s - 1] = new ComboBoxBean(String.valueOf(s), s);
    }
}

