/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Scaling;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.window.ColorPicker;
import gaiasky.gui.window.GenericDialog;
import gaiasky.render.postprocess.filters.NoiseFilter;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Atmosphere;
import gaiasky.scene.component.Cloud;
import gaiasky.scene.component.Model;
import gaiasky.scene.record.AtmosphereComponent;
import gaiasky.scene.record.CloudComponent;
import gaiasky.scene.record.MaterialComponent;
import gaiasky.scene.record.ModelComponent;
import gaiasky.scene.record.NoiseComponent;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnImageButton;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnSelectBox;
import gaiasky.util.scene2d.OwnSliderPlus;
import gaiasky.util.scene2d.OwnTextButton;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.scene2d.OwnTextTooltip;
import gaiasky.util.scene2d.Separator;
import gaiasky.util.validator.FloatValidator;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import net.jafama.FastMath;

public class ProceduralGenerationWindow
extends GenericDialog
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(ProceduralGenerationWindow.class);
    private static int lastTabSelected = 0;
    private Entity target;
    private final FocusView view;
    private final Random rand;
    private MaterialComponent initMtc;
    private MaterialComponent mtc;
    private CloudComponent initClc;
    private CloudComponent clc;
    private AtmosphereComponent initAc;
    private AtmosphereComponent ac;
    private float fieldWidth;
    private float fieldWidthAll;
    private float fieldWidthTotal;
    private float textWidth;
    private boolean updateTabSelected = true;
    private OwnSliderPlus hueShift;
    private Texture currentLutTexture;
    private Cell<?> lutImageCell;
    private OwnTextButton genCloudsButton;
    private OwnTextButton genSurfaceButton;
    private boolean surfaceEnabled;
    private int genCloudNum = 0;
    private int genSurfaceNum = 0;

    public ProceduralGenerationWindow(FocusView target, Stage stage, Skin skin) {
        super(I18n.msg("gui.procedural.title", target.getLocalizedName()), skin, stage);
        this.target = target.getEntity();
        this.view = new FocusView(target.getEntity());
        this.initMtc = ((Model)Mapper.model.get((Entity)this.target)).model.mtc;
        this.initClc = ((Cloud)Mapper.cloud.get((Entity)this.target)).cloud;
        this.initAc = ((Atmosphere)Mapper.atmosphere.get((Entity)this.target)).atmosphere;
        this.rand = new Random(1884L);
        this.setModal(false);
        this.surfaceEnabled = this.initMtc.diffuseCubemap == null && this.initMtc.specularCubemap == null && this.initMtc.heightCubemap == null && this.initMtc.emissiveCubemap == null;
        EventManager.instance.subscribe((IObserver)this, Event.PROCEDURAL_GENERATION_CLOUD_INFO, Event.PROCEDURAL_GENERATION_SURFACE_INFO, Event.FOCUS_CHANGED);
        this.setAcceptText(I18n.msg("gui.close"));
        this.buildSuper();
    }

    private void reinitialize(Entity target) {
        this.target = target;
        this.view.setEntity(target);
        this.initMtc = ((Model)Mapper.model.get((Entity)this.target)).model.mtc;
        this.initClc = ((Cloud)Mapper.cloud.get((Entity)this.target)).cloud;
        this.initAc = ((Atmosphere)Mapper.atmosphere.get((Entity)this.target)).atmosphere;
        this.setModal(false);
        this.surfaceEnabled = this.initMtc.diffuseCubemap == null && this.initMtc.specularCubemap == null && this.initMtc.heightCubemap == null && this.initMtc.emissiveCubemap == null;
        this.getTitleLabel().setText((CharSequence)I18n.msg("gui.procedural.title", this.view.getLocalizedName()));
        this.rebuild();
    }

    protected void rebuild() {
        this.content.clear();
        this.build();
    }

    @Override
    protected void build() {
        this.textWidth = 220.0f;
        this.fieldWidth = 500.0f;
        this.fieldWidthAll = 750.0f;
        this.fieldWidthTotal = 950.0f;
        float tabContentWidth = 400.0f;
        float tabWidth = 240.0f;
        HorizontalGroup group = new HorizontalGroup();
        group.align(8);
        OwnTextButton tabSurface = new OwnTextButton(I18n.msg("gui.procedural.surface"), this.skin, "toggle-big");
        tabSurface.pad(pad10);
        tabSurface.setWidth(tabWidth);
        OwnTextButton tabClouds = new OwnTextButton(I18n.msg("gui.procedural.cloud"), this.skin, "toggle-big");
        tabClouds.pad(pad10);
        tabClouds.setWidth(tabWidth);
        OwnTextButton tabAtmosphere = new OwnTextButton(I18n.msg("gui.procedural.atmosphere"), this.skin, "toggle-big");
        tabAtmosphere.pad(pad10);
        tabAtmosphere.setWidth(tabWidth);
        if (this.surfaceEnabled) {
            group.addActor((Actor)tabSurface);
        }
        group.addActor((Actor)tabClouds);
        group.addActor((Actor)tabAtmosphere);
        this.content.add((Actor)group).left().row();
        Stack tabContent = new Stack();
        final Table contentSurface = new Table(this.skin);
        contentSurface.setWidth(tabContentWidth);
        contentSurface.align(10);
        this.buildContentSurface(contentSurface);
        Table contentClouds = new Table(this.skin);
        contentClouds.setWidth(tabContentWidth);
        contentClouds.align(10);
        this.buildContentClouds(contentClouds);
        Table contentAtmosphere = new Table(this.skin);
        contentAtmosphere.setWidth(tabContentWidth);
        contentAtmosphere.align(10);
        this.buildContentAtmosphere(contentAtmosphere);
        if (this.surfaceEnabled) {
            tabContent.addActor((Actor)contentSurface);
        }
        tabContent.addActor((Actor)contentClouds);
        tabContent.addActor((Actor)contentAtmosphere);
        this.content.add((Actor)tabContent).padTop(pad34).padBottom(pad34).expand().fill().row();
        ChangeListener tabListener = new ChangeListener(this, (Button)tabSurface, contentClouds, (Button)tabClouds, contentAtmosphere, (Button)tabAtmosphere){
            final /* synthetic */ Button val$tabSurface;
            final /* synthetic */ Table val$contentClouds;
            final /* synthetic */ Button val$tabClouds;
            final /* synthetic */ Table val$contentAtmosphere;
            final /* synthetic */ Button val$tabAtmosphere;
            final /* synthetic */ ProceduralGenerationWindow this$0;
            {
                this.val$tabSurface = button;
                this.val$contentClouds = table2;
                this.val$tabClouds = button2;
                this.val$contentAtmosphere = table3;
                this.val$tabAtmosphere = button3;
                this.this$0 = this$0;
            }

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                contentSurface.setVisible(this.val$tabSurface.isChecked());
                this.val$contentClouds.setVisible(this.val$tabClouds.isChecked());
                this.val$contentAtmosphere.setVisible(this.val$tabAtmosphere.isChecked());
                if (this.this$0.updateTabSelected) {
                    if (this.val$tabSurface.isChecked()) {
                        lastTabSelected = 0;
                    } else if (this.val$tabClouds.isChecked()) {
                        lastTabSelected = 1;
                    } else if (this.val$tabAtmosphere.isChecked()) {
                        lastTabSelected = 2;
                    }
                }
            }
        };
        tabSurface.addListener((EventListener)tabListener);
        tabClouds.addListener((EventListener)tabListener);
        tabAtmosphere.addListener((EventListener)tabListener);
        ButtonGroup tabs = new ButtonGroup();
        tabs.setMinCheckCount(1);
        tabs.setMaxCheckCount(1);
        this.updateTabSelected = false;
        tabs.add((Button)tabSurface);
        tabs.add((Button)tabClouds);
        tabs.add((Button)tabAtmosphere);
        this.updateTabSelected = true;
        tabs.setChecked(((TextButton)tabs.getButtons().get(lastTabSelected)).getText().toString());
        OwnTextButton randomize = new OwnTextButton(I18n.msg("gui.procedural.randomize", I18n.msg("gui.procedural.all")), this.skin, "big");
        randomize.setColor(ColorUtils.gYellowC);
        randomize.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ProceduralGenerationWindow.this.randomizeAll();
            }
        });
        randomize.pad(pad10, pad20, pad10, pad20);
        this.content.add((Actor)randomize).center().padBottom(pad34).row();
        final OwnSliderPlus pgResolution = new OwnSliderPlus(I18n.msg("gui.ui.procedural.resolution"), 400.0f, 6000.0f, 1.0f, this.skin);
        pgResolution.setValueLabelTransform(value -> value.intValue() * 2 + "x" + value.intValue());
        pgResolution.setWidth(this.fieldWidthTotal + 50.0f);
        pgResolution.setValue(Settings.settings.graphics.proceduralGenerationResolution[1]);
        pgResolution.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                int pgHeight = (int)pgResolution.getValue();
                int pgWidth = pgHeight * 2;
                EventManager.publish(Event.PROCEDURAL_GENERATION_RESOLUTION_CMD, (Object)this, pgWidth, pgHeight);
            }
        });
        this.content.add((Actor)pgResolution).right().padBottom(pad18).row();
        final OwnCheckBox saveTextures = new OwnCheckBox(I18n.msg("gui.procedural.savetextures"), this.skin, pad10);
        saveTextures.setChecked(Settings.settings.program.saveProceduralTextures);
        saveTextures.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                EventManager.publish(Event.PROCEDURAL_GENERATION_SAVE_TEXTURES_CMD, (Object)this, saveTextures.isChecked());
            }
        });
        OwnImageButton saveTexturesTooltip = new OwnImageButton(this.skin, "tooltip");
        saveTexturesTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.savetextures", SysUtils.getProceduralPixmapDir().toString()), this.skin));
        HorizontalGroup saveTexturesGroup = new HorizontalGroup();
        saveTexturesGroup.space(pad10);
        saveTexturesGroup.addActor((Actor)saveTextures);
        saveTexturesGroup.addActor((Actor)saveTexturesTooltip);
        this.content.add((Actor)saveTexturesGroup).left();
    }

    private void addLocalButtons(Table content, final Function<Boolean, Boolean> gasGiantFunc, final Function<Boolean, Boolean> earthLikeFunc, final Function<Boolean, Boolean> coldPlanetFunc, final Function<Boolean, Boolean> rockyPlanetFunc) {
        float w = 220.0f;
        OwnTextButton gasGiant = new OwnTextButton(I18n.msg("gui.procedural.button.gasgiant"), this.skin);
        gasGiant.setWidth(w);
        gasGiant.setColor(ColorUtils.gBlueC);
        gasGiant.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                gasGiantFunc.apply(true);
            }
        });
        gasGiant.pad(pad10, pad20, pad10, pad20);
        gasGiant.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.gasgiant"), this.skin));
        OwnTextButton earthLike = new OwnTextButton(I18n.msg("gui.procedural.button.earthlike"), this.skin);
        earthLike.setWidth(w);
        earthLike.setColor(ColorUtils.gBlueC);
        earthLike.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                earthLikeFunc.apply(true);
            }
        });
        earthLike.pad(pad10, pad20, pad10, pad20);
        earthLike.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.earthlike"), this.skin));
        OwnTextButton snowWorld = new OwnTextButton(I18n.msg("gui.procedural.button.snow"), this.skin);
        snowWorld.setWidth(w);
        snowWorld.setColor(ColorUtils.gBlueC);
        snowWorld.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                coldPlanetFunc.apply(true);
            }
        });
        snowWorld.pad(pad10, pad20, pad10, pad20);
        snowWorld.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.snow"), this.skin));
        OwnTextButton rockyPlanet = new OwnTextButton(I18n.msg("gui.procedural.button.rocky"), this.skin);
        rockyPlanet.setWidth(w);
        rockyPlanet.setColor(ColorUtils.gBlueC);
        rockyPlanet.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                rockyPlanetFunc.apply(true);
            }
        });
        rockyPlanet.pad(pad10, pad20, pad10, pad20);
        rockyPlanet.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.rocky"), this.skin));
        Table bt = new Table(this.skin);
        bt.add((Actor)earthLike).pad(5.0f);
        bt.add((Actor)snowWorld).pad(5.0f);
        bt.add((Actor)rockyPlanet).pad(5.0f);
        bt.add((Actor)gasGiant).pad(5.0f);
        HorizontalGroup buttonGroup = new HorizontalGroup();
        buttonGroup.space(pad20);
        buttonGroup.addActor((Actor)bt);
        content.add((Actor)buttonGroup).center().colspan(2).padBottom(pad34).row();
    }

    private OwnTextButton addLocalButtons(Table content, String key, final Function<Boolean, Boolean> generateFunc, final Function<Boolean, Boolean> randomizeFunc, int colspan) {
        String name = I18n.msg(key);
        OwnTextButton randomize = new OwnTextButton(I18n.msg("gui.procedural.randomize", name), this.skin);
        randomize.setColor(ColorUtils.gYellowC);
        randomize.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                randomizeFunc.apply(true);
            }
        });
        randomize.pad(pad10, pad20, pad10, pad20);
        randomize.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.button.randomize", name), this.skin));
        OwnTextButton generate = new OwnTextButton(I18n.msg("gui.procedural.generate", name), this.skin);
        generate.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                generateFunc.apply(true);
            }
        });
        generate.pad(pad10, pad20, pad10, pad20);
        generate.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.button.generate", name), this.skin));
        HorizontalGroup buttonGroup = new HorizontalGroup();
        buttonGroup.space(pad20);
        buttonGroup.addActor((Actor)generate);
        buttonGroup.addActor((Actor)randomize);
        content.add((Actor)buttonGroup).center().colspan(colspan).padBottom(pad18).row();
        return generate;
    }

    private void addNoiseGroup(Table content, final NoiseComponent nc) {
        float fieldWidthNoise = this.fieldWidthAll + 250.0f;
        Table noiseTable = new Table(this.skin);
        FloatValidator lv = new FloatValidator(-10000.0f, 10000.0f);
        final OwnTextField seedField = new OwnTextField(Float.toString(nc.seed), this.skin);
        seedField.setWidth(this.fieldWidth + 110.0f);
        seedField.setValidator(lv);
        seedField.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                nc.seed = seedField.getLongValue(1L);
            }
        });
        OwnLabel seedLabel = new OwnLabel((CharSequence)I18n.msg("gui.procedural.seed"), this.skin);
        seedLabel.setWidth(this.textWidth);
        OwnImageButton seedTooltip = new OwnImageButton(this.skin, "tooltip");
        seedTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.seed"), this.skin));
        noiseTable.add((Actor)seedLabel).left().padBottom(pad18).padRight(pad18);
        noiseTable.add((Actor)seedField).padBottom(pad18).padRight(pad10);
        noiseTable.add((Actor)seedTooltip).padBottom(pad18).row();
        final OwnSelectBox type = new OwnSelectBox(this.skin);
        type.setItems((Object[])NoiseFilter.NoiseType.values());
        type.setWidth(this.fieldWidth + 110.0f);
        type.setSelected((Object)nc.type);
        type.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                nc.type = (NoiseFilter.NoiseType)((Object)type.getSelected());
            }
        });
        OwnLabel typeLabel = new OwnLabel((CharSequence)I18n.msg("gui.procedural.type"), this.skin);
        typeLabel.setWidth(this.textWidth);
        OwnImageButton typeTooltip = new OwnImageButton(this.skin, "tooltip");
        typeTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.type"), this.skin));
        noiseTable.add((Actor)typeLabel).left().padBottom(pad18).padRight(pad18);
        noiseTable.add(type).padBottom(pad18).padRight(pad10);
        noiseTable.add((Actor)typeTooltip).padBottom(pad18).row();
        final OwnSliderPlus scaleX = new OwnSliderPlus(I18n.msg("gui.procedural.scale", "[x]"), 0.01f, 14.0f, 0.01f, this.skin);
        scaleX.setWidth(fieldWidthNoise / 3.0f - pad10 * 1.3f);
        scaleX.setValue((float)nc.scale[0]);
        scaleX.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                nc.scale[0] = scaleX.getMappedValue();
            }
        });
        final OwnSliderPlus scaleY = new OwnSliderPlus(I18n.msg("gui.procedural.scale", "[y]"), 0.01f, 14.0f, 0.01f, this.skin);
        scaleY.setWidth(fieldWidthNoise / 3.0f - pad10 * 1.3f);
        scaleY.setValue((float)nc.scale[1]);
        scaleY.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                nc.scale[1] = scaleY.getMappedValue();
            }
        });
        final OwnSliderPlus scaleZ = new OwnSliderPlus(I18n.msg("gui.procedural.scale", "[z]"), 0.01f, 14.0f, 0.01f, this.skin);
        scaleZ.setWidth(fieldWidthNoise / 3.0f - pad10 * 1.3f);
        scaleZ.setValue((float)nc.scale[2]);
        scaleZ.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                nc.scale[2] = scaleZ.getMappedValue();
            }
        });
        HorizontalGroup scaleGroup = new HorizontalGroup();
        scaleGroup.space(pad10 * 2.0f);
        scaleGroup.addActor((Actor)scaleX);
        scaleGroup.addActor((Actor)scaleY);
        scaleGroup.addActor((Actor)scaleZ);
        OwnImageButton scaleTooltip = new OwnImageButton(this.skin, "tooltip");
        scaleTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.scale"), this.skin));
        noiseTable.add((Actor)scaleGroup).colspan(2).left().padBottom(pad18).padRight(pad10);
        noiseTable.add((Actor)scaleTooltip).left().padBottom(pad18).row();
        final OwnSliderPlus amplitude = new OwnSliderPlus(I18n.msg("gui.procedural.amplitude"), 0.1f, 3.0f, 0.01f, this.skin);
        amplitude.setWidth(fieldWidthNoise);
        amplitude.setValue((float)nc.amplitude);
        amplitude.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                nc.amplitude = amplitude.getMappedValue();
            }
        });
        OwnImageButton amplitudeTooltip = new OwnImageButton(this.skin, "tooltip");
        amplitudeTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.amplitude"), this.skin));
        noiseTable.add((Actor)amplitude).colspan(2).left().padBottom(pad18).padRight(pad10);
        noiseTable.add((Actor)amplitudeTooltip).left().padBottom(pad18).row();
        final OwnSliderPlus persistence = new OwnSliderPlus(I18n.msg("gui.procedural.persistence"), 0.01f, 0.9f, 0.01f, this.skin);
        persistence.setWidth(fieldWidthNoise);
        persistence.setValue((float)nc.persistence);
        persistence.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                nc.persistence = persistence.getMappedValue();
            }
        });
        OwnImageButton persistenceTooltip = new OwnImageButton(this.skin, "tooltip");
        persistenceTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.persistence"), this.skin));
        noiseTable.add((Actor)persistence).colspan(2).left().padBottom(pad18).padRight(pad10);
        noiseTable.add((Actor)persistenceTooltip).left().padBottom(pad18).row();
        final OwnSliderPlus frequency = new OwnSliderPlus(I18n.msg("gui.procedural.frequency"), 0.01f, 3.0f, 0.01f, this.skin);
        frequency.setWidth(fieldWidthNoise);
        frequency.setValue((float)nc.frequency);
        frequency.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                nc.frequency = frequency.getMappedValue();
            }
        });
        OwnImageButton frequencyTooltip = new OwnImageButton(this.skin, "tooltip");
        frequencyTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.frequency"), this.skin));
        noiseTable.add((Actor)frequency).colspan(2).left().padBottom(pad18).padRight(pad10);
        noiseTable.add((Actor)frequencyTooltip).left().padBottom(pad18).row();
        final OwnSliderPlus lacunarity = new OwnSliderPlus(I18n.msg("gui.procedural.lacunarity"), 0.1f, 5.0f, 0.1f, this.skin);
        lacunarity.setWidth(fieldWidthNoise);
        lacunarity.setValue((float)nc.lacunarity);
        lacunarity.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                nc.lacunarity = lacunarity.getMappedValue();
            }
        });
        OwnImageButton lacunarityTooltip = new OwnImageButton(this.skin, "tooltip");
        lacunarityTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.lacunarity"), this.skin));
        noiseTable.add((Actor)lacunarity).colspan(2).left().padBottom(pad18).padRight(pad10);
        noiseTable.add((Actor)lacunarityTooltip).left().padBottom(pad18).row();
        final OwnSliderPlus octaves = new OwnSliderPlus(I18n.msg("gui.procedural.octaves"), 1.0f, 8.0f, 1.0f, this.skin);
        octaves.setWidth(fieldWidthNoise);
        octaves.setValue(nc.octaves);
        octaves.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                nc.octaves = (int)octaves.getMappedValue();
            }
        });
        OwnImageButton octavesTooltip = new OwnImageButton(this.skin, "tooltip");
        octavesTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.octaves"), this.skin));
        noiseTable.add((Actor)octaves).colspan(2).left().padBottom(pad18).padRight(pad10);
        noiseTable.add((Actor)octavesTooltip).left().padBottom(pad18).row();
        final OwnSliderPlus terraces = new OwnSliderPlus(I18n.msg("gui.procedural.terraces"), 0.0f, 8.0f, 1.0f, this.skin);
        terraces.setWidth(fieldWidthNoise);
        terraces.setValue(nc.numTerraces);
        terraces.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                nc.numTerraces = (int)terraces.getMappedValue();
            }
        });
        OwnImageButton terracesTooltip = new OwnImageButton(this.skin, "tooltip");
        terracesTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.terraces"), this.skin));
        noiseTable.add((Actor)terraces).colspan(2).left().padBottom(pad18).padRight(pad10);
        noiseTable.add((Actor)terracesTooltip).left().padBottom(pad18).row();
        final OwnSliderPlus terracesExp = new OwnSliderPlus(I18n.msg("gui.procedural.terraces.exp"), 1.0f, 13.0f, 1.0f, this.skin);
        terracesExp.setWidth(fieldWidthNoise);
        terracesExp.setValue(nc.terracesExp);
        terracesExp.setValueLabelTransform(value -> String.valueOf((double)value.floatValue() * 2.0 - 1.0));
        terracesExp.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                nc.terracesExp = terracesExp.getMappedValue() * 2.0f - 1.0f;
            }
        });
        OwnImageButton terracesExpTooltip = new OwnImageButton(this.skin, "tooltip");
        terracesExpTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.terraces.exp"), this.skin));
        noiseTable.add((Actor)terracesExp).colspan(2).left().padBottom(pad18).padRight(pad10);
        noiseTable.add((Actor)terracesExpTooltip).left().padBottom(pad18).row();
        final OwnSliderPlus rangeMin = new OwnSliderPlus(I18n.msg("gui.procedural.range", "[min]"), -2.0f, 0.0f, 0.1f, this.skin);
        rangeMin.setWidth(fieldWidthNoise / 2.0f - pad10);
        rangeMin.setValue((float)nc.range[0]);
        rangeMin.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                nc.range[0] = rangeMin.getMappedValue();
            }
        });
        final OwnSliderPlus rangeMax = new OwnSliderPlus(I18n.msg("gui.procedural.range", "[max]"), 0.5f, 2.0f, 0.1f, this.skin);
        rangeMax.setWidth(fieldWidthNoise / 2.0f - pad10);
        rangeMax.setValue((float)nc.range[1]);
        rangeMax.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                nc.range[1] = rangeMax.getMappedValue();
            }
        });
        HorizontalGroup rangeGroup = new HorizontalGroup();
        rangeGroup.space(pad10 * 2.0f);
        rangeGroup.addActor((Actor)rangeMin);
        rangeGroup.addActor((Actor)rangeMax);
        OwnImageButton rangeTooltip = new OwnImageButton(this.skin, "tooltip");
        rangeTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.range"), this.skin));
        noiseTable.add((Actor)rangeGroup).colspan(2).left().padBottom(pad18).padRight(pad10);
        noiseTable.add((Actor)rangeTooltip).left().padBottom(pad18).row();
        final OwnSliderPlus power = new OwnSliderPlus(I18n.msg("gui.procedural.power"), 0.1f, 8.0f, 0.1f, this.skin);
        power.setWidth(fieldWidthNoise);
        power.setValue((float)nc.power);
        power.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                nc.power = power.getMappedValue();
            }
        });
        OwnImageButton powerTooltip = new OwnImageButton(this.skin, "tooltip");
        powerTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.power"), this.skin));
        noiseTable.add((Actor)power).colspan(2).left().padBottom(pad18).padRight(pad10);
        noiseTable.add((Actor)powerTooltip).left().padBottom(pad18).row();
        final OwnCheckBox turbulence = new OwnCheckBox(I18n.msg("gui.procedural.turbulence"), this.skin, pad10);
        final OwnCheckBox ridge = new OwnCheckBox(I18n.msg("gui.procedural.ridge"), this.skin, pad10);
        turbulence.setChecked(nc.turbulence);
        turbulence.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                nc.turbulence = turbulence.isChecked();
                if (!nc.turbulence) {
                    nc.ridge = false;
                    ridge.setProgrammaticChangeEvents(false);
                    ridge.setChecked(false);
                    ridge.setProgrammaticChangeEvents(true);
                }
            }
        });
        OwnImageButton turbulenceTooltip = new OwnImageButton(this.skin, "tooltip");
        turbulenceTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.turbulence"), this.skin));
        noiseTable.add((Actor)turbulence).colspan(2).left().padBottom(pad18).padRight(pad10);
        noiseTable.add((Actor)turbulenceTooltip).left().padBottom(pad18).row();
        ridge.setChecked(nc.ridge);
        ridge.addListener((EventListener)new ChangeListener(this){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                nc.ridge = ridge.isChecked();
                if (nc.ridge) {
                    nc.turbulence = true;
                    turbulence.setProgrammaticChangeEvents(false);
                    turbulence.setChecked(true);
                    turbulence.setProgrammaticChangeEvents(true);
                }
            }
        });
        OwnImageButton ridgeTooltip = new OwnImageButton(this.skin, "tooltip");
        ridgeTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.ridge"), this.skin));
        noiseTable.add((Actor)ridge).colspan(2).left().padBottom(pad18).padRight(pad10);
        noiseTable.add((Actor)ridgeTooltip).left().padBottom(pad18).row();
        content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.procedural.noise.params"), this.skin, "hud-header")).left().padBottom(pad34).row();
        content.add((Actor)noiseTable).colspan(3).center().padBottom(pad34).row();
    }

    private void updateLutImage(Array<String> luts) {
        if (this.lutImageCell != null) {
            this.lutImageCell.clearActor();
            Pixmap p = new Pixmap(Settings.settings.data.dataFileHandle((String)luts.get(luts.indexOf((Object)this.mtc.biomeLUT, false))));
            int w = p.getWidth();
            int h = p.getHeight();
            if (this.hueShift != null) {
                float hue = this.hueShift.getMappedValue();
                for (int x = 0; x < w; ++x) {
                    for (int y = 0; y < h; ++y) {
                        Color col = new Color(p.getPixel(x, y));
                        float[] rgb = new float[]{col.r, col.g, col.b, 1.0f};
                        if (hue != 0.0f) {
                            float[] hsb = ColorUtils.rgbToHsb(rgb);
                            hsb[0] = (hsb[0] * 360.0f + hue) % 360.0f / 360.0f;
                            rgb = ColorUtils.hsbToRgb(hsb);
                        }
                        col.set(rgb[0], rgb[1], rgb[2], 1.0f);
                        p.drawPixel(x, y, Color.rgba8888((Color)col));
                    }
                }
            }
            Texture newLutTexture = new Texture(p);
            newLutTexture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            Image img = new Image(newLutTexture);
            img.setScaling(Scaling.fill);
            this.lutImageCell.setActor((Actor)img);
            this.lutImageCell.size(260.0f, 260.0f);
            if (this.currentLutTexture != null) {
                this.currentLutTexture.dispose();
            }
            this.currentLutTexture = newLutTexture;
            p.dispose();
        }
    }

    private void buildContentSurface(Table content) {
        ModelComponent mc = ((Model)Mapper.model.get((Entity)this.target)).model;
        if (mc != null) {
            this.mtc = new MaterialComponent();
            if (this.initMtc == null) {
                this.mtc.randomizeAll(this.rand.nextLong());
            } else {
                this.mtc.copyFrom(this.initMtc);
            }
            content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.procedural.param.surface"), this.skin, "hud-header")).colspan(2).left().padBottom(pad34).row();
            this.addLocalButtons(content, this::randomizeSurfaceGasGiant, this::randomizeSurfaceEarthLike, this::randomizeSurfaceColdPlanet, this::randomizeSurfaceRockyPlanet);
            this.genSurfaceButton = this.addLocalButtons(content, "gui.procedural.surface", this::generateSurface, this::randomizeSurface, 2);
            content.add((Actor)new Separator(this.skin, "gray")).center().colspan(2).growX().padBottom(pad10).padTop(pad18).row();
            Table scrollContent = new Table(this.skin);
            Path dataPath = Settings.settings.data.dataPath("default-data/tex/lut");
            final Array lookUpTables = new Array();
            try (Stream<Path> stream2 = Files.list(dataPath);){
                List<Path> l = stream2.filter(f -> f.toString().endsWith("-lut.png") || f.toString().endsWith("-lut.jpg")).toList();
                for (Path p : l) {
                    String name = p.toString();
                    lookUpTables.add((Object)("$data/" + name.substring(name.indexOf("default-data/tex/lut/"))));
                }
            }
            catch (Exception stream2) {
                // empty catch block
            }
            if (lookUpTables.isEmpty()) {
                lookUpTables.add((Object)"$data/default-data/tex/lut/biome-lut.png");
                lookUpTables.add((Object)"$data/default-data/tex/lut/biome-smooth-lut.png");
            }
            final OwnSelectBox lookUpTablesBox = new OwnSelectBox(this.skin);
            lookUpTablesBox.setItems(lookUpTables);
            lookUpTablesBox.setWidth(this.fieldWidth + 80.0f);
            lookUpTablesBox.setSelected(this.mtc.biomeLUT);
            lookUpTablesBox.addListener((EventListener)new ChangeListener(this){
                final /* synthetic */ ProceduralGenerationWindow this$0;
                {
                    this.this$0 = this$0;
                }

                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    this.this$0.mtc.biomeLUT = (String)lookUpTablesBox.getSelected();
                    this.this$0.updateLutImage((Array<String>)lookUpTables);
                }
            });
            OwnLabel lookUpTablesLabel = new OwnLabel((CharSequence)I18n.msg("gui.procedural.lut"), this.skin);
            lookUpTablesLabel.setWidth(this.textWidth);
            OwnImageButton lutTooltip = new OwnImageButton(this.skin, "tooltip");
            lutTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.lut"), this.skin));
            scrollContent.add((Actor)lookUpTablesLabel).left().padBottom(pad18).padRight(pad18);
            scrollContent.add(lookUpTablesBox).left().padBottom(pad18).padRight(pad10);
            scrollContent.add((Actor)lutTooltip).left().padBottom(pad18).row();
            this.lutImageCell = scrollContent.add();
            this.lutImageCell.colspan(3).padBottom(pad18).row();
            this.hueShift = new OwnSliderPlus(I18n.msg("gui.procedural.hueshift"), 0.0f, 360.0f, 0.1f, this.skin);
            this.hueShift.setWidth(this.fieldWidthTotal - 100.0f);
            this.hueShift.setValueSuffix("\u00b0");
            this.hueShift.setValue(this.mtc.biomeHueShift);
            this.hueShift.addListener((EventListener)new ChangeListener(this){
                final /* synthetic */ ProceduralGenerationWindow this$0;
                {
                    this.this$0 = this$0;
                }

                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    this.this$0.mtc.biomeHueShift = this.this$0.hueShift.getMappedValue();
                    this.this$0.updateLutImage((Array<String>)lookUpTables);
                }
            });
            OwnImageButton hueShiftTooltip = new OwnImageButton(this.skin, "tooltip");
            hueShiftTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.hueshift"), this.skin));
            scrollContent.add((Actor)this.hueShift).colspan(2).left().padBottom(pad34).padRight(pad10);
            scrollContent.add((Actor)hueShiftTooltip).left().padBottom(pad34).row();
            this.updateLutImage((Array<String>)lookUpTables);
            final OwnSliderPlus heightScale = new OwnSliderPlus(I18n.msg("gui.procedural.heightscale"), 1.0f, 80.0f, 0.1f, this.skin);
            heightScale.setWidth(this.fieldWidthTotal - 100.0f);
            heightScale.setValueSuffix(" km");
            heightScale.setValue((float)((double)this.mtc.heightScale.floatValue() * Constants.U_TO_KM));
            heightScale.addListener((EventListener)new ChangeListener(this){
                final /* synthetic */ ProceduralGenerationWindow this$0;
                {
                    this.this$0 = this$0;
                }

                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    this.this$0.mtc.heightScale = Float.valueOf((float)((double)heightScale.getMappedValue() * Constants.KM_TO_U));
                }
            });
            OwnImageButton heightScaleTooltip = new OwnImageButton(this.skin, "tooltip");
            heightScaleTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.heightscale"), this.skin));
            scrollContent.add((Actor)heightScale).colspan(2).left().padBottom(pad34).padRight(pad10);
            scrollContent.add((Actor)heightScaleTooltip).left().padBottom(pad34).row();
            final OwnCheckBox emission = new OwnCheckBox(I18n.msg("gui.procedural.emission"), this.skin, pad10);
            emission.setChecked(this.mtc.nc.genEmissiveMap);
            emission.addListener((EventListener)new ChangeListener(this){
                final /* synthetic */ ProceduralGenerationWindow this$0;
                {
                    this.this$0 = this$0;
                }

                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    this.this$0.mtc.nc.genEmissiveMap = emission.isChecked();
                }
            });
            OwnImageButton emissionTooltip = new OwnImageButton(this.skin, "tooltip");
            emissionTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.emission"), this.skin));
            scrollContent.add((Actor)emission).colspan(2).left().padBottom(pad34).padRight(pad10);
            scrollContent.add((Actor)emissionTooltip).left().padBottom(pad34).row();
            this.addNoiseGroup(scrollContent, this.mtc.nc);
            ScrollPane scrollPane = this.scrollPane((Actor)scrollContent, 600.0f);
            content.add((Actor)scrollPane).colspan(2).center().top().row();
            content.add((Actor)new Separator(this.skin, "gray")).center().colspan(2).growX().padBottom(pad34).padTop(pad10).row();
        } else {
            OwnLabel l = new OwnLabel((CharSequence)I18n.msg("gui.procedural.nomodel", this.view.getName()), this.skin);
            content.add((Actor)l).pad(pad34).center();
        }
    }

    private void buildContentClouds(Table content) {
        this.clc = new CloudComponent();
        if (this.initClc == null) {
            this.clc.randomizeAll(this.rand.nextLong(), this.view.getSize());
        } else {
            this.clc.copyFrom(this.initClc);
            this.clc.setDiffuse("generate");
        }
        content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.procedural.param.cloud"), this.skin, "hud-header")).colspan(2).left().padBottom(pad34).row();
        this.genCloudsButton = this.addLocalButtons(content, "gui.procedural.cloud", this::generateClouds, this::randomizeClouds, 2);
        content.add((Actor)new Separator(this.skin, "gray")).center().colspan(2).growX().padBottom(pad34).padTop(pad18).row();
        Table scrollContent = new Table(this.skin);
        ColorPicker cloudColor = new ColorPicker(new float[]{this.clc.color[0], this.clc.color[1], this.clc.color[2], this.clc.color[3]}, this.stage, this.skin);
        cloudColor.setSize(128.0f, 128.0f);
        cloudColor.setNewColorRunnable(() -> {
            float[] col = cloudColor.getPickedColor();
            this.clc.color[0] = col[0];
            this.clc.color[1] = col[1];
            this.clc.color[2] = col[2];
            this.clc.color[3] = col[3];
        });
        OwnLabel cloudColorLabel = new OwnLabel((CharSequence)I18n.msg("gui.procedural.cloudcolor"), this.skin);
        cloudColorLabel.setWidth(this.textWidth);
        OwnImageButton cloudColorTooltip = new OwnImageButton(this.skin, "tooltip");
        cloudColorTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.cloudcolor"), this.skin));
        HorizontalGroup cloudGroup = new HorizontalGroup();
        cloudGroup.space(pad20);
        cloudGroup.addActor((Actor)cloudColor);
        cloudGroup.addActor((Actor)cloudColorTooltip);
        scrollContent.add((Actor)cloudColorLabel).left().padRight(pad18).padBottom(pad18);
        scrollContent.add((Actor)cloudGroup).left().expandX().padBottom(pad18).padRight(pad10).row();
        this.addNoiseGroup(scrollContent, this.clc.nc);
        ScrollPane scrollPane = this.scrollPane((Actor)scrollContent, 600.0f);
        content.add((Actor)scrollPane).colspan(2).center().top().row();
        content.add((Actor)new Separator(this.skin, "gray")).center().colspan(2).growX().padBottom(pad34).row();
    }

    private void buildContentAtmosphere(Table content) {
        this.ac = new AtmosphereComponent();
        if (this.initAc == null) {
            this.ac.randomizeAll(this.rand.nextLong(), this.view.getRadius());
        } else {
            this.ac.copyFrom(this.initAc);
        }
        content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.procedural.param.atm"), this.skin, "hud-header")).colspan(3).left().padBottom(pad34).row();
        this.addLocalButtons(content, "gui.procedural.atmosphere", this::generateAtmosphere, this::randomizeAtmosphere, 3);
        content.add((Actor)new Separator(this.skin, "gray")).center().colspan(3).growX().padBottom(pad34).padTop(pad18).row();
        final OwnSliderPlus wavelength0 = new OwnSliderPlus(I18n.msg("gui.procedural.wavelength", "0"), 0.4f, 1.0f, 0.01f, this.skin);
        wavelength0.setWidth(this.fieldWidthTotal / 3.0f - pad10 * 1.3f);
        wavelength0.setValue((float)this.ac.wavelengths[0]);
        wavelength0.addListener((EventListener)new ChangeListener(this){
            final /* synthetic */ ProceduralGenerationWindow this$0;
            {
                this.this$0 = this$0;
            }

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                this.this$0.ac.wavelengths[0] = wavelength0.getMappedValue();
            }
        });
        final OwnSliderPlus wavelength1 = new OwnSliderPlus(I18n.msg("gui.procedural.wavelength", "1"), 0.4f, 1.0f, 0.01f, this.skin);
        wavelength1.setWidth(this.fieldWidthTotal / 3.0f - pad10 * 1.3f);
        wavelength1.setValue((float)this.ac.wavelengths[1]);
        wavelength1.addListener((EventListener)new ChangeListener(this){
            final /* synthetic */ ProceduralGenerationWindow this$0;
            {
                this.this$0 = this$0;
            }

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                this.this$0.ac.wavelengths[1] = wavelength1.getMappedValue();
            }
        });
        final OwnSliderPlus wavelength2 = new OwnSliderPlus(I18n.msg("gui.procedural.wavelength", "2"), 0.4f, 1.0f, 0.01f, this.skin);
        wavelength2.setWidth(this.fieldWidthTotal / 3.0f - pad10 * 1.3f);
        wavelength2.setValue((float)this.ac.wavelengths[1]);
        wavelength2.addListener((EventListener)new ChangeListener(this){
            final /* synthetic */ ProceduralGenerationWindow this$0;
            {
                this.this$0 = this$0;
            }

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                this.this$0.ac.wavelengths[2] = wavelength2.getMappedValue();
            }
        });
        HorizontalGroup wavelengthGroup = new HorizontalGroup();
        wavelengthGroup.space(pad10 * 2.0f);
        wavelengthGroup.addActor((Actor)wavelength0);
        wavelengthGroup.addActor((Actor)wavelength1);
        wavelengthGroup.addActor((Actor)wavelength2);
        OwnImageButton wavelengthTooltip = new OwnImageButton(this.skin, "tooltip");
        wavelengthTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.wavelength"), this.skin));
        content.add((Actor)wavelengthGroup).left().padBottom(pad18).padRight(pad10);
        content.add((Actor)wavelengthTooltip).left().padBottom(pad18).row();
        final OwnSliderPlus eSun = new OwnSliderPlus(I18n.msg("gui.procedural.esun"), -1.0f, 25.0f, 0.1f, this.skin);
        eSun.setWidth(this.fieldWidthTotal);
        eSun.setValue(this.ac.m_eSun);
        eSun.addListener((EventListener)new ChangeListener(this){
            final /* synthetic */ ProceduralGenerationWindow this$0;
            {
                this.this$0 = this$0;
            }

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                this.this$0.ac.m_eSun = eSun.getMappedValue();
            }
        });
        OwnImageButton esunTooltip = new OwnImageButton(this.skin, "tooltip");
        esunTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.esun"), this.skin));
        content.add((Actor)eSun).left().padBottom(pad18).padRight(pad10);
        content.add((Actor)esunTooltip).left().padBottom(pad18).row();
        DecimalFormat nf = new DecimalFormat("#0.0000##");
        final OwnSliderPlus kr = new OwnSliderPlus(I18n.msg("gui.procedural.kr"), 0.0f, 0.01f, 1.0E-4f, this.skin);
        kr.setWidth(this.fieldWidthTotal);
        kr.setNumberFormatter(nf);
        kr.setValue(this.ac.m_Kr);
        kr.addListener((EventListener)new ChangeListener(this){
            final /* synthetic */ ProceduralGenerationWindow this$0;
            {
                this.this$0 = this$0;
            }

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                this.this$0.ac.m_Kr = kr.getMappedValue();
            }
        });
        OwnImageButton krTooltip = new OwnImageButton(this.skin, "tooltip");
        krTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.kr"), this.skin));
        content.add((Actor)kr).left().padBottom(pad18).padRight(pad10);
        content.add((Actor)krTooltip).left().padBottom(pad18).row();
        final OwnSliderPlus km = new OwnSliderPlus(I18n.msg("gui.procedural.km"), 0.0f, 0.01f, 1.0E-4f, this.skin);
        km.setWidth(this.fieldWidthTotal);
        km.setNumberFormatter(nf);
        km.setValue(this.ac.m_Km);
        km.addListener((EventListener)new ChangeListener(this){
            final /* synthetic */ ProceduralGenerationWindow this$0;
            {
                this.this$0 = this$0;
            }

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                this.this$0.ac.m_Km = km.getMappedValue();
            }
        });
        OwnImageButton kmTooltip = new OwnImageButton(this.skin, "tooltip");
        kmTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.km"), this.skin));
        content.add((Actor)km).left().padBottom(pad18).padRight(pad10);
        content.add((Actor)kmTooltip).left().padBottom(pad18).row();
        final OwnSliderPlus fogDensity = new OwnSliderPlus(I18n.msg("gui.procedural.fogdensity"), 0.01f, 3.5f, 0.01f, this.skin);
        fogDensity.setWidth(this.fieldWidthTotal);
        fogDensity.setValue(this.ac.fogDensity);
        fogDensity.addListener((EventListener)new ChangeListener(this){
            final /* synthetic */ ProceduralGenerationWindow this$0;
            {
                this.this$0 = this$0;
            }

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                this.this$0.ac.fogDensity = fogDensity.getMappedValue();
            }
        });
        OwnImageButton fogDensityTooltip = new OwnImageButton(this.skin, "tooltip");
        fogDensityTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.fogdensity"), this.skin));
        content.add((Actor)fogDensity).left().padBottom(pad18).padRight(pad10);
        content.add((Actor)fogDensityTooltip).left().padBottom(pad18).row();
        final OwnSliderPlus samples = new OwnSliderPlus(I18n.msg("gui.procedural.samples"), 2.0f, 50.0f, 1.0f, this.skin);
        samples.setWidth(this.fieldWidthTotal);
        samples.setValue(this.ac.samples);
        samples.addListener((EventListener)new ChangeListener(this){
            final /* synthetic */ ProceduralGenerationWindow this$0;
            {
                this.this$0 = this$0;
            }

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                this.this$0.ac.samples = (int)samples.getValue();
            }
        });
        OwnImageButton samplesTooltip = new OwnImageButton(this.skin, "tooltip");
        samplesTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.samples"), this.skin));
        content.add((Actor)samples).left().padBottom(pad18).padRight(pad10);
        content.add((Actor)samplesTooltip).left().padBottom(pad18).row();
        ColorPicker fogColor = new ColorPicker(new float[]{this.ac.fogColor.x, this.ac.fogColor.y, this.ac.fogColor.z, 1.0f}, this.stage, this.skin);
        fogColor.setNewColorRunnable(() -> {
            float[] col = fogColor.getPickedColor();
            this.ac.fogColor.x = col[0];
            this.ac.fogColor.y = col[1];
            this.ac.fogColor.z = col[2];
        });
        OwnLabel fogColorLabel = new OwnLabel((CharSequence)I18n.msg("gui.procedural.fogcolor"), this.skin);
        fogColorLabel.setWidth(this.textWidth);
        OwnImageButton fogColorTooltip = new OwnImageButton(this.skin, "tooltip");
        fogColorTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.procedural.info.fogcolor"), this.skin));
        HorizontalGroup fogColorGroup = new HorizontalGroup();
        fogColorGroup.space(pad18);
        fogColorGroup.addActor((Actor)fogColorLabel);
        fogColorGroup.addActor((Actor)fogColor);
        fogColorGroup.addActor((Actor)fogColorTooltip);
        content.add((Actor)fogColorGroup).left().padBottom(pad18).row();
        content.add((Actor)new Separator(this.skin, "gray")).center().colspan(3).growX().padTop(pad34).row();
    }

    protected Boolean randomizeSurface(Boolean rebuild) {
        this.initMtc = new MaterialComponent();
        switch (this.rand.nextInt(10)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.initMtc.randomizeEarthLike(this.rand.nextLong());
                break;
            }
            case 4: {
                this.initMtc.randomizeRockyPlanet(this.rand.nextLong());
                break;
            }
            case 5: 
            case 6: {
                this.initMtc.randomizeGasGiant(this.rand.nextLong());
                break;
            }
            case 7: 
            case 8: {
                this.initMtc.randomizeColdPlanet(this.rand.nextLong());
                break;
            }
            case 9: {
                this.initMtc.randomizeAll(this.rand.nextLong());
            }
        }
        if (rebuild.booleanValue()) {
            this.initClc = this.clc;
            this.initAc = this.ac;
            this.rebuild();
        }
        return this.generateSurface(false);
    }

    protected Boolean randomizeSurfaceGasGiant(Boolean rebuild) {
        this.initMtc = new MaterialComponent();
        this.initMtc.randomizeGasGiant(this.rand.nextLong());
        if (rebuild.booleanValue()) {
            this.initClc = this.clc;
            this.initAc = this.ac;
            this.rebuild();
        }
        return this.generateSurface(false);
    }

    protected Boolean randomizeSurfaceEarthLike(Boolean rebuild) {
        this.initMtc = new MaterialComponent();
        this.initMtc.randomizeEarthLike(this.rand.nextLong());
        if (rebuild.booleanValue()) {
            this.initClc = this.clc;
            this.initAc = this.ac;
            this.rebuild();
        }
        return this.generateSurface(false);
    }

    protected Boolean randomizeSurfaceColdPlanet(Boolean rebuild) {
        this.initMtc = new MaterialComponent();
        this.initMtc.randomizeColdPlanet(this.rand.nextLong());
        if (rebuild.booleanValue()) {
            this.initClc = this.clc;
            this.initAc = this.ac;
            this.rebuild();
        }
        return this.generateSurface(false);
    }

    protected Boolean randomizeSurfaceRockyPlanet(Boolean rebuild) {
        this.initMtc = new MaterialComponent();
        this.initMtc.randomizeRockyPlanet(this.rand.nextLong());
        if (rebuild.booleanValue()) {
            this.initClc = this.clc;
            this.initAc = this.ac;
            this.rebuild();
        }
        return this.generateSurface(false);
    }

    protected Boolean randomizeClouds(Boolean rebuild) {
        this.initClc = new CloudComponent();
        this.initClc.randomizeAll(this.rand.nextLong(), this.view.getSize());
        if (rebuild.booleanValue()) {
            this.initMtc = this.mtc;
            this.initAc = this.ac;
            this.rebuild();
        }
        return this.generateClouds(false);
    }

    protected Boolean randomizeAtmosphere(Boolean rebuild) {
        this.initAc = new AtmosphereComponent();
        this.initAc.randomizeAll(this.rand.nextLong(), this.view.getRadius());
        if (rebuild.booleanValue()) {
            this.initMtc = this.mtc;
            this.initClc = this.clc;
            this.rebuild();
        }
        return this.generateAtmosphere(false);
    }

    protected void randomizeAll() {
        this.randomizeSurface(false);
        this.randomizeClouds(false);
        this.randomizeAtmosphere(false);
        this.rebuild();
    }

    protected Boolean generateSurface(Boolean ignored) {
        GaiaSky.postRunnable(this::generateSurfaceDirect);
        return ignored;
    }

    protected void generateSurfaceDirect() {
        if (this.genSurfaceNum == 0) {
            Model model = (Model)Mapper.model.get(this.target);
            MaterialComponent materialComponent = model.model.mtc;
            if (materialComponent != null) {
                materialComponent.disposeTextures(GaiaSky.instance.assetManager);
                materialComponent.disposeNoiseBuffers();
            }
            this.mtc.initialize(this.view.getName());
            model.model.setMaterial(this.mtc);
        } else {
            logger.info(I18n.msg("gui.procedural.error.gen", I18n.msg("gui.procedural.surface")));
        }
    }

    protected Boolean generateClouds(Boolean ignored) {
        GaiaSky.postRunnable(this::generateCloudsDirect);
        return ignored;
    }

    protected void generateCloudsDirect() {
        if (this.genCloudNum == 0) {
            Cloud cloud = (Cloud)Mapper.cloud.get(this.target);
            CloudComponent cloudComponent = cloud.cloud;
            if (cloudComponent != null) {
                cloudComponent.disposeTextures(GaiaSky.instance.assetManager);
                cloudComponent.disposeNoiseBuffers();
            }
            this.clc.initialize(this.view.getName(), false);
            cloud.cloud = this.clc;
            cloud.cloud.doneLoading(GaiaSky.instance.assetManager);
        } else {
            logger.info(I18n.msg("gui.procedural.error.gen", I18n.msg("gui.procedural.cloud")));
        }
    }

    protected Boolean generateAtmosphere(Boolean ignored) {
        GaiaSky.postRunnable(this::generateAtmosphereDirect);
        return ignored;
    }

    protected void generateAtmosphereDirect() {
        Atmosphere atm = (Atmosphere)Mapper.atmosphere.get(this.target);
        Model model = (Model)Mapper.model.get(this.target);
        atm.atmosphere = this.ac;
        atm.atmosphere.doneLoading((Material)model.model.instance.materials.first(), (float)this.view.getSize());
    }

    protected void generateAll() {
        GaiaSky.postRunnable(() -> {
            this.generateSurfaceDirect();
            this.generateCloudsDirect();
            this.generateAtmosphereDirect();
        });
    }

    @Override
    protected boolean accept() {
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    protected void enableComponents(boolean enabled, Disableable ... components) {
        for (Disableable c : components) {
            if (c == null) continue;
            c.setDisabled(!enabled);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setKeyboardFocus() {
        this.stage.setKeyboardFocus(null);
    }

    private void updateButtonStatus() {
        this.genCloudsButton.setDisabled(this.genCloudNum > 0);
        this.genSurfaceButton.setDisabled(this.genSurfaceNum > 0);
    }

    private ScrollPane scrollPane(Actor actor, float height) {
        OwnScrollPane scroll = new OwnScrollPane(actor, this.skin, "minimalist-nobg");
        scroll.setWidth(this.fieldWidthTotal + 100.0f);
        scroll.setHeight(height);
        scroll.setOverscroll(false, false);
        scroll.setSmoothScrolling(false);
        scroll.setScrollingDisabled(true, false);
        scroll.setFadeScrollBars(false);
        scroll.setScrollbarsVisible(true);
        return scroll;
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case PROCEDURAL_GENERATION_CLOUD_INFO: {
                boolean status = (Boolean)data[0];
                this.genCloudNum = status ? ++this.genCloudNum : FastMath.max((int)(this.genCloudNum - 1), (int)0);
                this.updateButtonStatus();
                break;
            }
            case PROCEDURAL_GENERATION_SURFACE_INFO: {
                boolean status = (Boolean)data[0];
                this.genSurfaceNum = status ? ++this.genSurfaceNum : FastMath.max((int)(this.genSurfaceNum - 1), (int)0);
                this.updateButtonStatus();
                break;
            }
            case FOCUS_CHANGED: {
                Entity entity;
                if (data[0] instanceof String) {
                    entity = GaiaSky.instance.scene.getEntity((String)data[0]);
                } else {
                    FocusView v = (FocusView)data[0];
                    entity = v.getEntity();
                }
                if (!Mapper.atmosphere.has(entity)) break;
                this.reinitialize(entity);
            }
        }
    }
}

