/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Timer;
import gaiasky.GaiaSky;
import gaiasky.gui.window.GenericDialog;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnLabel;

public class QuitWindow
extends GenericDialog {
    private OwnCheckBox doNotAsk;

    public QuitWindow(Stage ui, Skin skin) {
        super(I18n.msg("gui.quit.title"), skin, ui);
        this.setAcceptText(I18n.msg("gui.yes"));
        this.setCancelText(I18n.msg("gui.no"));
        this.buildSuper();
    }

    @Override
    protected void build() {
        this.content.clear();
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.quit.sure"), this.skin)).left().padBottom(pad18 * 2.0f).row();
        this.doNotAsk = new OwnCheckBox(I18n.msg("gui.donotask"), this.skin, pad10);
        this.doNotAsk.setChecked(false);
        this.bottom.add((Actor)this.doNotAsk).right().row();
        Timer.Task task = new Timer.Task(){

            public void run() {
                QuitWindow.this.stage.setKeyboardFocus((Actor)QuitWindow.this.acceptButton);
            }
        };
        Timer.schedule((Timer.Task)task, (float)0.2f);
    }

    @Override
    protected boolean accept() {
        Settings.settings.program.exitConfirmation = !this.doNotAsk.isChecked();
        GaiaSky.postRunnable(() -> Gdx.app.exit());
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }
}

