/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import gaiasky.gui.window.GenericDialog;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnTextArea;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class ReleaseNotesWindow
extends GenericDialog {
    private static final Logger.Log logger = Logger.getLogger(ReleaseNotesWindow.class);
    private final Path releaseNotesFile;

    public ReleaseNotesWindow(Stage stage, Skin skin, Path file) {
        super(I18n.msg("gui.releasenotes.title"), skin, stage);
        this.releaseNotesFile = file;
        this.setResizable(true);
        this.setAcceptText(I18n.msg("gui.ok"));
        this.buildSuper();
    }

    @Override
    protected void build() {
        float taWidth = 1300.0f;
        float taHeight = 900.0f;
        try {
            String releaseNotes = Files.readString(this.releaseNotesFile).trim();
            OwnLabel title = new OwnLabel((CharSequence)(Settings.getApplicationTitle(false) + "   " + Settings.settings.version.version), this.skin, "header");
            this.content.add((Actor)title).left().pad(pad18).padBottom(pad34).row();
            OwnTextArea releaseNotesText = new OwnTextArea(releaseNotes, this.skin, "disabled-nobg");
            releaseNotesText.setDisabled(true);
            releaseNotesText.setPrefRows(30.0f);
            releaseNotesText.setWidth(taWidth - 15.0f);
            float fontHeight = releaseNotesText.getStyle().font.getLineHeight();
            releaseNotesText.offsets();
            releaseNotesText.setHeight((float)(releaseNotesText.getLines() + 3) * fontHeight);
            releaseNotesText.clearListeners();
            OwnScrollPane scroll = new OwnScrollPane((Actor)releaseNotesText, this.skin, "default-nobg");
            scroll.setWidth(taWidth);
            scroll.setHeight(taHeight);
            scroll.setForceScroll(false, true);
            scroll.setSmoothScrolling(false);
            scroll.setFadeScrollBars(false);
            this.content.add((Actor)scroll).center().pad(pad18);
            this.content.pack();
        }
        catch (IOException e) {
            OwnLabel error = new OwnLabel((CharSequence)I18n.msg("error.file.read", this.releaseNotesFile.toString()), this.skin);
            this.content.add((Actor)error).center();
        }
    }

    @Override
    protected boolean accept() {
        Path releaseNotesRev = SysUtils.getReleaseNotesRevisionFile();
        try {
            if (Files.exists(releaseNotesRev, new LinkOption[0])) {
                Files.delete(releaseNotesRev);
            }
            Files.writeString(releaseNotesRev, (CharSequence)Integer.toString(Settings.settings.version.versionNumber), new OpenOption[0]);
        }
        catch (IOException e) {
            logger.error(e);
        }
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }
}

