/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Timer;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.gui.window.GenericDialog;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.component.Base;
import gaiasky.scene.view.FilterView;
import gaiasky.scene.view.FocusView;
import gaiasky.util.CatalogInfo;
import gaiasky.util.Logger;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnTextField;
import java.util.Locale;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;

public class SearchDialog
extends GenericDialog {
    private static final Logger.Log logger = Logger.getLogger(SearchDialog.class);
    private final Scene scene;
    private final SortedSet<String> matching;
    private final Array<OwnLabel> matchingLabels;
    private final FocusView view;
    private final FilterView filterView;
    private final Vector2 aux;
    private final boolean suggestions;
    private final Array<Timer.Task> tasks;
    private OwnTextField searchInput;
    private String currentInputText = "";
    private Cell<?> infoCell;
    private OwnLabel infoMessage;
    private Table candidates;
    private int cIdx = -1;

    public SearchDialog(Skin skin, Stage ui, Scene scene, boolean suggestions) {
        super(I18n.msg("gui.objects.search"), skin, ui);
        this.scene = scene;
        this.aux = new Vector2();
        this.matching = new TreeSet<String>();
        this.matchingLabels = new Array(10);
        this.tasks = new Array(20);
        this.view = new FocusView();
        this.filterView = new FilterView();
        this.setModal(false);
        this.setAcceptText(I18n.msg("gui.close"));
        this.addListener((EventListener)new InputListener(){

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                SearchDialog.this.removeCandidates();
                return super.touchDown(event, x, y, pointer, button);
            }

            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                SearchDialog.this.removeCandidates();
                super.touchDragged(event, x, y, pointer);
            }
        });
        this.buildSuper();
        this.pack();
        this.suggestions = suggestions;
    }

    @Override
    public void build() {
        this.candidates = new Table(this.skin);
        this.candidates.setBackground("table-bg");
        this.candidates.setFillParent(false);
        this.searchInput = new OwnTextField("", this.skin);
        this.searchInput.setWidth(480.0f);
        this.searchInput.setMessageText(I18n.msg("gui.objects.search"));
        this.searchInput.addListener(event -> {
            if (event instanceof InputEvent) {
                InputEvent ie = (InputEvent)event;
                int matchingSize = this.matching.size();
                int code = ie.getKeyCode();
                if (ie.getType() == InputEvent.Type.keyUp) {
                    if (code == 111 || code == 66) {
                        if (this.cIdx >= 0) {
                            this.checkString(this.searchInput.getText(), this.scene);
                        }
                        this.removeCandidates();
                        this.me.remove();
                        return true;
                    }
                    if (code == 61 && Gdx.input.isKeyPressed(59) && matchingSize > 0) {
                        this.cIdx = this.cIdx - 1 < 0 ? matchingSize - 1 : this.cIdx - 1;
                        this.selectMatch();
                        return true;
                    }
                    if (code == 61 && !Gdx.input.isKeyPressed(59) && matchingSize > 0) {
                        this.cIdx = (this.cIdx + 1) % matchingSize;
                        this.selectMatch();
                        return true;
                    }
                    if (!this.searchInput.getText().equals(this.currentInputText) && !this.searchInput.getText().isBlank()) {
                        if (this.suggestions) {
                            this.currentInputText = this.searchInput.getText();
                            final String name = this.currentInputText.toLowerCase(Locale.ROOT).trim();
                            Timer.Task task = new Timer.Task(this){
                                final /* synthetic */ SearchDialog this$0;
                                {
                                    this.this$0 = this$0;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    SortedSet<String> sortedSet = this.this$0.matching;
                                    synchronized (sortedSet) {
                                        this.this$0.matchingNodes(name, this.this$0.scene);
                                        if (!this.this$0.matching.isEmpty()) {
                                            this.this$0.cIdx = -1;
                                            this.this$0.candidates.clear();
                                            this.this$0.matching.forEach(match -> {
                                                OwnLabel m = new OwnLabel((CharSequence)match, this.this$0.skin);
                                                m.addListener(evt -> {
                                                    InputEvent iEvt;
                                                    if (evt instanceof InputEvent && (iEvt = (InputEvent)evt).getType() == InputEvent.Type.touchDown) {
                                                        this.this$0.checkString((String)match, this.this$0.scene);
                                                        this.this$0.searchInput.setText((String)match);
                                                        this.this$0.accept();
                                                        return true;
                                                    }
                                                    return false;
                                                });
                                                this.this$0.matchingLabels.add((Object)m);
                                                m.setWidth(this.this$0.searchInput.getWidth());
                                                Cell c = this.this$0.candidates.add((Actor)m).left().padBottom(GenericDialog.pad10);
                                                c.row();
                                            });
                                            this.this$0.candidates.pack();
                                            this.this$0.searchInput.localToStageCoordinates(this.this$0.aux.set(0.0f, 0.0f));
                                            this.this$0.candidates.setPosition(this.this$0.aux.x, this.this$0.aux.y, 10);
                                            this.this$0.stage.addActor((Actor)this.this$0.candidates);
                                        } else {
                                            this.this$0.removeCandidates();
                                        }
                                    }
                                }
                            };
                            this.cancelTasks();
                            this.tasks.add((Object)task);
                            Timer.schedule((Timer.Task)task, (float)0.5f);
                            if (!this.checkString(name, this.scene)) {
                                if (name.matches("[0-9]+")) {
                                    if (this.checkString("hip " + name, this.scene)) {
                                        this.cancelTasks();
                                        this.removeCandidates();
                                    }
                                } else if ((name.matches("hip [0-9]+") || name.matches("HIP [0-9]+")) && this.checkString(name.substring(4), this.scene)) {
                                    this.cancelTasks();
                                    this.removeCandidates();
                                }
                            } else {
                                this.cancelTasks();
                                this.removeCandidates();
                            }
                            return true;
                        }
                    } else {
                        this.removeCandidates();
                        return true;
                    }
                }
            }
            return false;
        });
        this.infoMessage = new OwnLabel((CharSequence)"", this.skin, "default-blue");
        this.content.add((Actor)this.searchInput).top().left().expand().row();
        this.infoCell = this.content.add();
        this.infoCell.top().left().padTop(pad10).expand().row();
    }

    @Override
    public boolean accept() {
        this.cancelTasks();
        this.removeCandidates();
        this.info(null);
        return true;
    }

    @Override
    public void cancel() {
    }

    private void cancelTasks() {
        if (!this.tasks.isEmpty()) {
            for (Timer.Task t : this.tasks) {
                t.cancel();
            }
        }
        this.tasks.clear();
    }

    private void removeCandidates() {
        if (this.candidates != null) {
            this.candidates.clear();
            this.candidates.remove();
        }
        this.cIdx = -1;
    }

    private void selectMatch() {
        for (int i = 0; i < this.matchingLabels.size; ++i) {
            OwnLabel l = (OwnLabel)((Object)this.matchingLabels.get(i));
            if (i == this.cIdx) {
                l.setColor(ColorUtils.gYellowC);
                this.searchInput.setText(l.getText().toString());
                continue;
            }
            l.setColor(ColorUtils.gWhiteC);
        }
    }

    private void matchingNodes(String text, Scene scene) {
        this.matching.clear();
        this.matchingLabels.clear();
        scene.matchingFocusableNodes(text, this.matching, 10, null);
    }

    private boolean checkString(String text, Scene scene) {
        try {
            if (scene.index().containsEntity(text)) {
                Entity entity = scene.getEntity(text);
                if (Mapper.focus.has(entity)) {
                    boolean datasetVisible;
                    this.view.setEntity(entity);
                    this.view.getFocus(text);
                    this.filterView.setEntity(entity);
                    boolean timeOverflow = this.view.isCoordinatesTimeOverflow();
                    boolean canSelect = this.view.getSet() == null || this.view.getSet().canSelect(this.filterView);
                    boolean ctOn = GaiaSky.instance.isOn(this.view.getCt());
                    Optional<CatalogInfo> ci = GaiaSky.instance.getCatalogInfoFromEntity(entity);
                    boolean bl = datasetVisible = ci.isEmpty() || ci.get().isVisible(true);
                    if (!timeOverflow && canSelect && ctOn && datasetVisible) {
                        GaiaSky.postRunnable(() -> {
                            EventManager.publish(Event.CAMERA_MODE_CMD, (Object)this, new Object[]{CameraManager.CameraMode.FOCUS_MODE, true});
                            EventManager.publish(Event.FOCUS_CHANGE_CMD, (Object)this, entity, true);
                        });
                        this.info(null);
                    } else if (timeOverflow) {
                        this.info(I18n.msg("gui.objects.search.timerange", text));
                    } else if (!canSelect) {
                        this.info(I18n.msg("gui.objects.search.filter", text));
                    } else if (!datasetVisible) {
                        this.info(I18n.msg("gui.objects.search.dataset.invisible", text, ci.get().name));
                    } else {
                        this.info(I18n.msg("gui.objects.search.invisible", text, ((Base)Mapper.base.get((Entity)entity)).ct.toString()));
                    }
                    return true;
                }
            } else {
                this.info(null);
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        return false;
    }

    private void info(String info) {
        if (info == null) {
            this.infoMessage.setText("");
            this.info(false);
        } else {
            this.infoMessage.setText(info);
            this.info(true);
        }
    }

    private void info(boolean visible) {
        if (visible) {
            this.infoCell.setActor((Actor)this.infoMessage);
        } else {
            this.infoCell.setActor(null);
        }
        this.pack();
    }

    public void clearText() {
        this.removeCandidates();
        this.searchInput.setText("");
    }

    @Override
    public GenericDialog show(Stage stage, Action action) {
        GenericDialog gd = super.show(stage, action);
        stage.setKeyboardFocus((Actor)this.searchInput);
        return gd;
    }

    @Override
    public void dispose() {
    }
}

