/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.window.GenericDialog;
import gaiasky.util.Logger;
import gaiasky.util.MasterManager;
import gaiasky.util.i18n.I18n;
import gaiasky.util.parse.Parser;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnSelectBox;
import gaiasky.util.scene2d.OwnTextButton;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.validator.FloatValidator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SlaveConfigWindow
extends GenericDialog
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(SlaveConfigWindow.class);
    private static final Map<String, Map<String, String>> parametersMap = new HashMap<String, Map<String, String>>();
    private OwnTextField yaw;
    private OwnTextField pitch;
    private OwnTextField roll;
    private OwnTextField fov;
    private OwnSelectBox<String> slaveSelect;
    private OwnLabel[] slaveStatuses;
    private OwnLabel slaveStatusLabel;

    public SlaveConfigWindow(Stage stage, Skin skin) {
        super(I18n.msg("gui.slave.config.title"), skin, stage);
        this.setModal(false);
        this.setCancelText(I18n.msg("gui.close"));
        this.buildSuper();
        EventManager.instance.subscribe((IObserver)this, Event.SLAVE_CONNECTION_EVENT);
    }

    @Override
    protected void build() {
        FloatValidator angleVal = new FloatValidator(-1000.0f, 1000.0f);
        FloatValidator fovVal = new FloatValidator(1.0f, 170.0f);
        float tw = 96.0f;
        OwnTextButton sendButton = new OwnTextButton(I18n.msg("gui.send"), this.skin, "default");
        sendButton.setName("send");
        sendButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.accept();
                return true;
            }
            return false;
        });
        this.buttonGroup.addActor((Actor)sendButton);
        this.recalculateButtonSize();
        List<String> slaves = MasterManager.instance.getSlaves();
        this.slaveStatuses = new OwnLabel[slaves.size()];
        OwnLabel statusLabel = new OwnLabel((CharSequence)(I18n.msg("gui.slave.config.status") + ":"), this.skin);
        Table statusTable = new Table(this.skin);
        for (int i = 0; i < slaves.size(); ++i) {
            OwnLabel slaveMarker = new OwnLabel((CharSequence)("[" + (i + 1) + "]"), this.skin);
            if (MasterManager.instance.isSlaveConnected(slaves.get(i))) {
                slaveMarker.setColor(Color.GREEN);
            } else {
                slaveMarker.setColor(Color.RED);
            }
            this.slaveStatuses[i] = slaveMarker;
            statusTable.add((Actor)slaveMarker).left().padRight(pad18);
        }
        this.content.add((Actor)statusLabel).center().left().padRight(pad18).padBottom(pad18 * 2.0f);
        this.content.add((Actor)statusTable).center().left().padBottom(pad18 * 2.0f).row();
        Array<String> slaveList = this.getSlaveBeans();
        this.slaveSelect = new OwnSelectBox(this.skin);
        this.slaveSelect.setWidth(tw * 4.0f);
        this.slaveSelect.setItems(slaveList);
        this.slaveSelect.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                String newSlave = (String)this.slaveSelect.getSelected();
                this.pullParameters(newSlave);
                this.updateSlaveStatusText(newSlave);
                return true;
            }
            return false;
        });
        OwnLabel slaveLabel = new OwnLabel((CharSequence)(I18n.msg("gui.slave.config.instance") + ":"), this.skin);
        this.content.add((Actor)slaveLabel).center().left().padRight(pad18).padBottom(pad18);
        this.content.add(this.slaveSelect).center().left().padBottom(pad18).row();
        this.slaveStatusLabel = new OwnLabel((CharSequence)"", this.skin);
        this.content.add((Actor)this.slaveStatusLabel).colspan(2).center().padBottom(pad18 * 2.0f).row();
        if (!slaves.isEmpty()) {
            this.updateSlaveStatusText(slaves.get(0));
        }
        this.yaw = new OwnTextField("", this.skin, angleVal);
        this.yaw.setWidth(tw);
        OwnLabel yawLabel = new OwnLabel((CharSequence)(I18n.msg("gui.slave.config.yaw") + ":"), this.skin);
        this.content.add((Actor)yawLabel).center().left().padRight(pad18).padBottom(pad18);
        this.content.add((Actor)this.yaw).center().left().padBottom(pad18).row();
        this.pitch = new OwnTextField("", this.skin, angleVal);
        this.pitch.setWidth(tw);
        OwnLabel pitchLabel = new OwnLabel((CharSequence)(I18n.msg("gui.slave.config.pitch") + ":"), this.skin);
        this.content.add((Actor)pitchLabel).center().left().padRight(pad18).padBottom(pad18);
        this.content.add((Actor)this.pitch).center().left().padBottom(pad18).row();
        this.roll = new OwnTextField("", this.skin, angleVal);
        this.roll.setWidth(tw);
        OwnLabel rollLabel = new OwnLabel((CharSequence)(I18n.msg("gui.slave.config.roll") + ":"), this.skin);
        this.content.add((Actor)rollLabel).center().left().padRight(pad18).padBottom(pad18);
        this.content.add((Actor)this.roll).center().left().padBottom(pad18).row();
        this.fov = new OwnTextField("", this.skin, fovVal);
        this.fov.setWidth(tw);
        OwnLabel fovLabel = new OwnLabel((CharSequence)(I18n.msg("gui.slave.config.fov") + ":"), this.skin);
        this.content.add((Actor)fovLabel).center().left().padRight(pad18).padBottom(pad18);
        this.content.add((Actor)this.fov).center().left().padBottom(pad18).row();
        if (this.slaveSelect.getSelected() != null) {
            this.pullParameters((String)this.slaveSelect.getSelected());
        }
    }

    private void pullParameters(String slave) {
        this.pullParameter(slave, "yaw", this.yaw);
        this.pullParameter(slave, "pitch", this.pitch);
        this.pullParameter(slave, "roll", this.roll);
        this.pullParameter(slave, "fov", this.fov);
    }

    private void pullParameter(String slave, String param, OwnTextField field) {
        Map<String, String> params;
        if (parametersMap.containsKey(slave) && (params = parametersMap.get(slave)).containsKey(param)) {
            field.setText(params.get(param));
        }
    }

    private void pushParameters(String slave) {
        this.pushParameter(slave, "yaw", this.yaw.getText());
        this.pushParameter(slave, "pitch", this.pitch.getText());
        this.pushParameter(slave, "roll", this.roll.getText());
        this.pushParameter(slave, "fov", this.fov.getText());
    }

    private void pushParameter(String slave, String param, String value) {
        Map<Object, Object> params = parametersMap.containsKey(slave) ? parametersMap.get(slave) : new HashMap();
        params.put(param, value);
        parametersMap.put(slave, params);
    }

    @Override
    protected boolean accept() {
        String slave = (String)this.slaveSelect.getSelected();
        Object logStr = "";
        if (MasterManager.instance.isSlaveConnected(slave)) {
            float val;
            if (this.yaw.isValid()) {
                val = Parser.parseFloat(this.yaw.getText());
                MasterManager.instance.setSlaveYaw(slave, val);
                logStr = (String)logStr + "yaw=" + val + ";";
                this.pushParameter(slave, "yaw", this.yaw.getText());
            }
            if (this.pitch.isValid()) {
                val = Parser.parseFloat(this.pitch.getText());
                MasterManager.instance.setSlavePitch(slave, val);
                logStr = (String)logStr + "pitch=" + val + ";";
                this.pushParameter(slave, "pitch", this.pitch.getText());
            }
            if (this.roll.isValid()) {
                val = Parser.parseFloat(this.roll.getText());
                MasterManager.instance.setSlaveRoll(slave, val);
                logStr = (String)logStr + "roll=" + val + ";";
                this.pushParameter(slave, "roll", this.roll.getText());
            }
            if (this.fov.isValid()) {
                val = Parser.parseFloat(this.fov.getText());
                MasterManager.instance.setSlaveFov(slave, val);
                logStr = (String)logStr + "fov=" + val + ";";
                this.pushParameter(slave, "fov", this.fov.getText());
            }
            logger.info("New configuration sent to slave successfully: " + (String)logStr);
        } else {
            logger.warn("Slave is down, no configuration sent: " + slave);
        }
        return true;
    }

    private synchronized void updateSlaveStatusText(boolean connected) {
        if (connected) {
            this.slaveStatusLabel.setText("Slave is connected");
            this.slaveStatusLabel.setColor(Color.GREEN);
        } else {
            this.slaveStatusLabel.setText("Slave is down");
            this.slaveStatusLabel.setColor(Color.RED);
        }
    }

    private synchronized void updateSlaveStatusText(String newSlave) {
        List<String> slaves = MasterManager.instance.getSlaves();
        int idx = slaves.indexOf(newSlave);
        this.updateSlaveStatusText(MasterManager.instance.isSlaveConnected(idx));
    }

    private Array<String> getSlaveBeans() {
        List<String> slaves = MasterManager.instance.getSlaves();
        Array slaveList = new Array();
        for (String slave : slaves) {
            slaveList.add((Object)slave);
        }
        return slaveList;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.SLAVE_CONNECTION_EVENT) {
            int idx = (Integer)data[0];
            boolean status = (Boolean)data[2];
            if (this.slaveStatuses != null && this.slaveStatuses.length > idx && idx >= 0) {
                this.slaveStatuses[idx].setColor(status ? Color.GREEN : Color.RED);
            }
            if (this.slaveSelect.getSelectedIndex() == idx) {
                this.updateSlaveStatusText(status);
            }
        }
    }
}

