/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.window;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import gaiasky.gui.window.GenericDialog;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.TextureWidget;

public class TextureWindow
extends GenericDialog {
    private final TextureWidget textureWidget;

    public TextureWindow(String title, Skin skin, Stage stage, Texture texture, float scale) {
        super(title, skin, stage);
        this.textureWidget = new TextureWidget(texture);
        this.textureWidget.setScale(scale);
        this.setCancelText(I18n.msg("gui.close"));
        this.setModal(false);
        this.defaultMouseKbdListener = false;
        this.defaultGamepadListener = false;
        this.buildSuper();
        this.pack();
    }

    public TextureWindow(String title, Skin skin, Stage stage, Texture texture) {
        this(title, skin, stage, texture, 1.0f);
    }

    public TextureWindow(String title, Skin skin, Stage stage, FrameBuffer frameBuffer, float scale) {
        this(title, skin, stage, (Texture)frameBuffer.getColorBufferTexture(), scale);
    }

    public TextureWindow(String title, Skin skin, Stage stage, FrameBuffer frameBuffer) {
        this(title, skin, stage, frameBuffer, 1.0f);
    }

    public void setFlip(boolean x, boolean y) {
        if (this.textureWidget != null) {
            this.textureWidget.setFlip(x, y);
        }
    }

    public void setScale(float scale) {
        if (this.textureWidget != null) {
            this.textureWidget.setScale(scale);
        }
    }

    public void setScale(float scaleX, float scaleY) {
        if (this.textureWidget != null) {
            this.textureWidget.setScale(scaleX, scaleY);
        }
    }

    @Override
    protected void build() {
        Container textureContainer = new Container();
        textureContainer.setActor((Actor)this.textureWidget);
        this.content.add((Actor)textureContainer);
    }

    @Override
    protected boolean accept() {
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }
}

