/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.input;

import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.utils.TimeUtils;
import gaiasky.GaiaSky;
import gaiasky.desktop.GaiaSkyDesktop;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.api.IGamepadMappings;
import gaiasky.gui.api.IInputListener;
import gaiasky.gui.main.AbstractGamepadMappings;
import gaiasky.util.Logger;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jafama.FastMath;

public abstract class AbstractGamepadListener
implements ControllerListener,
IInputListener,
IObserver {
    private static final Logger.Log logger = Logger.getLogger(AbstractGamepadListener.class);
    protected static final float MIN_ZERO_POINT = 0.3f;
    protected long axisEventDelay = 200L;
    protected long axisPollDelay = 200L;
    protected long buttonPollDelay = 400L;
    protected final EventManager em;
    protected final AtomicBoolean active = new AtomicBoolean(true);
    protected Controller lastControllerUsed = null;
    protected IGamepadMappings mappings;
    protected long lastAxisEvtTime = 0L;
    protected long lastButtonPollTime = 0L;
    private final GaiaSkyDesktop.CLIArgs cliArgs;

    protected AbstractGamepadListener(String mappingsFile) {
        this(AbstractGamepadMappings.readGamepadMappings(mappingsFile));
    }

    protected AbstractGamepadListener(IGamepadMappings mappings) {
        this.mappings = mappings;
        this.em = EventManager.instance;
        this.cliArgs = GaiaSky.instance.getCliArgs();
        this.em.subscribe((IObserver)this, Event.RELOAD_CONTROLLER_MAPPINGS);
    }

    protected double applyZeroPoint(double value) {
        return FastMath.abs((double)value) >= FastMath.max((double)this.mappings.getZeroPoint(), (double)0.3f) ? value : 0.0;
    }

    public IGamepadMappings getMappings() {
        return this.mappings;
    }

    public void setMappings(IGamepadMappings mappings) {
        this.mappings = mappings;
    }

    public boolean buttonDown(Controller controller, int buttonCode) {
        if (this.isActive()) {
            this.lastControllerUsed = controller;
            if (this.cliArgs.debugInput) {
                logger.info(String.format("Button down [controller: %s, button: %d]", controller.getName(), buttonCode));
            }
        }
        return false;
    }

    public boolean buttonUp(Controller controller, int buttonCode) {
        if (this.isActive()) {
            this.lastControllerUsed = controller;
            if (this.cliArgs.debugInput) {
                logger.info(String.format("Button down [controller: %s, button: %d]", controller.getName(), buttonCode));
            }
        }
        return false;
    }

    public boolean axisMoved(Controller controller, int axisCode, float value) {
        if (this.isActive()) {
            this.lastControllerUsed = controller;
            if (this.cliArgs.debugInput) {
                logger.info(String.format("Axis moved [controller: %s, axis: %d, value: %f]", controller.getName(), axisCode, Float.valueOf(value)));
            }
        }
        return false;
    }

    public boolean isKeyPressed(int buttonCode) {
        return this.isKeyPressed(this.lastControllerUsed, buttonCode);
    }

    public boolean isKeyPressed(Controller controller, int buttonCode) {
        return controller != null && controller.getButton(buttonCode);
    }

    public boolean anyPressed(int ... buttonCodes) {
        return this.anyPressed(this.lastControllerUsed, buttonCodes);
    }

    public boolean anyPressed(Controller controller, int ... buttonCodes) {
        if (controller == null) {
            return false;
        }
        for (int buttonCode : buttonCodes) {
            if (!this.isKeyPressed(controller, buttonCode)) continue;
            return true;
        }
        return false;
    }

    public void connected(Controller controller) {
        logger.info("Controller connected: " + controller.getName());
        this.em.post(Event.CONTROLLER_CONNECTED_INFO, this, controller.getName());
    }

    public void disconnected(Controller controller) {
        logger.info("Controller disconnected: " + controller.getName());
        this.em.post(Event.CONTROLLER_DISCONNECTED_INFO, this, controller.getName());
    }

    public abstract boolean pollAxes();

    public abstract boolean pollButtons();

    @Override
    public void update() {
        if (this.active.get()) {
            long now = TimeUtils.millis();
            if (now - this.lastAxisEvtTime > this.axisPollDelay && this.pollAxes()) {
                this.lastAxisEvtTime = now;
            }
            if (now - this.lastButtonPollTime > this.buttonPollDelay && this.pollButtons()) {
                this.lastButtonPollTime = now;
            }
        }
    }

    @Override
    public void activate() {
        this.active.set(true);
    }

    @Override
    public void deactivate() {
        this.active.set(false);
    }

    public boolean isActive() {
        return this.active.get();
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.RELOAD_CONTROLLER_MAPPINGS) {
            this.mappings = AbstractGamepadMappings.readGamepadMappings((String)data[0]);
        }
    }
}

