/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.utils.TimeUtils;
import gaiasky.GaiaSky;
import gaiasky.desktop.GaiaSkyDesktop;
import gaiasky.gui.api.IInputListener;
import gaiasky.input.GuiKbdListener;
import gaiasky.input.InputUtils;
import gaiasky.scene.camera.ICamera;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractMouseKbdListener
extends GestureDetector
implements IInputListener {
    private static final Logger.Log logger = Logger.getLogger(AbstractMouseKbdListener.class);
    protected final AtomicBoolean active;
    protected ICamera iCamera;
    protected long minPollTime = 150L;
    protected long minPollInterval = 0L;
    protected long lastPollTime = 0L;
    private final GaiaSkyDesktop.CLIArgs cliArgs;

    protected AbstractMouseKbdListener(GestureDetector.GestureListener gl, ICamera camera) {
        super(gl);
        this.iCamera = camera;
        this.active = new AtomicBoolean(true);
        this.cliArgs = GaiaSky.instance.getCliArgs();
    }

    public boolean keyDown(int keyCode) {
        if (this.isActive()) {
            if ((GuiKbdListener.class.isAssignableFrom(this.getClass()) || Settings.settings.runtime.inputEnabled) && this.iCamera != null) {
                this.iCamera.setGamepadInput(false);
            }
            if (this.cliArgs.debugInput) {
                logger.info(String.format("Key down: %d (%s)", keyCode, Input.Keys.toString((int)keyCode)));
            }
        }
        return false;
    }

    public boolean keyUp(int keyCode) {
        if (this.isActive()) {
            if (this.iCamera != null) {
                this.iCamera.setGamepadInput(false);
            }
            if (this.cliArgs.debugInput) {
                logger.info(String.format("Key up: %d (%s)", keyCode, Input.Keys.toString((int)keyCode)));
            }
        }
        return false;
    }

    public boolean isKeyPressed(int keyCode) {
        return Gdx.input.isKeyPressed(keyCode);
    }

    public boolean isLogicalKeyPressed(int keyCode) {
        return Gdx.input.isKeyPressed(InputUtils.physicalToLogicalKeyCode(keyCode));
    }

    public boolean allPressed(int ... keys) {
        if (keys == null) {
            return false;
        }
        for (int k : keys) {
            if (this.isKeyPressed(k)) continue;
            return false;
        }
        return true;
    }

    public boolean allPressed(Collection<Integer> keys) {
        if (keys == null) {
            return false;
        }
        for (int k : keys) {
            if (this.isKeyPressed(k)) continue;
            return false;
        }
        return true;
    }

    public boolean anyPressed(int ... keys) {
        for (int k : keys) {
            if (!this.isKeyPressed(k)) continue;
            return true;
        }
        return false;
    }

    public boolean anyPressedLogical(int ... keys) {
        for (int k : keys) {
            if (!this.isLogicalKeyPressed(k)) continue;
            return true;
        }
        return false;
    }

    public float getResponseTime() {
        return 0.25f;
    }

    @Override
    public void update() {
        if (this.isActive()) {
            long now = TimeUtils.millis();
            long elapsed = now - this.lastPollTime;
            if ((this.minPollInterval <= 0L || elapsed > this.minPollInterval) && this.pollKeys()) {
                this.lastPollTime = now;
            }
        }
    }

    private String getButtonString(int button) {
        return switch (button) {
            case 1 -> "RIGHT";
            case 0 -> "LEFT";
            case 2 -> "MIDDLE";
            case 3 -> "BACK";
            case 4 -> "FORWARD";
            default -> "UNKNOWN";
        };
    }

    public boolean touchUp(float x, float y, int pointer, int button) {
        if (this.isActive() && this.cliArgs.debugInput) {
            logger.info(String.format("Mouse button up [x: %f, y: %f, pointer: %d, button: %d (%s)]", Float.valueOf(x), Float.valueOf(y), pointer, button, this.getButtonString(button)));
        }
        return super.touchUp(x, y, pointer, button);
    }

    public boolean touchUp(int x, int y, int pointer, int button) {
        return this.touchUp((float)x, (float)y, pointer, button);
    }

    public boolean touchDown(float x, float y, int pointer, int button) {
        if (this.isActive() && this.cliArgs.debugInput) {
            logger.info(String.format("Mouse button down [x: %f, y: %f, pointer: %d, button: %d (%s)]", Float.valueOf(x), Float.valueOf(y), pointer, button, this.getButtonString(button)));
        }
        return super.touchDown(x, y, pointer, button);
    }

    public boolean touchDown(int x, int y, int pointer, int button) {
        return this.touchDown((float)x, (float)y, pointer, button);
    }

    public boolean scrolled(float amountX, float amountY) {
        if (this.isActive() && this.cliArgs.debugInput) {
            logger.info(String.format("Scroll [x: %f, y: %f]", Float.valueOf(amountX), Float.valueOf(amountY)));
        }
        return super.scrolled(amountX, amountY);
    }

    protected abstract boolean pollKeys();

    public boolean isActive() {
        return this.active.get();
    }

    @Override
    public void activate() {
        this.active.set(true);
    }

    @Override
    public void deactivate() {
        this.active.set(false);
    }

    protected float getFpsScale() {
        return 1.0f / Gdx.graphics.getDeltaTime() / 60.0f;
    }
}

