/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics;
import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.math.MathUtils;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.main.ModePopupInfo;
import gaiasky.input.AbstractMouseKbdListener;
import gaiasky.scene.camera.NaturalCamera;
import gaiasky.util.math.MathUtilsDouble;
import org.lwjgl.glfw.GLFW;

public class GameMouseKbdListener
extends AbstractMouseKbdListener
implements IObserver {
    private final NaturalCamera camera;
    private float prevX = 0.0f;
    private float prevY = 0.0f;
    private float dx = 0.0f;
    private float dy = 0.0f;
    private boolean prevValid = false;

    public GameMouseKbdListener(GameGestureListener l, NaturalCamera naturalCamera) {
        super((GestureDetector.GestureListener)l, naturalCamera);
        this.camera = naturalCamera;
        EventManager.instance.subscribe((IObserver)this, Event.MOUSE_CAPTURE_CMD, Event.MOUSE_CAPTURE_TOGGLE);
    }

    public GameMouseKbdListener(NaturalCamera naturalCamera) {
        this(new GameGestureListener(), naturalCamera);
    }

    @Override
    public boolean pollKeys() {
        float keySensitivity = 0.3f;
        float multiplier = this.isKeyPressed(59) ? 3.0f : 1.0f;
        double minTranslateUnits = 1.0E-5;
        boolean result = false;
        if (this.anyPressed(51, 29, 47, 32)) {
            this.camera.vel.setZero();
            if (this.anyPressed(45, 33, 62, 31)) {
                this.camera.setGamepadInput(false);
            }
            result = true;
        }
        if (this.isKeyPressed(51)) {
            this.camera.forward(keySensitivity * multiplier, minTranslateUnits);
            result = true;
        } else if (this.isKeyPressed(47)) {
            this.camera.forward(-keySensitivity * multiplier, minTranslateUnits);
            result = true;
        }
        if (this.isKeyPressed(32)) {
            this.camera.strafe(keySensitivity * multiplier, minTranslateUnits);
            result = true;
        } else if (this.isKeyPressed(29)) {
            this.camera.strafe(-keySensitivity * multiplier, minTranslateUnits);
            result = true;
        }
        if (this.isKeyPressed(45)) {
            this.camera.addRoll(keySensitivity, true);
            result = true;
        } else if (this.isKeyPressed(33)) {
            this.camera.addRoll(-keySensitivity, true);
            result = true;
        }
        if (this.isKeyPressed(62)) {
            this.camera.vertical(keySensitivity * multiplier, minTranslateUnits);
            result = true;
        } else if (this.isKeyPressed(31)) {
            this.camera.vertical(-keySensitivity * multiplier, minTranslateUnits);
            result = true;
        }
        return result;
    }

    @Override
    public float getResponseTime() {
        return 0.1f;
    }

    @Override
    public void activate() {
        super.activate();
        GaiaSky.postRunnable(() -> {
            this.camera.setDiverted(true);
            this.setMouseCapture(true);
            GaiaSky.instance.mainGui.getGuiStage().unfocusAll();
            ModePopupInfo mpi = new ModePopupInfo();
            mpi.title = "Game mode";
            mpi.header = "You have entered Game mode!";
            mpi.addMapping("Move forward", "W");
            mpi.addMapping("Move backward", "S");
            mpi.addMapping("Strafe left", "A");
            mpi.addMapping("Strafe right", "D");
            mpi.addMapping("Roll left", "Q");
            mpi.addMapping("Roll right", "E");
            mpi.addMapping("Move up", "Space");
            mpi.addMapping("Move down", "C");
            mpi.addMapping("Look around", "Mouse");
            mpi.addMapping("Toggle mouse capture", "SHIFT", "CTRL", "L");
            mpi.addMapping("Go back to regular mode", "1");
            EventManager.publish(Event.MODE_POPUP_CMD, this, mpi, "gamemode", Float.valueOf(10.0f));
        });
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.setMouseCapture(false);
        EventManager.publish(Event.MODE_POPUP_CMD, this, null, "gamemode");
        this.prevValid = false;
    }

    @Override
    public boolean keyDown(int keyCode) {
        return super.keyDown(keyCode);
    }

    @Override
    public boolean keyUp(int keycode) {
        return super.keyUp(keycode);
    }

    private void updatePreviousMousePosition(float x, float y) {
        this.prevX = x;
        this.prevY = y;
    }

    public boolean mouseMoved(int screenX, int screenY) {
        if (this.isActive()) {
            float dt = Gdx.graphics.getDeltaTime() * 200.0f;
            float mouseXSensitivity = 1.0f / dt;
            float mouseYSensitivity = -1.0f / dt;
            if (!this.prevValid) {
                this.updatePreviousMousePosition(screenX, screenY);
                this.prevValid = true;
            }
            float limit = 17.0f;
            this.dx = MathUtils.clamp((float)MathUtilsDouble.lowPass(mouseXSensitivity * ((float)screenX - this.prevX), this.dx, 14.0f), (float)(-limit), (float)limit);
            this.dy = MathUtils.clamp((float)MathUtilsDouble.lowPass(mouseYSensitivity * ((float)screenY - this.prevY), this.dy, 14.0f), (float)(-limit), (float)limit);
            this.camera.addYaw(this.dx, true);
            this.camera.addPitch(this.dy, true);
            this.updatePreviousMousePosition(screenX, screenY);
            this.camera.setGamepadInput(false);
            return true;
        }
        return false;
    }

    @Override
    public boolean touchUp(float x, float y, int pointer, int button) {
        super.touchUp(x, y, pointer, button);
        if (this.isActive()) {
            if (button == 1) {
                int w = Gdx.graphics.getWidth();
                int h = Gdx.graphics.getHeight();
                Gdx.input.setCursorPosition(w / 2, h / 2);
                this.prevX = (float)w / 2.0f;
                this.prevY = (float)h / 2.0f;
            }
            return true;
        }
        return false;
    }

    private void setMouseCapture(boolean state) {
        int cursorStatus = state ? 212995 : 212993;
        GLFW.glfwSetInputMode((long)((Lwjgl3Graphics)Gdx.graphics).getWindow().getWindowHandle(), (int)208897, (int)cursorStatus);
    }

    private void toggleMouseCapture() {
        if (GLFW.glfwGetInputMode((long)((Lwjgl3Graphics)Gdx.graphics).getWindow().getWindowHandle(), (int)208897) == 212995) {
            GLFW.glfwSetInputMode((long)((Lwjgl3Graphics)Gdx.graphics).getWindow().getWindowHandle(), (int)208897, (int)212993);
        } else {
            GLFW.glfwSetInputMode((long)((Lwjgl3Graphics)Gdx.graphics).getWindow().getWindowHandle(), (int)208897, (int)212995);
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case MOUSE_CAPTURE_CMD: {
                this.setMouseCapture((Boolean)data[0]);
                break;
            }
            case MOUSE_CAPTURE_TOGGLE: {
                this.toggleMouseCapture();
            }
        }
    }

    public static class GameGestureListener
    extends GestureDetector.GestureAdapter {
        private GameGestureListener() {
        }
    }
}

