/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.input;

import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.TimeUtils;
import gaiasky.gui.api.IGamepadMappings;
import gaiasky.input.AbstractGamepadListener;
import gaiasky.util.GuiUtils;

public abstract class GuiGamepadListener
extends AbstractGamepadListener {
    protected final Stage stage;

    protected GuiGamepadListener(String mappingsFile, Stage stage) {
        super(mappingsFile);
        this.stage = stage;
    }

    protected GuiGamepadListener(IGamepadMappings mappings, Stage stage) {
        super(mappings);
        this.stage = stage;
    }

    @Override
    public boolean buttonDown(Controller controller, int buttonCode) {
        long now = TimeUtils.millis();
        if (buttonCode == this.mappings.getButtonA()) {
            this.actionDown();
            this.lastButtonPollTime = now;
        } else if (buttonCode == this.mappings.getButtonB()) {
            this.back();
            this.lastButtonPollTime = now;
        } else if (buttonCode == this.mappings.getButtonLB()) {
            this.tabLeft();
            this.lastButtonPollTime = now;
        } else if (buttonCode == this.mappings.getButtonRB()) {
            this.tabRight();
            this.lastButtonPollTime = now;
        } else if (buttonCode == this.mappings.getButtonStart()) {
            this.start();
            this.lastButtonPollTime = now;
        } else if (buttonCode == this.mappings.getButtonSelect()) {
            this.select();
            this.lastButtonPollTime = now;
        } else if (buttonCode == this.mappings.getButtonDpadUp()) {
            this.moveUp();
            this.lastButtonPollTime = now;
        } else if (buttonCode == this.mappings.getButtonDpadDown()) {
            this.moveDown();
            this.lastButtonPollTime = now;
        } else if (buttonCode == this.mappings.getButtonDpadRight()) {
            this.moveRight();
            this.lastButtonPollTime = now;
        } else if (buttonCode == this.mappings.getButtonDpadLeft()) {
            this.moveLeft();
            this.lastButtonPollTime = now;
        }
        this.lastControllerUsed = controller;
        return true;
    }

    @Override
    public boolean axisMoved(Controller controller, int axisCode, float value) {
        long now = TimeUtils.millis();
        value = (float)this.applyZeroPoint(value);
        if (now - this.lastAxisEvtTime > this.axisEventDelay) {
            if (axisCode == this.mappings.getAxisLstickV()) {
                if (value > 0.0f) {
                    this.moveDown();
                    this.lastAxisEvtTime = now;
                } else if (value < 0.0f) {
                    this.moveUp();
                    this.lastAxisEvtTime = now;
                }
            } else if (axisCode == this.mappings.getAxisLstickH()) {
                if (value > 0.0f) {
                    this.moveRight();
                    this.lastAxisEvtTime = now;
                } else if (value < 0.0f) {
                    this.moveLeft();
                    this.lastAxisEvtTime = now;
                }
            } else if (axisCode == this.mappings.getAxisRstickV()) {
                if (value != 0.0f) {
                    this.rightStickVertical(value);
                    this.lastAxisEvtTime = now;
                }
            } else if (axisCode == this.mappings.getAxisRstickH()) {
                if (value != 0.0f) {
                    this.rightStickHorizontal(value);
                    this.lastAxisEvtTime = now;
                }
            } else if (axisCode == this.mappings.getAxisRT()) {
                if (value != 0.0f) {
                    this.rightTrigger(value);
                    this.lastAxisEvtTime = now;
                }
            } else if (axisCode == this.mappings.getAxisLT() && value != 0.0f) {
                this.leftTrigger(value);
                this.lastAxisEvtTime = now;
            }
        }
        this.lastControllerUsed = controller;
        return true;
    }

    @Override
    public boolean pollAxes() {
        if (this.lastControllerUsed != null) {
            float valueLV = (float)this.applyZeroPoint(this.lastControllerUsed.getAxis(this.mappings.getAxisLstickV()));
            if (valueLV > 0.0f) {
                this.moveDown();
                return true;
            }
            if (valueLV < 0.0f) {
                this.moveUp();
                return true;
            }
            float valueLH = (float)this.applyZeroPoint(this.lastControllerUsed.getAxis(this.mappings.getAxisLstickH()));
            if (valueLH > 0.0f) {
                this.moveRight();
                return true;
            }
            if (valueLH < 0.0f) {
                this.moveLeft();
                return true;
            }
            float valueRV = (float)this.applyZeroPoint(this.lastControllerUsed.getAxis(this.mappings.getAxisRstickV()));
            if (valueRV != 0.0f) {
                this.rightStickVertical(valueRV);
                return true;
            }
            float valueRH = (float)this.applyZeroPoint(this.lastControllerUsed.getAxis(this.mappings.getAxisRstickH()));
            if (valueRH != 0.0f) {
                this.rightStickHorizontal(valueRH);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean pollButtons() {
        if (this.isKeyPressed(this.mappings.getButtonDpadUp())) {
            this.moveUp();
            return true;
        }
        if (this.isKeyPressed(this.mappings.getButtonDpadDown())) {
            this.moveDown();
            return true;
        }
        return false;
    }

    public Array<Group> getContentContainers() {
        Array a = new Array(1);
        a.add((Object)this.stage.getRoot());
        return a;
    }

    public void actionDown() {
        Actor target = this.stage.getKeyboardFocus();
        if (target != null) {
            if (target instanceof Button) {
                Button b = (Button)target;
                if (!b.isDisabled()) {
                    b.setChecked(!b.isChecked());
                }
            } else {
                ChangeListener.ChangeEvent event = (ChangeListener.ChangeEvent)Pools.obtain(ChangeListener.ChangeEvent::new);
                event.setTarget(target);
                target.fire((Event)event);
                Pools.free((Object)event);
            }
        }
    }

    public abstract void back();

    public abstract void start();

    public abstract void select();

    public abstract void tabLeft();

    public abstract void tabRight();

    public abstract void moveLeft();

    public abstract void moveRight();

    public void moveUp() {
        this.moveFocusVertical(true);
    }

    public void moveDown() {
        this.moveFocusVertical(false);
    }

    public void moveFocusVertical(boolean up) {
        Actor focus = this.stage.getKeyboardFocus();
        Array<Actor> inputWidgets = GuiUtils.getInputWidgets(this.getContentContainers(), (Array<Actor>)new Array());
        if (!inputWidgets.isEmpty()) {
            int index = inputWidgets.indexOf((Object)focus, true);
            if (index < 0) {
                index = 0;
            }
            if (up) {
                if (--index < 0) {
                    index = inputWidgets.size - 1;
                }
            } else {
                index = (index + 1) % inputWidgets.size;
            }
            this.stage.setKeyboardFocus((Actor)inputWidgets.get(index));
            GuiUtils.ensureScrollVisible((Actor)inputWidgets.get(index));
        }
    }

    public void rightStickVertical(float value) {
        if (value != 0.0f) {
            this.rightStickVertical(this.stage.getKeyboardFocus(), value);
        }
    }

    protected void rightStickVertical(Actor focus, float value) {
        if (focus instanceof SelectBox) {
            SelectBox sb = (SelectBox)focus;
            GuiUtils.selectBoxMoveSelection(value < 0.0f, false, sb);
        } else {
            ScrollPane scroll = GuiUtils.getScrollPaneIn((Actor)this.getContentContainers().get(0));
            if (scroll != null) {
                scroll.setScrollY(scroll.getScrollY() + 300.0f * value);
            }
        }
    }

    public void rightStickHorizontal(float value) {
        this.rightStickHorizontal(this.stage.getKeyboardFocus(), value);
    }

    protected void rightStickHorizontal(Actor focus, float value) {
        if (focus instanceof Slider) {
            GuiUtils.sliderMove(value > 0.0f, 0.05f, (Slider)focus);
        } else if (focus instanceof SelectBox) {
            SelectBox sb = (SelectBox)focus;
            GuiUtils.selectBoxMoveSelection(value < 0.0f, false, sb);
        }
    }

    protected void rightTrigger(float value) {
        this.rightTrigger(this.stage.getKeyboardFocus(), value);
    }

    protected void rightTrigger(Actor focus, float value) {
        if (focus instanceof Slider) {
            GuiUtils.sliderMove(true, 0.05f, (Slider)focus);
        } else if (focus instanceof SelectBox) {
            SelectBox sb = (SelectBox)focus;
            GuiUtils.selectBoxMoveSelection(false, false, sb);
        }
    }

    protected void leftTrigger(float value) {
        this.leftTrigger(this.stage.getKeyboardFocus(), value);
    }

    protected void leftTrigger(Actor focus, float value) {
        if (focus instanceof Slider) {
            GuiUtils.sliderMove(false, 0.05f, (Slider)focus);
        } else if (focus instanceof SelectBox) {
            SelectBox sb = (SelectBox)focus;
            GuiUtils.selectBoxMoveSelection(true, false, sb);
        }
    }
}

