/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.input;

import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.TimeUtils;
import gaiasky.input.AbstractMouseKbdListener;
import gaiasky.input.InputUtils;
import gaiasky.util.GuiUtils;

public abstract class GuiKbdListener
extends AbstractMouseKbdListener {
    protected final Stage stage;

    protected GuiKbdListener(Stage stage) {
        super(new GuiGestureListener(), null);
        this.stage = stage;
        this.minPollInterval = 250L;
    }

    @Override
    public boolean keyDown(int keyCode) {
        if (this.isActive()) {
            long now = TimeUtils.millis();
            super.keyDown(keyCode);
            this.lastPollTime = now;
        }
        return false;
    }

    @Override
    public boolean keyUp(int keyCode) {
        if (this.isActive()) {
            keyCode = InputUtils.physicalToLogicalKeyCode(keyCode);
            long now = TimeUtils.millis();
            super.keyUp(keyCode);
            this.lastPollTime = now;
            return switch (keyCode) {
                case 19 -> this.moveUp();
                case 20 -> this.moveDown();
                case 21 -> this.moveLeft();
                case 61 -> {
                    if (!this.isKeyPressed(59)) {
                        yield this.tabRight();
                    }
                    yield this.tabLeft();
                }
                case 66 -> this.actionDown();
                case 111 -> this.close();
                case 3 -> this.moveHome();
                case 123 -> this.moveEnd();
                case 57, 58 -> this.select();
                default -> false;
            };
        }
        return false;
    }

    @Override
    protected boolean pollKeys() {
        if (this.isKeyPressed(19)) {
            this.moveUp();
            return true;
        }
        if (this.isKeyPressed(20)) {
            this.moveDown();
            return true;
        }
        return false;
    }

    public Array<Group> getContentContainers() {
        Array a = new Array(1);
        a.add((Object)this.stage.getRoot());
        return a;
    }

    public boolean actionDown() {
        Actor target = this.stage.getKeyboardFocus();
        if (target != null) {
            if (target instanceof CheckBox) {
                CheckBox cb = (CheckBox)target;
                if (!cb.isDisabled()) {
                    cb.setChecked(!cb.isChecked());
                    return true;
                }
            } else if (target instanceof Button) {
                ChangeListener.ChangeEvent event = (ChangeListener.ChangeEvent)Pools.obtain(ChangeListener.ChangeEvent::new);
                event.setTarget(target);
                target.fire((Event)event);
                Pools.free((Object)event);
                return true;
            }
        }
        return false;
    }

    public abstract boolean close();

    public abstract boolean accept();

    public abstract boolean select();

    public abstract boolean tabLeft();

    public abstract boolean tabRight();

    public boolean moveLeft() {
        return this.moveHorizontal(true);
    }

    public boolean moveRight() {
        return this.moveHorizontal(false);
    }

    private boolean moveHorizontal(boolean left) {
        Actor focus = this.stage.getKeyboardFocus();
        if (focus instanceof Slider) {
            GuiUtils.sliderMove(!left, 0.05f, (Slider)focus);
            return true;
        }
        if (focus instanceof SelectBox) {
            SelectBox selectBox = (SelectBox)focus;
            GuiUtils.selectBoxMoveSelection(left, false, selectBox);
            return true;
        }
        return false;
    }

    public boolean moveHome() {
        Actor focus = this.stage.getKeyboardFocus();
        if (focus instanceof Slider) {
            GuiUtils.sliderMove(false, 1.0f, (Slider)focus);
            return true;
        }
        if (focus instanceof SelectBox) {
            SelectBox selectBox = (SelectBox)focus;
            GuiUtils.selectBoxMoveSelection(true, true, selectBox);
            return true;
        }
        return false;
    }

    public boolean moveEnd() {
        Actor focus = this.stage.getKeyboardFocus();
        if (focus instanceof Slider) {
            GuiUtils.sliderMove(true, 1.0f, (Slider)focus);
            return true;
        }
        if (focus instanceof SelectBox) {
            SelectBox selectBox = (SelectBox)focus;
            GuiUtils.selectBoxMoveSelection(false, true, selectBox);
            return true;
        }
        return false;
    }

    public boolean moveUp() {
        return this.moveFocusVertical(true);
    }

    public boolean moveDown() {
        return this.moveFocusVertical(false);
    }

    public boolean moveFocusVertical(boolean up) {
        Actor focus = this.stage.getKeyboardFocus();
        Array<Actor> inputWidgets = GuiUtils.getInputWidgets(this.getContentContainers(), (Array<Actor>)new Array());
        if (!inputWidgets.isEmpty()) {
            int index = inputWidgets.indexOf((Object)focus, true);
            if (index < 0) {
                index = 0;
            }
            if (up) {
                if (--index < 0) {
                    index = inputWidgets.size - 1;
                }
            } else {
                index = (index + 1) % inputWidgets.size;
            }
            this.stage.setKeyboardFocus((Actor)inputWidgets.get(index));
            GuiUtils.ensureScrollVisible((Actor)inputWidgets.get(index));
            return true;
        }
        return false;
    }

    private static class GuiGestureListener
    implements GestureDetector.GestureListener {
        private GuiGestureListener() {
        }

        public boolean touchDown(float x, float y, int pointer, int button) {
            return false;
        }

        public boolean tap(float x, float y, int count, int button) {
            return false;
        }

        public boolean longPress(float x, float y) {
            return false;
        }

        public boolean fling(float velocityX, float velocityY, int button) {
            return false;
        }

        public boolean pan(float x, float y, float deltaX, float deltaY) {
            return false;
        }

        public boolean panStop(float x, float y, int pointer, int button) {
            return false;
        }

        public boolean zoom(float initialDistance, float distance) {
            return false;
        }

        public boolean pinch(Vector2 initialPointer1, Vector2 initialPointer2, Vector2 pointer1, Vector2 pointer2) {
            return false;
        }

        public void pinchStop() {
        }
    }
}

