/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.input;

import com.badlogic.gdx.Input;
import java.util.Locale;
import org.lwjgl.glfw.GLFW;

public class InputUtils {
    public static int physicalToLogicalKeyCode(int physicalKeyCode) {
        String str = InputUtils.physicalKeyCodeToLogicalKeyString(physicalKeyCode);
        return InputUtils.keyStringToKeyCode(str);
    }

    public static String physicalKeyCodeToLogicalKeyString(int keyCode) {
        String keyName = GLFW.glfwGetKeyName((int)InputUtils.getGlfwKeyCode(keyCode), (int)0);
        if (keyName != null && !keyName.isEmpty()) {
            return keyName.toUpperCase(Locale.ROOT);
        }
        return Input.Keys.toString((int)keyCode);
    }

    public static int getGlfwKeyCode(int gdxKeyCode) {
        return switch (gdxKeyCode) {
            case 62 -> 32;
            case 75 -> 39;
            case 55 -> 44;
            case 69 -> 45;
            case 56 -> 46;
            case 76 -> 47;
            case 7 -> 48;
            case 8 -> 49;
            case 9 -> 50;
            case 10 -> 51;
            case 11 -> 52;
            case 12 -> 53;
            case 13 -> 54;
            case 14 -> 55;
            case 15 -> 56;
            case 16 -> 57;
            case 74 -> 59;
            case 70 -> 61;
            case 29 -> 65;
            case 30 -> 66;
            case 31 -> 67;
            case 32 -> 68;
            case 33 -> 69;
            case 34 -> 70;
            case 35 -> 71;
            case 36 -> 72;
            case 37 -> 73;
            case 38 -> 74;
            case 39 -> 75;
            case 40 -> 76;
            case 41 -> 77;
            case 42 -> 78;
            case 43 -> 79;
            case 44 -> 80;
            case 45 -> 81;
            case 46 -> 82;
            case 47 -> 83;
            case 48 -> 84;
            case 49 -> 85;
            case 50 -> 86;
            case 51 -> 87;
            case 52 -> 88;
            case 53 -> 89;
            case 54 -> 90;
            case 71 -> 91;
            case 73 -> 92;
            case 72 -> 93;
            case 68 -> 96;
            case 111 -> 256;
            case 66 -> 257;
            case 61 -> 258;
            case 67 -> 259;
            case 124 -> 260;
            case 112 -> 261;
            case 22 -> 262;
            case 21 -> 263;
            case 20 -> 264;
            case 19 -> 265;
            case 92 -> 266;
            case 93 -> 267;
            case 3 -> 268;
            case 123 -> 269;
            case 115 -> 280;
            case 116 -> 281;
            case 120 -> 283;
            case 121 -> 284;
            case 131 -> 290;
            case 132 -> 291;
            case 133 -> 292;
            case 134 -> 293;
            case 135 -> 294;
            case 136 -> 295;
            case 137 -> 296;
            case 138 -> 297;
            case 139 -> 298;
            case 140 -> 299;
            case 141 -> 300;
            case 142 -> 301;
            case 183 -> 302;
            case 184 -> 303;
            case 185 -> 304;
            case 186 -> 305;
            case 187 -> 306;
            case 188 -> 307;
            case 189 -> 308;
            case 190 -> 309;
            case 191 -> 310;
            case 192 -> 311;
            case 193 -> 312;
            case 194 -> 313;
            case 143 -> 282;
            case 144 -> 320;
            case 145 -> 321;
            case 146 -> 322;
            case 147 -> 323;
            case 148 -> 324;
            case 149 -> 325;
            case 150 -> 326;
            case 151 -> 327;
            case 152 -> 328;
            case 153 -> 329;
            case 158 -> 330;
            case 154 -> 331;
            case 155 -> 332;
            case 156 -> 333;
            case 157 -> 334;
            case 160 -> 335;
            case 161 -> 336;
            case 59 -> 340;
            case 129 -> 341;
            case 57 -> 342;
            case 63 -> 343;
            case 60 -> 344;
            case 130 -> 345;
            case 58 -> 346;
            case 82 -> 348;
            default -> -1;
        };
    }

    private static int[] keys(int ... keys) {
        return keys;
    }

    public static int keyStringToKeyCode(String keyString) {
        return switch (keyString) {
            case "0" -> 7;
            case "1" -> 8;
            case "2" -> 9;
            case "3" -> 10;
            case "4" -> 11;
            case "5" -> 12;
            case "6" -> 13;
            case "7" -> 14;
            case "8" -> 15;
            case "9" -> 16;
            case "@" -> 77;
            case "A" -> 29;
            case "B" -> 30;
            case "C" -> 31;
            case "D" -> 32;
            case "E" -> 33;
            case "F" -> 34;
            case "G" -> 35;
            case "H" -> 36;
            case "I" -> 37;
            case "J" -> 38;
            case "K" -> 39;
            case "L" -> 40;
            case "M" -> 41;
            case "N" -> 42;
            case "O" -> 43;
            case "P" -> 44;
            case "Q" -> 45;
            case "R" -> 46;
            case "S" -> 47;
            case "T" -> 48;
            case "U" -> 49;
            case "V" -> 50;
            case "W" -> 51;
            case "X" -> 52;
            case "Y" -> 53;
            case "Z" -> 54;
            case "," -> 55;
            case "." -> 56;
            case "\t", "Tab" -> 61;
            case "Caps Lock" -> 115;
            case "Num Lock" -> 143;
            case " ", "Space" -> 62;
            case "\n", "Enter" -> 66;
            case "Delete" -> 67;
            case "`" -> 68;
            case "-" -> 69;
            case "=" -> 70;
            case "[" -> 71;
            case "]" -> 72;
            case "\\" -> 73;
            case ";" -> 74;
            case ":" -> 243;
            case "'" -> 75;
            case "/" -> 76;
            case "Num" -> 78;
            case "Headset Hook" -> 79;
            case "Focus" -> 80;
            case "+" -> 81;
            case "Menu" -> 82;
            case "L-Shift" -> 59;
            case "R-Shift" -> 60;
            case "L-Ctrl" -> 129;
            case "R-Ctrl" -> 130;
            case "L-Alt" -> 57;
            case "R-Alt" -> 58;
            case "SYM" -> 63;
            case "Insert" -> 124;
            case "Forward Delete" -> 112;
            case "Home" -> 3;
            case "End" -> 123;
            case "Escape" -> 111;
            case "Page Up" -> 92;
            case "Page Down" -> 93;
            case "F1" -> 131;
            case "F2" -> 132;
            case "F3" -> 133;
            case "F4" -> 134;
            case "F5" -> 135;
            case "F6" -> 136;
            case "F7" -> 137;
            case "F8" -> 138;
            case "F9" -> 139;
            case "F10" -> 140;
            case "F11" -> 141;
            case "F12" -> 142;
            case "F13" -> 183;
            case "F14" -> 184;
            case "F15" -> 185;
            case "Scroll Lock" -> 116;
            case "Pause" -> 121;
            case "Up" -> 19;
            case "Down" -> 20;
            case "Left" -> 21;
            case "Right" -> 22;
            default -> -1;
        };
    }
}

