/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.input;

import com.badlogic.gdx.controllers.Controller;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.input.AbstractGamepadListener;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.camera.NaturalCamera;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import net.jafama.FastMath;

public class MainGamepadListener
extends AbstractGamepadListener {
    private static final Logger.Log logger = Logger.getLogger(MainGamepadListener.class);
    private final NaturalCamera cam;

    public MainGamepadListener(NaturalCamera cam, String mappingsFile) {
        super(mappingsFile);
        this.cam = cam;
        this.buttonPollDelay = 20L;
    }

    @Override
    public boolean buttonDown(Controller controller, int buttonCode) {
        if (this.active.get()) {
            super.buttonDown(controller, buttonCode);
            logger.debug("button down [inputListener/code]: " + controller.getName() + " / " + buttonCode);
            if (buttonCode == this.mappings.getButtonX()) {
                this.em.post(Event.MINIMAP_TOGGLE_CMD, this);
            } else if (buttonCode == this.mappings.getButtonY()) {
                this.em.post(Event.TOGGLE_VISIBILITY_CMD, this, "element.orbits");
            } else if (buttonCode == this.mappings.getButtonA()) {
                this.em.post(Event.TOGGLE_VISIBILITY_CMD, this, "element.labels");
            } else if (buttonCode == this.mappings.getButtonB()) {
                this.em.post(Event.TOGGLE_VISIBILITY_CMD, this, "element.asteroids");
            } else if (buttonCode == this.mappings.getButtonDpadLeft()) {
                this.em.post(Event.TIME_STATE_CMD, this, false);
            } else if (buttonCode == this.mappings.getButtonDpadRight()) {
                this.em.post(Event.TIME_STATE_CMD, this, true);
            } else if (buttonCode == this.mappings.getButtonStart()) {
                this.em.post(Event.SHOW_CONTROLLER_GUI_ACTION, this, this.cam);
            } else if (buttonCode == this.mappings.getButtonSelect()) {
                this.em.post(Event.SHOW_QUIT_ACTION, this);
            } else if (buttonCode == this.mappings.getButtonRstick()) {
                if (this.cam.getMode().isFocus()) {
                    this.em.post(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FREE_MODE});
                } else {
                    this.em.post(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FOCUS_MODE});
                }
            }
            this.cam.setGamepadInput(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean buttonUp(Controller controller, int buttonCode) {
        if (this.active.get()) {
            super.buttonUp(controller, buttonCode);
            logger.debug("button up [inputListener/code]: " + controller.getName() + " / " + buttonCode);
            this.cam.setGamepadInput(true);
        }
        return false;
    }

    @Override
    public boolean axisMoved(Controller controller, int axisCode, float value) {
        if (this.active.get()) {
            super.axisMoved(controller, axisCode, value);
            logger.debug("axis moved [inputListener/code/value]: " + controller.getName() + " / " + axisCode + " / " + value);
            boolean treated = false;
            value = (float)this.applyZeroPoint(value);
            double val = (double)FastMath.signum((float)value) * FastMath.pow((double)Math.abs(value), (double)this.mappings.getAxisValuePower());
            if (axisCode == this.mappings.getAxisLstickH()) {
                double valMapped = val * this.mappings.getAxisLstickHSensitivity();
                if (this.cam.getMode().isFocus()) {
                    this.cam.setRoll(valMapped * 0.1);
                } else {
                    this.cam.setHorizontal(valMapped);
                }
                treated = true;
            } else if (axisCode == this.mappings.getAxisLstickV()) {
                this.cam.setVelocity(-val * this.mappings.getAxisLstickVSensitivity());
                treated = true;
            } else if (axisCode == this.mappings.getAxisRstickH()) {
                double valMapped = (Settings.settings.controls.gamepad.invertX ? -1.0 : 1.0) * val * this.mappings.getAxisRstickVSensitivity();
                if (this.cam.getMode().isFocus()) {
                    this.cam.setHorizontal(valMapped * 0.02);
                } else {
                    this.cam.setYaw(valMapped * 0.1);
                }
                treated = true;
            } else if (axisCode == this.mappings.getAxisRstickV()) {
                double valMapped = (Settings.settings.controls.gamepad.invertY ? 1.0 : -1.0) * val * this.mappings.getAxisRstickHSensitivity();
                if (this.cam.getMode().isFocus()) {
                    this.cam.setVertical(valMapped * 0.02);
                } else {
                    this.cam.setPitch(valMapped * 0.1);
                }
                treated = true;
            } else if (axisCode == this.mappings.getAxisRT()) {
                double valMapped = val * 0.1 * this.mappings.getAxisRTSensitivity();
                this.cam.setRoll(valMapped);
                treated = true;
            } else if (axisCode == this.mappings.getAxisLT()) {
                double valMapped = val * 0.1 * this.mappings.getAxisLTSensitivity();
                this.cam.setRoll(-valMapped);
                treated = true;
            }
            if (treated) {
                this.cam.setGamepadInput(true);
            }
            return treated;
        }
        return false;
    }

    @Override
    public boolean pollAxes() {
        return false;
    }

    @Override
    public boolean pollButtons() {
        if (this.active.get() && this.lastControllerUsed != null) {
            if (this.lastControllerUsed.getButton(this.mappings.getButtonDpadUp())) {
                double t = GaiaSky.instance.time.getWarpFactor();
                if (t == 0.0) {
                    t = 0.1;
                } else if (t > -0.1 && t < 0.0) {
                    t = 0.0;
                }
                double inc = Settings.settings.scene.camera.cinematic ? 0.01 : 0.05;
                EventManager.instance.post(Event.TIME_WARP_CMD, this, t < 0.0 ? t + FastMath.abs((double)(t * inc)) : t + t * inc);
            } else if (this.lastControllerUsed.getButton(this.mappings.getButtonDpadDown())) {
                double t = GaiaSky.instance.time.getWarpFactor();
                if (t == 0.0) {
                    t = -0.1;
                } else if (t < 0.1 && t > 0.0) {
                    t = 0.0;
                }
                double inc = Settings.settings.scene.camera.cinematic ? 0.01 : 0.05;
                EventManager.instance.post(Event.TIME_WARP_CMD, this, t < 0.0 ? t - FastMath.abs((double)(t * inc)) : t - t * inc);
            }
            return true;
        }
        return false;
    }
}

