/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.input;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.TimeUtils;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.main.KeyBindings;
import gaiasky.input.AbstractMouseKbdListener;
import gaiasky.input.InputUtils;
import gaiasky.input.KeyRegister;
import gaiasky.scene.Scene;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.camera.NaturalCamera;
import gaiasky.scene.view.FocusView;
import gaiasky.scene.view.KeyframesView;
import gaiasky.util.Settings;
import gaiasky.util.comp.ViewAngleComparator;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeSet;
import net.jafama.FastMath;

public class MainMouseKbdListener
extends AbstractMouseKbdListener
implements IObserver {
    private static final long doubleClickTime = 400L;
    protected final GaiaGestureListener gestureListener;
    private final Comparator<Entity> comp;
    private final float MOVE_PX_DIST;
    private final int MIN_PIX_DIST;
    private final Vector2 gesture = new Vector2();
    private final double noAccelSmoothing;
    private final double noAccelFactor;
    private final Vector2 currentDrag;
    private final Vector2 lastDrag;
    private final NaturalCamera camera;
    private final FocusView view;
    public int leftMouseButton = 0;
    public int rightMouseButton = 1;
    public int middleMouseButton = 2;
    public boolean alwaysScroll = true;
    public float scrollFactor = -0.1f;
    private boolean movementMultiplierState = false;
    public int rollKey = 59;
    protected int button = -1;
    private float startX;
    private float startY;
    private double dragDx;
    private double dragDy;
    private long lastClickTime = -1L;
    private boolean keyframeBeingDragged = false;
    private int touched;
    private boolean multiTouch;
    private Scene scene;
    private Entity kpo;
    private KeyframesView kfView;
    private final KeyRegister register;

    protected MainMouseKbdListener(GaiaGestureListener gestureListener, NaturalCamera camera) {
        super((GestureDetector.GestureListener)gestureListener, camera);
        this.camera = camera;
        this.gestureListener = gestureListener;
        this.gestureListener.inputListener = this;
        this.comp = new ViewAngleComparator<Entity>();
        this.register = new KeyRegister();
        this.MOVE_PX_DIST = (float)FastMath.max((double)5.0, (double)((double)Gdx.graphics.getWidth() * 0.01));
        this.MIN_PIX_DIST = 8;
        this.dragDx = 0.0;
        this.dragDy = 0.0;
        this.noAccelSmoothing = 16.0;
        this.noAccelFactor = 10.0;
        this.view = new FocusView();
        this.currentDrag = new Vector2();
        this.lastDrag = new Vector2();
    }

    public MainMouseKbdListener(NaturalCamera camera) {
        this(new GaiaGestureListener(), camera);
        EventManager.instance.subscribe((IObserver)this, Event.TOUCH_DOWN, Event.TOUCH_UP, Event.TOUCH_DRAGGED, Event.SCROLLED, Event.KEY_DOWN, Event.KEY_UP, Event.SCENE_LOADED);
    }

    private KeyframesView getKeyframesPathObject() {
        if (this.scene != null) {
            if (this.kfView == null) {
                this.kfView = new KeyframesView(this.scene);
            }
            if (this.kpo != null) {
                this.kfView.setEntity(this.kpo);
                return this.kfView;
            }
            ImmutableArray<Entity> l = this.scene.findEntitiesByFamily(this.scene.getFamilies().keyframes);
            if (l.size() > 0) {
                this.kpo = (Entity)l.get(0);
                this.kfView.setEntity(this.kpo);
                return this.kfView;
            }
        }
        return null;
    }

    private FocusView getKeyframeCollision(int screenX, int screenY) {
        if (this.getKeyframesPathObject() != null) {
            return this.getKeyframesPathObject().select(screenX, screenY, this.MIN_PIX_DIST, this.camera);
        }
        return null;
    }

    private void dragKeyframe(int screenX, int screenY, double dragDx, double dragDy) {
        if (this.isKeyPressed(59) && !this.anyPressed(129, 57)) {
            Objects.requireNonNull(this.getKeyframesPathObject()).rotateAroundUp(dragDx, dragDy, this.camera);
            return;
        }
        if (this.isKeyPressed(129) && !this.anyPressed(59, 57)) {
            Objects.requireNonNull(this.getKeyframesPathObject()).rotateAroundDir(dragDx, dragDy, this.camera);
            return;
        }
        if (this.isKeyPressed(57) && !this.anyPressed(59, 129)) {
            Objects.requireNonNull(this.getKeyframesPathObject()).rotateAroundCrs(dragDx, dragDy, this.camera);
            return;
        }
        Objects.requireNonNull(this.getKeyframesPathObject()).moveSelection(screenX, screenY, this.camera);
    }

    private Array<Entity> getHits(int screenX, int screenY) {
        Array<Entity> l = this.camera.getScene().findFocusableEntities();
        Array hits = new Array();
        for (Entity entity : l) {
            this.view.setEntity(entity);
            this.view.addEntityHitCoordinate(screenX, screenY, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), this.MIN_PIX_DIST, this.camera, (Array<Entity>)hits);
        }
        return hits;
    }

    private Entity getBestHit(int screenX, int screenY) {
        Array<Entity> hits = this.getHits(screenX, screenY);
        if (hits.size != 0) {
            hits.sort(this.comp);
            return (Entity)hits.get(hits.size - 1);
        }
        return null;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (this.isActive()) {
            if (Settings.settings.runtime.inputEnabled) {
                this.touched |= 1 << pointer;
                boolean bl = this.multiTouch = !MathUtils.isPowerOfTwo((int)this.touched);
                if (this.multiTouch) {
                    this.button = -1;
                } else if (this.button < 0) {
                    this.startX = screenX;
                    this.startY = screenY;
                    this.gesture.set(this.startX, this.startY);
                    this.button = button;
                }
                if (!(button != 1 || this.anyPressed(57, 59, 129) && this.getKeyframesPathObject() != null && this.getKeyframesPathObject().isSelected())) {
                    FocusView hit = this.getKeyframeCollision(screenX, screenY);
                    boolean bl2 = this.keyframeBeingDragged = hit != null;
                    if (this.keyframeBeingDragged) {
                        EventManager.publish(Event.FOCUS_CHANGE_CMD, this, hit.getEntity(), false);
                        EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FOCUS_MODE, false});
                    }
                }
            }
            this.camera.setGamepadInput(false);
            return super.touchDown(screenX, screenY, pointer, button);
        }
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (this.isActive()) {
            EventManager.publish(Event.INPUT_EVENT, this, button);
            if (Settings.settings.runtime.inputEnabled) {
                this.touched &= ~(1 << pointer);
                boolean bl = this.multiTouch = !MathUtils.isPowerOfTwo((int)this.touched);
                if (button == this.button && button == this.leftMouseButton) {
                    long currentTime = TimeUtils.millis();
                    long lastLeftTime = this.lastClickTime;
                    GaiaSky.postRunnable(() -> {
                        if (!Settings.settings.scene.camera.cinematic || this.gesture.dst((float)screenX, (float)screenY) < this.MOVE_PX_DIST) {
                            Entity hit;
                            boolean stopped = this.camera.stopMovement();
                            boolean focusRemoved = GaiaSky.instance.mainGui != null && GaiaSky.instance.mainGui.cancelTouchFocus();
                            boolean doubleClick = currentTime - lastLeftTime < 400L;
                            this.gesture.set(0.0f, 0.0f);
                            if (doubleClick && !stopped && !focusRemoved && (hit = this.getBestHit(screenX, screenY)) != null) {
                                EventManager.publish(Event.FOCUS_CHANGE_CMD, this, hit);
                                EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FOCUS_MODE});
                            }
                        }
                    });
                    this.dragDx = 0.0;
                    this.dragDy = 0.0;
                    this.lastClickTime = currentTime;
                } else if (button == this.button && button == this.rightMouseButton) {
                    if (this.keyframeBeingDragged) {
                        this.keyframeBeingDragged = false;
                    } else if (this.gesture.dst((float)screenX, (float)screenY) < this.MOVE_PX_DIST && this.getKeyframesPathObject() != null && this.getKeyframesPathObject().isSelected() && !this.anyPressed(129, 59, 57)) {
                        EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FREE_MODE});
                        Objects.requireNonNull(this.getKeyframesPathObject()).unselect();
                    } else {
                        GaiaSky.postRunnable(() -> {
                            if (this.gesture.dst((float)screenX, (float)screenY) < this.MOVE_PX_DIST && !Settings.settings.program.modeStereo.active) {
                                this.camera.setYaw(0.0);
                                this.camera.setPitch(0.0);
                                Entity hit = this.getBestHit(screenX, screenY);
                                EventManager.publish(Event.CONTEXT_MENU_CMD, this, hit, screenX, screenY);
                            }
                        });
                        this.camera.setHorizontal(0.0);
                        this.camera.setVertical(0.0);
                    }
                }
                EventManager.instance.notify(Event.REMOVE_KEYBOARD_FOCUS_CMD, this, new Object[0]);
                this.button = -1;
            }
            this.camera.setGamepadInput(false);
            return super.touchUp(screenX, screenY, pointer, button);
        }
        return false;
    }

    protected boolean processDrag(int screenX, int screenY, double deltaX, double deltaY, int button) {
        if (this.isActive()) {
            boolean accel = Settings.settings.scene.camera.cinematic;
            if (accel) {
                this.dragDx = deltaX;
                this.dragDy = deltaY;
            } else {
                this.currentDrag.set((float)deltaX, (float)deltaY);
                if (Math.abs(this.currentDrag.angleDeg(this.lastDrag)) > 90.0f) {
                    this.dragDx = 0.0;
                    this.dragDy = 0.0;
                }
                this.dragDx = this.lowPass(this.dragDx, deltaX * this.noAccelFactor, this.noAccelSmoothing);
                this.dragDy = this.lowPass(this.dragDy, deltaY * this.noAccelFactor, this.noAccelSmoothing);
                this.lastDrag.set(this.currentDrag);
            }
            if (button == this.leftMouseButton) {
                if (this.isKeyPressed(this.rollKey)) {
                    if (this.dragDx != 0.0) {
                        this.camera.addRoll(this.dragDx, accel);
                    }
                } else {
                    this.camera.addRotateMovement(this.dragDx, this.dragDy, false, accel);
                }
            } else if (button == this.rightMouseButton) {
                if (this.keyframeBeingDragged || this.getKeyframesPathObject() != null && this.getKeyframesPathObject().isSelected() && this.anyPressed(59, 129, 57)) {
                    this.dragKeyframe(screenX, screenY, this.dragDx, this.dragDy);
                } else if (this.camera.getMode().isFree()) {
                    this.camera.setHorizontal(-this.dragDx * 5.0);
                    this.camera.setVertical(-this.dragDy * 5.0);
                } else {
                    this.camera.addRotateMovement(this.dragDx, this.dragDy, true, accel);
                }
            } else if (button == this.middleMouseButton && this.dragDx != 0.0) {
                this.camera.addForwardForce(this.dragDx);
            }
            this.camera.setGamepadInput(false);
            return false;
        }
        return false;
    }

    private double lowPass(double smoothedValue, double newValue, double smoothing) {
        return smoothedValue + (newValue - smoothedValue) / smoothing;
    }

    public boolean touchDragged(int screenX, int screenY, int pointer) {
        if (this.isActive()) {
            if (Settings.settings.runtime.inputEnabled) {
                boolean result = super.touchDragged(screenX, screenY, pointer);
                if (result || this.button < 0) {
                    return result;
                }
                float fpsScale = this.getFpsScale();
                double deltaX = fpsScale * ((float)screenX - this.startX) / (float)Gdx.graphics.getWidth();
                double deltaY = fpsScale * (this.startY - (float)screenY) / (float)Gdx.graphics.getHeight();
                this.startX = screenX;
                this.startY = screenY;
                return this.processDrag(screenX, screenY, deltaX, deltaY, this.button);
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean scrolled(float amountX, float amountY) {
        if (this.isActive()) {
            float fpsScale = this.getFpsScale();
            super.scrolled(amountX *= fpsScale, amountY *= fpsScale);
            if (Settings.settings.runtime.inputEnabled) {
                return this.zoom(amountY * this.scrollFactor);
            }
        }
        return false;
    }

    public boolean zoom(float amount) {
        if (this.alwaysScroll) {
            this.camera.addForwardForce(amount);
        }
        this.camera.setGamepadInput(false);
        return false;
    }

    @Override
    public boolean keyDown(int keyCode) {
        if (this.isActive()) {
            keyCode = InputUtils.physicalToLogicalKeyCode(keyCode);
            if (Settings.settings.runtime.inputEnabled) {
                this.register.registerKeyDownTime(keyCode, TimeUtils.millis());
            }
            return super.keyDown(keyCode);
        }
        return false;
    }

    @Override
    public boolean pollKeys() {
        KeyBindings bindings;
        TreeSet<Integer> speedUpKeys;
        long now = System.currentTimeMillis();
        boolean result = false;
        Actor keyboardFocus = GaiaSky.instance.mainGui.getGuiStage().getKeyboardFocus();
        if (!(keyboardFocus instanceof TextField)) {
            float horizontalScale;
            float f = horizontalScale = Settings.settings.scene.camera.cinematic ? 0.01f : 1.0f;
            if (this.isKeyPressed(19)) {
                this.camera.addForwardForce(1.0);
                result = true;
            }
            if (this.isKeyPressed(20)) {
                this.camera.addForwardForce(-1.0);
                result = true;
            }
            if (this.isKeyPressed(22)) {
                if (this.camera.getMode().isFocus()) {
                    this.camera.addHorizontal(-1.0f * horizontalScale, true);
                } else {
                    this.camera.addYaw(horizontalScale, true);
                }
                result = true;
            }
            if (this.isKeyPressed(21)) {
                if (this.camera.getMode().isFocus()) {
                    this.camera.addHorizontal(horizontalScale, true);
                } else {
                    this.camera.addYaw(-1.0f * horizontalScale, true);
                }
                result = true;
            }
        }
        if (this.allPressed(speedUpKeys = (bindings = KeyBindings.instance).getKeys("action.camera.speedup"))) {
            if (!this.movementMultiplierState) {
                this.movementMultiplierState = true;
                this.camera.setCameraMultipliers(6.0, 5.0);
            }
        } else if (this.movementMultiplierState) {
            this.movementMultiplierState = false;
            this.camera.setCameraMultipliers(1.0, 1.0);
        }
        long speedMs = bindings.findAction((String)"action.doubletime").maxKeyDownTimeMs;
        long slowMs = bindings.findAction((String)"action.dividetime").maxKeyDownTimeMs;
        TreeSet<Integer> speedTimeKeys = bindings.getKeys("action.doubletime");
        TreeSet<Integer> slowTimeKeys = bindings.getKeys("action.dividetime");
        if (this.allPressed(speedTimeKeys)) {
            if (now - this.register.lastKeyDownTime(speedTimeKeys) > speedMs) {
                double t = GaiaSky.instance.time.getWarpFactor();
                if (t == 0.0) {
                    t = 0.1;
                } else if (t > -0.1 && t < 0.0) {
                    t = 0.0;
                }
                double inc = Settings.settings.scene.camera.cinematic ? 0.01 : 0.05;
                EventManager.instance.post(Event.TIME_WARP_CMD, this, t < 0.0 ? t + FastMath.abs((double)(t * inc)) : t + t * inc);
            }
        } else if (this.allPressed(slowTimeKeys) && now - this.register.lastKeyDownTime(slowTimeKeys) > slowMs) {
            double t = GaiaSky.instance.time.getWarpFactor();
            if (t == 0.0) {
                t = -0.1;
            } else if (t < 0.1 && t > 0.0) {
                t = 0.0;
            }
            double inc = Settings.settings.scene.camera.cinematic ? 0.01 : 0.05;
            EventManager.instance.post(Event.TIME_WARP_CMD, this, t < 0.0 ? t - FastMath.abs((double)(t * inc)) : t - t * inc);
        }
        return result;
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case TOUCH_DOWN: {
                this.touchDown((Integer)data[0], (Integer)data[1], (int)((Integer)data[2]), (int)((Integer)data[3]));
                break;
            }
            case TOUCH_UP: {
                this.touchUp((Integer)data[0], (Integer)data[1], (int)((Integer)data[2]), (int)((Integer)data[3]));
                break;
            }
            case TOUCH_DRAGGED: {
                this.touchDragged((Integer)data[0], (Integer)data[1], (Integer)data[2]);
                break;
            }
            case SCROLLED: {
                this.scrolled(0.0f, ((Float)data[0]).floatValue());
                break;
            }
            case KEY_DOWN: {
                this.keyDown((Integer)data[0]);
                break;
            }
            case KEY_UP: {
                this.keyUp((Integer)data[0]);
                break;
            }
            case SCENE_LOADED: {
                this.scene = (Scene)data[0];
                break;
            }
        }
    }

    protected static class GaiaGestureListener
    extends GestureDetector.GestureAdapter {
        public MainMouseKbdListener inputListener;
        private float previousZoom;

        protected GaiaGestureListener() {
        }

        public boolean touchDown(float x, float y, int pointer, int button) {
            this.previousZoom = 0.0f;
            return false;
        }

        public boolean zoom(float initialDistance, float distance) {
            if (this.inputListener.isActive()) {
                float newZoom = distance - initialDistance;
                float amount = newZoom - this.previousZoom;
                this.previousZoom = newZoom;
                float w = Gdx.graphics.getWidth();
                float h = Gdx.graphics.getHeight();
                return this.inputListener.zoom(amount / Math.min(w, h));
            }
            return false;
        }
    }
}

