/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.input;

import com.badlogic.gdx.controllers.Controller;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.input.AbstractGamepadListener;
import gaiasky.scene.camera.SpacecraftCamera;
import gaiasky.scene.view.SpacecraftView;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import net.jafama.FastMath;

public class SpacecraftGamepadListener
extends AbstractGamepadListener {
    private static final Logger.Log logger = Logger.getLogger(SpacecraftGamepadListener.class);
    private final SpacecraftCamera cam;
    private Controller lastController;

    public SpacecraftGamepadListener(SpacecraftCamera cam, String mappingsFile) {
        super(mappingsFile);
        this.cam = cam;
    }

    @Override
    public boolean pollAxes() {
        return false;
    }

    @Override
    public boolean pollButtons() {
        return false;
    }

    @Override
    public void update() {
        if (this.lastController != null) {
            double thrust = this.lastController.getAxis(this.mappings.getAxisLstickV());
            double thrustFwd = this.lastController.getAxis(this.mappings.getAxisRT());
            double thrustBwd = this.lastController.getAxis(this.mappings.getAxisLT());
            if (Math.abs(thrust) < 0.05 && FastMath.abs((double)thrustFwd) < 0.05 && FastMath.abs((double)thrustBwd) < 0.05) {
                this.cam.getSpacecraftView().setCurrentEnginePower(0.0);
            }
        }
    }

    @Override
    public boolean buttonDown(Controller controller, int buttonCode) {
        logger.debug("button down [inputListener/code]: " + controller.getName() + " / " + buttonCode);
        this.cam.setGamepadInput(true);
        SpacecraftView sc = this.cam.getSpacecraftView();
        if (buttonCode == this.mappings.getButtonRB()) {
            sc.setRollPower(-1.0);
            EventManager.publish(Event.SPACECRAFT_STOP_CMD, this, false);
        } else if (buttonCode == this.mappings.getButtonLB()) {
            sc.setRollPower(1.0);
            EventManager.publish(Event.SPACECRAFT_STOP_CMD, this, false);
        }
        return true;
    }

    @Override
    public boolean buttonUp(Controller controller, int buttonCode) {
        logger.debug("button up [inputListener/code]: " + controller.getName() + " / " + buttonCode);
        SpacecraftView sc = this.cam.getSpacecraftView();
        if (buttonCode == this.mappings.getButtonX()) {
            EventManager.publish(Event.SPACECRAFT_STOP_CMD, this, true);
        } else if (buttonCode == this.mappings.getButtonY()) {
            EventManager.publish(Event.SPACECRAFT_STABILISE_CMD, this, true);
        } else if (buttonCode == this.mappings.getButtonA()) {
            this.em.post(Event.TOGGLE_VISIBILITY_CMD, this, "element.labels");
        } else if (buttonCode == this.mappings.getButtonB()) {
            this.em.post(Event.TOGGLE_VISIBILITY_CMD, this, "element.orbits");
        } else if (buttonCode == this.mappings.getButtonDpadUp()) {
            sc.increaseThrustFactorIndex(true);
        } else if (buttonCode == this.mappings.getButtonDpadDown()) {
            sc.decreaseThrustFactorIndex(true);
        } else if (buttonCode == this.mappings.getButtonDpadLeft()) {
            this.em.post(Event.TIME_STATE_CMD, this, false);
        } else if (buttonCode == this.mappings.getButtonDpadRight()) {
            this.em.post(Event.TIME_STATE_CMD, this, true);
        } else if (buttonCode == this.mappings.getButtonRB()) {
            sc.setRollPower(0.0);
            EventManager.publish(Event.SPACECRAFT_STOP_CMD, this, false);
        } else if (buttonCode == this.mappings.getButtonLB()) {
            sc.setRollPower(0.0);
            EventManager.publish(Event.SPACECRAFT_STOP_CMD, this, false);
        }
        this.cam.setGamepadInput(true);
        this.lastController = controller;
        return true;
    }

    @Override
    public boolean axisMoved(Controller controller, int axisCode, float value) {
        logger.debug("axis moved [inputListener/code/value]: " + controller.getName() + " / " + axisCode + " / " + value);
        SpacecraftView sc = this.cam.getSpacecraftView();
        boolean treated = false;
        value = (float)this.applyZeroPoint(value);
        double val = (double)FastMath.signum((float)value) * FastMath.pow((double)Math.abs(value), (double)this.mappings.getAxisValuePower());
        if (axisCode == this.mappings.getAxisLstickH()) {
            double effValue = -val * this.mappings.getAxisLstickHSensitivity();
            sc.setRollPower(effValue);
            EventManager.publish(Event.SPACECRAFT_STOP_CMD, this, false);
            treated = true;
        } else if (axisCode == this.mappings.getAxisLstickV()) {
            double effValue = -val * this.mappings.getAxisLstickVSensitivity();
            sc.setCurrentEnginePower(effValue);
            EventManager.publish(Event.SPACECRAFT_STOP_CMD, this, false);
            treated = true;
        } else if (axisCode == this.mappings.getAxisRstickH()) {
            double effValue = -(Settings.settings.controls.gamepad.invertX ? -1.0 : 1.0) * val * this.mappings.getAxisRstickVSensitivity();
            sc.setYawPower(effValue);
            EventManager.publish(Event.SPACECRAFT_STABILISE_CMD, this, false);
            treated = true;
        } else if (axisCode == this.mappings.getAxisRstickV()) {
            double effValue = (Settings.settings.controls.gamepad.invertY ? 1.0 : -1.0) * val * this.mappings.getAxisRstickHSensitivity();
            sc.setPitchPower(effValue);
            EventManager.publish(Event.SPACECRAFT_STABILISE_CMD, this, false);
            treated = true;
        } else if (axisCode == this.mappings.getAxisRT()) {
            double effValue = val * this.mappings.getAxisRTSensitivity();
            sc.setCurrentEnginePower(effValue);
            EventManager.publish(Event.SPACECRAFT_STOP_CMD, this, false);
            treated = true;
        } else if (axisCode == this.mappings.getAxisLT()) {
            double effValue = -val * this.mappings.getAxisLTSensitivity();
            sc.setCurrentEnginePower(effValue);
            EventManager.publish(Event.SPACECRAFT_STOP_CMD, this, false);
            treated = true;
        }
        if (treated) {
            this.cam.setGamepadInput(true);
        }
        this.lastController = controller;
        return treated;
    }
}

