/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.input;

import com.badlogic.gdx.input.GestureDetector;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.input.AbstractMouseKbdListener;
import gaiasky.scene.camera.SpacecraftCamera;
import gaiasky.scene.view.SpacecraftView;
import gaiasky.util.Settings;

public class SpacecraftMouseKbdListener
extends AbstractMouseKbdListener {
    private final SpacecraftCamera cam;

    public SpacecraftMouseKbdListener(SpacecraftCamera spacecraftCamera, GestureDetector.GestureListener listener) {
        super(listener, spacecraftCamera);
        this.cam = spacecraftCamera;
    }

    @Override
    public boolean keyDown(int keyCode) {
        SpacecraftView sc;
        if (this.isActive() && (sc = this.cam.getSpacecraftView()) != null && Settings.settings.runtime.inputEnabled) {
            double step = 0.01;
            switch (keyCode) {
                case 51: {
                    sc.setCurrentEnginePower(sc.currentEnginePower() + step);
                    EventManager.publish(Event.SPACECRAFT_STOP_CMD, this, false);
                    break;
                }
                case 47: {
                    sc.setCurrentEnginePower(sc.currentEnginePower() - step);
                    EventManager.publish(Event.SPACECRAFT_STOP_CMD, this, false);
                    break;
                }
                case 29: {
                    sc.setRollPower(sc.getRollPower() + step);
                    EventManager.publish(Event.SPACECRAFT_STOP_CMD, this, false);
                    break;
                }
                case 32: {
                    sc.setRollPower(sc.getRollPower() - step);
                    EventManager.publish(Event.SPACECRAFT_STABILISE_CMD, this, false);
                    break;
                }
                case 20: {
                    sc.setPitchPower(sc.getPitchPower() + step);
                    EventManager.publish(Event.SPACECRAFT_STABILISE_CMD, this, false);
                    break;
                }
                case 19: {
                    sc.setPitchPower(sc.getPitchPower() - step);
                    EventManager.publish(Event.SPACECRAFT_STABILISE_CMD, this, false);
                    break;
                }
                case 21: {
                    sc.setYawPower(sc.getYawPower() + step);
                    EventManager.publish(Event.SPACECRAFT_STABILISE_CMD, this, false);
                    break;
                }
                case 22: {
                    sc.setYawPower(sc.getYawPower() - step);
                    EventManager.publish(Event.SPACECRAFT_STABILISE_CMD, this, false);
                    break;
                }
            }
        }
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        SpacecraftView sc;
        if (this.isActive() && (sc = this.cam.getSpacecraftView()) != null && sc.getEntity() != null && Settings.settings.runtime.inputEnabled) {
            switch (keycode) {
                case 47: 
                case 51: {
                    sc.setCurrentEnginePower(0.0);
                    break;
                }
                case 29: 
                case 32: {
                    sc.setRollPower(0.0);
                    break;
                }
                case 19: 
                case 20: {
                    sc.setPitchPower(0.0);
                    break;
                }
                case 21: 
                case 22: {
                    sc.setYawPower(0.0);
                    break;
                }
                case 40: {
                    EventManager.publish(Event.SPACECRAFT_STABILISE_CMD, this, true);
                    break;
                }
                case 39: {
                    EventManager.publish(Event.SPACECRAFT_STOP_CMD, this, true);
                    break;
                }
                case 92: {
                    sc.increaseThrustFactorIndex(true);
                    break;
                }
                case 93: {
                    sc.decreaseThrustFactorIndex(true);
                    break;
                }
            }
        }
        return false;
    }

    @Override
    protected boolean pollKeys() {
        return false;
    }
}

